/* ###
 * IP: GHIDRA
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ghidra.pcode.emu.jit.gen.var;

import ghidra.pcode.emu.jit.var.JitDirectMemoryVar;

/**
 * The generator for a (whole) direct memory variable.
 */
public enum WholeDirectMemoryVarGen implements DirectMemoryVarGen {
	/** Singleton */
	GEN;

	@Override
	public ValGen<JitDirectMemoryVar> subpiece(int byteOffset, int maxByteSize) {
		return new SubDirectMemoryVarGen(byteOffset, maxByteSize);
	}
}
