/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DockingUtils;
import docking.Tool;
import docking.WindowPosition;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.action.ToolBarData;
import docking.options.OptionsService;
import docking.widgets.fieldpanel.FieldPanel;
import edu.uci.ics.jung.graph.Graph;
import generic.stl.Pair;
import generic.theme.GIcon;
import ghidra.app.context.ListingActionContext;
import ghidra.app.nav.DecoratorPanel;
import ghidra.app.nav.LocationMemento;
import ghidra.app.nav.Navigatable;
import ghidra.app.nav.NavigatableIconFactory;
import ghidra.app.nav.NavigatableRegistry;
import ghidra.app.nav.NavigatableRemovalListener;
import ghidra.app.plugin.core.functiongraph.DefaultFgEnv;
import ghidra.app.plugin.core.functiongraph.FGActionManager;
import ghidra.app.plugin.core.functiongraph.FGClipboardProvider;
import ghidra.app.plugin.core.functiongraph.FGLocationMemento;
import ghidra.app.plugin.core.functiongraph.FunctionGraphPlugin;
import ghidra.app.plugin.core.functiongraph.action.FunctionGraphEditableVertexLocationActionContext;
import ghidra.app.plugin.core.functiongraph.action.FunctionGraphEmptyGraphActionContext;
import ghidra.app.plugin.core.functiongraph.action.FunctionGraphSatelliteViewerActionContext;
import ghidra.app.plugin.core.functiongraph.action.FunctionGraphUneditableVertexLocationActionContext;
import ghidra.app.plugin.core.functiongraph.action.FunctionGraphValidGraphActionContext;
import ghidra.app.plugin.core.functiongraph.action.FunctionGraphVertexLocationInFullViewModeActionContext;
import ghidra.app.plugin.core.functiongraph.action.VertexActionContextInfo;
import ghidra.app.plugin.core.functiongraph.graph.FGEdge;
import ghidra.app.plugin.core.functiongraph.graph.FunctionGraph;
import ghidra.app.plugin.core.functiongraph.graph.FunctionGraphFactory;
import ghidra.app.plugin.core.functiongraph.graph.vertex.FGVertex;
import ghidra.app.plugin.core.functiongraph.graph.vertex.GroupedFunctionGraphVertex;
import ghidra.app.plugin.core.functiongraph.mvc.DefaultFGControllerListener;
import ghidra.app.plugin.core.functiongraph.mvc.FGController;
import ghidra.app.plugin.core.functiongraph.mvc.FGData;
import ghidra.app.plugin.core.functiongraph.mvc.FunctionGraphOptions;
import ghidra.app.plugin.core.marker.MarginProviderSupplier;
import ghidra.app.services.ClipboardContentProviderService;
import ghidra.app.services.ClipboardService;
import ghidra.app.services.GoToService;
import ghidra.app.services.NavigationHistoryService;
import ghidra.app.services.ProgramManager;
import ghidra.app.util.ListingHighlightProvider;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.EventType;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.PluginTool;
import ghidra.graph.VisualGraphComponentProvider;
import ghidra.graph.viewer.GraphPerspectiveInfo;
import ghidra.graph.viewer.GraphViewer;
import ghidra.graph.viewer.GraphViewerUtils;
import ghidra.graph.viewer.SatelliteGraphViewer;
import ghidra.graph.viewer.VisualGraphView;
import ghidra.graph.viewer.actions.VisualGraphContextMarker;
import ghidra.graph.viewer.event.mouse.VertexMouseInfo;
import ghidra.graph.viewer.options.RelayoutOption;
import ghidra.graph.viewer.options.ViewRestoreOption;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.util.ProgramChangeRecord;
import ghidra.program.util.ProgramEvent;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import ghidra.util.Swing;
import ghidra.util.SystemUtilities;
import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import ghidra.util.exception.AssertException;
import ghidra.util.task.SwingUpdateManager;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class FGProvider
extends VisualGraphComponentProvider<FGVertex, FGEdge, FunctionGraph>
implements Navigatable,
DomainObjectListener {
    private static final String DISPLAY_POPUPS = "DISPLAY_POPUPS";
    private final PluginTool tool;
    private final FunctionGraphPlugin plugin;
    private FGController controller;
    private Program currentProgram;
    private ProgramLocation currentLocation;
    private ProgramLocation pendingLocation;
    private ProgramSelection currentProgramSelection;
    private ProgramSelection currentProgramHighlight;
    private Supplier<Boolean> focusStatusDelegate = () -> super.isFocusedProvider();
    private DecoratorPanel decorationPanel;
    private String disconnectedName;
    private SwingUpdateManager rebuildGraphUpdateManager;
    private SwingUpdateManager updateLocationUpdateManager;
    private ClipboardService clipboardService;
    private FGClipboardProvider clipboardProvider;
    private FGActionManager actionManager;
    private WeakSet<NavigatableRemovalListener> navigationListeners = WeakDataStructureFactory.createCopyOnWriteWeakSet();
    private boolean isConnected;
    private ImageIcon navigatableIcon;
    private boolean disposed = false;

    public FGProvider(FunctionGraphPlugin plugin, boolean isConnected) {
        super((Tool)plugin.getTool(), "Function Graph", plugin.getName(), ListingActionContext.class);
        this.tool = plugin.getTool();
        this.plugin = plugin;
        DefaultFgEnv env = new DefaultFgEnv(this, plugin);
        DefaultFGControllerListener listener = new DefaultFGControllerListener(this);
        this.controller = new FGController(env, listener);
        this.setConnected(isConnected);
        this.setIcon(FunctionGraphPlugin.ICON);
        if (!isConnected) {
            this.setTransient();
        } else {
            this.addToToolbar();
        }
        this.decorationPanel = new DecoratorPanel(this.controller.getViewComponent(), isConnected);
        this.setWindowMenuGroup("Function Graph");
        this.setWindowGroup("Function Graph");
        this.setDefaultWindowPosition(WindowPosition.WINDOW);
        this.setHelpLocation(new HelpLocation("FunctionGraphPlugin", "FunctionGraphPlugin"));
        this.addToTool();
        this.addSatelliteFeature();
        this.createActions();
        this.rebuildGraphUpdateManager = new SwingUpdateManager(1000, 10000, () -> this.refreshAndKeepPerspective());
        this.updateLocationUpdateManager = new SwingUpdateManager(250, 750, () -> this.setPendingLocationFromUpdateManager());
        this.clipboardProvider = new FGClipboardProvider(this.tool, this.controller, this);
        this.setDefaultFocusComponent(this.controller.getViewComponent());
    }

    private void createActions() {
        this.actionManager = new FGActionManager(this.controller, this.plugin.getName());
        String toolbarEndGroup = "zzzend";
        String popupVeryLastGroup = "zzzzzz";
        String owner = this.plugin.getName();
        DockingAction cloneAction = new DockingAction("Function Graph Clone", owner){

            public void actionPerformed(ActionContext context) {
                FGProvider.this.cloneWindow();
            }

            public boolean isEnabledForContext(ActionContext context) {
                return FGProvider.this.controller.getGraphedFunction() != null;
            }
        };
        GIcon image = new GIcon("icon.plugin.functiongraph.action.viewer.clone");
        cloneAction.setToolBarData(new ToolBarData((Icon)image, toolbarEndGroup));
        cloneAction.setDescription("Create a snapshot (disconnected) copy of this Function Graph window");
        cloneAction.setHelpLocation(new HelpLocation("Snapshots", "Snapshots_Start"));
        cloneAction.setHelpLocation(new HelpLocation("FunctionGraphPlugin", "Function_Graph_Action_Snapshot"));
        cloneAction.setKeyBindingData(new KeyBindingData(84, DockingUtils.CONTROL_KEY_MODIFIER_MASK | 0x40));
        DockingAction optionsAction = new DockingAction("Function Graph Options", owner){

            public void actionPerformed(ActionContext context) {
                OptionsService service = (OptionsService)FGProvider.this.tool.getService(OptionsService.class);
                service.showOptionsDialog("Graph.Function Graph", "Function Graph");
            }

            public boolean isEnabledForContext(ActionContext context) {
                return true;
            }
        };
        optionsAction.setPopupMenuData(new MenuData(new String[]{"Properties"}, null, popupVeryLastGroup));
        optionsAction.setHelpLocation(new HelpLocation("FunctionGraphPlugin", "Options"));
        this.addLocalAction((DockingActionIf)cloneAction);
        this.addLocalAction((DockingActionIf)optionsAction);
    }

    public boolean isSnapshot() {
        return !this.isConnected();
    }

    void setClipboardService(ClipboardService service) {
        this.clipboardService = service;
        if (this.clipboardService != null) {
            this.clipboardService.registerClipboardContentProvider((ClipboardContentProviderService)this.clipboardProvider);
        }
    }

    public void setClipboardStringContent(String string) {
        this.clipboardProvider.setStringContent(string);
    }

    FGController getController() {
        return this.controller;
    }

    Program getCurrentProgram() {
        return this.currentProgram;
    }

    ProgramLocation getCurrentLocation() {
        return this.currentLocation;
    }

    ProgramSelection getCurrentProgramSelection() {
        return this.currentProgramSelection;
    }

    ProgramSelection getCurrentProgramHighlight() {
        return this.currentProgramHighlight;
    }

    FGActionManager getActionManager() {
        return this.actionManager;
    }

    AddressSet getAddressesFromHoveredVertices() {
        FunctionGraph functionGraph;
        AddressSet addresses = new AddressSet();
        FGData functionGraphData = this.controller.getFunctionGraphData();
        if (!functionGraphData.hasResults()) {
            return addresses;
        }
        FunctionGraph graph = functionGraph = functionGraphData.getFunctionGraph();
        Collection hoveredVertices = GraphViewerUtils.getVerticesOfHoveredEdges((Graph)graph);
        for (FGVertex vertex : hoveredVertices) {
            addresses.add(vertex.getAddresses());
        }
        return addresses;
    }

    private AddressSet getAddressesForSelectedVertices() {
        FunctionGraph functionGraph;
        if (this.currentProgram == null) {
            return new AddressSet();
        }
        AddressSet addresses = new AddressSet();
        FGData functionGraphData = this.controller.getFunctionGraphData();
        if (!functionGraphData.hasResults()) {
            return addresses;
        }
        FunctionGraph graph = functionGraph = functionGraphData.getFunctionGraph();
        Collection selectedVertices = GraphViewerUtils.getVerticesOfSelectedEdges((Graph)graph);
        for (FGVertex vertex : selectedVertices) {
            addresses.add(vertex.getAddresses());
        }
        return addresses;
    }

    void cloneWindow() {
        FGProvider newProvider = this.plugin.createNewDisconnectedProvider();
        Swing.runLater(() -> {
            newProvider.doSetProgram(this.currentProgram);
            FGData currentData = this.controller.getFunctionGraphData();
            SaveState state = new SaveState();
            this.writeConfigState(state);
            newProvider.readConfigState(state);
            FGController newController = newProvider.controller;
            FGData newData = FunctionGraphFactory.createClonedGraph(currentData, newController);
            newController.setFunctionGraphData(newData);
            newProvider.setLocationNow(this.currentLocation);
            newProvider.setGraphPerspective(this.controller.getGraphPerspective(this.currentLocation));
        });
    }

    private void setGraphPerspective(GraphPerspectiveInfo<FGVertex, FGEdge> info) {
        this.controller.setGraphPerspective(info);
    }

    private boolean arePopupsVisible() {
        return this.controller.arePopupsVisible();
    }

    public void setPopupsVisible(boolean visible) {
        this.actionManager.popupVisibilityChanged(visible);
    }

    public void saveLocationToHistory() {
        NavigationHistoryService historyService = (NavigationHistoryService)this.tool.getService(NavigationHistoryService.class);
        historyService.addNewLocation((Navigatable)this);
    }

    public VisualGraphView<FGVertex, FGEdge, FunctionGraph> getView() {
        return this.controller.getView();
    }

    public PluginTool getTool() {
        return this.plugin.getTool();
    }

    public ActionContext getActionContext(MouseEvent event) {
        if (this.currentProgram == null) {
            return null;
        }
        if (this.controller.getGraphedFunction() == null) {
            return new FunctionGraphEmptyGraphActionContext(this);
        }
        if (event == null) {
            return this.createKeybindingContext();
        }
        Object source = event.getSource();
        if (source instanceof SatelliteGraphViewer) {
            return new FunctionGraphSatelliteViewerActionContext(this);
        }
        if (source instanceof VisualGraphContextMarker) {
            return new FunctionGraphValidGraphActionContext(this, new HashSet<FGVertex>());
        }
        if (source instanceof FieldPanel) {
            FGVertex vertex = this.controller.getFocusedVertex();
            return new FunctionGraphVertexLocationInFullViewModeActionContext(this, vertex);
        }
        if (source instanceof GraphViewer) {
            GraphViewer viewer = (GraphViewer)source;
            Set selectedVertices = this.getSelectedVertices();
            VertexMouseInfo vertexMouseInfo = GraphViewerUtils.convertMouseEventToVertexMouseEvent((GraphViewer)viewer, (MouseEvent)event);
            if (vertexMouseInfo == null) {
                return new FunctionGraphValidGraphActionContext(this, selectedVertices);
            }
            FGVertex vertexAtPoint = (FGVertex)vertexMouseInfo.getVertex();
            VertexActionContextInfo vertexInfo = this.createContexInfo(vertexAtPoint);
            if (this.controller.isScaledPastInteractionThreshold() || vertexMouseInfo.isGrabArea()) {
                return new FunctionGraphUneditableVertexLocationActionContext(this, vertexInfo);
            }
            FGVertex vertex = vertexInfo.getActiveVertex();
            if (vertex instanceof GroupedFunctionGraphVertex) {
                return new FunctionGraphUneditableVertexLocationActionContext(this, vertexInfo);
            }
            if (selectedVertices.size() > 1) {
                return new FunctionGraphUneditableVertexLocationActionContext(this, vertexInfo);
            }
            return new FunctionGraphEditableVertexLocationActionContext(this, vertexInfo);
        }
        throw new AssertException("Received mouse event from unexpected source in getActionContext(): " + String.valueOf(source));
    }

    private ActionContext createKeybindingContext() {
        boolean isPastInteractionThreshold = this.controller.isScaledPastInteractionThreshold();
        FGVertex vertex = this.controller.getFocusedVertex();
        if (vertex == null || isPastInteractionThreshold) {
            return new FunctionGraphValidGraphActionContext(this, this.getSelectedVertices());
        }
        VertexActionContextInfo vertexInfo = this.createContexInfo(vertex);
        return new FunctionGraphEditableVertexLocationActionContext(this, vertexInfo);
    }

    private VertexActionContextInfo createContexInfo(FGVertex vertex) {
        AddressSet hoveredVerticesAddresses = this.getAddressesFromHoveredVertices();
        AddressSet selectedVerticesAddresses = this.getAddressesForSelectedVertices();
        Set selectedVertices = this.getSelectedVertices();
        return new VertexActionContextInfo(vertex, selectedVertices, hoveredVerticesAddresses, selectedVerticesAddresses);
    }

    public JComponent getComponent() {
        return this.decorationPanel;
    }

    public void functionGraphDataChanged() {
        this.updateTitle();
        this.notifyContextChanged();
        this.setStatusInfo("");
    }

    private void updateTitle() {
        Pair<String, String> result = this.getTitleFromGraphData("Function Graph");
        Object title = (String)result.first;
        String subTitle = (String)result.second;
        if (!this.isConnected()) {
            title = "[" + (String)title + "]";
        }
        this.setTitle((String)title);
        this.setSubTitle(subTitle);
    }

    private Pair<String, String> getTitleFromGraphData(String title) {
        FunctionGraph functionGraph;
        FGData graphData = this.controller.getFunctionGraphData();
        Pair result = new Pair((Object)title, (Object)"");
        if (graphData == null) {
            return result;
        }
        Function function = graphData.getFunction();
        if (function == null) {
            return result;
        }
        FunctionGraph graph = functionGraph = graphData.getFunctionGraph();
        String first = "Function Graph";
        String programName = this.currentProgram != null ? this.currentProgram.getDomainFile().getName() : "";
        String second = function.getName() + " - " + graph.getVertexCount() + " vertices  (" + programName + ")";
        return new Pair((Object)first, (Object)second);
    }

    void doSetProgram(Program newProgram) {
        this.controller.clear();
        this.clipboardProvider.setProgram(newProgram);
        if (this.currentProgram != null) {
            this.currentProgram.removeListener((DomainObjectListener)this);
        }
        this.currentProgram = newProgram;
        if (this.currentProgram != null) {
            this.currentProgram.addListener((DomainObjectListener)this);
        }
    }

    public void graphLocationChanged(ProgramLocation newLocation) {
        this.storeLocation(newLocation);
        if (this.isFocusedProvider()) {
            this.notifyLocationChanged(newLocation);
        }
        this.notifyContextChanged();
    }

    public void graphSelectionChanged(ProgramSelection selection) {
        this.storeSelection(selection);
        this.notifySelectionChanged(selection);
    }

    private void storeSelection(ProgramSelection selection) {
        this.currentProgramSelection = selection;
        this.clipboardProvider.setSelection(selection);
        this.notifyContextChanged();
    }

    private void storeLocation(ProgramLocation location) {
        this.currentLocation = location;
        this.clipboardProvider.setLocation(location);
    }

    private void notifyLocationChanged(ProgramLocation location) {
        this.plugin.handleProviderLocationChanged(this, location);
    }

    private void notifySelectionChanged(ProgramSelection selection) {
        this.plugin.handleProviderSelectionChanged(this, selection);
    }

    private void notifyHighlightChanged(ProgramSelection selection) {
        this.plugin.handleProviderHighlightChanged(this, selection);
    }

    private void notifyContextChanged() {
        this.tool.contextChanged((ComponentProvider)this);
    }

    void programClosed(Program program) {
        this.storeLocation(null);
        this.controller.clear();
        this.controller.programClosed(program);
    }

    void setLocation(ProgramLocation newLocation) {
        this.pendingLocation = newLocation;
        this.updateLocationUpdateManager.update();
    }

    private void setPendingLocationFromUpdateManager() {
        if (this.pendingLocation == null) {
            return;
        }
        ProgramLocation newLocation = this.pendingLocation;
        this.pendingLocation = null;
        if (SystemUtilities.isEqual((Object)this.currentLocation, (Object)newLocation)) {
            return;
        }
        Program program = newLocation.getProgram();
        if (program.isClosed()) {
            return;
        }
        this.setLocationNow(newLocation);
    }

    private void setLocationNow(ProgramLocation newLocation) {
        if (newLocation == null) {
            return;
        }
        if (SystemUtilities.isEqual((Object)this.currentLocation, (Object)newLocation)) {
            return;
        }
        this.storeLocation(newLocation);
        this.displayLocation(newLocation);
        this.notifyContextChanged();
    }

    void displayLocation(ProgramLocation newLocation) {
        Address newAddress;
        Address address = newAddress = newLocation != null ? newLocation.getAddress() : null;
        if (this.isVisible() && newAddress != null) {
            this.controller.display(this.currentProgram, newLocation);
        }
    }

    public void refreshAndKeepPerspective() {
        this.controller.refresh(true);
    }

    public void refreshAndResetPerspective() {
        this.controller.refresh(false);
    }

    public void refreshDisplayWithoutRebuilding() {
        this.controller.refreshDisplayWithoutRebuilding();
    }

    public void optionsChanged() {
        this.controller.optionsChanged();
    }

    public void domainObjectChanged(DomainObjectChangedEvent ev) {
        if (!this.isVisible()) {
            return;
        }
        if (this.controller.getGraphedFunction() == null) {
            return;
        }
        boolean graphChangedButNotRebuilt = false;
        boolean rebuildGraphOnChanges = this.isPerformingGraphRebuildOnDataChanges();
        if (ev.contains(new EventType[]{DomainObjectEvent.RESTORED, ProgramEvent.FUNCTION_BODY_CHANGED})) {
            if (this.graphDataMissing()) {
                this.controller.clear();
                return;
            }
            graphChangedButNotRebuilt = !this.handleObjectRestored(ev, rebuildGraphOnChanges);
        } else if (ev.contains(new EventType[]{ProgramEvent.SYMBOL_ADDED, ProgramEvent.SYMBOL_REMOVED})) {
            if (this.currentGraphContainsEventAddress(ev)) {
                graphChangedButNotRebuilt = !this.handleSymbolAddedRemoved(ev, rebuildGraphOnChanges);
            }
        } else if (ev.contains(new EventType[]{ProgramEvent.REFERENCE_ADDED, ProgramEvent.REFERENCE_REMOVED})) {
            if (this.currentGraphContainsReferenceChangedEvent(ev)) {
                graphChangedButNotRebuilt = !this.handleReferenceAddedRemoved(ev, rebuildGraphOnChanges);
            }
        } else if (ev.contains((EventType)ProgramEvent.SYMBOL_RENAMED)) {
            this.handleSymbolRenamed(ev);
        }
        if (graphChangedButNotRebuilt) {
            this.updateGraphForAffectedAddresses(ev);
        }
        this.controller.repaint();
    }

    private boolean graphDataMissing() {
        FGData data = this.controller.getFunctionGraphData();
        if (!data.hasResults()) {
            return true;
        }
        FunctionGraph functionGraph = data.getFunctionGraph();
        FGVertex rootVertex = functionGraph.getRootVertex();
        if (rootVertex == null) {
            return true;
        }
        AddressSetView addresses = rootVertex.getAddresses();
        FunctionManager functionManager = this.currentProgram.getFunctionManager();
        Function currentFunctionInMemory = functionManager.getFunctionAt(addresses.getMinAddress());
        return currentFunctionInMemory == null;
    }

    private void updateGraphForAffectedAddresses(DomainObjectChangedEvent ev) {
        if (ev.contains((EventType)DomainObjectEvent.RESTORED)) {
            this.controller.invalidateAllCacheForProgram(this.currentProgram);
            return;
        }
        AddressSet addresses = new AddressSet();
        for (DomainObjectChangeRecord record : ev) {
            if (!(record instanceof ProgramChangeRecord)) continue;
            ProgramChangeRecord programRecord = (ProgramChangeRecord)record;
            Address start = programRecord.getStart();
            Address end = programRecord.getEnd();
            if (start == null || end == null) continue;
            addresses.addRange(start, end);
        }
        this.controller.invalidateCacheForAddresses(addresses);
    }

    private boolean handleObjectRestored(DomainObjectChangedEvent ev, boolean isRebuildingGraph) {
        if (isRebuildingGraph) {
            this.rebuildGraphUpdateManager.updateLater();
            return true;
        }
        this.controller.refreshDisplayWithoutRebuilding();
        return false;
    }

    private boolean handleReferenceAddedRemoved(DomainObjectChangedEvent ev, boolean isRebuildingGraph) {
        if (isRebuildingGraph) {
            this.rebuildGraphUpdateManager.updateLater();
            return true;
        }
        for (DomainObjectChangeRecord record : ev) {
            EventType eventType = record.getEventType();
            if (eventType == ProgramEvent.REFERENCE_ADDED) {
                this.handleReferenceAdded(record);
                continue;
            }
            if (eventType != ProgramEvent.REFERENCE_REMOVED) continue;
            this.handleReferenceRemoved(record);
        }
        return false;
    }

    private void handleReferenceRemoved(DomainObjectChangeRecord record) {
        AddressSetView vertexAddresses;
        Address minAddress;
        Reference reference;
        Address toAddress;
        FGData functionGraphData = this.controller.getFunctionGraphData();
        FunctionGraph functionGraph = functionGraphData.getFunctionGraph();
        FGVertex destinationVertex = functionGraph.getVertexForAddress(toAddress = (reference = (Reference)record.getOldValue()).getToAddress());
        if (destinationVertex == null) {
            return;
        }
        FunctionGraph graph = functionGraph;
        Collection inEdgesForDestination = graph.getInEdges(destinationVertex);
        if (inEdgesForDestination.size() == 0) {
            return;
        }
        if (inEdgesForDestination.size() > 1) {
            return;
        }
        FGEdge incomingEdge = (FGEdge)inEdgesForDestination.iterator().next();
        FGVertex parentVertex = (FGVertex)incomingEdge.getStart();
        Collection outEdges = graph.getOutEdges(parentVertex);
        if (outEdges.size() > 1) {
            return;
        }
        FlowType flowType = incomingEdge.getFlowType();
        if (!flowType.isFallthrough()) {
            return;
        }
        SymbolTable symbolTable = this.currentProgram.getSymbolTable();
        Symbol primary = symbolTable.getPrimarySymbol(minAddress = (vertexAddresses = destinationVertex.getAddresses()).getMinAddress());
        if (primary == null) {
            this.controller.mergeVertexWithParent(destinationVertex);
        }
    }

    private void handleReferenceAdded(DomainObjectChangeRecord record) {
        Reference reference;
        Address toAddress;
        FGData functionGraphData = this.controller.getFunctionGraphData();
        FunctionGraph functionGraph = functionGraphData.getFunctionGraph();
        FGVertex destinationVertex = functionGraph.getVertexForAddress(toAddress = (reference = (Reference)record.getNewValue()).getToAddress());
        if (destinationVertex == null) {
            return;
        }
        AddressSetView addresses = destinationVertex.getAddresses();
        Address minAddress = addresses.getMinAddress();
        if (toAddress.equals((Object)minAddress)) {
            return;
        }
        this.controller.splitVertex(destinationVertex, toAddress);
    }

    private boolean handleSymbolAddedRemoved(DomainObjectChangedEvent ev, boolean isRebuildingGraph) {
        if (isRebuildingGraph) {
            this.rebuildGraphUpdateManager.updateLater();
            return true;
        }
        for (DomainObjectChangeRecord record : ev) {
            EventType eventType = record.getEventType();
            if (eventType == ProgramEvent.SYMBOL_ADDED) {
                this.handleSymbolAdded(record);
                continue;
            }
            if (eventType != ProgramEvent.SYMBOL_REMOVED) continue;
            this.handleSymbolRemoved(record);
        }
        return false;
    }

    private void handleSymbolRemoved(DomainObjectChangeRecord record) {
        AddressSetView vertexAddresses;
        Address minAddress;
        Address address;
        FGData functionGraphData = this.controller.getFunctionGraphData();
        FunctionGraph functionGraph = functionGraphData.getFunctionGraph();
        FGVertex destinationVertex = functionGraph.getVertexForAddress(address = ((ProgramChangeRecord)record).getStart());
        if (destinationVertex == null) {
            return;
        }
        FunctionGraph graph = functionGraph;
        Collection inEdgesForDestination = graph.getInEdges(destinationVertex);
        if (inEdgesForDestination.size() == 0) {
            return;
        }
        if (inEdgesForDestination.size() > 1) {
            this.controller.refreshDisplayWithoutRebuilding();
            return;
        }
        FGEdge incomingEdge = (FGEdge)inEdgesForDestination.iterator().next();
        FGVertex parentVertex = (FGVertex)incomingEdge.getStart();
        Collection outEdges = graph.getOutEdges(parentVertex);
        if (outEdges.size() > 1) {
            return;
        }
        FlowType flowType = incomingEdge.getFlowType();
        if (!flowType.isFallthrough()) {
            this.controller.refreshDisplayWithoutRebuilding();
            return;
        }
        SymbolTable symbolTable = this.currentProgram.getSymbolTable();
        Symbol[] symbols = symbolTable.getSymbols(minAddress = (vertexAddresses = destinationVertex.getAddresses()).getMinAddress());
        if (symbols.length > 1) {
            this.controller.refreshDisplayWithoutRebuilding();
            return;
        }
        if (symbols.length == 1 && !symbols[0].isDynamic()) {
            this.controller.refreshDisplayWithoutRebuilding();
            return;
        }
        ReferenceManager referenceManager = this.currentProgram.getReferenceManager();
        ReferenceIterator references = referenceManager.getReferencesTo(minAddress);
        if (references.hasNext()) {
            return;
        }
        this.controller.mergeVertexWithParent(destinationVertex);
    }

    private void handleSymbolAdded(DomainObjectChangeRecord record) {
        Address address;
        FGData functionGraphData = this.controller.getFunctionGraphData();
        FunctionGraph functionGraph = functionGraphData.getFunctionGraph();
        FGVertex destinationVertex = functionGraph.getVertexForAddress(address = ((ProgramChangeRecord)record).getStart());
        if (destinationVertex == null) {
            return;
        }
        AddressSetView addresses = destinationVertex.getAddresses();
        Address minAddress = addresses.getMinAddress();
        if (address.equals((Object)minAddress)) {
            this.controller.refreshDisplayWithoutRebuilding();
            return;
        }
        this.controller.splitVertex(destinationVertex, address);
    }

    private void handleSymbolRenamed(DomainObjectChangedEvent ev) {
        for (int i = 0; i < ev.numRecords(); ++i) {
            Address address;
            DomainObjectChangeRecord record = ev.getChangeRecord(i);
            EventType eventType = record.getEventType();
            if (eventType != ProgramEvent.SYMBOL_RENAMED || (address = this.getChangedAddress(record)) == null) continue;
            this.controller.refreshDisplayForAddress(address);
        }
    }

    private boolean isPerformingGraphRebuildOnDataChanges() {
        FunctionGraphOptions options = this.controller.getFunctionGraphOptions();
        RelayoutOption relayoutOption = options.getRelayoutOption();
        switch (relayoutOption) {
            case ALWAYS: 
            case BLOCK_MODEL_CHANGES: {
                return true;
            }
            case NEVER: 
            case VERTEX_GROUPING_CHANGES: {
                return false;
            }
        }
        throw new AssertException("Unhandled case statement for Function Graph RelayoutOption");
    }

    private boolean currentGraphContainsEventAddress(DomainObjectChangedEvent ev) {
        FGData functionGraphData = this.controller.getFunctionGraphData();
        FunctionGraph graph = functionGraphData.getFunctionGraph();
        for (int i = 0; i < ev.numRecords(); ++i) {
            Address address = this.getChangedAddress(ev.getChangeRecord(i));
            if (address == null || graph.getVertexForAddress(address) == null) continue;
            return true;
        }
        return false;
    }

    private Address getChangedAddress(DomainObjectChangeRecord changeRecord) {
        if (changeRecord instanceof ProgramChangeRecord) {
            return ((ProgramChangeRecord)changeRecord).getStart();
        }
        return null;
    }

    private boolean currentGraphContainsReferenceChangedEvent(DomainObjectChangedEvent ev) {
        FGData functionGraphData = this.controller.getFunctionGraphData();
        FunctionGraph graph = functionGraphData.getFunctionGraph();
        for (DomainObjectChangeRecord record : ev) {
            Reference reference;
            Address toAddress;
            EventType eventType = record.getEventType();
            if (!(eventType == ProgramEvent.REFERENCE_ADDED ? graph.getVertexForAddress(toAddress = (reference = (Reference)record.getNewValue()).getToAddress()) != null : eventType == ProgramEvent.REFERENCE_REMOVED && graph.getVertexForAddress(toAddress = (reference = (Reference)record.getOldValue()).getToAddress()) != null)) continue;
            return true;
        }
        return false;
    }

    public void dispose() {
        this.unregisterNavigatable();
        this.disposed = true;
        for (NavigatableRemovalListener listener : this.navigationListeners) {
            listener.navigatableRemoved((Navigatable)this);
        }
        super.dispose();
        this.controller.cleanup();
        if (this.currentProgram != null) {
            this.currentProgram.removeListener((DomainObjectListener)this);
            this.currentProgram = null;
        }
    }

    public void componentHidden() {
        this.storeLocation(null);
        this.controller.primaryProviderHidden();
        super.componentHidden();
    }

    public void componentShown() {
        super.componentShown();
        if (this.currentLocation == null) {
            return;
        }
        this.refreshAndResetPerspective();
    }

    public void closeComponent() {
        super.closeComponent();
        this.controller.cleanup();
        this.plugin.closeProvider(this);
    }

    public String getWindowGroup() {
        if (this.isConnected()) {
            return "Function Graph";
        }
        return "disconnected";
    }

    public void formatChanged() {
        this.controller.formatChanged();
    }

    public void writeConfigState(SaveState saveState) {
        super.writeConfigState(saveState);
        saveState.putBoolean(DISPLAY_POPUPS, this.arePopupsVisible());
        this.actionManager.writeConfigState(saveState);
    }

    public void readConfigState(SaveState saveState) {
        super.readConfigState(saveState);
        this.actionManager.readConfigState(saveState);
        boolean showPopups = saveState.getBoolean(DISPLAY_POPUPS, true);
        this.setPopupsVisible(showPopups);
    }

    public void writeDataState(SaveState saveState) {
        saveState.putLong("NAV_ID", this.getInstanceID());
        if (!this.controller.hasResults()) {
            return;
        }
        if (this.currentLocation != null) {
            this.currentLocation.saveState(saveState);
        }
        GraphPerspectiveInfo<FGVertex, FGEdge> info = this.controller.getGraphPerspective(this.currentLocation);
        info.saveState(saveState);
    }

    public void readDataState(SaveState saveState) {
        this.unregisterNavigatable();
        this.initializeInstanceID(saveState.getLong("NAV_ID", this.getInstanceID()));
        this.registerNavigatable();
        if (this.currentProgram == null) {
            return;
        }
        ProgramLocation newLocation = ProgramLocation.getLocation((Program)this.currentProgram, (SaveState)saveState);
        this.storeLocation(newLocation);
        if (newLocation != null) {
            this.controller.display(this.currentProgram, newLocation);
        }
        this.controller.setGraphPerspective((GraphPerspectiveInfo<FGVertex, FGEdge>)new GraphPerspectiveInfo(saveState));
    }

    protected ComponentProvider getSatelliteProvider() {
        return super.getSatelliteProvider();
    }

    String getDisconnectedName() {
        return this.disconnectedName;
    }

    void setDisconnectedName(String name) {
        this.disconnectedName = name;
    }

    public void configChanged() {
        this.tool.setConfigChanged(true);
    }

    public void clearViewSettings() {
        this.controller.clearViewSettings();
    }

    void addMarkerProviderSupplier(MarginProviderSupplier supplier) {
        this.controller.addMarkerProviderSupplier(supplier);
        this.refreshAndKeepPerspective();
    }

    void removeMarkerProviderSupplier(MarginProviderSupplier supplier) {
        this.controller.removeMarkerProviderSupplier(supplier);
        this.refreshAndKeepPerspective();
    }

    public FunctionGraphPlugin getPlugin() {
        return this.plugin;
    }

    public Program getProgram() {
        return this.currentProgram;
    }

    public void setSelection(ProgramSelection selection) {
        this.storeSelection(selection);
        this.controller.setSelection(selection);
        this.notifySelectionChanged(selection);
    }

    public ProgramSelection getSelection() {
        if (this.currentProgramSelection == null || this.currentProgramSelection.isEmpty()) {
            return null;
        }
        FGData currentData = this.controller.getFunctionGraphData();
        if (!currentData.hasResults()) {
            return null;
        }
        Function function = currentData.getFunction();
        AddressSetView functionBody = function.getBody();
        AddressSet intersection = this.currentProgramSelection.intersect(functionBody);
        return new ProgramSelection((AddressSetView)intersection);
    }

    public ProgramSelection getHighlight() {
        if (this.currentProgramHighlight == null || this.currentProgramHighlight.isEmpty()) {
            return null;
        }
        FGData currentData = this.controller.getFunctionGraphData();
        if (!currentData.hasResults()) {
            return null;
        }
        Function function = currentData.getFunction();
        AddressSetView functionBody = function.getBody();
        AddressSet intersection = this.currentProgramHighlight.intersect(functionBody);
        return new ProgramSelection((AddressSetView)intersection);
    }

    public String getTextSelection() {
        FGData currentData = this.controller.getFunctionGraphData();
        if (!currentData.hasResults()) {
            return null;
        }
        FGVertex focusedVertex = this.controller.getFocusedVertex();
        if (focusedVertex == null) {
            return null;
        }
        return focusedVertex.getTextSelection();
    }

    public boolean supportsHighlight() {
        return true;
    }

    public void setHighlight(ProgramSelection highlight) {
        this.storeHighlight(highlight);
        this.controller.setHighlight(highlight);
        this.notifyHighlightChanged(highlight);
    }

    private void storeHighlight(ProgramSelection highlight) {
        this.currentProgramHighlight = highlight;
        this.notifyContextChanged();
    }

    public ProgramLocation getLocation() {
        return this.currentLocation;
    }

    public LocationMemento getMemento() {
        FGLocationMemento memento = new FGLocationMemento(this.currentProgram, this.currentLocation, this.controller.getGraphPerspective(this.currentLocation));
        return memento;
    }

    public void setMemento(LocationMemento memento) {
        FunctionGraphOptions options = this.controller.getFunctionGraphOptions();
        ViewRestoreOption viewOption = options.getViewRestoreOption();
        if (viewOption == ViewRestoreOption.REMEMBER_SETTINGS) {
            FGLocationMemento fgMemento = (FGLocationMemento)memento;
            this.controller.setGraphPerspective(fgMemento.getGraphPerspectiveInfo());
        }
    }

    private void setStatusInfo(String message) {
        this.tool.setStatusInfo(message);
    }

    public void internalGoTo(ProgramLocation location) {
        GoToService goToService = (GoToService)this.tool.getService(GoToService.class);
        goToService.goTo((Navigatable)this, location, location.getProgram());
    }

    public boolean goTo(Program gotoProgram, ProgramLocation location) {
        if (gotoProgram != this.currentProgram) {
            if (!this.isConnected()) {
                this.tool.setStatusInfo("Program location not applicable for this provider!");
                return false;
            }
            ProgramManager programManagerService = (ProgramManager)this.tool.getService(ProgramManager.class);
            if (programManagerService != null) {
                programManagerService.setCurrentProgram(gotoProgram);
            }
        }
        this.setLocation(location);
        this.notifyLocationChanged(location);
        this.tool.showComponentProvider((ComponentProvider)this, true);
        return true;
    }

    public boolean isFocusedProvider() {
        return this.focusStatusDelegate.get();
    }

    void setFocusStatusDelegate(Supplier<Boolean> focusStatusDelegate) {
        this.focusStatusDelegate = focusStatusDelegate;
    }

    public void removeHighlightProvider(ListingHighlightProvider highlightProvider, Program program) {
    }

    public void setHighlightProvider(ListingHighlightProvider highlightProvider, Program program) {
    }

    public Icon getIcon() {
        if (this.isConnected()) {
            return super.getIcon();
        }
        if (this.navigatableIcon == null) {
            Icon primaryIcon = super.getIcon();
            this.navigatableIcon = NavigatableIconFactory.createSnapshotOverlayIcon((Icon)primaryIcon);
        }
        return this.navigatableIcon;
    }

    public Icon getNavigatableIcon() {
        return this.getIcon();
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public boolean supportsMarkers() {
        return this.isConnected;
    }

    protected void setConnected(boolean newValue) {
        this.isConnected = newValue;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    private void registerNavigatable() {
        NavigatableRegistry.registerNavigatable((PluginTool)this.tool, (Navigatable)this);
    }

    private void unregisterNavigatable() {
        NavigatableRegistry.unregisterNavigatable((PluginTool)this.tool, (Navigatable)this);
    }

    public void addNavigatableListener(NavigatableRemovalListener listener) {
        this.navigationListeners.add((Object)listener);
    }

    public void removeNavigatableListener(NavigatableRemovalListener listener) {
        this.navigationListeners.remove((Object)listener);
    }
}

