/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.var;

import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.opnd.Opnd;
import ghidra.pcode.emu.jit.gen.tgt.JitCompiledPassage;
import ghidra.pcode.emu.jit.gen.util.Emitter;
import ghidra.pcode.emu.jit.gen.util.Local;
import ghidra.pcode.emu.jit.gen.util.Op;
import ghidra.pcode.emu.jit.gen.util.Scope;
import ghidra.pcode.emu.jit.gen.util.Types;
import ghidra.pcode.emu.jit.gen.var.ValGen;
import ghidra.pcode.emu.jit.var.JitConstVal;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigInteger;
import java.util.Objects;

public enum ConstValGen implements ValGen<JitConstVal>
{
    GEN;


    @Override
    public <THIS extends JitCompiledPassage, N extends Emitter.Next> Emitter<N> genValInit(Emitter<N> em, Local<Types.TRef<THIS>> localThis, JitCodeGenerator<THIS> gen, JitConstVal v) {
        return em;
    }

    @Override
    public <THIS extends JitCompiledPassage, T extends Types.BPrim<?>, JT extends JitType.SimpleJitType<T, JT>, N extends Emitter.Next> Emitter<Emitter.Ent<N, T>> genReadToStack(Emitter<N> em, Local<Types.TRef<THIS>> localThis, JitCodeGenerator<THIS> gen, JitConstVal v, JT type, Opnd.Ext ext) {
        JT JT = type;
        Objects.requireNonNull(JT);
        JT JT2 = JT;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.FloatJitType.class, JitType.DoubleJitType.class}, JT2, n)) {
            case 0 -> {
                JitType.IntJitType t = (JitType.IntJitType)JT2;
                yield em.emit(Op::ldc__i, v.value().intValue()).emit(ValGen::castBack, type, t);
            }
            case 1 -> {
                JitType.LongJitType t = (JitType.LongJitType)JT2;
                yield em.emit(Op::ldc__l, v.value().longValue()).emit(ValGen::castBack, type, t);
            }
            case 2 -> {
                JitType.FloatJitType t = (JitType.FloatJitType)JT2;
                yield em.emit(Op::ldc__f, Float.valueOf(Float.intBitsToFloat(v.value().intValue()))).emit(ValGen::castBack, type, t);
            }
            case 3 -> {
                JitType.DoubleJitType t = (JitType.DoubleJitType)JT2;
                yield em.emit(Op::ldc__d, Double.longBitsToDouble(v.value().longValue())).emit(ValGen::castBack, type, t);
            }
            default -> throw new AssertionError();
        };
    }

    @Override
    public <THIS extends JitCompiledPassage, N extends Emitter.Next> Opnd.OpndEm<JitType.MpIntJitType, N> genReadToOpnd(Emitter<N> em, Local<Types.TRef<THIS>> localThis, JitCodeGenerator<THIS> gen, JitConstVal v, JitType.MpIntJitType type, Opnd.Ext ext, Scope scope) {
        return new Opnd.OpndEm<JitType.MpIntJitType, N>(Opnd.constOf(type, v.value()), em);
    }

    @Override
    public <THIS extends JitCompiledPassage, N extends Emitter.Next> Emitter<Emitter.Ent<N, Types.TInt>> genReadLegToStack(Emitter<N> em, Local<Types.TRef<THIS>> localThis, JitCodeGenerator<THIS> gen, JitConstVal v, JitType.MpIntJitType type, int leg, Opnd.Ext ext) {
        BigInteger value = v.value();
        int legVal = value.shiftRight(leg * 32).intValue();
        return em.emit(Op::ldc__i, legVal);
    }

    @Override
    public <THIS extends JitCompiledPassage, N extends Emitter.Next> Emitter<Emitter.Ent<N, Types.TRef<int[]>>> genReadToArray(Emitter<N> em, Local<Types.TRef<THIS>> localThis, JitCodeGenerator<THIS> gen, JitConstVal v, JitType.MpIntJitType type, Opnd.Ext ext, Scope scope, int slack) {
        int legCount = type.legsAlloc();
        Emitter ckArr = em.emit(Op::ldc__i, legCount + slack).emit(Op::newarray, Types.T_INT);
        BigInteger value = v.value();
        for (int i = 0; i < legCount; ++i) {
            int leg = value.intValue();
            if (leg == 0) continue;
            ckArr = ckArr.emit(Op::dup).emit(Op::ldc__i, i).emit(Op::ldc__i, leg).emit(Op::iastore);
        }
        return ckArr;
    }

    @Override
    public <THIS extends JitCompiledPassage, N extends Emitter.Next> Emitter<Emitter.Ent<N, Types.TInt>> genReadToBool(Emitter<N> em, Local<Types.TRef<THIS>> localThis, JitCodeGenerator<THIS> gen, JitConstVal v) {
        return em.emit(Op::ldc__i, v.value().equals(BigInteger.ZERO) ? 0 : 1);
    }

    @Override
    public ValGen<JitConstVal> subpiece(int byteShift, int maxByteSize) {
        throw new AssertionError((Object)"Sleigh compiler generated subpiece of a constant?");
    }
}

