/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.util;

import ghidra.pcode.emu.jit.gen.util.Emitter;
import ghidra.pcode.emu.jit.gen.util.Lbl;
import ghidra.pcode.emu.jit.gen.util.Types;
import org.objectweb.asm.Label;

public interface Misc {
    public static <T1 extends Types.BNonVoid, N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, T1>> Emitter<Emitter.Ent<N1, T1>> cast1(Emitter<N0> em) {
        return em;
    }

    public static <T extends Throwable, N extends Emitter.Next> TryCatchBlock<T, N> tryCatch(Emitter<N> em, Lbl<N> end, Lbl<Emitter.Ent<N, Types.TRef<T>>> handler, Types.TRef<T> type) {
        Lbl start = Lbl.create();
        em = em.emit(Lbl::place, start);
        em.mv.visitTryCatchBlock(start.label(), end.label(), handler.label(), type.internalName());
        return new TryCatchBlock<T, N>(end, handler, em);
    }

    public static <N extends Emitter.Next> Emitter<N> lineNumber(Emitter<N> em, int number) {
        Label label = new Label();
        em.mv.visitLabel(label);
        em.mv.visitLineNumber(number, label);
        return em;
    }

    public static Void finish(Emitter<Emitter.Dead> em) {
        em.rootScope.close();
        try {
            em.mv.visitMaxs(0, 0);
        }
        catch (Exception e) {
            Emitter.LOGGER.log(System.Logger.Level.WARNING, "Failed to compute Maxs", (Throwable)e);
        }
        em.mv.visitEnd();
        return null;
    }

    public record TryCatchBlock<T extends Throwable, N extends Emitter.Next>(Lbl<N> end, Lbl<Emitter.Ent<N, Types.TRef<T>>> handler, Emitter<N> em) {
    }
}

