/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.opnd;

import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.gen.GenConsts;
import ghidra.pcode.emu.jit.gen.opnd.DoubleConstOpnd;
import ghidra.pcode.emu.jit.gen.opnd.DoubleLocalOpnd;
import ghidra.pcode.emu.jit.gen.opnd.FloatConstOpnd;
import ghidra.pcode.emu.jit.gen.opnd.FloatLocalOpnd;
import ghidra.pcode.emu.jit.gen.opnd.IntConstOpnd;
import ghidra.pcode.emu.jit.gen.opnd.IntLocalOpnd;
import ghidra.pcode.emu.jit.gen.opnd.IntReadOnlyLocalOpnd;
import ghidra.pcode.emu.jit.gen.opnd.LongConstOpnd;
import ghidra.pcode.emu.jit.gen.opnd.LongLocalOpnd;
import ghidra.pcode.emu.jit.gen.opnd.MpIntConstOpnd;
import ghidra.pcode.emu.jit.gen.opnd.MpIntLocalOpnd;
import ghidra.pcode.emu.jit.gen.opnd.SimpleOpnd;
import ghidra.pcode.emu.jit.gen.util.Emitter;
import ghidra.pcode.emu.jit.gen.util.Lbl;
import ghidra.pcode.emu.jit.gen.util.Local;
import ghidra.pcode.emu.jit.gen.util.Methods;
import ghidra.pcode.emu.jit.gen.util.Misc;
import ghidra.pcode.emu.jit.gen.util.Op;
import ghidra.pcode.emu.jit.gen.util.Scope;
import ghidra.pcode.emu.jit.gen.util.SubScope;
import ghidra.pcode.emu.jit.gen.util.Types;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public interface Opnd<T extends JitType> {
    public static boolean needsIntExt(JitType.IntJitType from, JitType.IntJitType to) {
        return to.size() < from.size();
    }

    public static boolean needsLongExt(JitType.LongJitType from, JitType.LongJitType to) {
        return to.size() < from.size();
    }

    public static <N2 extends Emitter.Next, N1 extends Emitter.Ent<N2, Types.TLong>, N0 extends Emitter.Ent<N1, Types.TInt>> Emitter<Emitter.Ent<N2, Types.TLong>> lextshr(Emitter<N0> em, Ext ext) {
        return switch (ext.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> em.emit(Op::lushr);
            case 1 -> em.emit(Op::lshr);
        };
    }

    public static SimpleOpnd<Types.TInt, JitType.IntJitType> constOf(JitType.IntJitType type, int value) {
        if (value == 0) {
            return IntConstOpnd.zero(type);
        }
        return new IntConstOpnd(value, type);
    }

    public static SimpleOpnd<Types.TLong, JitType.LongJitType> constOf(JitType.LongJitType type, long value) {
        return new LongConstOpnd(value, type);
    }

    public static SimpleOpnd<Types.TFloat, JitType.FloatJitType> constOf(JitType.FloatJitType type, float value) {
        return new FloatConstOpnd(value, type);
    }

    public static SimpleOpnd<Types.TDouble, JitType.DoubleJitType> constOf(JitType.DoubleJitType type, double value) {
        return new DoubleConstOpnd(value, type);
    }

    public static Opnd<JitType.MpIntJitType> constOf(JitType.MpIntJitType type, BigInteger value) {
        return new MpIntConstOpnd(value, type);
    }

    public static <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TInt>> Emitter<Emitter.Ent<N1, Types.TInt>> intToBool(Emitter<N0> em) {
        Lbl.LblEm lblTrue = em.emit(Op::ifne);
        Lbl.LblEm lblDone = lblTrue.em().emit(Op::ldc__i, 0).emit(Op::goto_);
        return lblDone.em().emit(Lbl::placeDead, lblTrue.lbl()).emit(Op::ldc__i, 1).emit(Lbl::place, lblDone.lbl());
    }

    public static <TT extends Types.BPrim<?>, TJT extends JitType.SimpleJitType<TT, TJT>, FT extends Types.BPrim<?>, FJT extends JitType.SimpleJitType<FT, FJT>, N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, FT>> Emitter<Emitter.Ent<N1, TT>> castStack1(Emitter<N0> em, FJT from, TJT to) {
        if (!1.$assertionsDisabled && from != to) {
            throw new AssertionError();
        }
        return em;
    }

    public static <T extends Types.BPrim<?>, JT extends JitType.SimpleJitType<T, JT>, N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, T>> SimpleOpnd.SimpleOpndEm<T, JT, N1> create(Emitter<N0> em, JT type, String name, Scope scope) {
        JT JT = type;
        Objects.requireNonNull(JT);
        JT JT2 = JT;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.FloatJitType.class, JitType.DoubleJitType.class}, JT2, n)) {
            case 0 -> {
                JitType.IntJitType t = (JitType.IntJitType)JT2;
                yield IntLocalOpnd.create(Opnd.castStack1(em, type, t), t, name, scope).castBack(type);
            }
            case 1 -> {
                JitType.LongJitType t = (JitType.LongJitType)JT2;
                yield LongLocalOpnd.create(Opnd.castStack1(em, type, t), t, name, scope).castBack(type);
            }
            case 2 -> {
                JitType.FloatJitType t = (JitType.FloatJitType)JT2;
                yield FloatLocalOpnd.create(Opnd.castStack1(em, type, t), t, name, scope).castBack(type);
            }
            case 3 -> {
                JitType.DoubleJitType t = (JitType.DoubleJitType)JT2;
                yield DoubleLocalOpnd.create(Opnd.castStack1(em, type, t), t, name, scope).castBack(type);
            }
            default -> throw new AssertionError();
        };
    }

    public static <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TInt>> SimpleOpnd.SimpleOpndEm<Types.TInt, JitType.IntJitType, N1> createInt(Emitter<N0> em, JitType.IntJitType type, String name, Scope scope) {
        return IntLocalOpnd.create(em, type, name, scope);
    }

    public static <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TInt>> SimpleOpnd.SimpleOpndEm<Types.TInt, JitType.IntJitType, N1> createIntReadOnly(Emitter<N0> em, JitType.IntJitType type, String name, Scope scope) {
        return IntReadOnlyLocalOpnd.create(em, type, name, scope);
    }

    public static <FT extends Types.BPrim<?>, FJT extends JitType.SimpleJitType<FT, FJT>, TT extends Types.BPrim<?>, TJT extends JitType.SimpleJitType<TT, TJT>> StackToStackConv<FT, FJT, TT, TJT> getStackToStack(FJT from, TJT to) {
        FJT FJT = from;
        Objects.requireNonNull(FJT);
        FJT FJT2 = FJT;
        int n = 0;
        return (StackToStackConv)((Object)(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.FloatJitType.class, JitType.DoubleJitType.class}, FJT2, n)) {
            case 0 -> {
                JitType.IntJitType ft = (JitType.IntJitType)FJT2;
                TJT v1 = to;
                Objects.requireNonNull(v1);
                TJT var9_5 = v1;
                int var10_7 = 0;
                Enum v2 = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.FloatJitType.class, JitType.DoubleJitType.class}, var9_5, var10_7)) {
                    case 0 -> {
                        JitType.IntJitType tt = (JitType.IntJitType)var9_5;
                        yield IntToInt.INSTANCE;
                    }
                    case 1 -> {
                        JitType.LongJitType tt = (JitType.LongJitType)var9_5;
                        yield IntToLong.INSTANCE;
                    }
                    case 2 -> {
                        JitType.FloatJitType tt = (JitType.FloatJitType)var9_5;
                        yield IntToFloat.INSTANCE;
                    }
                    case 3 -> {
                        JitType.DoubleJitType tt = (JitType.DoubleJitType)var9_5;
                        yield IntToDouble.INSTANCE;
                    }
                    default -> throw new AssertionError();
                };
                yield v2;
            }
            case 1 -> {
                JitType.LongJitType ft = (JitType.LongJitType)FJT2;
                TJT v4 = to;
                Objects.requireNonNull(v4);
                TJT var14_13 = v4;
                int var15_15 = 0;
                Enum v5 = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.FloatJitType.class, JitType.DoubleJitType.class}, var14_13, var15_15)) {
                    case 0 -> {
                        JitType.IntJitType tt = (JitType.IntJitType)var14_13;
                        yield LongToInt.INSTANCE;
                    }
                    case 1 -> {
                        JitType.LongJitType tt = (JitType.LongJitType)var14_13;
                        yield LongToLong.INSTANCE;
                    }
                    case 2 -> {
                        JitType.FloatJitType tt = (JitType.FloatJitType)var14_13;
                        yield LongToFloat.INSTANCE;
                    }
                    case 3 -> {
                        JitType.DoubleJitType tt = (JitType.DoubleJitType)var14_13;
                        yield LongToDouble.INSTANCE;
                    }
                    default -> throw new AssertionError();
                };
                yield v5;
            }
            case 2 -> {
                JitType.FloatJitType ft = (JitType.FloatJitType)FJT2;
                TJT v6 = to;
                Objects.requireNonNull(v6);
                TJT var19_20 = v6;
                int var20_22 = 0;
                Enum v7 = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.FloatJitType.class, JitType.DoubleJitType.class}, var19_20, var20_22)) {
                    case 0 -> {
                        JitType.IntJitType tt = (JitType.IntJitType)var19_20;
                        yield FloatToInt.INSTANCE;
                    }
                    case 1 -> {
                        JitType.LongJitType tt = (JitType.LongJitType)var19_20;
                        yield FloatToLong.INSTANCE;
                    }
                    case 2 -> {
                        JitType.FloatJitType tt = (JitType.FloatJitType)var19_20;
                        yield FloatToFloat.INSTANCE;
                    }
                    case 3 -> {
                        JitType.DoubleJitType tt = (JitType.DoubleJitType)var19_20;
                        yield FloatToDouble.INSTANCE;
                    }
                    default -> throw new AssertionError();
                };
                yield v7;
            }
            case 3 -> {
                JitType.DoubleJitType ft = (JitType.DoubleJitType)FJT2;
                TJT v8 = to;
                Objects.requireNonNull(v8);
                TJT var24_27 = v8;
                int var25_28 = 0;
                Enum v9 = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.FloatJitType.class, JitType.DoubleJitType.class}, var24_27, var25_28)) {
                    case 0 -> {
                        JitType.IntJitType tt = (JitType.IntJitType)var24_27;
                        yield DoubleToInt.INSTANCE;
                    }
                    case 1 -> {
                        JitType.LongJitType tt = (JitType.LongJitType)var24_27;
                        yield DoubleToLong.INSTANCE;
                    }
                    case 2 -> {
                        JitType.FloatJitType tt = (JitType.FloatJitType)var24_27;
                        yield DoubleToFloat.INSTANCE;
                    }
                    case 3 -> {
                        JitType.DoubleJitType tt = (JitType.DoubleJitType)var24_27;
                        yield DoubleToDouble.INSTANCE;
                    }
                    default -> throw new AssertionError();
                };
                yield v9;
            }
            default -> throw new AssertionError();
        }));
    }

    public static <FT extends Types.BPrim<?>, FJT extends JitType.SimpleJitType<FT, FJT>, TT extends Types.BPrim<?>, TJT extends JitType.SimpleJitType<TT, TJT>, N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, FT>> Emitter<Emitter.Ent<N1, TT>> convert(Emitter<N0> em, FJT from, TJT to, Ext ext) {
        return Opnd.getStackToStack(from, to).convertStackToStack(em, from, to, ext);
    }

    public static <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TInt>> Emitter<Emitter.Ent<N1, Types.TInt>> convertIntToInt(Emitter<N0> em, JitType.IntJitType from, JitType.IntJitType to, Ext ext) {
        return IntToInt.INSTANCE.convertStackToStack(em, from, to, ext);
    }

    public static <FT extends Types.BPrim<?>, FJT extends JitType.SimpleJitType<FT, FJT>, TT extends Types.BPrim<?>, TLT extends JitType.SimpleJitType<TT, TLT>, TJT extends JitType.LeggedJitType<TT, TLT>> StackToMpConv<FT, FJT, TT, TLT, TJT> getStackToMp(FJT from, TJT to) {
        FJT FJT = from;
        Objects.requireNonNull(FJT);
        FJT FJT2 = FJT;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.FloatJitType.class, JitType.DoubleJitType.class}, FJT2, n)) {
            case 0 -> {
                JitType.IntJitType ft = (JitType.IntJitType)FJT2;
                TJT v1 = to;
                Objects.requireNonNull(v1);
                TJT var6_5 = v1;
                int var7_7 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.MpIntJitType.class}, var6_5, var7_7)) {
                    case 0: {
                        JitType.MpIntJitType tt = (JitType.MpIntJitType)var6_5;
                        yield IntToMpInt.INSTANCE;
                    }
                }
                throw new AssertionError();
            }
            case 1 -> {
                JitType.LongJitType ft = (JitType.LongJitType)FJT2;
                TJT v3 = to;
                Objects.requireNonNull(v3);
                TJT var8_10 = v3;
                int var9_12 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.MpIntJitType.class}, var8_10, var9_12)) {
                    case 0: {
                        JitType.MpIntJitType tt = (JitType.MpIntJitType)var8_10;
                        yield LongToMpInt.INSTANCE;
                    }
                }
                throw new AssertionError();
            }
            case 2 -> {
                JitType.FloatJitType ft = (JitType.FloatJitType)FJT2;
                TJT v4 = to;
                Objects.requireNonNull(v4);
                TJT var10_14 = v4;
                int var11_16 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.MpIntJitType.class}, var10_14, var11_16)) {
                    case 0: {
                        JitType.MpIntJitType tt = (JitType.MpIntJitType)var10_14;
                        yield FloatToMpInt.INSTANCE;
                    }
                }
                throw new AssertionError();
            }
            case 3 -> {
                JitType.DoubleJitType ft = (JitType.DoubleJitType)FJT2;
                TJT v5 = to;
                Objects.requireNonNull(v5);
                TJT var12_18 = v5;
                int var13_19 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.MpIntJitType.class}, var12_18, var13_19)) {
                    case 0: {
                        JitType.MpIntJitType tt = (JitType.MpIntJitType)var12_18;
                        yield DoubleToMpInt.INSTANCE;
                    }
                }
                throw new AssertionError();
            }
            default -> throw new AssertionError();
        };
    }

    public static <FT extends Types.BPrim<?>, FJT extends JitType.SimpleJitType<FT, FJT>, TT extends Types.BPrim<?>, TLT extends JitType.SimpleJitType<TT, TLT>, TJT extends JitType.LeggedJitType<TT, TLT>, N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, FT>> OpndEm<TJT, N1> convertToOpnd(Emitter<N0> em, FJT from, String name, TJT to, Ext ext, Scope scope) {
        return Opnd.getStackToMp(from, to).convertStackToOpnd(em, from, name, to, ext, scope);
    }

    public static <FT extends Types.BPrim<?>, FJT extends JitType.SimpleJitType<FT, FJT>, TT extends Types.BPrim<?>, TLT extends JitType.SimpleJitType<TT, TLT>, TJT extends JitType.LeggedJitType<TT, TLT>, N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, FT>> Emitter<Emitter.Ent<N1, Types.TRef<int[]>>> convertToArray(Emitter<N0> em, FJT from, String name, TJT to, Ext ext, Scope scope, int slack) {
        return Opnd.getStackToMp(from, to).convertStackToArray(em, from, name, to, ext, scope, slack);
    }

    public T type();

    public String name();

    public List<? extends SimpleOpnd<?, ?>> legsLE();

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public static enum Ext {
        ZERO,
        SIGN;


        public static Ext forSigned(boolean signed) {
            return signed ? SIGN : ZERO;
        }
    }

    public static enum IntToInt implements StackToStackConv<Types.TInt, JitType.IntJitType, Types.TInt, JitType.IntJitType>
    {
        INSTANCE;


        @Override
        public <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TInt>> Emitter<Emitter.Ent<N1, Types.TInt>> convertStackToStack(Emitter<N0> em, JitType.IntJitType from, JitType.IntJitType to, Ext ext) {
            if (!Opnd.needsIntExt(from, to)) {
                return em.emit(Misc::cast1);
            }
            int shamt = 32 - to.size() * 8;
            return switch (ext.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> em.emit(Op::ldc__i, -1 >>> shamt).emit(Op::iand);
                case 1 -> {
                    switch (to.size()) {
                        case 1: {
                            yield em.emit(Op::i2b);
                        }
                        case 2: {
                            yield em.emit(Op::i2s);
                        }
                    }
                    yield em.emit(Op::ldc__i, shamt).emit(Op::ishl).emit(Op::ldc__i, shamt).emit(Op::ishr);
                }
            };
        }
    }

    public static enum IntToLong implements StackToStackConv<Types.TInt, JitType.IntJitType, Types.TLong, JitType.LongJitType>
    {
        INSTANCE;


        @Override
        public <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TInt>> Emitter<Emitter.Ent<N1, Types.TLong>> convertStackToStack(Emitter<N0> em, JitType.IntJitType from, JitType.LongJitType to, Ext ext) {
            return switch (ext.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> em.emit(Op::invokestatic, GenConsts.TR_INTEGER, "toUnsignedLong", GenConsts.MDESC_INTEGER__TO_UNSIGNED_LONG, false).step(Methods.Inv::takeArg).step(Methods.Inv::ret);
                case 1 -> em.emit(IntToInt.INSTANCE::convertStackToStack, from, JitType.IntJitType.I4, ext).emit(Op::i2l);
            };
        }
    }

    public static enum IntToFloat implements StackToStackConv<Types.TInt, JitType.IntJitType, Types.TFloat, JitType.FloatJitType>
    {
        INSTANCE;


        @Override
        public <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TInt>> Emitter<Emitter.Ent<N1, Types.TFloat>> convertStackToStack(Emitter<N0> em, JitType.IntJitType from, JitType.FloatJitType to, Ext ext) {
            return em.emit(Op::invokestatic, GenConsts.TR_FLOAT, "intBitsToFloat", GenConsts.MDESC_FLOAT__INT_BITS_TO_FLOAT, false).step(Methods.Inv::takeArg).step(Methods.Inv::ret);
        }
    }

    public static enum IntToDouble implements StackToStackConv<Types.TInt, JitType.IntJitType, Types.TDouble, JitType.DoubleJitType>
    {
        INSTANCE;


        @Override
        public <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TInt>> Emitter<Emitter.Ent<N1, Types.TDouble>> convertStackToStack(Emitter<N0> em, JitType.IntJitType from, JitType.DoubleJitType to, Ext ext) {
            return em.emit(IntToLong.INSTANCE::convertStackToStack, from, JitType.LongJitType.I8, ext).emit(LongToDouble.INSTANCE::convertStackToStack, JitType.LongJitType.I8, to, ext);
        }
    }

    public static enum LongToInt implements StackToStackConv<Types.TLong, JitType.LongJitType, Types.TInt, JitType.IntJitType>
    {
        INSTANCE;


        @Override
        public <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TLong>> Emitter<Emitter.Ent<N1, Types.TInt>> convertStackToStack(Emitter<N0> em, JitType.LongJitType from, JitType.IntJitType to, Ext ext) {
            return em.emit(Op::l2i).emit(IntToInt.INSTANCE::convertStackToStack, JitType.IntJitType.I4, to, ext);
        }
    }

    public static enum LongToLong implements StackToStackConv<Types.TLong, JitType.LongJitType, Types.TLong, JitType.LongJitType>
    {
        INSTANCE;


        @Override
        public <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TLong>> Emitter<Emitter.Ent<N1, Types.TLong>> convertStackToStack(Emitter<N0> em, JitType.LongJitType from, JitType.LongJitType to, Ext ext) {
            if (!Opnd.needsLongExt(from, to)) {
                return em.emit(Misc::cast1);
            }
            int shamt = 64 - to.size() * 8;
            return switch (ext.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> em.emit(Op::ldc__l, -1L >>> shamt).emit(Op::land);
                case 1 -> em.emit(Op::ldc__i, shamt).emit(Op::lshl).emit(Op::ldc__i, shamt).emit(Op::lshr);
            };
        }
    }

    public static enum LongToFloat implements StackToStackConv<Types.TLong, JitType.LongJitType, Types.TFloat, JitType.FloatJitType>
    {
        INSTANCE;


        @Override
        public <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TLong>> Emitter<Emitter.Ent<N1, Types.TFloat>> convertStackToStack(Emitter<N0> em, JitType.LongJitType from, JitType.FloatJitType to, Ext ext) {
            return em.emit(LongToInt.INSTANCE::convertStackToStack, from, JitType.IntJitType.I4, ext).emit(IntToFloat.INSTANCE::convertStackToStack, JitType.IntJitType.I4, to, ext);
        }
    }

    public static enum LongToDouble implements StackToStackConv<Types.TLong, JitType.LongJitType, Types.TDouble, JitType.DoubleJitType>
    {
        INSTANCE;


        @Override
        public <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TLong>> Emitter<Emitter.Ent<N1, Types.TDouble>> convertStackToStack(Emitter<N0> em, JitType.LongJitType from, JitType.DoubleJitType to, Ext ext) {
            if (to.size() != from.size()) {
                throw new AssertionError((Object)"Size mismatch");
            }
            return em.emit(Op::invokestatic, GenConsts.TR_DOUBLE, "longBitsToDouble", GenConsts.MDESC_DOUBLE__LONG_BITS_TO_DOUBLE, false).step(Methods.Inv::takeArg).step(Methods.Inv::ret);
        }
    }

    public static enum FloatToInt implements StackToStackConv<Types.TFloat, JitType.FloatJitType, Types.TInt, JitType.IntJitType>
    {
        INSTANCE;


        @Override
        public <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TFloat>> Emitter<Emitter.Ent<N1, Types.TInt>> convertStackToStack(Emitter<N0> em, JitType.FloatJitType from, JitType.IntJitType to, Ext ext) {
            if (to.size() != from.size()) {
                throw new AssertionError((Object)"Size mismatch");
            }
            return em.emit(Op::invokestatic, GenConsts.TR_FLOAT, "floatToRawIntBits", GenConsts.MDESC_FLOAT__FLOAT_TO_RAW_INT_BITS, false).step(Methods.Inv::takeArg).step(Methods.Inv::ret);
        }
    }

    public static enum FloatToLong implements StackToStackConv<Types.TFloat, JitType.FloatJitType, Types.TLong, JitType.LongJitType>
    {
        INSTANCE;


        @Override
        public <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TFloat>> Emitter<Emitter.Ent<N1, Types.TLong>> convertStackToStack(Emitter<N0> em, JitType.FloatJitType from, JitType.LongJitType to, Ext ext) {
            return em.emit(FloatToInt.INSTANCE::convertStackToStack, from, JitType.IntJitType.I4, ext).emit(IntToLong.INSTANCE::convertStackToStack, JitType.IntJitType.I4, to, ext);
        }
    }

    public static enum FloatToFloat implements StackToStackConv<Types.TFloat, JitType.FloatJitType, Types.TFloat, JitType.FloatJitType>
    {
        INSTANCE;


        @Override
        public <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TFloat>> Emitter<Emitter.Ent<N1, Types.TFloat>> convertStackToStack(Emitter<N0> em, JitType.FloatJitType from, JitType.FloatJitType to, Ext ext) {
            return em.emit(Misc::cast1);
        }
    }

    public static enum FloatToDouble implements StackToStackConv<Types.TFloat, JitType.FloatJitType, Types.TDouble, JitType.DoubleJitType>
    {
        INSTANCE;


        @Override
        public <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TFloat>> Emitter<Emitter.Ent<N1, Types.TDouble>> convertStackToStack(Emitter<N0> em, JitType.FloatJitType from, JitType.DoubleJitType to, Ext ext) {
            return em.emit(FloatToInt.INSTANCE::convertStackToStack, from, JitType.IntJitType.I4, ext).emit(IntToDouble.INSTANCE::convertStackToStack, JitType.IntJitType.I4, to, ext);
        }
    }

    public static enum DoubleToInt implements StackToStackConv<Types.TDouble, JitType.DoubleJitType, Types.TInt, JitType.IntJitType>
    {
        INSTANCE;


        @Override
        public <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TDouble>> Emitter<Emitter.Ent<N1, Types.TInt>> convertStackToStack(Emitter<N0> em, JitType.DoubleJitType from, JitType.IntJitType to, Ext ext) {
            return em.emit(DoubleToLong.INSTANCE::convertStackToStack, from, JitType.LongJitType.I8, ext).emit(LongToInt.INSTANCE::convertStackToStack, JitType.LongJitType.I8, to, ext);
        }
    }

    public static enum DoubleToLong implements StackToStackConv<Types.TDouble, JitType.DoubleJitType, Types.TLong, JitType.LongJitType>
    {
        INSTANCE;


        @Override
        public <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TDouble>> Emitter<Emitter.Ent<N1, Types.TLong>> convertStackToStack(Emitter<N0> em, JitType.DoubleJitType from, JitType.LongJitType to, Ext ext) {
            if (to.size() != from.size()) {
                throw new AssertionError((Object)"Size mismatch");
            }
            return em.emit(Op::invokestatic, GenConsts.TR_DOUBLE, "doubleToRawLongBits", GenConsts.MDESC_DOUBLE__DOUBLE_TO_RAW_LONG_BITS, false).step(Methods.Inv::takeArg).step(Methods.Inv::ret);
        }
    }

    public static enum DoubleToFloat implements StackToStackConv<Types.TDouble, JitType.DoubleJitType, Types.TFloat, JitType.FloatJitType>
    {
        INSTANCE;


        @Override
        public <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TDouble>> Emitter<Emitter.Ent<N1, Types.TFloat>> convertStackToStack(Emitter<N0> em, JitType.DoubleJitType from, JitType.FloatJitType to, Ext ext) {
            return em.emit(DoubleToInt.INSTANCE::convertStackToStack, from, JitType.IntJitType.I4, ext).emit(IntToFloat.INSTANCE::convertStackToStack, JitType.IntJitType.I4, to, ext);
        }
    }

    public static enum DoubleToDouble implements StackToStackConv<Types.TDouble, JitType.DoubleJitType, Types.TDouble, JitType.DoubleJitType>
    {
        INSTANCE;


        @Override
        public <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TDouble>> Emitter<Emitter.Ent<N1, Types.TDouble>> convertStackToStack(Emitter<N0> em, JitType.DoubleJitType from, JitType.DoubleJitType to, Ext ext) {
            return em.emit(Misc::cast1);
        }
    }

    public static interface StackToStackConv<FT extends Types.BPrim<?>, FJT extends JitType.SimpleJitType<FT, FJT>, TT extends Types.BPrim<?>, TJT extends JitType.SimpleJitType<TT, TJT>> {
        public <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, FT>> Emitter<Emitter.Ent<N1, TT>> convertStackToStack(Emitter<N0> var1, FJT var2, TJT var3, Ext var4);
    }

    public static enum IntToMpInt implements StackToMpConv<Types.TInt, JitType.IntJitType, Types.TInt, JitType.IntJitType, JitType.MpIntJitType>
    {
        INSTANCE;


        public <N extends Emitter.Next> OpndEm<JitType.MpIntJitType, N> doConvert(Emitter<N> em, SimpleOpnd<Types.TInt, JitType.IntJitType> temp, String name, JitType.MpIntJitType to, Ext ext, Scope scope) {
            ArrayList<SimpleOpnd<Types.TInt, JitType.IntJitType>> legs = new ArrayList<SimpleOpnd<Types.TInt, JitType.IntJitType>>();
            JitType.IntJitType typeLsl = to.legTypesLE().get(0);
            SimpleOpnd.SimpleOpndEm lsl = Opnd.needsIntExt((JitType.IntJitType)temp.type(), typeLsl) ? em.emit(temp::read).emit(IntToInt.INSTANCE::convertStackToStack, (JitType.IntJitType)temp.type(), typeLsl, ext).emit(temp::write, scope) : new SimpleOpnd.SimpleOpndEm(temp, em);
            legs.add(lsl.opnd());
            SimpleOpnd.SimpleOpndEm sign = switch (ext.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> new SimpleOpnd.SimpleOpndEm(IntConstOpnd.ZERO_I4, em);
                case 1 -> lsl.em().emit(lsl.opnd()::read).emit(Op::ldc__i, 31).emit(Op::ishr).emit(Opnd::createIntReadOnly, JitType.IntJitType.I4, "%s_convSign".formatted(name), scope);
            };
            for (int i = 1; i < to.legsAlloc(); ++i) {
                legs.add(sign.opnd());
            }
            return new OpndEm<JitType.MpIntJitType, N>(MpIntLocalOpnd.of(to, "%s_convMpInt".formatted(name), legs), sign.em());
        }

        @Override
        public <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TInt>> OpndEm<JitType.MpIntJitType, N1> convertStackToOpnd(Emitter<N0> em, JitType.IntJitType from, String name, JitType.MpIntJitType to, Ext ext, Scope scope) {
            JitType.IntJitType typeLsl = to.legTypesLE().get(0);
            SimpleOpnd.SimpleOpndEm lsl = em.emit(IntToInt.INSTANCE::convertStackToStack, from, typeLsl, ext).emit(IntLocalOpnd.temp(typeLsl, "%s_convLeg0".formatted(name), scope)::write, scope);
            return this.doConvert(lsl.em(), lsl.opnd(), name, to, ext, scope);
        }

        @Override
        public <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TInt>> Emitter<Emitter.Ent<N1, Types.TRef<int[]>>> convertStackToArray(Emitter<N0> em, JitType.IntJitType from, String name, JitType.MpIntJitType to, Ext ext, Scope scope, int slack) {
            int legCount = to.legsAlloc();
            Local<Types.TRef<int[]>> arr = scope.decl(Types.T_INT_ARR, "%s_convArr".formatted(name));
            try (SubScope ss = scope.sub();){
                JitType.IntJitType typeLsl = to.legTypesLE().get(0);
                Local<Types.TInt> lsl = ss.decl(typeLsl.bType(), "temp_lsl");
                Emitter ckExt = em.emit(IntToInt.INSTANCE::convertStackToStack, from, typeLsl, ext).emit(Op::istore, lsl).emit(Op::ldc__i, legCount + slack).emit(Op::newarray, Types.T_INT).emit(Op::astore, arr).emit(Op::aload, arr).emit(Op::ldc__i, 0).emit(Op::iload, lsl).emit(Op::iastore);
                switch (ext.ordinal()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        Local<Types.TInt> sign = ss.decl(Types.T_INT, "temp_sign");
                        ckExt = ckExt.emit(Op::iload, lsl).emit(Op::ldc__i, 31).emit(Op::ishr).emit(Op::istore, sign);
                        for (int i = 1; i < legCount; ++i) {
                            ckExt = ckExt.emit(Op::aload, arr).emit(Op::ldc__i, i).emit(Op::iload, sign).emit(Op::iastore);
                        }
                        break;
                    }
                }
                Emitter emitter = ckExt.emit(Op::aload, arr);
                return emitter;
            }
        }
    }

    public static enum LongToMpInt implements StackToMpConv<Types.TLong, JitType.LongJitType, Types.TInt, JitType.IntJitType, JitType.MpIntJitType>
    {
        INSTANCE;


        @Override
        public <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TLong>> OpndEm<JitType.MpIntJitType, N1> convertStackToOpnd(Emitter<N0> em, JitType.LongJitType from, String name, JitType.MpIntJitType to, Ext ext, Scope scope) {
            Emitter upperOnStack = em.emit(Op::dup2__2).emit(Op::ldc__i, 32).emit(Opnd::lextshr, ext).emit(Op::l2i);
            SimpleOpnd.SimpleOpndEm sign = switch (ext.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> new SimpleOpnd.SimpleOpndEm(IntConstOpnd.ZERO_I4, upperOnStack);
                case 1 -> upperOnStack.emit(Op::dup).emit(Op::ldc__i, 31).emit(Op::ishr).emit(Opnd::createIntReadOnly, JitType.IntJitType.I4, "%s_convSign".formatted(name), scope);
            };
            upperOnStack = sign.em();
            ArrayList legs = new ArrayList();
            IntLocalOpnd lower = IntLocalOpnd.temp(JitType.IntJitType.I4, "%s_convLegLower".formatted(name), scope);
            legs.add(lower);
            SimpleOpnd.SimpleOpndEm upper = sign.em().emit(IntLocalOpnd::create, JitType.IntJitType.I4, "%s_convLegUpper".formatted(name), scope);
            legs.add(upper.opnd());
            for (int i = 2; i < to.legsAlloc(); ++i) {
                legs.add(sign.opnd());
            }
            return new OpndEm(MpIntLocalOpnd.of(to, "%s_convMpInt".formatted(name), legs), upper.em().emit(Op::l2i).emit(lower::writeDirect));
        }

        @Override
        public <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TLong>> Emitter<Emitter.Ent<N1, Types.TRef<int[]>>> convertStackToArray(Emitter<N0> em, JitType.LongJitType from, String name, JitType.MpIntJitType to, Ext ext, Scope scope, int slack) {
            int legCount = to.legsAlloc();
            Local<Types.TRef<int[]>> arr = scope.decl(Types.T_INT_ARR, "%s_convArr".formatted(name));
            try (SubScope ss = scope.sub();){
                JitType.IntJitType typeLsl = to.legTypesLE().get(0);
                JitType.IntJitType typeMsl = to.legTypesLE().get(1);
                Local<Types.TInt> lsl = ss.decl(typeLsl.bType(), "temp_lsl");
                Local<Types.TInt> msl = ss.decl(typeMsl.bType(), "temp_msl");
                Emitter ckExt = em.emit(Op::dup2__2).emit(Op::l2i).emit(Op::istore, lsl).emit(Op::ldc__i, 32).emit(Opnd::lextshr, ext).emit(Op::l2i).emit(Op::istore, msl).emit(Op::ldc__i, legCount + slack).emit(Op::newarray, Types.T_INT).emit(Op::astore, arr).emit(Op::aload, arr).emit(Op::ldc__i, 0).emit(Op::iload, lsl).emit(Op::iastore).emit(Op::aload, arr).emit(Op::ldc__i, 1).emit(Op::iload, msl).emit(Op::iastore);
                switch (ext.ordinal()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        Local<Types.TInt> sign = ss.decl(Types.T_INT, "temp_sign");
                        ckExt = ckExt.emit(Op::iload, msl).emit(Op::ldc__i, 31).emit(Op::ishr).emit(Op::istore, sign);
                        for (int i = 2; i < legCount; ++i) {
                            ckExt = ckExt.emit(Op::aload, arr).emit(Op::ldc__i, i).emit(Op::iload, sign).emit(Op::iastore);
                        }
                        break;
                    }
                }
                Emitter emitter = ckExt.emit(Op::aload, arr);
                return emitter;
            }
        }
    }

    public static enum FloatToMpInt implements StackToMpConv<Types.TFloat, JitType.FloatJitType, Types.TInt, JitType.IntJitType, JitType.MpIntJitType>
    {
        INSTANCE;


        @Override
        public <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TFloat>> OpndEm<JitType.MpIntJitType, N1> convertStackToOpnd(Emitter<N0> em, JitType.FloatJitType from, String name, JitType.MpIntJitType to, Ext ext, Scope scope) {
            return em.emit(FloatToInt.INSTANCE::convertStackToStack, from, JitType.IntJitType.I4, ext).emit(IntToMpInt.INSTANCE::convertStackToOpnd, JitType.IntJitType.I4, name, to, ext, scope);
        }

        @Override
        public <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TFloat>> Emitter<Emitter.Ent<N1, Types.TRef<int[]>>> convertStackToArray(Emitter<N0> em, JitType.FloatJitType from, String name, JitType.MpIntJitType to, Ext ext, Scope scope, int slack) {
            return em.emit(FloatToInt.INSTANCE::convertStackToStack, from, JitType.IntJitType.I4, ext).emit(IntToMpInt.INSTANCE::convertStackToArray, JitType.IntJitType.I4, name, to, ext, scope, slack);
        }
    }

    public static enum DoubleToMpInt implements StackToMpConv<Types.TDouble, JitType.DoubleJitType, Types.TInt, JitType.IntJitType, JitType.MpIntJitType>
    {
        INSTANCE;


        @Override
        public <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TDouble>> OpndEm<JitType.MpIntJitType, N1> convertStackToOpnd(Emitter<N0> em, JitType.DoubleJitType from, String name, JitType.MpIntJitType to, Ext ext, Scope scope) {
            return em.emit(DoubleToLong.INSTANCE::convertStackToStack, from, JitType.LongJitType.I8, ext).emit(LongToMpInt.INSTANCE::convertStackToOpnd, JitType.LongJitType.I8, name, to, ext, scope);
        }

        @Override
        public <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TDouble>> Emitter<Emitter.Ent<N1, Types.TRef<int[]>>> convertStackToArray(Emitter<N0> em, JitType.DoubleJitType from, String name, JitType.MpIntJitType to, Ext ext, Scope scope, int slack) {
            return em.emit(DoubleToLong.INSTANCE::convertStackToStack, from, JitType.LongJitType.I8, ext).emit(LongToMpInt.INSTANCE::convertStackToArray, JitType.LongJitType.I8, name, to, ext, scope, slack);
        }
    }

    public static interface StackToMpConv<FT extends Types.BPrim<?>, FJT extends JitType.SimpleJitType<FT, FJT>, TT extends Types.BPrim<?>, TLT extends JitType.SimpleJitType<TT, TLT>, TJT extends JitType.LeggedJitType<TT, TLT>> {
        public <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, FT>> OpndEm<TJT, N1> convertStackToOpnd(Emitter<N0> var1, FJT var2, String var3, TJT var4, Ext var5, Scope var6);

        public <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, FT>> Emitter<Emitter.Ent<N1, Types.TRef<int[]>>> convertStackToArray(Emitter<N0> var1, FJT var2, String var3, TJT var4, Ext var5, Scope var6, int var7);
    }

    public record OpndEm<T extends JitType, N extends Emitter.Next>(Opnd<T> opnd, Emitter<N> em) {
        public <TT extends JitType> OpndEm<TT, N> castBack(TT to, T from) {
            assert (from == to);
            return this;
        }
    }

    public static enum MpIntToDouble implements MpToStackConv<Types.TInt, JitType.IntJitType, JitType.MpIntJitType, Types.TDouble, JitType.DoubleJitType>
    {
        INSTANCE;


        @Override
        public <N extends Emitter.Next> Emitter<Emitter.Ent<N, Types.TDouble>> convertOpndToStack(Emitter<N> em, Opnd<JitType.MpIntJitType> from, JitType.DoubleJitType to, Ext ext) {
            return em.emit(MpIntToLong.INSTANCE::convertOpndToStack, from, JitType.LongJitType.I8, ext).emit(LongToDouble.INSTANCE::convertStackToStack, JitType.LongJitType.I8, to, ext);
        }

        @Override
        public <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TRef<int[]>>> Emitter<Emitter.Ent<N1, Types.TDouble>> convertArrayToStack(Emitter<N0> em, JitType.MpIntJitType from, JitType.DoubleJitType to, Ext ext) {
            return em.emit(MpIntToLong.INSTANCE::convertArrayToStack, from, JitType.LongJitType.I8, ext).emit(LongToDouble.INSTANCE::convertStackToStack, JitType.LongJitType.I8, to, ext);
        }
    }

    public static enum MpIntToFloat implements MpToStackConv<Types.TInt, JitType.IntJitType, JitType.MpIntJitType, Types.TFloat, JitType.FloatJitType>
    {
        INSTANCE;


        @Override
        public <N extends Emitter.Next> Emitter<Emitter.Ent<N, Types.TFloat>> convertOpndToStack(Emitter<N> em, Opnd<JitType.MpIntJitType> from, JitType.FloatJitType to, Ext ext) {
            return em.emit(MpIntToInt.INSTANCE::convertOpndToStack, from, JitType.IntJitType.I4, ext).emit(IntToFloat.INSTANCE::convertStackToStack, JitType.IntJitType.I4, to, ext);
        }

        @Override
        public <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TRef<int[]>>> Emitter<Emitter.Ent<N1, Types.TFloat>> convertArrayToStack(Emitter<N0> em, JitType.MpIntJitType from, JitType.FloatJitType to, Ext ext) {
            return em.emit(MpIntToInt.INSTANCE::convertArrayToStack, from, JitType.IntJitType.I4, ext).emit(IntToFloat.INSTANCE::convertStackToStack, JitType.IntJitType.I4, to, ext);
        }
    }

    public static enum MpIntToMpInt implements MpToMpConv<Types.TInt, JitType.IntJitType, JitType.MpIntJitType, Types.TInt, JitType.IntJitType, JitType.MpIntJitType>
    {
        INSTANCE;


        @Override
        public <N extends Emitter.Next> OpndEm<JitType.MpIntJitType, N> convertOpndToOpnd(Emitter<N> em, Opnd<JitType.MpIntJitType> from, JitType.MpIntJitType to, Ext ext, Scope scope) {
            SimpleOpnd curLeg;
            if (to.size() == from.type().size()) {
                return new OpndEm<JitType.MpIntJitType, N>(from, em);
            }
            List fromLegs = from.type().castLegsLE(from);
            List<JitType.IntJitType> toLegTypes = to.legTypesLE();
            int legsIn = from.legsLE().size();
            int legsOut = to.legsAlloc();
            int defLegs = Integer.min(legsIn, legsOut);
            ArrayList<SimpleOpnd<Types.TInt, JitType.IntJitType>> toLegs = new ArrayList<SimpleOpnd<Types.TInt, JitType.IntJitType>>();
            for (int i = 0; i < defLegs; ++i) {
                SimpleOpnd<Types.TInt, JitType.IntJitType> simpleOpnd;
                curLeg = fromLegs.get(i);
                Objects.requireNonNull(curLeg);
                int n = 0;
                block12: while (true) {
                    SimpleOpnd simpleOpnd2;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IntReadOnlyLocalOpnd.class, IntConstOpnd.class}, (Object)simpleOpnd2, n)) {
                        case 0: {
                            IntReadOnlyLocalOpnd ro = (IntReadOnlyLocalOpnd)simpleOpnd2;
                            if (ext != Ext.SIGN) {
                                n = 1;
                                continue block12;
                            }
                            simpleOpnd = ro;
                            break block12;
                        }
                        case 1: {
                            IntConstOpnd c = (IntConstOpnd)simpleOpnd2;
                            if (ext != Ext.ZERO) {
                                n = 2;
                                continue block12;
                            }
                            simpleOpnd = c;
                            break block12;
                        }
                        default: {
                            if (!Opnd.needsIntExt((JitType.IntJitType)curLeg.type(), toLegTypes.get(i))) {
                                simpleOpnd = curLeg;
                                break block12;
                            }
                            String name = "%s_convLeg%d".formatted(from.name(), i);
                            SimpleOpnd.SimpleOpndEm result = em.emit(curLeg::read).emit(Opnd::convertIntToInt, JitType.IntJitType.I4, (JitType.IntJitType)curLeg.type(), ext).emit(Opnd::convertIntToInt, (JitType.IntJitType)curLeg.type(), toLegTypes.get(i), ext).emit(Opnd::createInt, toLegTypes.get(i), name, scope);
                            em = result.em();
                            simpleOpnd = result.opnd();
                            break block12;
                        }
                    }
                    break;
                }
                toLegs.add(simpleOpnd);
            }
            if (legsOut > defLegs) {
                SimpleOpnd.SimpleOpndEm sign = switch (ext.ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 0 -> new SimpleOpnd.SimpleOpndEm(IntConstOpnd.ZERO_I4, em);
                    case 1 -> {
                        SimpleOpnd v2 = (SimpleOpnd)toLegs.getLast();
                        Objects.requireNonNull(v2);
                        curLeg = v2;
                        int var14_17 = 0;
                        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IntConstOpnd.class}, (Object)curLeg, var14_17)) {
                            case 0: {
                                IntConstOpnd c = (IntConstOpnd)curLeg;
                                yield new SimpleOpnd.SimpleOpndEm(c, em);
                            }
                        }
                        yield em.emit(((SimpleOpnd)toLegs.getLast())::read).emit(Op::ldc__i, 31).emit(Op::ishr).emit(Opnd::createIntReadOnly, JitType.IntJitType.I4, "%s_sign".formatted(from.name()), scope);
                    }
                };
                em = sign.em();
                for (int i = defLegs; i < legsOut; ++i) {
                    toLegs.add(sign.opnd());
                }
            }
            return new OpndEm<JitType.MpIntJitType, N>(MpIntLocalOpnd.of(to, "%s_convMpInt".formatted(from.name()), toLegs), em);
        }

        public static <N extends Emitter.Next> Emitter<N> doGenArrExt(Emitter<N> em, Local<Types.TRef<int[]>> arr, int legsOut, int defLegs, Ext ext, Scope scope) {
            Emitter emitter;
            if (legsOut <= defLegs) {
                return em;
            }
            switch (ext.ordinal()) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    Emitter emitter2;
                    emitter = emitter2 = em;
                    break;
                }
                case 1: {
                    try (SubScope ss = scope.sub();){
                        Local<Types.TInt> sign = ss.decl(Types.T_INT, "temp_sign");
                        em = em.emit(Op::aload, arr).emit(Op::ldc__i, defLegs - 1).emit(Op::iaload).emit(Op::ldc__i, 31).emit(Op::ishr).emit(Op::istore, sign);
                        for (int i = defLegs; i < legsOut; ++i) {
                            em = em.emit(Op::aload, arr).emit(Op::ldc__i, i).emit(Op::iload, sign).emit(Op::iastore);
                        }
                        Emitter emitter3 = em;
                        emitter = emitter3;
                        break;
                    }
                }
            }
            return emitter;
        }

        @Override
        public <N extends Emitter.Next> Emitter<Emitter.Ent<N, Types.TRef<int[]>>> convertOpndToArray(Emitter<N> em, Opnd<JitType.MpIntJitType> from, JitType.MpIntJitType to, Ext ext, Scope scope, int slack) {
            List fromLegs = from.type().castLegsLE(from);
            List<JitType.IntJitType> toLegTypes = to.legTypesLE();
            int legsIn = from.type().legsAlloc();
            int legsOut = to.legsAlloc();
            int defLegs = Integer.min(legsIn, legsOut);
            Local<Types.TRef<int[]>> arr = scope.decl(Types.T_INT_ARR, "%s_convArr".formatted(from.name()));
            em = em.emit(Op::ldc__i, legsOut + slack).emit(Op::newarray, Types.T_INT).emit(Op::astore, arr);
            for (int i = 0; i < defLegs; ++i) {
                SimpleOpnd fromLeg = fromLegs.get(i);
                JitType.IntJitType toLegType = toLegTypes.get(i);
                em = em.emit(Op::aload, arr).emit(Op::ldc__i, i).emit(fromLeg::read).emit(Opnd::convertIntToInt, (JitType.IntJitType)fromLeg.type(), toLegType, ext).emit(Op::iastore);
            }
            return em.emit(MpIntToMpInt::doGenArrExt, arr, legsOut, defLegs, ext, scope).emit(Op::aload, arr);
        }
    }

    public static enum MpIntToLong implements MpToStackConv<Types.TInt, JitType.IntJitType, JitType.MpIntJitType, Types.TLong, JitType.LongJitType>
    {
        INSTANCE;


        @Override
        public <N extends Emitter.Next> Emitter<Emitter.Ent<N, Types.TLong>> convertOpndToStack(Emitter<N> em, Opnd<JitType.MpIntJitType> from, JitType.LongJitType to, Ext ext) {
            List legs = from.type().castLegsLE(from);
            return em.emit(legs.get(1)::read).emit(legs.get(0)::read).emit(Op::invokestatic, GenConsts.T_JIT_COMPILED_PASSAGE, "conv2IntToLong", GenConsts.MDESC_JIT_COMPILED_PASSAGE__CONV_OFFSET2_TO_LONG, true).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::ret).emit(LongToLong.INSTANCE::convertStackToStack, JitType.LongJitType.I8, to, ext);
        }

        @Override
        public <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TRef<int[]>>> Emitter<Emitter.Ent<N1, Types.TLong>> convertArrayToStack(Emitter<N0> em, JitType.MpIntJitType from, JitType.LongJitType to, Ext ext) {
            return em.emit(Op::dup).emit(Op::ldc__i, 1).emit(Op::iaload).emit(Op::swap).emit(Op::ldc__i, 0).emit(Op::iaload).emit(Op::invokestatic, GenConsts.T_JIT_COMPILED_PASSAGE, "conv2IntToLong", GenConsts.MDESC_JIT_COMPILED_PASSAGE__CONV_OFFSET2_TO_LONG, true).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::ret).emit(LongToLong.INSTANCE::convertStackToStack, JitType.LongJitType.I8, to, ext);
        }
    }

    public static enum MpIntToInt implements MpToStackConv<Types.TInt, JitType.IntJitType, JitType.MpIntJitType, Types.TInt, JitType.IntJitType>
    {
        INSTANCE;


        @Override
        public <N extends Emitter.Next> Emitter<Emitter.Ent<N, Types.TInt>> convertOpndToStack(Emitter<N> em, Opnd<JitType.MpIntJitType> from, JitType.IntJitType to, Ext ext) {
            SimpleOpnd lsl = from.type().castLegsLE(from).get(0);
            return em.emit(lsl::read).emit(IntToInt.INSTANCE::convertStackToStack, (JitType.IntJitType)lsl.type(), to, ext);
        }

        @Override
        public <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TRef<int[]>>> Emitter<Emitter.Ent<N1, Types.TInt>> convertArrayToStack(Emitter<N0> em, JitType.MpIntJitType from, JitType.IntJitType to, Ext ext) {
            JitType.IntJitType typeLsl = from.legTypesLE().get(0);
            return em.emit(Op::ldc__i, 0).emit(Op::iaload).emit(IntToInt.INSTANCE::convertStackToStack, typeLsl, to, ext);
        }
    }

    public static interface MpToMpConv<FT extends Types.BPrim<?>, FLT extends JitType.SimpleJitType<FT, FLT>, FJT extends JitType.LeggedJitType<FT, FLT>, TT extends Types.BPrim<?>, TLT extends JitType.SimpleJitType<TT, TLT>, TJT extends JitType.LeggedJitType<TT, TLT>> {
        public <N extends Emitter.Next> OpndEm<TJT, N> convertOpndToOpnd(Emitter<N> var1, Opnd<FJT> var2, TJT var3, Ext var4, Scope var5);

        public <N extends Emitter.Next> Emitter<Emitter.Ent<N, Types.TRef<int[]>>> convertOpndToArray(Emitter<N> var1, Opnd<FJT> var2, TJT var3, Ext var4, Scope var5, int var6);
    }

    public static interface MpToStackConv<FT extends Types.BPrim<?>, FLT extends JitType.SimpleJitType<FT, FLT>, FJT extends JitType.LeggedJitType<FT, FLT>, TT extends Types.BPrim<?>, TJT extends JitType.SimpleJitType<TT, TJT>> {
        public <N extends Emitter.Next> Emitter<Emitter.Ent<N, TT>> convertOpndToStack(Emitter<N> var1, Opnd<FJT> var2, TJT var3, Ext var4);

        public <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TRef<int[]>>> Emitter<Emitter.Ent<N1, TT>> convertArrayToStack(Emitter<N0> var1, FJT var2, TJT var3, Ext var4);
    }
}

