/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.op;

import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.gen.GenConsts;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.op.IntCountUnOpGen;
import ghidra.pcode.emu.jit.gen.tgt.JitCompiledPassage;
import ghidra.pcode.emu.jit.gen.util.Emitter;
import ghidra.pcode.emu.jit.gen.util.Lbl;
import ghidra.pcode.emu.jit.gen.util.Local;
import ghidra.pcode.emu.jit.gen.util.Methods;
import ghidra.pcode.emu.jit.gen.util.Op;
import ghidra.pcode.emu.jit.gen.util.Scope;
import ghidra.pcode.emu.jit.gen.util.Types;
import ghidra.pcode.emu.jit.op.JitLzCountOp;

public enum LzCountOpGen implements IntCountUnOpGen<JitLzCountOp>
{
    GEN;


    @Override
    public boolean isSigned() {
        return false;
    }

    @Override
    public <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TInt>> Emitter<Emitter.Ent<N1, Types.TInt>> opForInt(Emitter<N0> em, JitType.IntJitType type) {
        Emitter temp = em.emit(Op::invokestatic, GenConsts.TR_INTEGER, "numberOfLeadingZeros", GenConsts.MDESC_INTEGER__NUMBER_OF_LEADING_ZEROS, false).step(Methods.Inv::takeArg).step(Methods.Inv::ret);
        if (type != JitType.IntJitType.I4) {
            return temp.emit(Op::ldc__i, 32 - type.size() * 8).emit(Op::isub);
        }
        return temp;
    }

    @Override
    public <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TLong>> Emitter<Emitter.Ent<N1, Types.TInt>> opForLong(Emitter<N0> em, JitType.LongJitType type) {
        Emitter temp = em.emit(Op::invokestatic, GenConsts.TR_LONG, "numberOfLeadingZeros", GenConsts.MDESC_LONG__NUMBER_OF_LEADING_ZEROS, false).step(Methods.Inv::takeArg).step(Methods.Inv::ret);
        if (type != JitType.LongJitType.I8) {
            return temp.emit(Op::ldc__i, 64 - type.size() * 8).emit(Op::isub);
        }
        return temp;
    }

    @Override
    public <THIS extends JitCompiledPassage> Emitter<Emitter.Ent<Emitter.Bot, Types.TInt>> genRunMpInt(Emitter<Emitter.Bot> em, Local<Types.TRef<THIS>> localThis, JitCodeGenerator<THIS> gen, JitLzCountOp op, JitType.MpIntJitType type, Scope scope) {
        int legCount = type.legsAlloc();
        Lbl lblDone = Lbl.create();
        Emitter emCount = em.emit(gen::genReadLegToStack, localThis, op.u(), type, legCount - 1, this.ext()).emit(Op::invokestatic, GenConsts.TR_INTEGER, "numberOfLeadingZeros", GenConsts.MDESC_INTEGER__NUMBER_OF_LEADING_ZEROS, false).step(Methods.Inv::takeArg).step(Methods.Inv::ret).emit(Op::dup).emit(Op::ldc__i, 32).emit(Op::if_icmpne, lblDone);
        for (int i = legCount - 2; i >= 1; --i) {
            emCount = emCount.emit(gen::genReadLegToStack, localThis, op.u(), type, i, this.ext()).emit(Op::invokestatic, GenConsts.TR_INTEGER, "numberOfLeadingZeros", GenConsts.MDESC_INTEGER__NUMBER_OF_LEADING_ZEROS, false).step(Methods.Inv::takeArg).step(Methods.Inv::ret).emit(Op::iadd).emit(Op::dup).emit(Op::ldc__i, 32 * (legCount - i)).emit(Op::if_icmpne, lblDone);
        }
        emCount = emCount.emit(gen::genReadLegToStack, localThis, op.u(), type, 0, this.ext()).emit(Op::invokestatic, GenConsts.TR_INTEGER, "numberOfLeadingZeros", GenConsts.MDESC_INTEGER__NUMBER_OF_LEADING_ZEROS, false).step(Methods.Inv::takeArg).step(Methods.Inv::ret).emit(Op::iadd).emit(Lbl::place, lblDone);
        JitType.IntJitType mslType = type.legTypesLE().getLast();
        if (mslType != JitType.IntJitType.I4) {
            emCount = emCount.emit(Op::ldc__i, 32 - mslType.size() * 8).emit(Op::isub);
        }
        return emCount;
    }
}

