/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.op;

import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.op.IntOpBinOpGen;
import ghidra.pcode.emu.jit.gen.opnd.MpIntLocalOpnd;
import ghidra.pcode.emu.jit.gen.opnd.Opnd;
import ghidra.pcode.emu.jit.gen.opnd.SimpleOpnd;
import ghidra.pcode.emu.jit.gen.tgt.JitCompiledPassage;
import ghidra.pcode.emu.jit.gen.util.Emitter;
import ghidra.pcode.emu.jit.gen.util.Local;
import ghidra.pcode.emu.jit.gen.util.Op;
import ghidra.pcode.emu.jit.gen.util.Scope;
import ghidra.pcode.emu.jit.gen.util.Types;
import ghidra.pcode.emu.jit.op.JitIntAddOp;
import java.util.ArrayList;
import java.util.List;

public final class IntAddOpGen
extends Enum<IntAddOpGen>
implements IntOpBinOpGen<JitIntAddOp> {
    public static final /* enum */ IntAddOpGen GEN = new IntAddOpGen();
    private static final /* synthetic */ IntAddOpGen[] $VALUES;

    public static IntAddOpGen[] values() {
        return (IntAddOpGen[])$VALUES.clone();
    }

    public static IntAddOpGen valueOf(String name) {
        return Enum.valueOf(IntAddOpGen.class, name);
    }

    @Override
    public boolean isSigned() {
        return false;
    }

    @Override
    public <N2 extends Emitter.Next, N1 extends Emitter.Ent<N2, Types.TInt>, N0 extends Emitter.Ent<N1, Types.TInt>> Emitter<Emitter.Ent<N2, Types.TInt>> opForInt(Emitter<N0> em, JitType.IntJitType type) {
        return Op.iadd(em);
    }

    @Override
    public <N2 extends Emitter.Next, N1 extends Emitter.Ent<N2, Types.TLong>, N0 extends Emitter.Ent<N1, Types.TLong>> Emitter<Emitter.Ent<N2, Types.TLong>> opForLong(Emitter<N0> em, JitType.LongJitType type) {
        return Op.ladd(em);
    }

    static Emitter<Emitter.Ent<Emitter.Bot, Types.TLong>> prepLeftAndCarry(Emitter<Emitter.Ent<Emitter.Bot, Types.TLong>> em, SimpleOpnd<Types.TInt, JitType.IntJitType> left) {
        return em.emit(Op::ldc__i, 32).emit(Op::lushr).emit(left::read).emit(Op::i2l).emit(Op::ladd);
    }

    static Emitter<Emitter.Ent<Emitter.Bot, Types.TLong>> addRight(Emitter<Emitter.Ent<Emitter.Bot, Types.TLong>> em, SimpleOpnd<Types.TInt, JitType.IntJitType> right) {
        return em.emit(right::read).emit(Op::i2l).emit(Op::ladd);
    }

    static SimpleOpnd.SimpleOpndEm<Types.TInt, JitType.IntJitType, Emitter.Ent<Emitter.Bot, Types.TLong>> maybeStore(Emitter<Emitter.Ent<Emitter.Bot, Types.TLong>> em, SimpleOpnd<Types.TInt, JitType.IntJitType> into, boolean store, Scope scope) {
        if (!store) {
            return new SimpleOpnd.SimpleOpndEm<Types.TInt, JitType.IntJitType, Emitter.Ent<Emitter.Bot, Types.TLong>>(null, em);
        }
        return em.emit(Op::dup2__2).emit(Op::l2i).emit(into::write, scope);
    }

    static SimpleOpnd.SimpleOpndEm<Types.TInt, JitType.IntJitType, Emitter.Ent<Emitter.Bot, Types.TLong>> genMpIntLegAddTakesAndGivesCarry(Emitter<Emitter.Ent<Emitter.Bot, Types.TLong>> em, SimpleOpnd<Types.TInt, JitType.IntJitType> left, SimpleOpnd<Types.TInt, JitType.IntJitType> right, boolean storesResult, Scope scope) {
        return em.emit(IntAddOpGen::prepLeftAndCarry, left).emit(IntAddOpGen::addRight, right).emit(IntAddOpGen::maybeStore, left, storesResult, scope);
    }

    static SimpleOpnd.SimpleOpndEm<Types.TInt, JitType.IntJitType, Emitter.Ent<Emitter.Bot, Types.TLong>> genMpIntLegAddGivesCarry(Emitter<Emitter.Bot> em, SimpleOpnd<Types.TInt, JitType.IntJitType> left, SimpleOpnd<Types.TInt, JitType.IntJitType> right, boolean storesResult, Scope scope) {
        return em.emit(left::read).emit(Op::i2l).emit(IntAddOpGen::addRight, right).emit(IntAddOpGen::maybeStore, left, storesResult, scope);
    }

    static SimpleOpnd.SimpleOpndEm<Types.TInt, JitType.IntJitType, Emitter.Bot> genMpIntLegAddTakesCarry(Emitter<Emitter.Ent<Emitter.Bot, Types.TLong>> em, SimpleOpnd<Types.TInt, JitType.IntJitType> left, SimpleOpnd<Types.TInt, JitType.IntJitType> right, Scope scope) {
        return em.emit(IntAddOpGen::prepLeftAndCarry, left).emit(IntAddOpGen::addRight, right).emit(Op::l2i).emit(left::write, scope);
    }

    @Override
    public <THIS extends JitCompiledPassage> Emitter<Emitter.Bot> genRunMpInt(Emitter<Emitter.Bot> em, Local<Types.TRef<THIS>> localThis, JitCodeGenerator<THIS> gen, JitIntAddOp op, JitType.MpIntJitType type, Scope scope) {
        Opnd.OpndEm<JitType.MpIntJitType, Emitter.Bot> left = gen.genReadToOpnd(em, localThis, op.l(), type, this.ext(), scope);
        Opnd.OpndEm<JitType.MpIntJitType, Emitter.Bot> right = gen.genReadToOpnd(left.em(), localThis, op.r(), type, this.rExt(), scope);
        em = right.em();
        List lLegs = left.opnd().type().castLegsLE(left.opnd());
        assert (lLegs.size() >= 2);
        List rLegs = right.opnd().type().castLegsLE(right.opnd());
        ArrayList<SimpleOpnd<Types.TInt, JitType.IntJitType>> outLegs = new ArrayList<SimpleOpnd<Types.TInt, JitType.IntJitType>>();
        int legCount = type.legsAlloc();
        SimpleOpnd.SimpleOpndEm<Types.TInt, JitType.IntJitType, Emitter.Ent<Emitter.Bot, Types.TLong>> first = IntAddOpGen.genMpIntLegAddGivesCarry(em, lLegs.getFirst(), rLegs.getFirst(), true, scope);
        Emitter<Emitter.Ent<Emitter.Bot, Types.TLong>> emCarry = first.em();
        outLegs.add(first.opnd());
        for (int i = 1; i < legCount - 1; ++i) {
            SimpleOpnd.SimpleOpndEm<Types.TInt, JitType.IntJitType, Emitter.Ent<Emitter.Bot, Types.TLong>> result = IntAddOpGen.genMpIntLegAddTakesAndGivesCarry(emCarry, lLegs.get(i), rLegs.get(i), true, scope);
            emCarry = result.em();
            outLegs.add(result.opnd());
        }
        SimpleOpnd.SimpleOpndEm<Types.TInt, JitType.IntJitType, Emitter.Bot> last = IntAddOpGen.genMpIntLegAddTakesCarry(emCarry, lLegs.getLast(), rLegs.getLast(), scope);
        em = last.em();
        outLegs.add(last.opnd());
        MpIntLocalOpnd out = MpIntLocalOpnd.of(type, "out", outLegs);
        return gen.genWriteFromOpnd(em, localThis, op.out(), out, this.ext(), scope);
    }

    private static /* synthetic */ IntAddOpGen[] $values() {
        return new IntAddOpGen[]{GEN};
    }

    static {
        $VALUES = IntAddOpGen.$values();
    }
}

