/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.op;

import ghidra.pcode.emu.jit.JitPassage;
import ghidra.pcode.emu.jit.analysis.JitControlFlowModel;
import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.analysis.JitTypeBehavior;
import ghidra.pcode.emu.jit.gen.FieldForPcodeOp;
import ghidra.pcode.emu.jit.gen.FieldForUserop;
import ghidra.pcode.emu.jit.gen.GenConsts;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.op.OpGen;
import ghidra.pcode.emu.jit.gen.opnd.Opnd;
import ghidra.pcode.emu.jit.gen.tgt.JitCompiledPassage;
import ghidra.pcode.emu.jit.gen.util.Emitter;
import ghidra.pcode.emu.jit.gen.util.Lbl;
import ghidra.pcode.emu.jit.gen.util.Local;
import ghidra.pcode.emu.jit.gen.util.Methods;
import ghidra.pcode.emu.jit.gen.util.Misc;
import ghidra.pcode.emu.jit.gen.util.Op;
import ghidra.pcode.emu.jit.gen.util.Scope;
import ghidra.pcode.emu.jit.gen.util.Types;
import ghidra.pcode.emu.jit.gen.var.VarGen;
import ghidra.pcode.emu.jit.op.JitCallOtherDefOp;
import ghidra.pcode.emu.jit.op.JitCallOtherOpIf;
import ghidra.pcode.emu.jit.var.JitVal;
import ghidra.pcode.exec.AnnotatedPcodeUseropLibrary;
import ghidra.pcode.exec.PcodeUseropLibrary;
import ghidra.program.model.pcode.PcodeOp;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum CallOtherOpGen implements OpGen<JitCallOtherOpIf>
{
    GEN;


    public static <THIS extends JitCompiledPassage> OpGen.OpResult genRunRetirementStrategy(Emitter<Emitter.Bot> em, Local<Types.TRef<THIS>> localThis, JitCodeGenerator<THIS> gen, PcodeOp op, JitControlFlowModel.JitBlock block, PcodeUseropLibrary.PcodeUseropDefinition<?> userop) {
        FieldForUserop useropField = gen.requestFieldForUserop(userop);
        FieldForPcodeOp opField = gen.requestStaticFieldForOp(op);
        VarGen.BlockTransition<THIS> transition = VarGen.computeBlockTransition(localThis, gen, block, null);
        JitCodeGenerator.PcGen pcGen = JitCodeGenerator.PcGen.loadOffset(gen.getAddressForOp(op));
        return new OpGen.LiveOpResult(em.emit(transition::genFwd).emit(gen::genRetirePcCtx, localThis, pcGen, gen.getExitContext(op), JitCodeGenerator.RetireMode.SET).emit(Op::aload, localThis).emit(useropField::genLoad, localThis, gen).emit(opField::genLoad, gen).emit(Op::invokeinterface, GenConsts.T_JIT_COMPILED_PASSAGE, "invokeUserop", GenConsts.MDESC_JIT_COMPILED_PASSAGE__INVOKE_USEROP).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::takeObjRef).step(Methods.Inv::retVoid).emit(transition::genInv));
    }

    static Parameter findOutputParameter(Parameter[] parameters, Method method) {
        List<Parameter> found = Stream.of(parameters).filter(p -> p.getAnnotation(AnnotatedPcodeUseropLibrary.OpOutput.class) != null).toList();
        return switch (found.size()) {
            case 0 -> null;
            case 1 -> {
                Parameter p = found.get(0);
                if (p.getType() == int[].class) {
                    yield p;
                }
                throw new IllegalArgumentException("@%s requires parameter to have type int[] when functional=true. Got %s (method %s)".formatted(AnnotatedPcodeUseropLibrary.OpOutput.class.getSimpleName(), p, method.getName()));
            }
            default -> throw new IllegalArgumentException("@%s can only be applied to one parameter of method %s. It is applied to: %s".formatted(AnnotatedPcodeUseropLibrary.OpOutput.class.getSimpleName(), method.getName(), found.stream().map(Parameter::toString).collect(Collectors.joining(", "))));
        };
    }

    public static <THIS extends JitCompiledPassage, LIB extends PcodeUseropLibrary<?>> OpGen.OpResult genRunDirectStrategy(Emitter<Emitter.Bot> em, final Local<Types.TRef<THIS>> localThis, final JitCodeGenerator<THIS> gen, JitCallOtherOpIf op, JitControlFlowModel.JitBlock block, final Scope scope) {
        JitType.MpIntJitType outMpType;
        Local<Types.TRef<int[]>> localOut;
        FieldForUserop useropField = gen.requestFieldForUserop(op.userop());
        final Method method = op.userop().getJavaMethod();
        Parameter[] parameters = method.getParameters();
        final Parameter outputParameter = CallOtherOpGen.findOutputParameter(parameters, method);
        if (outputParameter != null && method.getReturnType() != Void.TYPE) {
            throw new IllegalArgumentException("@%s cannot be applied to any parameter of a method returning non-void. It's applied to %s of %s".formatted(AnnotatedPcodeUseropLibrary.OpOutput.class.getSimpleName(), outputParameter, method.getName()));
        }
        if (outputParameter != null) {
            localOut = scope.decl(Types.T_INT_ARR, "out");
            if (op instanceof JitCallOtherDefOp) {
                JitCallOtherDefOp defOp = (JitCallOtherDefOp)op;
                outMpType = JitType.MpIntJitType.forSize(defOp.out().size());
                em = em.emit(Op::ldc__i, outMpType.legsAlloc()).emit(Op::newarray, Types.T_INT).emit(Op::astore, localOut);
            } else {
                outMpType = null;
                em = em.emit(Op::aconst_null, Types.T_INT_ARR).emit(Op::astore, localOut);
            }
        } else {
            outMpType = null;
            localOut = null;
        }
        final Types.TRef libType = Types.refExtends(GenConsts.T_PCODE_USEROP_LIBRARY, method.getDeclaringClass());
        var rec = new Object(){

            <N extends Emitter.Next> Emitter<? extends Emitter.Ent<N, ?>> doReadArg(Emitter<N> em, JitVal arg, Parameter param) {
                if (param.getType() == Boolean.TYPE) {
                    return gen.genReadToBool(em, localThis, arg);
                }
                if (param.getType() == int[].class) {
                    JitType.MpIntJitType t = JitType.MpIntJitType.forSize(arg.size());
                    return gen.genReadToArray(em, localThis, arg, t, Opnd.Ext.ZERO, scope, 0);
                }
                JitType jitType = JitType.forJavaType(param.getType());
                Objects.requireNonNull(jitType);
                JitType jitType2 = jitType;
                int n = 0;
                return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.FloatJitType.class, JitType.DoubleJitType.class}, (Object)jitType2, n)) {
                    case 0 -> {
                        JitType.IntJitType t = (JitType.IntJitType)jitType2;
                        yield gen.genReadToStack(em, localThis, arg, t, Opnd.Ext.ZERO);
                    }
                    case 1 -> {
                        JitType.LongJitType t = (JitType.LongJitType)jitType2;
                        yield gen.genReadToStack(em, localThis, arg, t, Opnd.Ext.ZERO);
                    }
                    case 2 -> {
                        JitType.FloatJitType t = (JitType.FloatJitType)jitType2;
                        yield gen.genReadToStack(em, localThis, arg, t, Opnd.Ext.ZERO);
                    }
                    case 3 -> {
                        JitType.DoubleJitType t = (JitType.DoubleJitType)jitType2;
                        yield gen.genReadToStack(em, localThis, arg, t, Opnd.Ext.ZERO);
                    }
                    default -> throw new AssertionError();
                };
            }

            <N extends Emitter.Next> Methods.ObjInv<?, LIB, N, ?> doInv(Emitter<N> em, List<JitVal> args, List<Parameter> params) {
                if (params.isEmpty()) {
                    return Op.invokevirtual(em, libType, method.getName(), Methods.MthDesc.reflect(method), false);
                }
                Parameter param = params.getFirst();
                if (param == outputParameter) {
                    Emitter emOut = em.emit(Op::aload, localOut);
                    Methods.ObjInv inv = this.doInv(emOut, args, params.subList(1, params.size()));
                    return Methods.Inv.takeQArg(inv);
                }
                JitVal arg = args.getFirst();
                Emitter<Emitter.Ent<N, ?>> emRead = this.doReadArg(em, arg, param);
                Methods.ObjInv inv = this.doInv(emRead, args.subList(1, args.size()), params.subList(1, params.size()));
                return Methods.Inv.takeQArg(inv);
            }
        };
        Misc.TryCatchBlock tryCatchBlock = Misc.tryCatch(em, Lbl.create(), gen.requestExceptionHandler((JitPassage.DecodedPcodeOp)op.op(), block).lbl(), GenConsts.T_THROWABLE);
        em = tryCatchBlock.em();
        Emitter emLib = em.emit(useropField::genLoad, localThis, gen).emit(Op::invokeinterface, GenConsts.T_PCODE_USEROP_DEFINITION, "getDefiningLibrary", GenConsts.MDESC_PCODE_USEROP_DEFINITION__GET_DEFINING_LIBRARY).step(Methods.Inv::takeObjRef).step(Methods.Inv::ret).emit(Op::checkcast, libType);
        Methods.Inv inv = rec.doInv(emLib, op.args(), Arrays.asList(parameters)).step(Methods.Inv::takeQObjRef);
        if (outputParameter != null) {
            if (outMpType != null && op instanceof JitCallOtherDefOp) {
                JitCallOtherDefOp defOp = (JitCallOtherDefOp)op;
                em = inv.step(Methods.Inv::retQVoid).emit(Op::aload, localOut).emit(gen::genWriteFromArray, localThis, defOp.out(), outMpType, Opnd.Ext.ZERO, scope);
            }
        } else if (op instanceof JitCallOtherDefOp) {
            final JitCallOtherDefOp defOp = (JitCallOtherDefOp)op;
            Object write = new Object(){

                public <T extends Types.BPrim<?>, JT extends JitType.SimpleJitType<T, JT>> Emitter<Emitter.Bot> doWrite(Methods.Inv<?, Emitter.Bot, Emitter.Bot> inv, Class<?> returnType) {
                    Object type = JitType.SimpleJitType.forJavaType(returnType);
                    return inv.step(Methods.Inv::retQ, type.bType()).emit(gen::genWriteFromStack, localThis, defOp.out(), type, Opnd.Ext.ZERO, scope);
                }
            };
            em = inv.step((write)::doWrite, method.getReturnType());
        } else if (method.getReturnType() != Void.TYPE) {
            JitType jitType = JitType.forJavaType(method.getReturnType());
            Objects.requireNonNull(jitType);
            JitType jitType2 = jitType;
            int n = 0;
            em = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.FloatJitType.class, JitType.DoubleJitType.class}, (Object)jitType2, n)) {
                case 0 -> {
                    JitType.IntJitType t = (JitType.IntJitType)jitType2;
                    yield inv.step(Methods.Inv::retQ, t.bType()).emit(Op::pop);
                }
                case 1 -> {
                    JitType.LongJitType t = (JitType.LongJitType)jitType2;
                    yield inv.step(Methods.Inv::retQ, t.bType()).emit(Op::pop2__2);
                }
                case 2 -> {
                    JitType.FloatJitType t = (JitType.FloatJitType)jitType2;
                    yield inv.step(Methods.Inv::retQ, t.bType()).emit(Op::pop);
                }
                case 3 -> {
                    JitType.DoubleJitType t = (JitType.DoubleJitType)jitType2;
                    yield inv.step(Methods.Inv::retQ, t.bType()).emit(Op::pop2__2);
                }
                default -> throw new AssertionError();
            };
        }
        return new OpGen.LiveOpResult(em.emit(Lbl::place, tryCatchBlock.end()));
    }

    public static boolean canDoDirectInvocation(JitCallOtherOpIf op) {
        JitCallOtherDefOp defOp;
        if (!op.userop().isFunctional() || op.userop().modifiesContext()) {
            return false;
        }
        for (JitTypeBehavior type : op.inputTypes()) {
            if (type != JitTypeBehavior.ANY) continue;
            return false;
        }
        return !(op instanceof JitCallOtherDefOp) || (defOp = (JitCallOtherDefOp)op).type() != JitTypeBehavior.ANY;
    }

    @Override
    public <THIS extends JitCompiledPassage> OpGen.OpResult genRun(Emitter<Emitter.Bot> em, Local<Types.TRef<THIS>> localThis, Local<Types.TInt> localCtxmod, Methods.RetReq<Types.TRef<JitCompiledPassage.EntryPoint>> retReq, JitCodeGenerator<THIS> gen, JitCallOtherOpIf op, JitControlFlowModel.JitBlock block, Scope scope) {
        if (op.userop().modifiesContext()) {
            em = em.emit(Op::ldc__i, 1).emit(Op::istore, localCtxmod);
        }
        if (CallOtherOpGen.canDoDirectInvocation(op)) {
            return CallOtherOpGen.genRunDirectStrategy(em, localThis, gen, op, block, scope);
        }
        return CallOtherOpGen.genRunRetirementStrategy(em, localThis, gen, op.op(), block, op.userop());
    }
}

