/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.op;

import ghidra.pcode.emu.jit.JitPassage;
import ghidra.pcode.emu.jit.analysis.JitControlFlowModel;
import ghidra.pcode.emu.jit.gen.FieldForExitSlot;
import ghidra.pcode.emu.jit.gen.GenConsts;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.op.OpGen;
import ghidra.pcode.emu.jit.gen.tgt.JitCompiledPassage;
import ghidra.pcode.emu.jit.gen.util.Emitter;
import ghidra.pcode.emu.jit.gen.util.Lbl;
import ghidra.pcode.emu.jit.gen.util.Local;
import ghidra.pcode.emu.jit.gen.util.Methods;
import ghidra.pcode.emu.jit.gen.util.Op;
import ghidra.pcode.emu.jit.gen.util.Scope;
import ghidra.pcode.emu.jit.gen.util.Types;
import ghidra.pcode.emu.jit.gen.var.VarGen;
import ghidra.pcode.emu.jit.op.JitBranchOp;
import ghidra.pcode.emu.jit.op.JitOp;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.RegisterValue;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;

public enum BranchOpGen implements OpGen<JitBranchOp>
{
    GEN;


    static <THIS extends JitCompiledPassage> Emitter<Emitter.Bot> genRetire(Emitter<Emitter.Bot> em, Local<Types.TRef<THIS>> localThis, JitCodeGenerator<THIS> gen, Address exit, RegisterValue ctx, JitControlFlowModel.JitBlock block) {
        return gen.genExit(em, localThis, block, JitCodeGenerator.PcGen.loadOffset(exit), ctx);
    }

    static <THIS extends JitCompiledPassage> Emitter<Emitter.Dead> genExit(Emitter<Emitter.Bot> em, Local<Types.TRef<THIS>> localThis, Methods.RetReq<Types.TRef<JitCompiledPassage.EntryPoint>> retReq, JitCodeGenerator<THIS> gen, Address exit, JitControlFlowModel.JitBlock block) {
        return em.emit(BranchOpGen::genRetire, localThis, gen, exit, null, block).emit(Op::aconst_null, GenConsts.T_ENTRY_POINT).emit(Op::areturn, retReq);
    }

    public <THIS extends JitCompiledPassage> OpGen.DeadOpResult genRun(Emitter<Emitter.Bot> em, Local<Types.TRef<THIS>> localThis, Local<Types.TInt> localCtxmod, Methods.RetReq<Types.TRef<JitCompiledPassage.EntryPoint>> retReq, JitCodeGenerator<THIS> gen, JitBranchOp op, JitControlFlowModel.JitBlock block, Scope scope) {
        JitPassage.RBranch rBranch = op.branch();
        Objects.requireNonNull(rBranch);
        JitPassage.RBranch rBranch2 = rBranch;
        int n = 0;
        return new OpGen.DeadOpResult(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitPassage.RIntBranch.class, JitPassage.RExtBranch.class}, (Object)rBranch2, n)) {
            case 0 -> {
                JitPassage.RIntBranch ib = (JitPassage.RIntBranch)rBranch2;
                yield IntBranchGen.INT.genRun(em, localThis, localCtxmod, retReq, gen, op, ib, block);
            }
            case 1 -> {
                JitPassage.RExtBranch eb = (JitPassage.RExtBranch)rBranch2;
                yield ExtBranchGen.EXT.genRun(em, localThis, localCtxmod, retReq, gen, op, eb, block);
            }
            default -> throw new AssertionError((Object)"Branch type confusion");
        });
    }

    static class IntBranchGen
    extends UBranchGen<JitPassage.RIntBranch, JitOp> {
        static final IntBranchGen INT = new IntBranchGen();

        IntBranchGen() {
        }

        @Override
        Address exit(JitCodeGenerator<?> gen, JitPassage.RIntBranch branch) {
            return gen.getAddressForOp(branch.to());
        }

        @Override
        <THIS extends JitCompiledPassage> Emitter<Emitter.Dead> genRunWithoutCtxmod(Emitter<Emitter.Bot> em, Local<Types.TRef<THIS>> localThis, Methods.RetReq<Types.TRef<JitCompiledPassage.EntryPoint>> retReq, JitCodeGenerator<THIS> gen, JitOp op, JitPassage.RIntBranch branch, JitControlFlowModel.JitBlock block) {
            JitControlFlowModel.JitBlock target = block.getTargetBlock(branch);
            Lbl<Emitter.Bot> label = gen.labelForBlock(target);
            return em.emit(VarGen.computeBlockTransition(localThis, gen, block, target)::genFwd).emit(Op::goto_, label);
        }

        @Override
        <THIS extends JitCompiledPassage> Emitter<Emitter.Dead> genRunWithCtxmod(Emitter<Emitter.Bot> em, Local<Types.TRef<THIS>> localThis, Local<Types.TInt> localCtxmod, Methods.RetReq<Types.TRef<JitCompiledPassage.EntryPoint>> retReq, JitCodeGenerator<THIS> gen, JitOp op, Address exit, JitControlFlowModel.JitBlock block) {
            return BranchOpGen.genExit(em, localThis, retReq, gen, exit, block);
        }
    }

    static class ExtBranchGen
    extends UBranchGen<JitPassage.RExtBranch, JitOp> {
        static final ExtBranchGen EXT = new ExtBranchGen();

        ExtBranchGen() {
        }

        @Override
        Address exit(JitCodeGenerator<?> gen, JitPassage.RExtBranch branch) {
            return branch.to().address;
        }

        @Override
        <THIS extends JitCompiledPassage> Emitter<Emitter.Dead> genRunWithoutCtxmod(Emitter<Emitter.Bot> em, Local<Types.TRef<THIS>> localThis, Methods.RetReq<Types.TRef<JitCompiledPassage.EntryPoint>> retReq, JitCodeGenerator<THIS> gen, JitOp op, JitPassage.RExtBranch branch, JitControlFlowModel.JitBlock block) {
            JitPassage.AddrCtx exit = branch.to();
            FieldForExitSlot slotField = gen.requestFieldForExitSlot(exit);
            return em.emit(BranchOpGen::genRetire, localThis, gen, exit.address, exit.rvCtx, block).emit(slotField::genLoad, localThis, gen).emit(Op::invokestatic, GenConsts.T_JIT_COMPILED_PASSAGE, "getChained", GenConsts.MDESC_JIT_COMPILED_PASSAGE__GET_CHAINED, true).step(Methods.Inv::takeArg).step(Methods.Inv::ret).emit(Op::areturn, retReq);
        }

        @Override
        <THIS extends JitCompiledPassage> Emitter<Emitter.Dead> genRunWithCtxmod(Emitter<Emitter.Bot> em, Local<Types.TRef<THIS>> localThis, Local<Types.TInt> localCtxmod, Methods.RetReq<Types.TRef<JitCompiledPassage.EntryPoint>> retReq, JitCodeGenerator<THIS> gen, JitOp op, Address exit, JitControlFlowModel.JitBlock block) {
            return BranchOpGen.genExit(em, localThis, retReq, gen, exit, block);
        }
    }

    static abstract class UBranchGen<TB extends JitPassage.RBranch, TO extends JitOp>
    extends BranchGen<Emitter.Dead, Emitter.Bot, TB, TO> {
        UBranchGen() {
        }

        @Override
        <THIS extends JitCompiledPassage> Emitter<Emitter.Dead> genRun(Emitter<Emitter.Bot> em, Local<Types.TRef<THIS>> localThis, Local<Types.TInt> localCtxmod, Methods.RetReq<Types.TRef<JitCompiledPassage.EntryPoint>> retReq, JitCodeGenerator<THIS> gen, TO op, TB branch, JitControlFlowModel.JitBlock block) {
            return switch (branch.reach()) {
                default -> throw new MatchException(null, null);
                case JitPassage.Reachability.WITH_CTXMOD -> this.genRunWithCtxmod(em, localThis, localCtxmod, retReq, gen, op, this.exit(gen, branch), block);
                case JitPassage.Reachability.WITHOUT_CTXMOD -> this.genRunWithoutCtxmod(em, localThis, retReq, gen, op, branch, block);
                case JitPassage.Reachability.MAYBE_CTXMOD -> {
                    Lbl.LblEm emIf = em.emit(Op::iload, localCtxmod).emit(Op::ifne);
                    yield emIf.em().emit(this::genRunWithoutCtxmod, localThis, retReq, gen, op, branch, block).emit(Lbl::placeDead, emIf.lbl()).emit(this::genRunWithCtxmod, localThis, localCtxmod, retReq, gen, op, this.exit(gen, branch), block);
                }
            };
        }
    }

    static abstract class BranchGen<NR, NI extends Emitter.Next, TB extends JitPassage.RBranch, TO extends JitOp> {
        BranchGen() {
        }

        abstract Address exit(JitCodeGenerator<?> var1, TB var2);

        abstract <THIS extends JitCompiledPassage> Emitter<NR> genRunWithoutCtxmod(Emitter<NI> var1, Local<Types.TRef<THIS>> var2, Methods.RetReq<Types.TRef<JitCompiledPassage.EntryPoint>> var3, JitCodeGenerator<THIS> var4, TO var5, TB var6, JitControlFlowModel.JitBlock var7);

        abstract <THIS extends JitCompiledPassage> Emitter<NR> genRunWithCtxmod(Emitter<NI> var1, Local<Types.TRef<THIS>> var2, Local<Types.TInt> var3, Methods.RetReq<Types.TRef<JitCompiledPassage.EntryPoint>> var4, JitCodeGenerator<THIS> var5, TO var6, Address var7, JitControlFlowModel.JitBlock var8);

        abstract <THIS extends JitCompiledPassage> Emitter<NR> genRun(Emitter<NI> var1, Local<Types.TRef<THIS>> var2, Local<Types.TInt> var3, Methods.RetReq<Types.TRef<JitCompiledPassage.EntryPoint>> var4, JitCodeGenerator<THIS> var5, TO var6, TB var7, JitControlFlowModel.JitBlock var8);
    }
}

