/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.access;

import ghidra.pcode.emu.jit.gen.FieldForArrDirect;
import ghidra.pcode.emu.jit.gen.GenConsts;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.access.ExportsLegAccessGen;
import ghidra.pcode.emu.jit.gen.access.MethodAccessGen;
import ghidra.pcode.emu.jit.gen.tgt.JitCompiledPassage;
import ghidra.pcode.emu.jit.gen.util.Emitter;
import ghidra.pcode.emu.jit.gen.util.Local;
import ghidra.pcode.emu.jit.gen.util.Methods;
import ghidra.pcode.emu.jit.gen.util.Op;
import ghidra.pcode.emu.jit.gen.util.Types;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Endian;

public enum IntAccessGen implements MethodAccessGen,
ExportsLegAccessGen
{
    BE{

        @Override
        public String chooseReadName(int size) {
            return switch (size) {
                case 1 -> "readInt1";
                case 2 -> "readIntBE2";
                case 3 -> "readIntBE3";
                case 4 -> "readIntBE4";
                default -> throw new AssertionError();
            };
        }

        @Override
        public <THIS extends JitCompiledPassage, N extends Emitter.Next> Emitter<Emitter.Ent<N, Types.TInt>> genReadLegToStack(Emitter<N> em, Local<Types.TRef<THIS>> localThis, JitCodeGenerator<THIS> gen, AddressSpace space, long block, int off, int size) {
            FieldForArrDirect blkField = gen.requestFieldForArrDirect(space.getAddress(block));
            if (off + size <= 4096) {
                return em.emit(blkField::genLoad, localThis, gen).emit(Op::ldc__i, off).emit(Op::invokestatic, GenConsts.T_JIT_COMPILED_PASSAGE, this.chooseReadName(size), GenConsts.MDESC_JIT_COMPILED_PASSAGE__READ_INTX, true).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::ret);
            }
            FieldForArrDirect nxtField = gen.requestFieldForArrDirect(space.getAddress(block + 4096L));
            return em.emit(blkField::genLoad, localThis, gen).emit(Op::ldc__i, off).emit(Op::invokestatic, GenConsts.T_JIT_COMPILED_PASSAGE, this.chooseReadName(4096 - off), GenConsts.MDESC_JIT_COMPILED_PASSAGE__READ_INTX, true).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::ret).emit(Op::ldc__i, off + size - 4096).emit(Op::ishl).emit(nxtField::genLoad, localThis, gen).emit(Op::ldc__i, 0).emit(Op::invokestatic, GenConsts.T_JIT_COMPILED_PASSAGE, this.chooseReadName(off + size - 4096), GenConsts.MDESC_JIT_COMPILED_PASSAGE__READ_INTX, true).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::ret).emit(Op::ior);
        }

        @Override
        public String chooseWriteName(int size) {
            return switch (size) {
                case 1 -> "writeInt1";
                case 2 -> "writeIntBE2";
                case 3 -> "writeIntBE3";
                case 4 -> "writeIntBE4";
                default -> throw new AssertionError();
            };
        }

        @Override
        public <THIS extends JitCompiledPassage, N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TInt>> Emitter<N1> genWriteLegFromStack(Emitter<N0> em, Local<Types.TRef<THIS>> localThis, JitCodeGenerator<THIS> gen, AddressSpace space, long block, int off, int size) {
            FieldForArrDirect blkField = gen.requestFieldForArrDirect(space.getAddress(block));
            if (off + size <= 4096) {
                return em.emit(blkField::genLoad, localThis, gen).emit(Op::ldc__i, off).emit(Op::invokestatic, GenConsts.T_JIT_COMPILED_PASSAGE, this.chooseWriteName(size), GenConsts.MDESC_JIT_COMPILED_PASSAGE__WRITE_INTX, true).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::retVoid);
            }
            FieldForArrDirect nxtField = gen.requestFieldForArrDirect(space.getAddress(block + 4096L));
            return em.emit(Op::dup).emit(Op::ldc__i, off + size - 4096).emit(Op::iushr).emit(blkField::genLoad, localThis, gen).emit(Op::ldc__i, off).emit(Op::invokestatic, GenConsts.T_JIT_COMPILED_PASSAGE, this.chooseWriteName(4096 - off), GenConsts.MDESC_JIT_COMPILED_PASSAGE__WRITE_INTX, true).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::retVoid).emit(nxtField::genLoad, localThis, gen).emit(Op::ldc__i, 0).emit(Op::invokestatic, GenConsts.T_JIT_COMPILED_PASSAGE, this.chooseWriteName(off + size - 4096), GenConsts.MDESC_JIT_COMPILED_PASSAGE__WRITE_INTX, true).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::retVoid);
        }
    }
    ,
    LE{

        @Override
        public String chooseReadName(int size) {
            return switch (size) {
                case 1 -> "readInt1";
                case 2 -> "readIntLE2";
                case 3 -> "readIntLE3";
                case 4 -> "readIntLE4";
                default -> throw new AssertionError();
            };
        }

        @Override
        public <THIS extends JitCompiledPassage, N extends Emitter.Next> Emitter<Emitter.Ent<N, Types.TInt>> genReadLegToStack(Emitter<N> em, Local<Types.TRef<THIS>> localThis, JitCodeGenerator<THIS> gen, AddressSpace space, long block, int off, int size) {
            FieldForArrDirect blkField = gen.requestFieldForArrDirect(space.getAddress(block));
            if (off + size <= 4096) {
                return em.emit(blkField::genLoad, localThis, gen).emit(Op::ldc__i, off).emit(Op::invokestatic, GenConsts.T_JIT_COMPILED_PASSAGE, this.chooseReadName(size), GenConsts.MDESC_JIT_COMPILED_PASSAGE__READ_INTX, true).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::ret);
            }
            FieldForArrDirect nxtField = gen.requestFieldForArrDirect(space.getAddress(block + 4096L));
            return em.emit(nxtField::genLoad, localThis, gen).emit(Op::ldc__i, 0).emit(Op::invokestatic, GenConsts.T_JIT_COMPILED_PASSAGE, this.chooseReadName(off + size - 4096), GenConsts.MDESC_JIT_COMPILED_PASSAGE__READ_INTX, true).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::ret).emit(blkField::genLoad, localThis, gen).emit(Op::ldc__i, off).emit(Op::invokestatic, GenConsts.T_JIT_COMPILED_PASSAGE, this.chooseReadName(4096 - off), GenConsts.MDESC_JIT_COMPILED_PASSAGE__READ_INTX, true).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::ret).emit(Op::ior);
        }

        @Override
        public String chooseWriteName(int size) {
            return switch (size) {
                case 1 -> "writeInt1";
                case 2 -> "writeIntLE2";
                case 3 -> "writeIntLE3";
                case 4 -> "writeIntLE4";
                default -> throw new AssertionError();
            };
        }

        @Override
        public <THIS extends JitCompiledPassage, N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TInt>> Emitter<N1> genWriteLegFromStack(Emitter<N0> em, Local<Types.TRef<THIS>> localThis, JitCodeGenerator<THIS> gen, AddressSpace space, long block, int off, int size) {
            FieldForArrDirect blkField = gen.requestFieldForArrDirect(space.getAddress(block));
            if (off + size <= 4096) {
                return em.emit(blkField::genLoad, localThis, gen).emit(Op::ldc__i, off).emit(Op::invokestatic, GenConsts.T_JIT_COMPILED_PASSAGE, this.chooseWriteName(size), GenConsts.MDESC_JIT_COMPILED_PASSAGE__WRITE_INTX, true).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::retVoid);
            }
            FieldForArrDirect nxtField = gen.requestFieldForArrDirect(space.getAddress(block + 4096L));
            return em.emit(Op::dup).emit(Op::ldc__i, 4096 - off).emit(Op::iushr).emit(nxtField::genLoad, localThis, gen).emit(Op::ldc__i, 0).emit(Op::invokestatic, GenConsts.T_JIT_COMPILED_PASSAGE, this.chooseWriteName(off + size - 4096), GenConsts.MDESC_JIT_COMPILED_PASSAGE__WRITE_INTX, true).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::retVoid).emit(blkField::genLoad, localThis, gen).emit(Op::ldc__i, off).emit(Op::invokestatic, GenConsts.T_JIT_COMPILED_PASSAGE, this.chooseWriteName(4096 - off), GenConsts.MDESC_JIT_COMPILED_PASSAGE__WRITE_INTX, true).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::retVoid);
        }
    };


    public static IntAccessGen forEndian(Endian endian) {
        return switch (endian) {
            default -> throw new MatchException(null, null);
            case Endian.BIG -> BE;
            case Endian.LITTLE -> LE;
        };
    }
}

