/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.access;

import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.access.SimpleAccessGen;
import ghidra.pcode.emu.jit.gen.tgt.JitCompiledPassage;
import ghidra.pcode.emu.jit.gen.util.Emitter;
import ghidra.pcode.emu.jit.gen.util.Local;
import ghidra.pcode.emu.jit.gen.util.Types;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.pcode.Varnode;

public interface ExportsLegAccessGen
extends SimpleAccessGen<Types.TInt, JitType.IntJitType> {
    public <THIS extends JitCompiledPassage, N extends Emitter.Next> Emitter<Emitter.Ent<N, Types.TInt>> genReadLegToStack(Emitter<N> var1, Local<Types.TRef<THIS>> var2, JitCodeGenerator<THIS> var3, AddressSpace var4, long var5, int var7, int var8);

    public <THIS extends JitCompiledPassage, N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TInt>> Emitter<N1> genWriteLegFromStack(Emitter<N0> var1, Local<Types.TRef<THIS>> var2, JitCodeGenerator<THIS> var3, AddressSpace var4, long var5, int var7, int var8);

    @Override
    default public <THIS extends JitCompiledPassage, N extends Emitter.Next> Emitter<Emitter.Ent<N, Types.TInt>> genReadToStack(Emitter<N> em, Local<Types.TRef<THIS>> localThis, JitCodeGenerator<THIS> gen, Varnode vn) {
        AddressSpace space = vn.getAddress().getAddressSpace();
        long offset = vn.getOffset();
        long block = offset / 4096L * 4096L;
        int off = (int)(offset - block);
        int size = vn.getSize();
        return this.genReadLegToStack(em, localThis, gen, space, block, off, size);
    }

    @Override
    default public <THIS extends JitCompiledPassage, N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TInt>> Emitter<N1> genWriteFromStack(Emitter<N0> em, Local<Types.TRef<THIS>> localThis, JitCodeGenerator<THIS> gen, Varnode vn) {
        AddressSpace space = vn.getAddress().getAddressSpace();
        long offset = vn.getOffset();
        long block = offset / 4096L * 4096L;
        int off = (int)(offset - block);
        int size = vn.getSize();
        return this.genWriteLegFromStack(em, localThis, gen, space, block, off, size);
    }
}

