/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.access;

import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.gen.FieldForArrDirect;
import ghidra.pcode.emu.jit.gen.GenConsts;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.access.DoubleAccessGen;
import ghidra.pcode.emu.jit.gen.access.FloatAccessGen;
import ghidra.pcode.emu.jit.gen.access.IntAccessGen;
import ghidra.pcode.emu.jit.gen.access.LongAccessGen;
import ghidra.pcode.emu.jit.gen.access.MpIntAccessGen;
import ghidra.pcode.emu.jit.gen.access.SimpleAccessGen;
import ghidra.pcode.emu.jit.gen.tgt.JitCompiledPassage;
import ghidra.pcode.emu.jit.gen.util.Emitter;
import ghidra.pcode.emu.jit.gen.util.Local;
import ghidra.pcode.emu.jit.gen.util.Methods;
import ghidra.pcode.emu.jit.gen.util.Op;
import ghidra.pcode.emu.jit.gen.util.Types;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Endian;
import ghidra.program.model.pcode.Varnode;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;

public interface AccessGen<JT extends JitType> {
    public static <T extends JitType> AccessGen<T> lookup(Endian endian, T type) {
        return (AccessGen)((Object)(switch (endian) {
            default -> throw new MatchException(null, null);
            case Endian.BIG -> {
                T v0 = type;
                Objects.requireNonNull(v0);
                T var2_2 = v0;
                int var3_4 = 0;
                Enum v1 = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.FloatJitType.class, JitType.DoubleJitType.class, JitType.MpIntJitType.class}, var2_2, var3_4)) {
                    case 0 -> {
                        JitType.IntJitType t = (JitType.IntJitType)var2_2;
                        yield IntAccessGen.BE;
                    }
                    case 1 -> {
                        JitType.LongJitType t = (JitType.LongJitType)var2_2;
                        yield LongAccessGen.BE;
                    }
                    case 2 -> {
                        JitType.FloatJitType t = (JitType.FloatJitType)var2_2;
                        yield FloatAccessGen.BE;
                    }
                    case 3 -> {
                        JitType.DoubleJitType t = (JitType.DoubleJitType)var2_2;
                        yield DoubleAccessGen.BE;
                    }
                    case 4 -> {
                        JitType.MpIntJitType t = (JitType.MpIntJitType)var2_2;
                        yield MpIntAccessGen.BE;
                    }
                    default -> throw new AssertionError();
                };
                yield v1;
            }
            case Endian.LITTLE -> {
                T v3 = type;
                Objects.requireNonNull(v3);
                T var2_3 = v3;
                int var3_5 = 0;
                Enum v4 = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.FloatJitType.class, JitType.DoubleJitType.class, JitType.MpIntJitType.class}, var2_3, var3_5)) {
                    case 0 -> {
                        JitType.IntJitType t = (JitType.IntJitType)var2_3;
                        yield IntAccessGen.LE;
                    }
                    case 1 -> {
                        JitType.LongJitType t = (JitType.LongJitType)var2_3;
                        yield LongAccessGen.LE;
                    }
                    case 2 -> {
                        JitType.FloatJitType t = (JitType.FloatJitType)var2_3;
                        yield FloatAccessGen.LE;
                    }
                    case 3 -> {
                        JitType.DoubleJitType t = (JitType.DoubleJitType)var2_3;
                        yield DoubleAccessGen.LE;
                    }
                    case 4 -> {
                        JitType.MpIntJitType t = (JitType.MpIntJitType)var2_3;
                        yield MpIntAccessGen.LE;
                    }
                    default -> throw new AssertionError();
                };
                yield v4;
            }
        }));
    }

    public static <T extends Types.BPrim<?>, JT extends JitType.SimpleJitType<T, JT>> SimpleAccessGen<T, JT> lookupSimple(Endian endian, JT type) {
        return (SimpleAccessGen)((Object)(switch (endian) {
            default -> throw new MatchException(null, null);
            case Endian.BIG -> {
                JT v0 = type;
                Objects.requireNonNull(v0);
                JT var2_2 = v0;
                int var3_4 = 0;
                Enum v1 = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.FloatJitType.class, JitType.DoubleJitType.class}, var2_2, var3_4)) {
                    case 0 -> {
                        JitType.IntJitType t = (JitType.IntJitType)var2_2;
                        yield IntAccessGen.BE;
                    }
                    case 1 -> {
                        JitType.LongJitType t = (JitType.LongJitType)var2_2;
                        yield LongAccessGen.BE;
                    }
                    case 2 -> {
                        JitType.FloatJitType t = (JitType.FloatJitType)var2_2;
                        yield FloatAccessGen.BE;
                    }
                    case 3 -> {
                        JitType.DoubleJitType t = (JitType.DoubleJitType)var2_2;
                        yield DoubleAccessGen.BE;
                    }
                    default -> throw new AssertionError();
                };
                yield v1;
            }
            case Endian.LITTLE -> {
                JT v3 = type;
                Objects.requireNonNull(v3);
                JT var2_3 = v3;
                int var3_5 = 0;
                Enum v4 = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.FloatJitType.class, JitType.DoubleJitType.class}, var2_3, var3_5)) {
                    case 0 -> {
                        JitType.IntJitType t = (JitType.IntJitType)var2_3;
                        yield IntAccessGen.LE;
                    }
                    case 1 -> {
                        JitType.LongJitType t = (JitType.LongJitType)var2_3;
                        yield LongAccessGen.LE;
                    }
                    case 2 -> {
                        JitType.FloatJitType t = (JitType.FloatJitType)var2_3;
                        yield FloatAccessGen.LE;
                    }
                    case 3 -> {
                        JitType.DoubleJitType t = (JitType.DoubleJitType)var2_3;
                        yield DoubleAccessGen.LE;
                    }
                    default -> throw new AssertionError();
                };
                yield v4;
            }
        }));
    }

    public static MpIntAccessGen lookupMp(Endian endian) {
        return switch (endian) {
            default -> throw new MatchException(null, null);
            case Endian.BIG -> MpIntAccessGen.BE;
            case Endian.LITTLE -> MpIntAccessGen.LE;
        };
    }

    public static <THIS extends JitCompiledPassage, N extends Emitter.Next> Emitter<Emitter.Ent<N, Types.TInt>> genReadToBool(Emitter<N> em, Local<Types.TRef<THIS>> localThis, JitCodeGenerator<THIS> gen, Varnode vn) {
        AddressSpace space = vn.getAddress().getAddressSpace();
        long offset = vn.getOffset();
        long block = offset / 4096L * 4096L;
        int off = (int)(offset - block);
        int size = vn.getSize();
        FieldForArrDirect blkField = gen.requestFieldForArrDirect(space.getAddress(block));
        if (off + size < 4096) {
            return em.emit(blkField::genLoad, localThis, gen).emit(Op::ldc__i, off).emit(Op::ldc__i, size).emit(Op::invokestatic, GenConsts.T_JIT_COMPILED_PASSAGE, "readBoolN", GenConsts.MDESC_JIT_COMPILED_PASSAGE__READ_BOOL_N, true).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::ret);
        }
        FieldForArrDirect nxtField = gen.requestFieldForArrDirect(space.getAddress(block + 4096L));
        return em.emit(blkField::genLoad, localThis, gen).emit(Op::ldc__i, off).emit(Op::ldc__i, 4096 - off).emit(Op::invokestatic, GenConsts.T_JIT_COMPILED_PASSAGE, "readBoolN", GenConsts.MDESC_JIT_COMPILED_PASSAGE__READ_BOOL_N, true).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::ret).emit(nxtField::genLoad, localThis, gen).emit(Op::ldc__i, 0).emit(Op::ldc__i, off + size - 4096).emit(Op::invokestatic, GenConsts.T_JIT_COMPILED_PASSAGE, "readBoolN", GenConsts.MDESC_JIT_COMPILED_PASSAGE__READ_BOOL_N, true).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::ret).emit(Op::ior);
    }
}

