/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen;

import ghidra.pcode.emu.jit.gen.GenConsts;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.StaticFieldReq;
import ghidra.pcode.emu.jit.gen.util.Emitter;
import ghidra.pcode.emu.jit.gen.util.Fld;
import ghidra.pcode.emu.jit.gen.util.Methods;
import ghidra.pcode.emu.jit.gen.util.Op;
import ghidra.pcode.emu.jit.gen.util.Types;
import ghidra.program.model.address.Address;
import ghidra.program.model.pcode.Varnode;
import org.objectweb.asm.ClassVisitor;

public record FieldForVarnode(Varnode vn) implements StaticFieldReq<Types.TRef<Varnode>>
{
    @Override
    public String name() {
        Address addr = this.vn.getAddress();
        return "VARNODE_%s_%s_%s".formatted(addr.getAddressSpace().getName().toUpperCase(), Long.toUnsignedString(addr.getOffset(), 16), this.vn.getSize());
    }

    @Override
    public <N extends Emitter.Next> Emitter<N> genClInitCode(Emitter<N> em, JitCodeGenerator<?> gen, ClassVisitor cv) {
        Fld.decl(cv, 26, GenConsts.T_VARNODE, this.name());
        return em.emit(Op::getstatic, gen.typeThis, "ADDRESS_FACTORY", GenConsts.T_ADDRESS_FACTORY).emit(Op::ldc__a, this.vn.getAddress().getAddressSpace().getName()).emit(Op::ldc__l, this.vn.getAddress().getOffset()).emit(Op::ldc__i, this.vn.getSize()).emit(Op::invokestatic, GenConsts.T_JIT_COMPILED_PASSAGE, "createVarnode", GenConsts.MDESC_JIT_COMPILED_PASSAGE__CREATE_VARNODE, true).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::ret).emit(Op::putstatic, gen.typeThis, this.name(), GenConsts.T_VARNODE);
    }

    @Override
    public <N extends Emitter.Next> Emitter<Emitter.Ent<N, Types.TRef<Varnode>>> genLoad(Emitter<N> em, JitCodeGenerator<?> gen) {
        return em.emit(Op::getstatic, gen.typeThis, this.name(), GenConsts.T_VARNODE);
    }
}

