/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.alloc;

import ghidra.pcode.emu.jit.alloc.JvmLocal;
import ghidra.pcode.emu.jit.alloc.VarHandler;
import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.opnd.Opnd;
import ghidra.pcode.emu.jit.gen.util.Emitter;
import ghidra.pcode.emu.jit.gen.util.Scope;
import ghidra.pcode.emu.jit.gen.util.Types;

public interface SubVarHandler<ST extends Types.BPrim<?>, SJT extends JitType.SimpleJitType<ST, SJT>, WT extends Types.BPrim<?>, WJT extends JitType.SimpleJitType<WT, WJT>>
extends VarHandler {
    default public void assertShiftFits(int byteShift, SJT type, JvmLocal<WT, WJT> local) {
        if (!(1.$assertionsDisabled || byteShift >= 0 && byteShift + type.size() <= local.type().size())) {
            throw new AssertionError();
        }
    }

    public int byteShift();

    default public int bitSize() {
        return this.type().size() * 8;
    }

    default public int bitShift() {
        return this.byteShift() * 8;
    }

    default public int intMask() {
        return -1 >>> 32 - this.bitSize() << this.bitShift();
    }

    default public long longMask() {
        return -1L >>> 64 - this.bitSize() << this.bitShift();
    }

    public JvmLocal<WT, WJT> local();

    public SJT type();

    public Opnd.MpToStackConv<Types.TInt, JitType.IntJitType, JitType.MpIntJitType, ST, SJT> getConvToSub();

    @Override
    default public <N extends Emitter.Next> Opnd.OpndEm<JitType.MpIntJitType, N> genLoadToOpnd(Emitter<N> em, JitCodeGenerator<?> gen, JitType.MpIntJitType type, Opnd.Ext ext, Scope scope) {
        return em.emit(this::genLoadToStack, gen, this.type(), ext).emit(Opnd::convertToOpnd, this.type(), this.name(), type, ext, scope);
    }

    @Override
    default public <N extends Emitter.Next> Emitter<Emitter.Ent<N, Types.TRef<int[]>>> genLoadToArray(Emitter<N> em, JitCodeGenerator<?> gen, JitType.MpIntJitType type, Opnd.Ext ext, Scope scope, int slack) {
        return em.emit(this::genLoadToStack, gen, this.type(), ext).emit(Opnd::convertToArray, this.type(), this.name(), type, ext, scope, slack);
    }

    @Override
    default public <N extends Emitter.Next> Emitter<N> genStoreFromOpnd(Emitter<N> em, JitCodeGenerator<?> gen, Opnd<JitType.MpIntJitType> opnd, Opnd.Ext ext, Scope scope) {
        return em.emit(this.getConvToSub()::convertOpndToStack, opnd, this.type(), ext).emit(this::genStoreFromStack, gen, this.type(), ext, scope);
    }

    @Override
    default public <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TRef<int[]>>> Emitter<N1> genStoreFromArray(Emitter<N0> em, JitCodeGenerator<?> gen, JitType.MpIntJitType type, Opnd.Ext ext, Scope scope) {
        return em.emit(this.getConvToSub()::convertArrayToStack, type, this.type(), ext).emit(this::genStoreFromStack, gen, this.type(), ext, scope);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

