/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.alloc;

import ghidra.pcode.emu.jit.alloc.JvmLocal;
import ghidra.pcode.emu.jit.alloc.VarHandler;
import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.opnd.Opnd;
import ghidra.pcode.emu.jit.gen.util.Emitter;
import ghidra.pcode.emu.jit.gen.util.Op;
import ghidra.pcode.emu.jit.gen.util.Scope;
import ghidra.pcode.emu.jit.gen.util.Types;
import ghidra.program.model.pcode.Varnode;

public interface SimpleVarHandler<T extends Types.BPrim<?>, JT extends JitType.SimpleJitType<T, JT>>
extends VarHandler {
    public JvmLocal<T, JT> local();

    @Override
    default public Varnode vn() {
        return this.local().vn();
    }

    public JT type();

    @Override
    default public <TT extends Types.BPrim<?>, TJT extends JitType.SimpleJitType<TT, TJT>, N extends Emitter.Next> Emitter<Emitter.Ent<N, TT>> genLoadToStack(Emitter<N> em, JitCodeGenerator<?> gen, TJT type, Opnd.Ext ext) {
        return this.local().genLoadToStack(em, gen, type, ext);
    }

    @Override
    default public <N extends Emitter.Next> Opnd.OpndEm<JitType.MpIntJitType, N> genLoadToOpnd(Emitter<N> em, JitCodeGenerator<?> gen, JitType.MpIntJitType type, Opnd.Ext ext, Scope scope) {
        return em.emit(this::genLoadToStack, gen, this.type(), ext).emit(Opnd::convertToOpnd, this.type(), this.local().name(), type, ext, scope);
    }

    default public <N extends Emitter.Next> Emitter<Emitter.Ent<N, Types.TInt>> genLoadLegToStackC1(Emitter<N> em, JitCodeGenerator<?> gen, JitType.MpIntJitType type, int leg, Opnd.Ext ext) {
        if (leg == 0) {
            return em.emit(this::genLoadToStack, gen, type.legTypesLE().get(leg), ext);
        }
        return switch (ext) {
            default -> throw new MatchException(null, null);
            case Opnd.Ext.ZERO -> em.emit(Op::ldc__i, 0);
            case Opnd.Ext.SIGN -> {
                JitType.IntJitType intType = JitType.IntJitType.forSize(this.type().size());
                yield em.emit(this::genLoadToStack, gen, intType, ext).emit(Op::ldc__i, 32 - intType.size() * 8).emit(Op::ishl).emit(Op::ldc__i, 31).emit(Op::ishr);
            }
        };
    }

    default public <N extends Emitter.Next> Emitter<Emitter.Ent<N, Types.TInt>> genLoadLegToStackC2(Emitter<N> em, JitCodeGenerator<?> gen, JitType.MpIntJitType type, int leg, Opnd.Ext ext) {
        if (leg == 0) {
            return em.emit(this::genLoadToStack, gen, type.legTypesLE().get(leg), ext);
        }
        if (leg == 1) {
            JitType.LongJitType longType = JitType.LongJitType.forSize(this.type().size());
            return em.emit(this::genLoadToStack, gen, longType, ext).emit(Op::ldc__i, 32).emit(Op::lshr).emit(Op::l2i).emit(Opnd::convertIntToInt, JitType.IntJitType.forSize(this.type().size() - 4), type.legTypesLE().get(leg), ext);
        }
        return switch (ext) {
            default -> throw new MatchException(null, null);
            case Opnd.Ext.ZERO -> em.emit(Op::ldc__i, 0);
            case Opnd.Ext.SIGN -> {
                JitType.LongJitType longType = JitType.LongJitType.forSize(this.type().size());
                yield em.emit(this::genLoadToStack, gen, longType, ext).emit(Op::ldc__i, longType.size() * 8 - 32).emit(Op::lshr).emit(Op::l2i).emit(Op::ldc__i, 31).emit(Op::ishr);
            }
        };
    }

    @Override
    default public <N extends Emitter.Next> Emitter<Emitter.Ent<N, Types.TRef<int[]>>> genLoadToArray(Emitter<N> em, JitCodeGenerator<?> gen, JitType.MpIntJitType type, Opnd.Ext ext, Scope scope, int slack) {
        return em.emit(this::genLoadToStack, gen, this.type(), ext).emit(Opnd::convertToArray, this.type(), this.local().name(), type, ext, scope, slack);
    }

    @Override
    default public <FT extends Types.BPrim<?>, FJT extends JitType.SimpleJitType<FT, FJT>, N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, FT>> Emitter<N1> genStoreFromStack(Emitter<N0> em, JitCodeGenerator<?> gen, FJT type, Opnd.Ext ext, Scope scope) {
        return this.local().genStoreFromStack(em, gen, type, ext, scope);
    }

    public Opnd.MpToStackConv<Types.TInt, JitType.IntJitType, JitType.MpIntJitType, T, JT> getConvToStack();

    @Override
    default public <N extends Emitter.Next> Emitter<N> genStoreFromOpnd(Emitter<N> em, JitCodeGenerator<?> gen, Opnd<JitType.MpIntJitType> opnd, Opnd.Ext ext, Scope scope) {
        return em.emit(this.getConvToStack()::convertOpndToStack, opnd, this.type(), ext).emit(this::genStoreFromStack, gen, this.type(), ext, scope);
    }

    @Override
    default public <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TRef<int[]>>> Emitter<N1> genStoreFromArray(Emitter<N0> em, JitCodeGenerator<?> gen, JitType.MpIntJitType type, Opnd.Ext ext, Scope scope) {
        return em.emit(this.getConvToStack()::convertArrayToStack, type, this.type(), ext).emit(this::genStoreFromStack, gen, this.type(), ext, scope);
    }
}

