/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.alloc;

import ghidra.pcode.emu.jit.alloc.AlignedMpIntHandler;
import ghidra.pcode.emu.jit.alloc.JvmLocal;
import ghidra.pcode.emu.jit.alloc.VarHandler;
import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.opnd.IntConstOpnd;
import ghidra.pcode.emu.jit.gen.opnd.MpIntLocalOpnd;
import ghidra.pcode.emu.jit.gen.opnd.Opnd;
import ghidra.pcode.emu.jit.gen.opnd.SimpleOpnd;
import ghidra.pcode.emu.jit.gen.util.Emitter;
import ghidra.pcode.emu.jit.gen.util.Local;
import ghidra.pcode.emu.jit.gen.util.Misc;
import ghidra.pcode.emu.jit.gen.util.Op;
import ghidra.pcode.emu.jit.gen.util.Scope;
import ghidra.pcode.emu.jit.gen.util.SubScope;
import ghidra.pcode.emu.jit.gen.util.Types;
import ghidra.program.model.lang.Endian;
import ghidra.program.model.pcode.Varnode;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class ShiftedMpIntHandler
extends Record
implements VarHandler {
    private final List<JvmLocal<Types.TInt, JitType.IntJitType>> parts;
    private final JitType.MpIntJitType type;
    private final Varnode vn;
    private final int byteShift;

    public ShiftedMpIntHandler(List<JvmLocal<Types.TInt, JitType.IntJitType>> parts, JitType.MpIntJitType type, Varnode vn, int byteShift) {
        assert (byteShift > 0 && byteShift < 4);
        assert (parts.size() > 1);
        this.parts = parts;
        this.type = type;
        this.vn = vn;
        this.byteShift = byteShift;
    }

    private int bitShift() {
        return this.byteShift * 8;
    }

    private <N extends Emitter.Next> Emitter<Emitter.Ent<N, Types.TInt>> doGenLoadIntRight(Emitter<N> em, JitCodeGenerator<?> gen, int i, Opnd.Ext ext) {
        return em.emit(this.parts.get(i)::genLoadToStack, gen, JitType.IntJitType.I4, ext).emit(Op::ldc__i, this.bitShift()).emit(Op::iushr);
    }

    private <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TInt>> Emitter<Emitter.Ent<N1, Types.TInt>> doGenLoadOrIntLeft(Emitter<N0> em, JitCodeGenerator<?> gen, int i, Opnd.Ext ext) {
        if (i >= this.parts.size()) {
            return Misc.cast1(em);
        }
        return em.emit(this.parts.get(i)::genLoadToStack, gen, JitType.IntJitType.I4, ext).emit(Op::ldc__i, 32 - this.bitShift()).emit(Op::ishl).emit(Op::ior);
    }

    private <N extends Emitter.Next> Emitter<Emitter.Ent<N, Types.TLong>> doGenLoadLongRight(Emitter<N> em, JitCodeGenerator<?> gen, int i, Opnd.Ext ext) {
        return em.emit(this.parts.get(i)::genLoadToStack, gen, JitType.LongJitType.I8, ext).emit(Op::ldc__i, this.bitShift()).emit(Op::lushr);
    }

    private <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TLong>> Emitter<Emitter.Ent<N1, Types.TLong>> doGenLoadOrLongMiddle(Emitter<N0> em, JitCodeGenerator<?> gen, int i, Opnd.Ext ext) {
        return em.emit(this.parts.get(i)::genLoadToStack, gen, JitType.LongJitType.I8, ext).emit(Op::ldc__i, 32 - this.bitShift()).emit(Op::lshl).emit(Op::lor);
    }

    private <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TLong>> Emitter<Emitter.Ent<N1, Types.TLong>> doGenLoadOrLongLeft(Emitter<N0> em, JitCodeGenerator<?> gen, int i, Opnd.Ext ext) {
        return em.emit(this.parts.get(i)::genLoadToStack, gen, JitType.LongJitType.I8, ext).emit(Op::ldc__i, 64 - this.bitShift()).emit(Op::lshl).emit(Op::lor);
    }

    @Override
    public <TT extends Types.BPrim<?>, TJT extends JitType.SimpleJitType<TT, TJT>, N extends Emitter.Next> Emitter<Emitter.Ent<N, TT>> genLoadToStack(Emitter<N> em, JitCodeGenerator<?> gen, TJT type, Opnd.Ext ext) {
        Emitter emitter;
        TJT TJT = type;
        Objects.requireNonNull(TJT);
        TJT TJT2 = TJT;
        int n = 0;
        block6: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.IntJitType.class, JitType.LongJitType.class, JitType.LongJitType.class}, TJT2, n)) {
                case 0: {
                    JitType.IntJitType t = (JitType.IntJitType)TJT2;
                    if (t.size() + this.byteShift > 4) {
                        n = 1;
                        continue block6;
                    }
                    emitter = em.emit(this::doGenLoadIntRight, gen, 0, ext).emit(Opnd::convert, JitType.IntJitType.forSize(4 - this.byteShift), type, ext);
                    break block6;
                }
                case 1: {
                    JitType.IntJitType t = (JitType.IntJitType)TJT2;
                    emitter = em.emit(this::doGenLoadIntRight, gen, 0, ext).emit(this::doGenLoadOrIntLeft, gen, 1, ext).emit(Opnd::convert, JitType.IntJitType.I4, type, ext);
                    break block6;
                }
                case 2: {
                    JitType.LongJitType t = (JitType.LongJitType)TJT2;
                    if (t.size() + this.byteShift > 8) {
                        n = 3;
                        continue block6;
                    }
                    emitter = em.emit(this::doGenLoadLongRight, gen, 0, ext).emit(this::doGenLoadOrLongMiddle, gen, 1, ext).emit(Opnd::convert, JitType.LongJitType.forSize(8 - this.byteShift), type, ext);
                    break block6;
                }
                case 3: {
                    JitType.LongJitType t = (JitType.LongJitType)TJT2;
                    emitter = em.emit(this::doGenLoadLongRight, gen, 0, ext).emit(this::doGenLoadOrLongMiddle, gen, 1, ext).emit(this::doGenLoadOrLongLeft, gen, 2, ext).emit(Opnd::convert, JitType.LongJitType.I8, type, ext);
                    break block6;
                }
                default: {
                    throw new AssertionError();
                }
            }
            break;
        }
        return emitter;
    }

    @Override
    public <N extends Emitter.Next> Opnd.OpndEm<JitType.MpIntJitType, N> genLoadToOpnd(Emitter<N> em, JitCodeGenerator<?> gen, JitType.MpIntJitType to, Opnd.Ext ext, Scope scope) {
        List<JitType.IntJitType> fromLegTypes = this.type.legTypesLE();
        List<JitType.IntJitType> toLegTypes = to.legTypesLE();
        ArrayList toLegs = new ArrayList();
        int legsOut = toLegTypes.size();
        int legsIn = fromLegTypes.size();
        int defLegs = Integer.min(legsIn, legsOut);
        for (int i = 0; i < defLegs; ++i) {
            JitType.IntJitType fromLegType = fromLegTypes.get(i);
            JitType.IntJitType toLegType = toLegTypes.get(i);
            SimpleOpnd.SimpleOpndEm result = em.emit(this::doGenLoadIntRight, gen, i, ext).emit(this::doGenLoadOrIntLeft, gen, i + 1, ext).emit(Opnd::convertIntToInt, JitType.IntJitType.I4, fromLegType, ext).emit(Opnd::convertIntToInt, fromLegType, toLegType, ext).emit(Opnd::createInt, toLegType, "%s_leg%d".formatted(this.name(), i), scope);
            em = result.em();
            toLegs.add(result.opnd());
        }
        if (legsOut > defLegs) {
            SimpleOpnd.SimpleOpndEm sign = switch (ext) {
                default -> throw new MatchException(null, null);
                case Opnd.Ext.ZERO -> new SimpleOpnd.SimpleOpndEm(IntConstOpnd.ZERO_I4, em);
                case Opnd.Ext.SIGN -> em.emit(((SimpleOpnd)toLegs.getLast())::read).emit(Op::ldc__i, 31).emit(Op::ishr).emit(Opnd::createIntReadOnly, JitType.IntJitType.I4, "%s_sign".formatted(this.name()), scope);
            };
            em = sign.em();
            for (int i = defLegs; i < legsOut; ++i) {
                toLegs.add(sign.opnd());
            }
        }
        return new Opnd.OpndEm<JitType.MpIntJitType, N>(MpIntLocalOpnd.of(to, this.name(), toLegs), em);
    }

    @Override
    public <N extends Emitter.Next> Emitter<Emitter.Ent<N, Types.TInt>> genLoadLegToStack(Emitter<N> em, JitCodeGenerator<?> gen, JitType.MpIntJitType type, int leg, Opnd.Ext ext) {
        List<JitType.IntJitType> fromLegTypes = type.legTypesLE();
        int fromLegCount = fromLegTypes.size();
        if (leg >= fromLegCount) {
            return switch (ext) {
                default -> throw new MatchException(null, null);
                case Opnd.Ext.ZERO -> em.emit(Op::ldc__i, 0);
                case Opnd.Ext.SIGN -> em.emit(this::doGenLoadIntRight, gen, fromLegCount - 1, ext).emit(this::doGenLoadOrIntLeft, gen, fromLegCount, ext).emit(Opnd::convertIntToInt, JitType.IntJitType.I4, fromLegTypes.getLast(), ext).emit(Op::ldc__i, 31).emit(Op::ishr);
            };
        }
        JitType.IntJitType fromLegType = fromLegTypes.get(leg);
        JitType.IntJitType toLegType = type.legTypesLE().get(leg);
        return em.emit(this::doGenLoadIntRight, gen, leg, ext).emit(this::doGenLoadOrIntLeft, gen, leg + 1, ext).emit(Opnd::convertIntToInt, JitType.IntJitType.I4, fromLegType, ext).emit(Opnd::convertIntToInt, fromLegType, toLegType, ext);
    }

    @Override
    public <N extends Emitter.Next> Emitter<Emitter.Ent<N, Types.TRef<int[]>>> genLoadToArray(Emitter<N> em, JitCodeGenerator<?> gen, JitType.MpIntJitType to, Opnd.Ext ext, Scope scope, int slack) {
        List<JitType.IntJitType> fromLegTypes = this.type.legTypesLE();
        List<JitType.IntJitType> toLegTypes = to.legTypesLE();
        int legsOut = toLegTypes.size();
        int legsIn = fromLegTypes.size();
        int defLegs = Integer.min(legsIn, legsOut);
        Local<Types.TRef<int[]>> arr = scope.decl(Types.T_INT_ARR, this.name());
        em = em.emit(Op::ldc__i, legsOut + slack).emit(Op::newarray, Types.T_INT).emit(Op::astore, arr);
        for (int i = 0; i < defLegs; ++i) {
            JitType.IntJitType fromLegType = fromLegTypes.get(i);
            JitType.IntJitType toLegType = toLegTypes.get(i);
            em = em.emit(Op::aload, arr).emit(Op::ldc__i, i).emit(this::doGenLoadIntRight, gen, i, ext).emit(this::doGenLoadOrIntLeft, gen, i + 1, ext).emit(Opnd::convertIntToInt, JitType.IntJitType.I4, fromLegType, ext).emit(Opnd::convertIntToInt, fromLegType, toLegType, ext).emit(Op::iastore);
        }
        return em.emit(Opnd.MpIntToMpInt::doGenArrExt, arr, legsOut, defLegs, ext, scope).emit(Op::aload, arr);
    }

    @Override
    public <N extends Emitter.Next> Emitter<Emitter.Ent<N, Types.TInt>> genLoadToBool(Emitter<N> em, JitCodeGenerator<?> gen) {
        int maskRight = -1 << this.bitShift();
        Emitter result = em.emit(Op::iload, this.parts.get(0).local()).emit(Op::ldc__i, maskRight).emit(Op::iand);
        for (int i = 0; i < this.parts.size(); ++i) {
            int bytesLeft = this.type.size() - this.byteShift - i * 32;
            Emitter twoInts = result.emit(Op::iload, this.parts.get(i).local());
            if (bytesLeft < 32) {
                int maskLeft = -1 >>> 32 - bytesLeft;
                twoInts = twoInts.emit(Op::ldc__i, maskLeft).emit(Op::iand);
            }
            result = twoInts.emit(Op::ior);
        }
        return result.emit(Opnd::intToBool);
    }

    private <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TInt>> Emitter<N1> doGenStoreInt(Emitter<N0> em, int i) {
        int bytesToRight;
        int bitShift = this.byteShift * 8;
        int mask = -1;
        if (i == 0) {
            mask &= -1 << bitShift;
        }
        if ((bytesToRight = 4 * (i + 1) - this.type.size() - this.byteShift) > 0) {
            mask &= -1 >>> bytesToRight * 8;
        }
        JvmLocal<Types.TInt, JitType.IntJitType> part = this.parts.get(i);
        assert (mask != 0);
        return mask == -1 ? em.emit(Op::istore, part.local()) : em.emit(Op::ldc__i, mask).emit(Op::iand).emit(Op::iload, part.local()).emit(Op::ldc__i, ~mask).emit(Op::iand).emit(Op::ior).emit(Op::istore, part.local());
    }

    @Override
    public <FT extends Types.BPrim<?>, FJT extends JitType.SimpleJitType<FT, FJT>, N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, FT>> Emitter<N1> genStoreFromStack(Emitter<N0> em, JitCodeGenerator<?> gen, FJT from, Opnd.Ext ext, Scope scope) {
        int bitShift = this.byteShift * 8;
        FJT FJT = from;
        Objects.requireNonNull(FJT);
        FJT FJT2 = FJT;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class}, FJT2, n)) {
            case 0 -> {
                JitType.IntJitType t = (JitType.IntJitType)FJT2;
                Emitter emConvPos = em.emit(Opnd::convert, from, JitType.LongJitType.I8, ext).emit(Op::ldc__i, bitShift).emit(Op::lshl);
                for (int i = 0; i < this.parts.size() - 1; ++i) {
                    emConvPos = emConvPos.emit(Op::dup2__2).emit(Op::l2i).emit(this::doGenStoreInt, i).emit(Op::ldc__i, 32).emit(Opnd::lextshr, ext);
                }
                yield emConvPos.emit(Op::l2i).emit(this::doGenStoreInt, this.parts.size() - 1);
            }
            case 1 -> {
                JitType.LongJitType t = (JitType.LongJitType)FJT2;
                Emitter emConvPos = em.emit(Opnd::convert, from, JitType.LongJitType.I8, ext).emit(Op::dup2__2).emit(Op::l2i).emit(Op::ldc__i, bitShift).emit(Op::ishl).emit(this::doGenStoreInt, 0).emit(Op::ldc__i, 32 - bitShift).emit(Opnd::lextshr, ext);
                for (int i = 1; i < this.parts.size() - 1; ++i) {
                    emConvPos = emConvPos.emit(Op::dup2__2).emit(Op::l2i).emit(this::doGenStoreInt, i).emit(Op::ldc__i, 32).emit(Opnd::lextshr, ext);
                }
                yield emConvPos.emit(Op::l2i).emit(this::doGenStoreInt, this.parts.size() - 1);
            }
            default -> throw new AssertionError();
        };
    }

    private <N extends Emitter.Next> Emitter<Emitter.Ent<N, Types.TLong>> positionOpndLeg(Emitter<N> em, SimpleOpnd<Types.TInt, JitType.IntJitType> leg, int bitShift, Opnd.Ext ext) {
        return em.emit(leg::read).emit(Opnd::convert, (JitType.IntJitType)leg.type(), JitType.LongJitType.I8, ext).emit(Op::ldc__i, bitShift).emit(Op::lshl);
    }

    private <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TLong>> Emitter<Emitter.Ent<N1, Types.TLong>> storePartAndPositionNextOpndLeg(Emitter<N0> em, List<SimpleOpnd<Types.TInt, JitType.IntJitType>> fromLegs, int i, int bitShift, Opnd.Ext ext) {
        Emitter emStored = em.emit(Op::dup2__2).emit(Op::l2i).emit(this::doGenStoreInt, i);
        return i + 1 < fromLegs.size() ? emStored.emit(Op::ldc__i, 32).emit(Op::lushr).emit(this::positionOpndLeg, fromLegs.get(i + 1), bitShift, ext).emit(Op::lor) : emStored.emit(Op::ldc__i, 32).emit(Opnd::lextshr, ext);
    }

    @Override
    public <N extends Emitter.Next> Emitter<N> genStoreFromOpnd(Emitter<N> em, JitCodeGenerator<?> gen, Opnd<JitType.MpIntJitType> opnd, Opnd.Ext ext, Scope scope) {
        List fromLegs = opnd.type().castLegsLE(opnd);
        int bitShift = this.byteShift * 8;
        Emitter emConvPos = em.emit(this::positionOpndLeg, fromLegs.get(0), bitShift, ext);
        for (int i = 0; i < this.parts.size() - 1; ++i) {
            emConvPos = emConvPos.emit(this::storePartAndPositionNextOpndLeg, fromLegs, i, bitShift, ext);
        }
        return emConvPos.emit(Op::l2i).emit(this::doGenStoreInt, this.parts.size() - 1);
    }

    private <N extends Emitter.Next> Emitter<Emitter.Ent<N, Types.TLong>> positionArrLeg(Emitter<N> em, Local<Types.TRef<int[]>> arr, JitType.IntJitType legType, int bitShift, Opnd.Ext ext) {
        return em.emit(Op::aload, arr).emit(Op::ldc__i, 0).emit(Op::iaload).emit(Opnd::convert, legType, JitType.LongJitType.I8, ext).emit(Op::ldc__i, bitShift).emit(Op::lshl);
    }

    private <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TLong>> Emitter<Emitter.Ent<N1, Types.TLong>> storePartAndPositionNextArrLeg(Emitter<N0> em, Local<Types.TRef<int[]>> arr, List<JitType.IntJitType> fromLegTypes, int i, int bitShift, Opnd.Ext ext) {
        Emitter emStored = em.emit(Op::dup2__2).emit(Op::l2i).emit(this::doGenStoreInt, i);
        return i + 1 < fromLegTypes.size() ? emStored.emit(Op::ldc__i, 32).emit(Op::lushr).emit(this::positionArrLeg, arr, fromLegTypes.get(i + 1), bitShift, ext).emit(Op::lor) : emStored.emit(Op::ldc__i, 32).emit(Opnd::lextshr, ext);
    }

    @Override
    public <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TRef<int[]>>> Emitter<N1> genStoreFromArray(Emitter<N0> em, JitCodeGenerator<?> gen, JitType.MpIntJitType from, Opnd.Ext ext, Scope scope) {
        try (SubScope ss = scope.sub();){
            Local<Types.TRef<int[]>> arr = ss.decl(Types.T_INT_ARR, "temp_arr");
            List<JitType.IntJitType> fromLegTypes = from.legTypesLE();
            int bitShift = this.byteShift + 8;
            Emitter emConvPos = em.emit(Op::astore, arr).emit(this::positionArrLeg, arr, fromLegTypes.get(0), bitShift, ext);
            for (int i = 0; i < this.parts.size() - 1; ++i) {
                emConvPos = emConvPos.emit(this::storePartAndPositionNextArrLeg, arr, fromLegTypes, i, bitShift, ext);
            }
            Emitter emitter = emConvPos.emit(Op::l2i).emit(this::doGenStoreInt, this.parts.size() - 1);
            return emitter;
        }
    }

    @Override
    public VarHandler subpiece(Endian endian, int byteOffset, int maxByteSize) {
        return AlignedMpIntHandler.subHandler(endian, this.vn, this.parts, this.byteShift, byteOffset, maxByteSize);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{ShiftedMpIntHandler.class, "parts;type;vn;byteShift", "parts", "type", "vn", "byteShift"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ShiftedMpIntHandler.class, "parts;type;vn;byteShift", "parts", "type", "vn", "byteShift"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ShiftedMpIntHandler.class, "parts;type;vn;byteShift", "parts", "type", "vn", "byteShift"}, this, o);
    }

    public List<JvmLocal<Types.TInt, JitType.IntJitType>> parts() {
        return this.parts;
    }

    @Override
    public JitType.MpIntJitType type() {
        return this.type;
    }

    @Override
    public Varnode vn() {
        return this.vn;
    }

    public int byteShift() {
        return this.byteShift;
    }
}

