/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.alloc;

import ghidra.pcode.emu.jit.alloc.IntInLongHandler;
import ghidra.pcode.emu.jit.alloc.JvmLocal;
import ghidra.pcode.emu.jit.alloc.SubInLongHandler;
import ghidra.pcode.emu.jit.alloc.VarHandler;
import ghidra.pcode.emu.jit.analysis.JitDataFlowArithmetic;
import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.opnd.Opnd;
import ghidra.pcode.emu.jit.gen.util.Emitter;
import ghidra.pcode.emu.jit.gen.util.Op;
import ghidra.pcode.emu.jit.gen.util.Types;
import ghidra.program.model.lang.Endian;
import ghidra.program.model.pcode.Varnode;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;

public final class LongInLongHandler
extends Record
implements SubInLongHandler<Types.TLong, JitType.LongJitType> {
    private final JvmLocal<Types.TLong, JitType.LongJitType> local;
    private final JitType.LongJitType type;
    private final Varnode vn;
    private final int byteShift;

    public LongInLongHandler(JvmLocal<Types.TLong, JitType.LongJitType> local, JitType.LongJitType type, Varnode vn, int byteShift) {
        this.assertShiftFits(byteShift, type, local);
        this.local = local;
        this.type = type;
        this.vn = vn;
        this.byteShift = byteShift;
    }

    @Override
    public Opnd.MpToStackConv<Types.TInt, JitType.IntJitType, JitType.MpIntJitType, Types.TLong, JitType.LongJitType> getConvToSub() {
        return Opnd.MpIntToLong.INSTANCE;
    }

    @Override
    public <TT extends Types.BPrim<?>, TJT extends JitType.SimpleJitType<TT, TJT>, N extends Emitter.Next> Emitter<Emitter.Ent<N, TT>> genLoadToStack(Emitter<N> em, JitCodeGenerator<?> gen, TJT type, Opnd.Ext ext) {
        return em.emit(Op::lload, this.local.local()).emit(Op::ldc__i, this.bitShift()).emit(Op::lushr).emit(Opnd::convert, this.type, type, ext);
    }

    @Override
    public <N extends Emitter.Next> Emitter<Emitter.Ent<N, Types.TInt>> genLoadLegToStack(Emitter<N> em, JitCodeGenerator<?> gen, JitType.MpIntJitType type, int leg, Opnd.Ext ext) {
        if (leg == 0) {
            Varnode subVn = JitDataFlowArithmetic.subPieceVn(gen.getAnalysisContext().getEndian(), this.vn, 0, 4);
            return new IntInLongHandler(this.local, JitType.IntJitType.I4, subVn, this.byteShift).genLoadLegToStack(em, gen, type, leg, ext);
        }
        Varnode subVn = JitDataFlowArithmetic.subPieceVn(gen.getAnalysisContext().getEndian(), this.vn, 4, this.vn.getSize() - 4);
        return new IntInLongHandler(this.local, JitType.IntJitType.forSize(subVn.getSize()), subVn, this.byteShift + 4).genLoadLegToStack(em, gen, type, leg - 1, ext);
    }

    @Override
    public VarHandler subpiece(Endian endian, int byteOffset, int maxByteSize) {
        Varnode subVn = JitDataFlowArithmetic.subPieceVn(endian, this.vn, byteOffset, maxByteSize);
        if (subVn.getSize() <= 4) {
            return new IntInLongHandler(this.local, JitType.IntJitType.forSize(subVn.getSize()), subVn, this.byteShift + byteOffset);
        }
        return new LongInLongHandler(this.local, JitType.LongJitType.forSize(subVn.getSize()), subVn, this.byteShift + byteOffset);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{LongInLongHandler.class, "local;type;vn;byteShift", "local", "type", "vn", "byteShift"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{LongInLongHandler.class, "local;type;vn;byteShift", "local", "type", "vn", "byteShift"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{LongInLongHandler.class, "local;type;vn;byteShift", "local", "type", "vn", "byteShift"}, this, o);
    }

    @Override
    public JvmLocal<Types.TLong, JitType.LongJitType> local() {
        return this.local;
    }

    @Override
    public JitType.LongJitType type() {
        return this.type;
    }

    @Override
    public Varnode vn() {
        return this.vn;
    }

    @Override
    public int byteShift() {
        return this.byteShift;
    }
}

