/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.alloc;

import ghidra.pcode.emu.jit.alloc.IntInIntHandler;
import ghidra.pcode.emu.jit.alloc.JvmLocal;
import ghidra.pcode.emu.jit.alloc.SimpleVarHandler;
import ghidra.pcode.emu.jit.alloc.VarHandler;
import ghidra.pcode.emu.jit.analysis.JitDataFlowArithmetic;
import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.opnd.Opnd;
import ghidra.pcode.emu.jit.gen.util.Emitter;
import ghidra.pcode.emu.jit.gen.util.Scope;
import ghidra.pcode.emu.jit.gen.util.Types;
import ghidra.program.model.lang.Endian;
import ghidra.program.model.pcode.Varnode;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;

public final class IntVarAlloc
extends Record
implements SimpleVarHandler<Types.TInt, JitType.IntJitType> {
    private final JvmLocal<Types.TInt, JitType.IntJitType> local;
    private final JitType.IntJitType type;

    public IntVarAlloc(JvmLocal<Types.TInt, JitType.IntJitType> local, JitType.IntJitType type) {
        this.local = local;
        this.type = type;
    }

    @Override
    public <N extends Emitter.Next> Emitter<Emitter.Ent<N, Types.TInt>> genLoadLegToStack(Emitter<N> em, JitCodeGenerator<?> gen, JitType.MpIntJitType type, int leg, Opnd.Ext ext) {
        return this.genLoadLegToStackC1(em, gen, type, leg, ext);
    }

    @Override
    public <N extends Emitter.Next> Opnd.OpndEm<JitType.MpIntJitType, N> genLoadToOpnd(Emitter<N> em, JitCodeGenerator<?> gen, JitType.MpIntJitType type, Opnd.Ext ext, Scope scope) {
        return Opnd.IntToMpInt.INSTANCE.doConvert(em, this.local.opnd(), this.local.name(), type, ext, scope);
    }

    @Override
    public Opnd.MpToStackConv<Types.TInt, JitType.IntJitType, JitType.MpIntJitType, Types.TInt, JitType.IntJitType> getConvToStack() {
        return Opnd.MpIntToInt.INSTANCE;
    }

    @Override
    public <N extends Emitter.Next> Emitter<Emitter.Ent<N, Types.TInt>> genLoadToBool(Emitter<N> em, JitCodeGenerator<?> gen) {
        return em.emit(this::genLoadToStack, gen, this.type, Opnd.Ext.ZERO).emit(Opnd::intToBool);
    }

    @Override
    public VarHandler subpiece(Endian endian, int byteOffset, int maxByteSize) {
        Varnode subVn = JitDataFlowArithmetic.subPieceVn(endian, this.local.vn(), byteOffset, Math.min(this.type.size(), maxByteSize));
        if (byteOffset == 0) {
            return new IntVarAlloc(this.local, JitType.IntJitType.forSize(subVn.getSize()));
        }
        return new IntInIntHandler(this.local, JitType.IntJitType.forSize(subVn.getSize()), subVn, byteOffset);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{IntVarAlloc.class, "local;type", "local", "type"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{IntVarAlloc.class, "local;type", "local", "type"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{IntVarAlloc.class, "local;type", "local", "type"}, this, o);
    }

    @Override
    public JvmLocal<Types.TInt, JitType.IntJitType> local() {
        return this.local;
    }

    @Override
    public JitType.IntJitType type() {
        return this.type;
    }
}

