/*
 * Decompiled with CFR 0.152.
 */
package ghidra.formats.gfilesystem.factory;

import ghidra.app.util.bin.ByteProvider;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.FileSystemProbeConflictResolver;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.formats.gfilesystem.factory.FileSystemFactoryDependencyException;
import ghidra.formats.gfilesystem.factory.FileSystemInfoRec;
import ghidra.formats.gfilesystem.factory.GFileSystemFactory;
import ghidra.formats.gfilesystem.factory.GFileSystemFactoryByteProvider;
import ghidra.formats.gfilesystem.factory.GFileSystemFactoryIgnore;
import ghidra.formats.gfilesystem.factory.GFileSystemProbe;
import ghidra.formats.gfilesystem.factory.GFileSystemProbeByteProvider;
import ghidra.formats.gfilesystem.factory.GFileSystemProbeBytesOnly;
import ghidra.util.Msg;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FileSystemFactoryMgr {
    private int largestBytesRequired = 0;
    private List<FileSystemInfoRec> sortedFactories = new ArrayList<FileSystemInfoRec>();
    private Map<String, FileSystemInfoRec> fsByType = new HashMap<String, FileSystemInfoRec>();

    public static FileSystemFactoryMgr getInstance() {
        return Singleton.instance;
    }

    private FileSystemFactoryMgr() {
        for (Class fsClass : ClassSearcher.getClasses(GFileSystem.class)) {
            this.addFactory(fsClass);
        }
        this.sortedFactories.sort(FileSystemInfoRec.BY_PRIORITY);
    }

    private void addFactory(Class<? extends GFileSystem> fsClass) {
        FileSystemInfoRec fsir = FileSystemInfoRec.fromClass(fsClass);
        if (fsir == null) {
            Msg.error((Object)this, (Object)("No valid FileSystemInfo found for " + fsClass.getName()));
            return;
        }
        if (this.fsByType.containsKey(fsir.getType())) {
            FileSystemInfoRec prevFSI = this.fsByType.get(fsir.getType());
            Msg.error((Object)this, (Object)"GFileSystem type '%s' registered more than one time: %s, %s, ommitting second instance.".formatted(fsir.getType(), fsClass.getName(), prevFSI.getFSClass().getName()));
            return;
        }
        if (fsir.getFactory() instanceof GFileSystemFactoryIgnore) {
            return;
        }
        GFileSystemFactory<?> gFileSystemFactory = fsir.getFactory();
        if (gFileSystemFactory instanceof GFileSystemProbeBytesOnly) {
            GFileSystemProbeBytesOnly pbo = (GFileSystemProbeBytesOnly)((Object)gFileSystemFactory);
            if (pbo.getBytesRequired() > 65536) {
                Msg.error((Object)this, (Object)"GFileSystemProbeBytesOnly for %s specifies too large value for bytes_required: %s, skipping this probe.".formatted(fsClass.getName(), pbo.getBytesRequired()));
            } else {
                this.largestBytesRequired = Math.max(this.largestBytesRequired, pbo.getBytesRequired());
            }
        }
        this.fsByType.put(fsir.getType(), fsir);
        this.sortedFactories.add(fsir);
    }

    public List<String> getAllFilesystemNames() {
        return this.fsByType.keySet().stream().map(fsType -> this.fsByType.get(fsType).getDescription()).sorted(String::compareToIgnoreCase).toList();
    }

    public String getFileSystemType(Class<? extends GFileSystem> fsClass) {
        FileSystemInfo fsi = fsClass.getAnnotation(FileSystemInfo.class);
        return fsi != null && this.fsByType.get(fsi.type()) != null ? fsi.type() : null;
    }

    public GFileSystem mountFileSystem(String fsType, ByteProvider byteProvider, FileSystemService fsService, TaskMonitor monitor) throws IOException, CancelledException {
        FileSystemInfoRec fsir = this.fsByType.get(fsType);
        if (fsir == null) {
            FSUtilities.uncheckedClose(byteProvider, null);
            throw new IOException("Unknown file system type " + fsType);
        }
        GFileSystem result = this.mountUsingFactory(fsir, byteProvider, byteProvider.getFSRL().makeNested(fsType), fsService, monitor);
        return result;
    }

    private GFileSystem mountUsingFactory(FileSystemInfoRec fsir, ByteProvider byteProvider, FSRLRoot targetFSRL, FileSystemService fsService, TaskMonitor monitor) throws IOException, CancelledException {
        GFileSystem result = null;
        boolean bpTaken = false;
        try {
            GFileSystemFactory<?> gFileSystemFactory = fsir.getFactory();
            if (gFileSystemFactory instanceof GFileSystemFactoryByteProvider) {
                GFileSystemFactoryByteProvider bpFactory = (GFileSystemFactoryByteProvider)gFileSystemFactory;
                bpTaken = true;
                result = bpFactory.create(targetFSRL, byteProvider, fsService, monitor);
            }
        }
        catch (CancelledException | IOException e) {
            if (e instanceof FileSystemFactoryDependencyException) {
                Msg.warn((Object)this, (Object)"File system dependency error: %s (%s)".formatted(e.getMessage(), fsir.getType()));
            } else {
                Msg.warn((Object)this, (Object)"Error during fs factory create: %s, %s".formatted(fsir.getType(), fsir.getFSClass()), (Throwable)e);
            }
            throw e;
        }
        finally {
            if (byteProvider != null && !bpTaken) {
                FSUtilities.uncheckedClose(byteProvider, null);
            }
        }
        return result;
    }

    public boolean test(ByteProvider byteProvider, FileSystemService fsService, TaskMonitor monitor) throws IOException, CancelledException {
        int pboByteCount = Math.min((int)Math.min(byteProvider.length(), 65536L), this.largestBytesRequired);
        FSRL containerFSRL = byteProvider.getFSRL();
        byte[] startBytes = byteProvider.readBytes(0L, pboByteCount);
        for (FileSystemInfoRec fsir : this.sortedFactories) {
            try {
                GFileSystemProbe factoryProbe;
                GFileSystemFactory<?> gFileSystemFactory = fsir.getFactory();
                if (gFileSystemFactory instanceof GFileSystemProbeBytesOnly && (factoryProbe = (GFileSystemProbeBytesOnly)((Object)gFileSystemFactory)).getBytesRequired() <= startBytes.length && factoryProbe.probeStartBytes(containerFSRL, startBytes)) {
                    return true;
                }
                gFileSystemFactory = fsir.getFactory();
                if (!(gFileSystemFactory instanceof GFileSystemProbeByteProvider) || !(factoryProbe = (GFileSystemProbeByteProvider)((Object)gFileSystemFactory)).probe(byteProvider, fsService, monitor)) continue;
                return true;
            }
            catch (IOException e) {
                Msg.trace((Object)this, (Object)("File system probe error for " + fsir.getDescription() + " with " + String.valueOf(containerFSRL)), (Throwable)e);
            }
        }
        return false;
    }

    public GFileSystem probe(ByteProvider byteProvider, FileSystemService fsService, FileSystemProbeConflictResolver conflictResolver, TaskMonitor monitor) throws IOException, CancelledException {
        return this.probe(byteProvider, fsService, conflictResolver, Integer.MIN_VALUE, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GFileSystem probe(ByteProvider byteProvider, FileSystemService fsService, FileSystemProbeConflictResolver conflictResolver, int priorityFilter, TaskMonitor monitor) throws IOException, CancelledException {
        conflictResolver = conflictResolver == null ? FileSystemProbeConflictResolver.CHOOSEFIRST : conflictResolver;
        FSRL containerFSRL = byteProvider.getFSRL();
        try {
            GFileSystemFactory<?> gFileSystemFactory;
            int pboByteCount = Math.min((int)Math.min(byteProvider.length(), 65536L), this.largestBytesRequired);
            byte[] startBytes = byteProvider.readBytes(0L, pboByteCount);
            ArrayList<FileSystemInfoRec> probeMatches = new ArrayList<FileSystemInfoRec>();
            for (FileSystemInfoRec fsir2 : this.sortedFactories) {
                try {
                    GFileSystemProbe factoryProbe;
                    if (fsir2.getPriority() < priorityFilter) break;
                    gFileSystemFactory = fsir2.getFactory();
                    if (gFileSystemFactory instanceof GFileSystemProbeBytesOnly && (factoryProbe = (GFileSystemProbeBytesOnly)((Object)gFileSystemFactory)).getBytesRequired() <= startBytes.length && factoryProbe.probeStartBytes(containerFSRL, startBytes)) {
                        probeMatches.add(fsir2);
                        continue;
                    }
                    gFileSystemFactory = fsir2.getFactory();
                    if (!(gFileSystemFactory instanceof GFileSystemProbeByteProvider) || !(factoryProbe = (GFileSystemProbeByteProvider)((Object)gFileSystemFactory)).probe(byteProvider, fsService, monitor)) continue;
                    probeMatches.add(fsir2);
                }
                catch (IOException e) {
                    Msg.trace((Object)this, (Object)"File system probe error for %s with %s".formatted(fsir2.getDescription(), containerFSRL), (Throwable)e);
                }
            }
            monitor.setMessage("Choosing filesystem");
            FileSystemInfoRec fsir = conflictResolver.resolveFSIR(probeMatches);
            if (fsir == null) {
                FileSystemInfoRec fsir2;
                fsir2 = null;
                return fsir2;
            }
            ByteProvider mountBP = byteProvider;
            byteProvider = null;
            GFileSystem fs = this.mountUsingFactory(fsir, mountBP, containerFSRL.makeNested(fsir.getType()), fsService, monitor);
            monitor.setMessage("Found file system " + fs.getDescription());
            gFileSystemFactory = fs;
            return gFileSystemFactory;
        }
        finally {
            FSUtilities.uncheckedClose(byteProvider, null);
        }
    }

    private static class Singleton {
        private static final FileSystemFactoryMgr instance = new FileSystemFactoryMgr();

        private Singleton() {
        }
    }
}

