/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.internal.FieldBackgroundColorManager;
import docking.widgets.fieldpanel.internal.PaintContext;
import docking.widgets.fieldpanel.support.RowColLocation;
import ghidra.app.util.viewer.field.AbstractOpenCloseField;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.proxy.FunctionProxy;
import ghidra.app.util.viewer.proxy.ProxyObj;
import ghidra.program.model.address.Address;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;

public class FunctionOpenCloseField
extends AbstractOpenCloseField {
    public FunctionOpenCloseField(FieldFactory factory, ProxyObj<?> proxy, FontMetrics metrics, int x, int width) {
        super(factory, proxy, metrics, x, width);
        if (proxy instanceof FunctionProxy) {
            FunctionProxy functionProxy = (FunctionProxy)proxy;
            Address functionAddress = functionProxy.getFunctionAddress();
            this.isOpen = proxy.getListingLayoutModel().isFunctionOpen(functionAddress);
        }
    }

    public int getWidth() {
        return this.fieldWidth;
    }

    public void paint(JComponent c, Graphics g, PaintContext context, Rectangle clip, FieldBackgroundColorManager map, RowColLocation cursorLoc, int rowHeight) {
        int toggleHandleStartY = -(this.heightAbove / 2 + this.toggleHandleSize / 2);
        int toggleHandleStartX = this.startX;
        if (!context.isPrinting()) {
            if (this.isOpen) {
                g.drawImage(OPEN_ICON.getImageIcon().getImage(), toggleHandleStartX, toggleHandleStartY, context.getBackground(), null);
            } else {
                g.drawImage(CLOSED_ICON.getImageIcon().getImage(), toggleHandleStartX, toggleHandleStartY, context.getBackground(), null);
            }
        }
        this.paintCursor(g, context.getCursorColor(), cursorLoc);
    }

    @Override
    public void toggleOpenCloseState() {
        ProxyObj proxyObj = this.proxy;
        if (proxyObj instanceof FunctionProxy) {
            FunctionProxy functionProxy = (FunctionProxy)proxyObj;
            Address functionAddress = functionProxy.getFunctionAddress();
            this.proxy.getListingLayoutModel().setFunctionOpen(functionAddress, !this.isOpen);
        }
    }
}

