/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.DecompileDebugByteManager;
import ghidra.app.util.opinion.DecompileDebugDataTypeManager;
import ghidra.app.util.opinion.DecompileDebugFunctionManager;
import ghidra.app.util.opinion.DecompileDebugXmlLoader;
import ghidra.app.util.opinion.LoadException;
import ghidra.framework.store.LockException;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.data.DataType;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CommentType;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.mem.MemoryConflictException;
import ghidra.program.model.pcode.AddressXML;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlMessageLog;
import ghidra.xml.XmlParseException;
import ghidra.xml.XmlPullParser;
import ghidra.xml.XmlPullParserFactory;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.HexFormat;
import java.util.Map;
import java.util.TreeMap;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DecompileDebugFormatManager {
    private File file;
    private DecompileDebugXmlLoader.DecompileDebugProgramInfo progInfo;
    private Map<Long, Namespace> scopeMap;

    public DecompileDebugFormatManager(File file) {
        this.file = file;
    }

    public DecompileDebugFormatManager(ByteProvider provider) {
        this.file = provider.getFSRL() != null && provider.getFSRL().getNestingDepth() == 1 ? new File(provider.getFSRL().getPath()) : provider.getFile();
    }

    public DecompileDebugXmlLoader.DecompileDebugProgramInfo getProgramInfo() throws SAXException, IOException {
        XmlPullParser parser = XmlPullParserFactory.create((File)this.file, (ErrorHandler)new MyErrorHandler(this, new MessageLog()), (boolean)false);
        String loadSpecString = "";
        String offset = "";
        while (parser.hasNext()) {
            XmlElement element = parser.next();
            if (element.isStart("binaryimage")) {
                loadSpecString = element.getAttribute("arch");
                continue;
            }
            if (!element.isStart("bytechunk")) continue;
            offset = element.getAttribute(AttributeId.ATTRIB_OFFSET.name());
            break;
        }
        String compilerString = loadSpecString.substring(loadSpecString.lastIndexOf(58) + 1, loadSpecString.length());
        loadSpecString = loadSpecString.substring(0, loadSpecString.lastIndexOf(58));
        this.progInfo = new DecompileDebugXmlLoader.DecompileDebugProgramInfo(offset, compilerString, loadSpecString);
        parser.dispose();
        return this.progInfo;
    }

    public MessageLog read(Program prog, TaskMonitor monitor, String programName) throws LoadException {
        XmlMessageLog log = new XmlMessageLog();
        MyErrorHandler errorHandler = new MyErrorHandler(this, (MessageLog)log);
        this.scopeMap = new TreeMap<Long, Namespace>();
        this.scopeMap.put(0L, prog.getGlobalNamespace());
        int transactionId = prog.startTransaction("Loading");
        XmlPullParser parser = null;
        try {
            parser = XmlPullParserFactory.create((File)this.file, (ErrorHandler)errorHandler, (boolean)false);
            log.setParser(parser);
            monitor.setMessage("Beginning Load");
            log.appendMsg("Beginning Load");
            XmlElement startSavefileElement = parser.start(new String[]{"xml_savefile"});
            XmlElement saveStateElement = null;
            DecompileDebugDataTypeManager dataTypeManager = new DecompileDebugDataTypeManager(monitor, prog);
            block25: while (parser.peek().isStart() && !monitor.isCancelled()) {
                String name;
                XmlElement element = null;
                switch (name = parser.peek().getName()) {
                    case "binaryimage": {
                        element = parser.start(new String[]{"binaryimage"});
                        this.handleBinaryImageElements(parser, monitor, prog, programName, log);
                        parser.end(element);
                        continue block25;
                    }
                    case "coretypes": {
                        monitor.setMessage("Processing Core Data Types");
                        element = parser.start(new String[]{"coretypes"});
                        this.parseDataTypes(parser, monitor, prog, dataTypeManager, log);
                        parser.end(element);
                        continue block25;
                    }
                    case "typegrp": {
                        monitor.setMessage("Processing Composite Data Types");
                        element = parser.start(new String[]{"typegrp"});
                        this.parseDataTypes(parser, monitor, prog, dataTypeManager, log);
                        parser.end(element);
                        continue block25;
                    }
                    case "save_state": {
                        saveStateElement = parser.start(new String[]{"save_state"});
                        continue block25;
                    }
                    case "db": {
                        element = parser.start(new String[]{"db"});
                        this.handleDBElements(parser, monitor, prog, dataTypeManager, programName, log);
                        parser.end(element);
                        continue block25;
                    }
                    case "commentdb": {
                        element = parser.start(new String[]{"commentdb"});
                        this.parseComments(parser, monitor, prog, log);
                        parser.end(element);
                        continue block25;
                    }
                    case "stringmanage": {
                        element = parser.start(new String[]{"stringmanage"});
                        this.parseStrings(parser, monitor, prog, log);
                        parser.end(element);
                        continue block25;
                    }
                    case "context_points": {
                        element = parser.start(new String[]{"context_points"});
                        this.parseContextPoints(parser, monitor, prog, log);
                        parser.end(element);
                        continue block25;
                    }
                }
                log.appendMsg(parser.getLineNumber(), "Level " + parser.getCurrentLevel() + " tag not currently supported: " + name);
                parser.discardSubTree(name);
            }
            parser.end(saveStateElement);
            parser.end(startSavefileElement);
        }
        catch (IOException | SAXException e) {
            log.appendException((Throwable)e);
            throw new LoadException("File read error.");
        }
        finally {
            monitor.setMessage("Finished import");
            log.appendMsg("Finished import");
            prog.endTransaction(transactionId, true);
            parser.dispose();
        }
        return log;
    }

    private void handleDBElements(XmlPullParser parser, TaskMonitor monitor, Program prog, DecompileDebugDataTypeManager dataTypeManager, String programName, XmlMessageLog log) {
        while (parser.peek().isStart() && !monitor.isCancelled()) {
            if (parser.peek().getName().equals("scope")) {
                Namespace namespace;
                XmlElement scopeElement = parser.start(new String[]{"scope"});
                Long scopeId = SpecXmlUtils.decodeLong((String)scopeElement.getAttribute(AttributeId.ATTRIB_ID.name()));
                String namespaceName = scopeElement.getAttribute(AttributeId.ATTRIB_NAME.name());
                long parentId = 0L;
                if (parser.peek().getName().equals("parent")) {
                    XmlElement parentElement = parser.start(new String[]{"parent"});
                    parentId = SpecXmlUtils.decodeLong((String)parentElement.getAttribute(AttributeId.ATTRIB_ID.name()));
                    parser.end(parentElement);
                }
                if ((namespace = this.scopeMap.get(scopeId)) == null) {
                    Namespace parentNamespace = this.scopeMap.get(parentId);
                    try {
                        namespace = prog.getSymbolTable().createNameSpace(parentNamespace, namespaceName, SourceType.IMPORTED);
                        this.scopeMap.put(scopeId, namespace);
                    }
                    catch (DuplicateNameException | InvalidInputException e) {
                        log.appendException(e);
                    }
                }
                this.handleScopeSubtree(namespace, parser, monitor, prog, dataTypeManager, programName, log);
                parser.end(scopeElement);
                continue;
            }
            log.appendMsg(parser.getLineNumber(), "Level " + parser.getCurrentLevel() + " tag not currently supported: " + parser.peek().getName());
            parser.discardSubTree();
        }
    }

    private void handleScopeSubtree(Namespace namespace, XmlPullParser parser, TaskMonitor monitor, Program prog, DecompileDebugDataTypeManager dataTypeManager, String programName, XmlMessageLog log) {
        XmlElement symbollistElement = null;
        DecompileDebugFunctionManager functionManager = new DecompileDebugFunctionManager(prog, monitor, dataTypeManager);
        block10: while (parser.peek().isStart() && !monitor.isCancelled()) {
            String name;
            switch (name = parser.peek().getName()) {
                case "symbollist": {
                    symbollistElement = parser.start(new String[]{"symbollist"});
                    continue block10;
                }
                case "mapsym": {
                    XmlElement mapsymTypeElement = parser.start(new String[]{"mapsym"});
                    monitor.setMessage("Processing Symbols");
                    String symbolType = parser.peek().getName();
                    if (symbolType.equals("function")) {
                        functionManager.parseFunctionSignature(parser, this.scopeMap, log);
                        while (parser.peek().isStart()) {
                            log.appendMsg(parser.getLineNumber(), "Level " + parser.getCurrentLevel() + " tag not currently supported: " + name);
                            parser.discardSubTree();
                        }
                    } else if (symbolType.equals("labelsym")) {
                        this.parseLabelSymbol(prog, parser, log);
                    } else if (symbolType.equals("symbol")) {
                        try {
                            this.parseSymbol(prog, parser, dataTypeManager, namespace, programName, monitor, log);
                        }
                        catch (LoadException e) {
                            log.appendException((Throwable)e);
                        }
                    }
                    parser.end(mapsymTypeElement);
                    continue block10;
                }
            }
            log.appendMsg(parser.getLineNumber(), "Level " + parser.getCurrentLevel() + " tag not currently supported: " + name);
            parser.discardSubTree();
        }
        parser.end(symbollistElement);
    }

    private void handleBinaryImageElements(XmlPullParser parser, TaskMonitor monitor, Program prog, String programName, XmlMessageLog log) {
        monitor.setMessage("Processing binary image");
        while (parser.peek().isStart() && !monitor.isCancelled()) {
            if (parser.peek().getName().equals("bytechunk")) {
                monitor.setMessage("Processing Byte Chunk(s)");
                DecompileDebugByteManager byteMngr = new DecompileDebugByteManager(monitor, prog, programName);
                byteMngr.parse(parser, log);
                continue;
            }
            log.appendMsg(parser.getLineNumber(), "Level " + parser.getCurrentLevel() + " tag not currently supported: " + parser.peek().getName());
            parser.discardSubTree();
        }
    }

    private void parseLabelSymbol(Program prog, XmlPullParser parser, XmlMessageLog log) {
        XmlElement symbolElement = parser.start(new String[]{"labelsym"});
        String symbolName = symbolElement.getAttribute(AttributeId.ATTRIB_NAME.name());
        parser.end(symbolElement);
        XmlElement addrElement = parser.start(new String[]{"addr"});
        try {
            Address symbolAddr = AddressXML.restoreXml((XmlElement)addrElement, (CompilerSpec)prog.getCompilerSpec()).getFirstAddress();
            SymbolTable st = prog.getSymbolTable();
            Symbol createdSymbol = st.createLabel(symbolAddr, symbolName, SourceType.IMPORTED);
            createdSymbol.setPrimary();
            parser.end(addrElement);
            while (parser.peek().isStart()) {
                log.appendMsg(parser.getLineNumber(), "Level " + parser.getCurrentLevel() + " tag not currently supported: " + parser.peek().getName());
                parser.discardSubTree();
            }
        }
        catch (InvalidInputException | XmlParseException e) {
            log.appendException(e);
        }
    }

    private void parseSymbol(Program prog, XmlPullParser parser, DecompileDebugDataTypeManager dataTypeManager, Namespace namespace, String programName, TaskMonitor monitor, XmlMessageLog log) throws LoadException {
        XmlElement symbolElement = parser.start(new String[]{"symbol"});
        String symbolName = symbolElement.getAttribute(AttributeId.ATTRIB_NAME.name());
        DataType dt = dataTypeManager.parseDataTypeTag(parser, log);
        Boolean readOnly = symbolElement.hasAttribute(AttributeId.ATTRIB_READONLY.name());
        parser.end(symbolElement);
        XmlElement addrElement = parser.start(new String[]{"addr"});
        Address symbolAddr = null;
        try {
            AddressXML xmlAddr = AddressXML.restoreXml((XmlElement)addrElement, (CompilerSpec)prog.getCompilerSpec());
            symbolAddr = xmlAddr.getFirstAddress();
            Symbol createdSymbol = SymbolUtilities.createPreferredLabelOrFunctionSymbol((Program)prog, (Address)symbolAddr, (Namespace)namespace, (String)symbolName, (SourceType)SourceType.IMPORTED);
            createdSymbol.setPrimary();
            Memory memory = prog.getMemory();
            Address end = symbolAddr.addNoWrap(xmlAddr.getSize() - 1L);
            if (!memory.contains(symbolAddr, end)) {
                MemoryBlock generatedBlock = memory.createInitializedBlock(programName, symbolAddr, xmlAddr.getSize(), (byte)0, monitor, false);
                generatedBlock.setWrite(readOnly == false);
                prog.getListing().createData(symbolAddr, dt, (int)xmlAddr.getSize());
            } else {
                prog.getListing().createData(symbolAddr, dt, (int)xmlAddr.getSize());
            }
        }
        catch (MemoryConflictException mce) {
            log.appendMsg("Attempted to allocate overlapping memory block for data: " + dt.getDisplayName() + " at address: " + String.valueOf(symbolAddr));
            log.appendException((Throwable)mce);
        }
        catch (LockException | AddressOverflowException | CodeUnitInsertionException | CancelledException | InvalidInputException | XmlParseException | IllegalArgumentException e) {
            log.appendException(e);
        }
        parser.end(addrElement);
        while (parser.peek().isStart()) {
            log.appendMsg(parser.getLineNumber(), "Level " + parser.getCurrentLevel() + " tag not currently supported: " + parser.peek().getName());
            parser.discardSubTree();
        }
    }

    private void parseComments(XmlPullParser parser, TaskMonitor monitor, Program prog, XmlMessageLog log) {
        while (parser.peek().isStart("comment") && !monitor.isCancelled()) {
            this.parseAndAddComment(parser, prog, log);
        }
    }

    private void parseAndAddComment(XmlPullParser parser, Program prog, XmlMessageLog log) {
        XmlElement commentElement = parser.start(new String[]{"comment"});
        String commentType = commentElement.getAttribute(AttributeId.ATTRIB_TYPE.name());
        CommentType decodedType = this.decodeCommentType(commentType);
        parser.discardSubTree("addr");
        XmlElement addrElement = parser.start(new String[]{"addr"});
        try {
            Address commentAddr = AddressXML.restoreXml((XmlElement)addrElement, (CompilerSpec)prog.getCompilerSpec()).getFirstAddress();
            parser.end(addrElement);
            parser.start(new String[]{"text"});
            String commentText = parser.end().getText();
            this.setupComments(decodedType, commentAddr, commentText, prog);
            parser.end(commentElement);
        }
        catch (XmlParseException e) {
            log.appendException((Throwable)e);
        }
    }

    private void setupComments(CommentType decodedType, Address commentAddr, String commentText, Program prog) {
        CodeUnit cu = prog.getListing().getCodeUnitAt(commentAddr);
        cu.setComment(decodedType, commentText);
    }

    private CommentType decodeCommentType(String typeName) {
        return switch (typeName) {
            case "user1" -> CommentType.EOL;
            case "user2" -> CommentType.PRE;
            case "user3" -> CommentType.POST;
            case "header" -> CommentType.PLATE;
            default -> CommentType.valueOf((String)"");
        };
    }

    private void parseDataTypes(XmlPullParser parser, TaskMonitor monitor, Program prog, DecompileDebugDataTypeManager dataTypeManager, XmlMessageLog log) {
        while (parser.peek().isStart() && !monitor.isCancelled()) {
            dataTypeManager.parseDataTypeTag(parser, log);
        }
    }

    private void parseStrings(XmlPullParser parser, TaskMonitor monitor, Program prog, XmlMessageLog log) {
        while (parser.peek().isStart("string") && !monitor.isCancelled()) {
            this.parseAndAddStrings(parser, monitor, prog, log);
        }
    }

    private void parseAndAddStrings(XmlPullParser parser, TaskMonitor monitor, Program prog, XmlMessageLog log) {
        XmlElement stringElement = parser.start(new String[]{"string"});
        XmlElement addrElement = parser.start(new String[]{"addr"});
        try {
            Address stringAddr = AddressXML.restoreXml((XmlElement)addrElement, (CompilerSpec)prog.getCompilerSpec()).getFirstAddress();
            parser.end(addrElement);
            parser.start(new String[]{"bytes"});
            String hexString = parser.end().getText().trim().replaceAll("\n", "");
            hexString = hexString.replaceAll(" ", "");
            byte[] rawBytes = HexFormat.of().parseHex(hexString);
            Memory memory = prog.getMemory();
            memory.setBytes(stringAddr, rawBytes);
        }
        catch (MemoryAccessException | XmlParseException | IllegalArgumentException e) {
            log.appendException(e);
        }
        parser.end(stringElement);
    }

    private void parseContextPoints(XmlPullParser parser, TaskMonitor monitor, Program prog, XmlMessageLog log) {
        while (parser.peek().isStart("context_pointset")) {
            XmlElement contextElement = parser.start(new String[]{"context_pointset"});
            try {
                Address addr = AddressXML.restoreXml((XmlElement)contextElement, (CompilerSpec)prog.getCompilerSpec()).getFirstAddress();
                ProgramContext pc = prog.getProgramContext();
                while (parser.peek().isStart("set") && !monitor.isCancelled()) {
                    XmlElement setElement = parser.start(new String[]{"set"});
                    String regName = setElement.getAttribute(AttributeId.ATTRIB_NAME.name());
                    BigInteger regVal = new BigInteger(setElement.getAttribute(AttributeId.ATTRIB_VAL.name()));
                    Register reg = pc.getRegister(regName);
                    pc.setValue(reg, addr, addr, regVal);
                    parser.end(setElement);
                }
            }
            catch (ContextChangeException | XmlParseException e) {
                log.appendException(e);
            }
            parser.end(contextElement);
        }
        while (parser.peek().isStart("tracked_pointset")) {
            log.appendMsg(parser.getLineNumber(), "Level " + parser.getCurrentLevel() + " tag not currently supported: " + parser.peek().getName());
            parser.discardSubTree();
        }
    }

    class MyErrorHandler
    implements ErrorHandler {
        private MessageLog log;

        MyErrorHandler(DecompileDebugFormatManager this$0, MessageLog log) {
            this.log = log;
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            this.log.appendMsg(exception.getMessage());
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            this.log.appendMsg(exception.getMessage());
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            this.log.appendMsg(exception.getMessage());
        }
    }
}

