/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.swift.types;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.swift.SwiftUtils;
import ghidra.app.util.bin.format.swift.types.TargetTypeContextDescriptor;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public final class TargetClassDescriptor
extends TargetTypeContextDescriptor {
    private int superclassType;
    private int metadataNegativeSizeInWords;
    private int metadataPositiveSizeInWords;
    private int numImmediateMembers;
    private int numFields;
    private int fieldOffsetVectorOffset;

    public TargetClassDescriptor(BinaryReader reader) throws IOException {
        super(reader);
        this.superclassType = reader.readNextInt();
        this.metadataNegativeSizeInWords = reader.readNextInt();
        this.metadataPositiveSizeInWords = reader.readNextInt();
        this.numImmediateMembers = reader.readNextInt();
        this.numFields = reader.readNextInt();
        this.fieldOffsetVectorOffset = reader.readNextInt();
    }

    public int getSuperclassType() {
        return this.superclassType;
    }

    public int getMetadataNegativeSizeInWords() {
        return this.metadataNegativeSizeInWords;
    }

    public int getMetadataPositiveSizeInWords() {
        return this.metadataPositiveSizeInWords;
    }

    public int getNumImmediateMembers() {
        return this.numImmediateMembers;
    }

    public int getNumFields() {
        return this.numFields;
    }

    public int getFieldOffsetVectorOffset() {
        return this.fieldOffsetVectorOffset;
    }

    @Override
    public String getStructureName() {
        return TargetClassDescriptor.class.getSimpleName();
    }

    @Override
    public String getDescription() {
        return "class descriptor";
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(this.getStructureName(), 0);
        struct.add(super.toDataType(), super.getStructureName(), "");
        struct.add((DataType)SwiftUtils.PTR_STRING, "SuperclassType", "The type of the superclass, expressed as a mangled type name that can refer to the generic arguments of the subclass type");
        struct.add(DWORD, "MetadataNegativeSizeInWords", "If this descriptor does not have a resilient superclass, this is the negative size of metadata objects of this class (in words)");
        struct.add(DWORD, "MetadataPositiveSizeInWords", "If this descriptor does not have a resilient superclass, this is the positive size of metadata objects of this class (in words)");
        struct.add(DWORD, "NumImmediateMembers", "The number of additional members added by this class to the class metadata");
        struct.add(DWORD, "NumFields", "The number of stored properties in the class, not including its superclasses. If there is a field offset vector, this is its length.");
        struct.add(DWORD, "FieldOffsetVectorOffset", "The offset of the field offset vector for this class's stored properties in its metadata, in words. 0 means there is no field offset vector.");
        struct.setCategoryPath(new CategoryPath("/SwiftTypeMetadata"));
        return struct;
    }
}

