/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.omf.omf166;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.omf.OmfException;
import ghidra.app.util.bin.format.omf.OmfRecord;
import ghidra.app.util.bin.format.omf.OmfString;
import ghidra.app.util.bin.format.omf.OmfUtils;
import ghidra.app.util.bin.format.omf.omf166.Omf166RecordTypes;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Omf166DepList
extends OmfRecord {
    private List<Info> infoList = new ArrayList<Info>();

    public Omf166DepList(BinaryReader reader) throws IOException {
        super(reader);
    }

    @Override
    public void parseData() throws IOException, OmfException {
        block4: while (this.dataReader.getPointerIndex() < this.dataEnd) {
            byte iTyp = this.dataReader.readNextByte();
            switch (iTyp) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    byte mark = this.dataReader.readNextByte();
                    int time = this.dataReader.readNextInt();
                    OmfString name = OmfUtils.readString(this.dataReader);
                    this.infoList.add(new Info(iTyp, mark, time, name, null));
                    continue block4;
                }
                case -1: {
                    OmfString invocation = OmfUtils.readString(this.dataReader);
                    OmfString bigName = null;
                    if (invocation.length() == 0) {
                        bigName = OmfUtils.readBigString(this.dataReader);
                    }
                    this.infoList.add(new Info(iTyp, null, null, invocation, bigName));
                    continue block4;
                }
            }
            throw new OmfException("Unexpected DEPLST iTyp: 0x%x".formatted(iTyp));
        }
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(Omf166RecordTypes.getName(this.recordType), 0);
        struct.add(BYTE, "type", null);
        struct.add(WORD, "length", null);
        for (Info info : this.infoList) {
            struct.add(BYTE, "iTyp", null);
            if (info.mark != null) {
                struct.add(BYTE, "mark8", null);
            }
            if (info.time != null) {
                struct.add(DWORD, "time32", null);
            }
            struct.add(info.name.toDataType(), info.name.getDataTypeSize(), "name", null);
            if (info.bigName == null) continue;
            struct.add(info.bigName.toDataType(), info.bigName.getDataTypeSize(), "bigName", null);
        }
        struct.add(BYTE, "checksum", null);
        struct.setCategoryPath(new CategoryPath("/OMF"));
        return struct;
    }

    private record Info(byte type, Byte mark, Integer time, OmfString name, OmfString bigName) {
    }
}

