/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objc.objc2;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.objc.ObjcState;
import ghidra.app.util.bin.format.objc.ObjcTypeMetadataStructure;
import ghidra.app.util.bin.format.objc.ObjcUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class Objc2MessageReference
extends ObjcTypeMetadataStructure {
    public static final String NAME = "message_ref";
    private long implementation;
    private String selector;

    public static int SIZEOF(int pointerSize) {
        return 2 * pointerSize;
    }

    public Objc2MessageReference(Program program, ObjcState state, BinaryReader reader) throws IOException {
        super(program, state, reader.getPointerIndex());
        this.implementation = this.is32bit ? reader.readNextUnsignedInt() : reader.readNextLong();
        long selectorIndex = ObjcUtils.readNextIndex(reader, this.is32bit);
        if (selectorIndex != 0L) {
            this.selector = reader.readAsciiString(selectorIndex);
        }
    }

    public long getImplementation() {
        return this.implementation;
    }

    public String getSelector() {
        return this.selector;
    }

    @Override
    public void applyTo(Namespace namespace, TaskMonitor monitor) throws Exception {
        Address address = ObjcUtils.toAddress(this.program, this.base);
        DataType dt = this.toDataType();
        Data messageRefData = this.program.getListing().createData(address, dt);
        Data selData = messageRefData.getComponent(1);
        Object selAddress = selData.getValue();
        Data selStringData = this.program.getListing().getDataAt((Address)selAddress);
        Object selString = selStringData.getValue();
        ObjcUtils.createSymbol(this.program, null, String.valueOf(selString) + "_message_ref", address);
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add((DataType)new PointerDataType(VOID), this.pointerSize, "imp", null);
        struct.add((DataType)new PointerDataType(ASCII), this.pointerSize, "sel", null);
        return struct;
    }
}

