/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objc.objc2;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.objc.ObjcState;
import ghidra.app.util.bin.format.objc.ObjcTypeMetadataStructure;
import ghidra.app.util.bin.format.objc.ObjcUtils;
import ghidra.app.util.bin.format.objc.objc2.Objc2Cache;
import ghidra.app.util.bin.format.objc.objc2.Objc2ClassRW;
import ghidra.app.util.bin.format.objc.objc2.Objc2Constants;
import ghidra.app.util.bin.format.objc.objc2.Objc2Implementation;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class Objc2Class
extends ObjcTypeMetadataStructure {
    public static final String NAME = "class_t";
    private Objc2Class isa;
    private Objc2Class superclass;
    private Objc2Cache cache;
    private Objc2Implementation vtable;
    private Objc2ClassRW data;

    public Objc2Class(Program program, ObjcState state, BinaryReader reader) {
        super(program, state, reader.getPointerIndex());
        state.classIndexMap.put(this.base, this);
        try {
            this.readISA(reader);
            this.readSuperClass(reader);
            this.readCache(reader);
            this.readVTable(reader);
            this.readData(reader);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean equals(Object that) {
        if (that instanceof Objc2Class) {
            return this.base == ((Objc2Class)that).base;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.base;
    }

    public Objc2Class getISA() {
        return this.isa;
    }

    public Objc2Class getSuperClass() {
        return this.superclass;
    }

    public Objc2Cache getCache() {
        return this.cache;
    }

    public Objc2Implementation getVTable() {
        return this.vtable;
    }

    public Objc2ClassRW getData() {
        return this.data;
    }

    public long getIndex() {
        return this.base;
    }

    private void readData(BinaryReader reader) throws IOException {
        long index = 0L;
        try {
            index = ObjcUtils.readNextIndex(reader, this.is32bit);
        }
        catch (IOException ioe) {
            return;
        }
        if ((index &= this.is32bit ? -4L : -8L) != 0L && reader.isValidIndex(index)) {
            long originalIndex = reader.getPointerIndex();
            reader.setPointerIndex(index);
            this.data = new Objc2ClassRW(this.program, this.state, reader);
            reader.setPointerIndex(originalIndex);
        }
    }

    private void readVTable(BinaryReader reader) {
        try {
            this.vtable = new Objc2Implementation(this.program, this.state, reader);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void readCache(BinaryReader reader) {
        try {
            this.cache = new Objc2Cache(this.program, this.state, reader);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void readSuperClass(BinaryReader reader) {
        long index = 0L;
        try {
            index = ObjcUtils.readNextIndex(reader, this.is32bit);
        }
        catch (IOException ioe) {
            return;
        }
        if (this.state.classIndexMap.containsKey(index)) {
            this.superclass = this.state.classIndexMap.get(index);
            return;
        }
        if (index != 0L && reader.isValidIndex(index)) {
            long originalIndex = reader.getPointerIndex();
            reader.setPointerIndex(index);
            this.superclass = new Objc2Class(this.program, this.state, reader);
            reader.setPointerIndex(originalIndex);
        }
    }

    private void readISA(BinaryReader reader) {
        long index = 0L;
        try {
            index = ObjcUtils.readNextIndex(reader, this.is32bit);
        }
        catch (IOException ioe) {
            return;
        }
        if (this.state.classIndexMap.containsKey(index)) {
            this.isa = this.state.classIndexMap.get(index);
            return;
        }
        if (index != 0L && reader.isValidIndex(index)) {
            long originalIndex = reader.getPointerIndex();
            reader.setPointerIndex(index);
            this.isa = new Objc2Class(this.program, this.state, reader);
            reader.setPointerIndex(originalIndex);
        }
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add((DataType)new PointerDataType((DataType)struct), this.pointerSize, "isa", null);
        struct.add((DataType)new PointerDataType((DataType)struct), this.pointerSize, "superclass", null);
        struct.add(this.cache.toDataType(), "cache", null);
        struct.add(this.vtable.toDataType(), "vtable", null);
        if (this.data == null) {
            Objc2ClassRW fakeData = new Objc2ClassRW(this.program, this.state);
            struct.add((DataType)new PointerDataType(fakeData.toDataType()), this.pointerSize, "data", null);
        } else {
            struct.add((DataType)new PointerDataType(this.data.toDataType()), this.pointerSize, "data", null);
        }
        struct.setCategoryPath(Objc2Constants.CATEGORY_PATH);
        return struct;
    }

    @Override
    public void applyTo(Namespace namespace, TaskMonitor monitor) throws Exception {
        if (this.state.beenApplied.contains(this.base)) {
            return;
        }
        this.state.beenApplied.add(this.base);
        Address address = ObjcUtils.toAddress(this.program, this.getIndex());
        try {
            ObjcUtils.createData(this.program, this.toDataType(), address);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Namespace classNamespace = ObjcUtils.createNamespace(this.program, "objc", NAME);
            ObjcUtils.createSymbol(this.program, classNamespace, this.data.getName(), address);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.isa != null) {
            this.isa.applyTo(namespace, monitor);
        }
        if (this.superclass != null) {
            this.superclass.applyTo(namespace, monitor);
        }
        if (this.cache != null) {
            this.cache.applyTo(namespace, monitor);
        }
        if (this.vtable != null) {
            this.vtable.applyTo(namespace, monitor);
        }
        if (this.data != null) {
            this.data.applyTo(namespace, monitor);
        }
    }
}

