/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objc.objc1;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.bin.format.objc.AbstractObjcTypeMetadata;
import ghidra.app.util.bin.format.objc.ObjcState;
import ghidra.app.util.bin.format.objc.ObjcUtils;
import ghidra.app.util.bin.format.objc.objc1.Objc1Constants;
import ghidra.app.util.bin.format.objc.objc1.Objc1Module;
import ghidra.app.util.bin.format.objc.objc1.Objc1Protocol;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Objc1TypeMetadata
extends AbstractObjcTypeMetadata {
    private List<Objc1Module> modules = new ArrayList<Objc1Module>();
    private List<Objc1Protocol> protocols = new ArrayList<Objc1Protocol>();

    public Objc1TypeMetadata(Program program, TaskMonitor monitor, MessageLog log) throws IOException, CancelledException {
        super(new ObjcState(program, Objc1Constants.CATEGORY_PATH), program, monitor, log);
        this.parse();
    }

    public List<Objc1Module> getModules() {
        return this.modules;
    }

    public List<Objc1Protocol> getProtocols() {
        return this.protocols;
    }

    private void parse() throws IOException, CancelledException {
        try (MemoryByteProvider provider = MemoryByteProvider.createDefaultAddressSpaceByteProvider(this.program, false);){
            BinaryReader reader = new BinaryReader(provider, !this.program.getLanguage().isBigEndian());
            this.parseModules("__module_info", reader);
            this.parseProtocols("__protocol", reader);
        }
    }

    private void parseModules(String section, BinaryReader reader) throws CancelledException {
        this.monitor.setMessage("Parsing Objective-C modules...");
        this.monitor.setIndeterminate(true);
        try {
            for (MemoryBlock block : ObjcUtils.getObjcBlocks(section, this.program)) {
                long start = block.getStart().getOffset();
                long end = block.getEnd().getOffset();
                reader.setPointerIndex(start);
                while (reader.getPointerIndex() < end) {
                    this.monitor.checkCancelled();
                    this.modules.add(new Objc1Module(this.program, this.state, reader));
                }
            }
        }
        catch (IOException e) {
            this.log("Failed to parse modules from section '" + section + "'");
        }
    }

    private void parseProtocols(String section, BinaryReader reader) throws CancelledException {
        this.monitor.setMessage("Parsing Objective-C protocols...");
        this.monitor.setIndeterminate(true);
        try {
            for (MemoryBlock block : ObjcUtils.getObjcBlocks(section, this.program)) {
                long start = block.getStart().getOffset();
                long end = block.getEnd().getOffset();
                reader.setPointerIndex(start);
                while (reader.getPointerIndex() < end) {
                    this.monitor.checkCancelled();
                    this.protocols.add(new Objc1Protocol(this.program, this.state, reader));
                }
            }
        }
        catch (IOException e) {
            this.log("Failed to parse protocols from section '" + section + "'");
        }
    }

    @Override
    public void applyTo() {
        for (Objc1Module module : this.modules) {
            try {
                module.applyTo(this.program.getGlobalNamespace(), this.monitor);
            }
            catch (Exception e) {
                this.log("Failed to markup module: " + module.getName());
            }
        }
        for (Objc1Protocol protocol : this.protocols) {
            try {
                protocol.applyTo(this.program.getGlobalNamespace(), this.monitor);
            }
            catch (Exception e) {
                this.log("Failed to markup protocol: " + protocol.getName());
            }
        }
        ObjcUtils.createMethods(this.program, this.state, this.log, this.monitor);
        ObjcUtils.fixupReferences(Objc1Constants.getObjectiveCSectionNames(), this.program, this.monitor);
        ObjcUtils.setBlocksReadOnly(this.program.getMemory(), List.of("__data", "__cls_refs", "__message_refs"));
    }
}

