/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objc;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.objc.ObjcMethod;
import ghidra.app.util.bin.format.objc.ObjcState;
import ghidra.app.util.bin.format.objc.ObjcTypeMetadataStructure;
import ghidra.app.util.bin.format.objc.ObjcUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.util.Msg;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.List;

public abstract class ObjcMethodList
extends ObjcTypeMetadataStructure {
    private String _className;
    protected List<ObjcMethod> methods = new ArrayList<ObjcMethod>();

    protected ObjcMethodList(Program program, ObjcState state, BinaryReader reader, String className) {
        super(program, state, reader.getPointerIndex());
        this._className = className;
    }

    public List<ObjcMethod> getMethods() {
        return this.methods;
    }

    @Override
    public void applyTo(Namespace namespace, TaskMonitor monitor) throws Exception {
        if (this.base == 0L) {
            return;
        }
        if (this.state.beenApplied.contains(this.base)) {
            return;
        }
        this.state.beenApplied.add(this.base);
        Address address = ObjcUtils.toAddress(this.program, this.base);
        DataType dt = this.toDataType();
        try {
            ObjcUtils.createData(this.program, dt, address);
        }
        catch (Exception e) {
            Msg.warn((Object)this, (Object)("Could not create " + dt.getName() + " @" + String.valueOf(address)));
        }
        try {
            Namespace methodListNamespace = ObjcUtils.createNamespace(this.program, "objc", this._className);
            ObjcUtils.createSymbol(this.program, methodListNamespace, namespace.getName(), address);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (ObjcMethod method : this.getMethods()) {
            method.applyTo(namespace, monitor);
        }
    }
}

