/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.rtti;

import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.plugin.core.analysis.TransientProgramProperties;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.golang.BootstrapInfoException;
import ghidra.app.util.bin.format.golang.GoBuildInfo;
import ghidra.app.util.bin.format.golang.GoConstants;
import ghidra.app.util.bin.format.golang.GoParamStorageAllocator;
import ghidra.app.util.bin.format.golang.GoRegisterInfo;
import ghidra.app.util.bin.format.golang.GoRegisterInfoManager;
import ghidra.app.util.bin.format.golang.GoVer;
import ghidra.app.util.bin.format.golang.GoVerRange;
import ghidra.app.util.bin.format.golang.GoVerSet;
import ghidra.app.util.bin.format.golang.rtti.GoApiSnapshot;
import ghidra.app.util.bin.format.golang.rtti.GoFuncData;
import ghidra.app.util.bin.format.golang.rtti.GoFunctabEntry;
import ghidra.app.util.bin.format.golang.rtti.GoIface;
import ghidra.app.util.bin.format.golang.rtti.GoItab;
import ghidra.app.util.bin.format.golang.rtti.GoModuledata;
import ghidra.app.util.bin.format.golang.rtti.GoName;
import ghidra.app.util.bin.format.golang.rtti.GoPcHeader;
import ghidra.app.util.bin.format.golang.rtti.GoSlice;
import ghidra.app.util.bin.format.golang.rtti.GoString;
import ghidra.app.util.bin.format.golang.rtti.GoSymbolName;
import ghidra.app.util.bin.format.golang.rtti.GoSymbolNameType;
import ghidra.app.util.bin.format.golang.rtti.GoTypeManager;
import ghidra.app.util.bin.format.golang.rtti.GoVarlenString;
import ghidra.app.util.bin.format.golang.rtti.MethodInfo;
import ghidra.app.util.bin.format.golang.rtti.types.GoArrayType;
import ghidra.app.util.bin.format.golang.rtti.types.GoBaseType;
import ghidra.app.util.bin.format.golang.rtti.types.GoChanType;
import ghidra.app.util.bin.format.golang.rtti.types.GoFuncType;
import ghidra.app.util.bin.format.golang.rtti.types.GoIMethod;
import ghidra.app.util.bin.format.golang.rtti.types.GoInterfaceType;
import ghidra.app.util.bin.format.golang.rtti.types.GoMapType;
import ghidra.app.util.bin.format.golang.rtti.types.GoMethod;
import ghidra.app.util.bin.format.golang.rtti.types.GoPlainType;
import ghidra.app.util.bin.format.golang.rtti.types.GoPointerType;
import ghidra.app.util.bin.format.golang.rtti.types.GoSliceType;
import ghidra.app.util.bin.format.golang.rtti.types.GoStructField;
import ghidra.app.util.bin.format.golang.rtti.types.GoStructType;
import ghidra.app.util.bin.format.golang.rtti.types.GoType;
import ghidra.app.util.bin.format.golang.rtti.types.GoTypeDetector;
import ghidra.app.util.bin.format.golang.rtti.types.GoUncommonType;
import ghidra.app.util.bin.format.golang.structmapping.DataTypeMapper;
import ghidra.app.util.bin.format.golang.structmapping.DataTypeMapperContext;
import ghidra.app.util.bin.format.golang.structmapping.MarkupSession;
import ghidra.app.util.bin.format.golang.structmapping.StructureContext;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.BooleanDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.FunctionDefinitionDataType;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.ParameterDefinitionImpl;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.Structure;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.UnknownProgressWrappingTaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;

public class GoRttiMapper
extends DataTypeMapper
implements DataTypeMapperContext {
    public static final GoVerRange SUPPORTED_VERSIONS = GoVerRange.parse("1.15-1.25");
    private static final List<String> SYMBOL_SEARCH_PREFIXES = List.of("", "_");
    private static final List<String> SECTION_PREFIXES = List.of(".", "__");
    private static final String FAILED_FLAG = "FAILED TO FIND GOLANG BINARY";
    public static final String ARTIFICIAL_RUNTIME_ZEROBASE_SYMBOLNAME = "ARTIFICIAL.runtime.zerobase";
    private static final CategoryPath GOLANG_CP = GoConstants.GOLANG_CATEGORYPATH;
    private static final CategoryPath VARLEN_STRUCTS_CP = GoConstants.GOLANG_CATEGORYPATH;
    private static final List<Class<?>> GOLANG_STRUCTMAPPED_CLASSES = List.of(GoModuledata.class, GoName.class, GoVarlenString.class, GoSlice.class, GoBaseType.class, GoTypeDetector.class, GoPlainType.class, GoUncommonType.class, GoArrayType.class, GoChanType.class, GoFuncType.class, GoInterfaceType.class, GoMapType.class, GoPointerType.class, GoSliceType.class, GoIface.class, GoStructType.class, GoMethod.class, GoStructField.class, GoIMethod.class, GoFunctabEntry.class, GoFuncData.class, GoItab.class, GoString.class, GoPcHeader.class);
    private final BinaryReader reader;
    private final GoBuildInfo buildInfo;
    private final GoVer goVer;
    private final int ptrSize;
    private final GoRegisterInfo regInfo;
    private final String defaultCCName;
    private final List<GoModuledata> modules = new ArrayList<GoModuledata>();
    private Map<Address, GoFuncData> funcdataByAddr = new HashMap<Address, GoFuncData>();
    private Map<String, GoFuncData> funcdataByName = new HashMap<String, GoFuncData>();
    private Map<Address, List<MethodInfo>> methodsByAddr = new HashMap<Address, List<MethodInfo>>();
    private byte minLC;
    private final GoApiSnapshot apiSnapshot;
    private final GoTypeManager goTypes;

    public static GoRttiMapper getSharedGoBinary(Program program, TaskMonitor monitor) {
        if (TransientProgramProperties.hasProperty(program, FAILED_FLAG)) {
            return null;
        }
        GoRttiMapper goBinary = TransientProgramProperties.getProperty(program, GoRttiMapper.class, TransientProgramProperties.SCOPE.ANALYSIS_SESSION, GoRttiMapper.class, () -> {
            Msg.info(GoRttiMapper.class, (Object)("Reading Go binary info: " + program.getName()));
            try {
                GoRttiMapper supplier_result = GoRttiMapper.getGoBinary(program, monitor);
                if (supplier_result != null) {
                    supplier_result.init(monitor);
                    return supplier_result;
                }
            }
            catch (BootstrapInfoException mbie) {
                Msg.warn(GoRttiMapper.class, (Object)mbie.getMessage());
                GoRttiMapper.logAnalyzerMsg(program, mbie.getMessage());
            }
            catch (IOException e) {
                Msg.error(GoRttiMapper.class, (Object)"Failed to read Go info", (Throwable)e);
                GoRttiMapper.logAnalyzerMsg(program, e.getMessage());
            }
            TransientProgramProperties.getProperty(program, FAILED_FLAG, TransientProgramProperties.SCOPE.PROGRAM, Boolean.class, () -> true);
            return null;
        });
        return goBinary;
    }

    private static void logAnalyzerMsg(Program program, String msg) {
        AutoAnalysisManager aam = AutoAnalysisManager.getAnalysisManager(program);
        if (aam.isAnalyzing()) {
            MessageLog log = aam.getMessageLog();
            log.appendMsg(msg);
        }
    }

    public static GoRttiMapper getGoBinary(Program program, TaskMonitor monitor) throws BootstrapInfoException, IOException {
        GoApiSnapshot apiSnapshot;
        GoBuildInfo buildInfo = GoBuildInfo.fromProgram(program);
        if (buildInfo == null) {
            return null;
        }
        GoVer goVer = buildInfo.getGoVer();
        if (goVer.isInvalid()) {
            throw new BootstrapInfoException("Invalid Go version string [%s]".formatted(buildInfo.getVersion()));
        }
        if (!SUPPORTED_VERSIONS.contains(goVer)) {
            Msg.error(GoRttiMapper.class, (Object)"Untested Go version [%s]".formatted(goVer));
        }
        try {
            apiSnapshot = GoApiSnapshot.get(goVer, buildInfo.getGOARCH(program), buildInfo.getGOOS(program), monitor);
            if (!apiSnapshot.getVer().isInvalid()) {
                Msg.info(GoRttiMapper.class, (Object)"Using Go API snapshot for version %s".formatted(apiSnapshot.getVer()));
            }
        }
        catch (CancelledException e) {
            throw new IOException("Error fetching Go API snapshot file: cancelled");
        }
        return new GoRttiMapper(program, buildInfo, buildInfo.getPointerSize(), goVer, apiSnapshot);
    }

    public static boolean isGolangProgram(Program program) {
        return "golang".equals(program.getCompilerSpec().getCompilerSpecDescription().getCompilerSpecName());
    }

    public static boolean hasGolangSections(List<String> sectionNames) {
        for (String sectionName : sectionNames) {
            if (!sectionName.contains("gopclntab") && !sectionName.contains("go_buildinfo") && !sectionName.contains("go.buildinfo")) continue;
            return true;
        }
        return false;
    }

    public static Symbol getGoSymbol(Program program, String symbolName) {
        for (String prefix : SYMBOL_SEARCH_PREFIXES) {
            List symbols = program.getSymbolTable().getSymbols(prefix + symbolName, null);
            if (symbols.size() != 1) continue;
            return (Symbol)symbols.get(0);
        }
        return null;
    }

    public static MemoryBlock getGoSection(Program program, String sectionName) {
        for (String prefix : SECTION_PREFIXES) {
            MemoryBlock memBlock = program.getMemory().getBlock(prefix + sectionName);
            if (memBlock == null) continue;
            return memBlock;
        }
        return null;
    }

    public static MemoryBlock getFirstGoSection(Program program, String ... blockNames) {
        for (String blockToSearch : blockNames) {
            MemoryBlock memBlock = GoRttiMapper.getGoSection(program, blockToSearch);
            if (memBlock == null) continue;
            return memBlock;
        }
        return null;
    }

    public static Address getZerobaseAddress(Program prog) {
        Address zerobaseAddr;
        Symbol zerobaseSym = GoRttiMapper.getGoSymbol(prog, "runtime.zerobase");
        Address address = zerobaseAddr = zerobaseSym != null ? zerobaseSym.getAddress() : GoRttiMapper.getArtificalZerobaseAddress(prog);
        if (zerobaseAddr == null) {
            zerobaseAddr = prog.getImageBase().getAddressSpace().getMinAddress();
            Msg.warn(GoRttiMapper.class, (Object)("Unable to find Go runtime.zerobase, using " + String.valueOf(zerobaseAddr)));
        }
        return zerobaseAddr;
    }

    public static List<GoVer> getAllSupportedVersions() {
        try {
            return SUPPORTED_VERSIONS.asList();
        }
        catch (IOException e) {
            return List.of();
        }
    }

    private static Address getArtificalZerobaseAddress(Program program) {
        Symbol zerobaseSym = GoRttiMapper.getGoSymbol(program, ARTIFICIAL_RUNTIME_ZEROBASE_SYMBOLNAME);
        return zerobaseSym != null ? zerobaseSym.getAddress() : null;
    }

    public GoRttiMapper(Program program, GoBuildInfo buildInfo, int ptrSize, GoVer goVer, GoApiSnapshot apiSnapshot) throws IOException, BootstrapInfoException {
        super(program, null);
        this.regInfo = GoRegisterInfoManager.getInstance().getRegisterInfoForLang(program.getLanguage(), goVer);
        this.apiSnapshot = apiSnapshot;
        this.buildInfo = buildInfo;
        this.goVer = goVer;
        this.ptrSize = ptrSize;
        this.defaultCCName = this.regInfo.hasAbiInternalParamRegisters() && this.hasCallingConvention("abi-internal") ? "abi-internal" : null;
        this.reader = super.createProgramReader();
        this.goTypes = new GoTypeManager(this, apiSnapshot);
        this.initStructMappings();
    }

    private void initStructMappings() throws IOException {
        try {
            this.registerStructures(GOLANG_STRUCTMAPPED_CLASSES, this);
        }
        catch (IOException e) {
            if (this.apiSnapshot.isInvalid()) {
                throw new BootstrapInfoException("Missing Go bootstrap type info, unable to extract Go RTTI info.".formatted(this.goVer));
            }
            throw new IOException("Invalid Go bootstrap struct mapping info: %s".formatted(this.goVer), e);
        }
    }

    @Override
    public void close() {
        Set<String> missingGoTypes = this.goTypes.getMissingGoTypes();
        if (!missingGoTypes.isEmpty()) {
            Msg.info((Object)this, (Object)("Go missing type names: " + missingGoTypes.size()));
        }
        super.close();
    }

    @Override
    public <T extends DataType> T getType(String name, Class<T> clazz) {
        try {
            DataType result = this.goTypes.findDataType(name);
            if (result == null && "runtime.pcHeader".equals(name) && Structure.class.isAssignableFrom(clazz)) {
                result = (DataType)clazz.cast(GoPcHeader.createArtificialGoPcHeaderStructure(GOLANG_CP, (DataTypeManager)this.program.getDataTypeManager()));
            }
            return (T)(clazz.isInstance(result) ? (DataType)clazz.cast(result) : null);
        }
        catch (IOException e) {
            Msg.warn((Object)this, (Object)"Unable to find Go type %s".formatted(name), (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean isFieldPresent(String presentWhen) {
        if ((presentWhen = presentWhen.strip()).isEmpty()) {
            return true;
        }
        try {
            GoVerSet versions = GoVerSet.parse(presentWhen);
            if (!versions.isEmpty()) {
                return versions.contains(this.goVer);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        throw new IllegalArgumentException("Invalid 'presentWhen' value [%s]".formatted(presentWhen));
    }

    public GoVer getGoVer() {
        return this.goVer;
    }

    public GoRegisterInfo getRegInfo() {
        return this.regInfo;
    }

    public GoBuildInfo getBuildInfo() {
        return this.buildInfo;
    }

    public void init(TaskMonitor monitor) throws IOException {
        GoModuledata firstModule = this.findFirstModuledata(monitor);
        if (firstModule != null) {
            GoPcHeader pcHeader = firstModule.getPcHeader();
            if (pcHeader != null) {
                this.minLC = pcHeader.getMinLC();
                if (pcHeader.getPtrSize() != this.ptrSize) {
                    throw new IOException("Mismatched ptrSize: %d vs %d".formatted(pcHeader.getPtrSize(), this.ptrSize));
                }
                if (pcHeader.getGoVersion().isInvalid()) {
                    Msg.warn((Object)this, (Object)"Unknown Go pcheader magic value: 0x%x".formatted(pcHeader.getMagic()));
                }
            }
            this.modules.add(firstModule);
        }
        this.initFuncdata();
        this.goTypes.init(monitor);
        this.initMethodInfo();
    }

    private void initFuncdata() throws IOException {
        for (GoModuledata module : this.modules) {
            for (GoFuncData funcdata : module.getAllFunctionData()) {
                this.funcdataByAddr.put(funcdata.getFuncAddress(), funcdata);
                this.funcdataByName.put(funcdata.getName(), funcdata);
            }
        }
    }

    private void initMethodInfo() throws IOException {
        for (GoType goType : this.goTypes.allTypes()) {
            goType.getMethodInfoList().forEach(this::addMethodInfo);
        }
        for (GoModuledata module : this.modules) {
            for (GoItab itab : module.getItabs()) {
                itab.getMethodInfoList().forEach(this::addMethodInfo);
            }
        }
    }

    private void addMethodInfo(MethodInfo bm) {
        List methods = this.methodsByAddr.computeIfAbsent(bm.getAddress(), unused -> new ArrayList());
        methods.add(bm);
    }

    public GoTypeManager getGoTypes() {
        return this.goTypes;
    }

    public byte getMinLC() throws IOException {
        if (this.minLC == 0) {
            throw new IOException("Unknown Go minLC value");
        }
        return this.minLC;
    }

    public GoModuledata getFirstModule() {
        return !this.modules.isEmpty() ? this.modules.get(0) : null;
    }

    public List<GoModuledata> getModules() {
        return this.modules;
    }

    public GoParamStorageAllocator newStorageAllocator() {
        GoParamStorageAllocator storageAllocator = new GoParamStorageAllocator(this.program, this.goVer);
        return storageAllocator;
    }

    public boolean isGolangAbi0Func(Function func) {
        return GoRttiMapper.isAbi0Func(func.getEntryPoint(), this.program);
    }

    public static boolean isAbi0Func(Address funcEntry, Program program) {
        for (Symbol symbol : program.getSymbolTable().getSymbolsAsIterator(funcEntry)) {
            String labelName;
            if (symbol.getSymbolType() != SymbolType.LABEL || !(labelName = symbol.getName()).endsWith("abi0")) continue;
            return true;
        }
        return false;
    }

    public boolean hasCallingConvention(String ccName) {
        return this.program.getFunctionManager().getCallingConvention(ccName) != null;
    }

    public String getDefaultCallingConventionName() {
        return this.defaultCCName;
    }

    @Override
    public MarkupSession createMarkupSession(TaskMonitor monitor) {
        UnknownProgressWrappingTaskMonitor upwtm = new UnknownProgressWrappingTaskMonitor(monitor);
        upwtm.initialize(1L, "Marking up Go RTTI structures");
        return super.createMarkupSession((TaskMonitor)upwtm);
    }

    public GoModuledata findContainingModule(long offset) {
        for (GoModuledata module : this.modules) {
            if (module.getTypesOffset() > offset || offset >= module.getTypesEndOffset()) continue;
            return module;
        }
        return null;
    }

    public GoModuledata findContainingModuleByFuncData(long offset) {
        for (GoModuledata module : this.modules) {
            if (!module.containsFuncDataInstance(offset)) continue;
            return module;
        }
        return null;
    }

    @Override
    public CategoryPath getDefaultVariableLengthStructCategoryPath() {
        return VARLEN_STRUCTS_CP;
    }

    @Override
    protected BinaryReader createProgramReader() {
        return this.reader.clone();
    }

    public int getPtrSize() {
        return this.ptrSize;
    }

    public FuncDefResult getFuncDefFor(GoFuncData funcData) throws IOException {
        GoSymbolName nonptrRecvName;
        GoType recvType;
        Object symbolName = funcData.getSymbolName();
        GoMethod.GoMethodInfo methodInfo = this.getMethodInfoForFunction(funcData.getFuncAddress());
        if (methodInfo != null) {
            if (((GoSymbolName)symbolName).isNonPtrReceiverCandidate()) {
                recvType = methodInfo.getType();
                Object nonptrRecvName2 = ((GoSymbolName)symbolName).asNonPtrReceiverSymbolName();
                if (nonptrRecvName2 != null && recvType.getSymbolName().getBaseTypeName().equals(((GoSymbolName)nonptrRecvName2).getReceiverString())) {
                    symbolName = nonptrRecvName2;
                }
            }
            if (methodInfo.getMethodFuncType() != null) {
                return this.createFuncDefFromMethod((GoSymbolName)symbolName, methodInfo);
            }
        }
        if (((GoSymbolName)symbolName).getPrefix() != null) {
            String prefix = Objects.requireNonNullElse(((GoSymbolName)symbolName).getTypePrefixSubKeyword(), "");
            switch (prefix) {
                case "eq": {
                    return this.createFuncDefForDotEquals((GoSymbolName)symbolName);
                }
                case "hash": {
                    return this.createFuncDefForDotHash((GoSymbolName)symbolName);
                }
            }
            return null;
        }
        if (((GoSymbolName)symbolName).asString().equals("runtime.morestack")) {
            return this.createFuncDefForClosure((GoSymbolName)symbolName);
        }
        if (((GoSymbolName)symbolName).isNonPtrReceiverCandidate() && (nonptrRecvName = ((GoSymbolName)symbolName).asNonPtrReceiverSymbolName()) != null && this.goTypes.findRecieverType(nonptrRecvName) != null) {
            symbolName = nonptrRecvName;
        }
        recvType = methodInfo != null ? methodInfo.getType() : null;
        GoSymbolNameType nameType = ((GoSymbolName)symbolName).getNameType();
        if (nameType == GoSymbolNameType.METHOD_WRAPPER) {
            return this.createFuncDefForMethodWrapper((GoSymbolName)symbolName);
        }
        if (nameType != null && nameType.isClosure()) {
            return this.createFuncDefForClosure((GoSymbolName)symbolName);
        }
        GoApiSnapshot.GoFuncDef snapshotFuncdef = this.apiSnapshot.getFuncdef(((GoSymbolName)symbolName).getStrippedSymbolString());
        if (snapshotFuncdef != null) {
            return this.createFuncDefFromApiSnapshot((GoSymbolName)symbolName, recvType, snapshotFuncdef);
        }
        return this.createFuncDefWithMissingInfo((GoSymbolName)symbolName, recvType);
    }

    private FuncDefResult createFuncDefForDotEquals(GoSymbolName symbolName) throws IOException {
        GoSymbolName typeName = GoSymbolName.parseTypeName(symbolName.getBaseName(), null);
        if (typeName.asString().startsWith("[...]")) {
            typeName = GoSymbolName.parseTypeName(typeName.asString().substring(5));
        }
        DataType typ = null;
        try {
            typ = this.goTypes.findDataType(typeName);
            if (typ != null && typ instanceof Array) {
                Array adt = (Array)typ;
                typ = adt.getDataType();
            }
        }
        catch (IOException adt) {
            // empty catch block
        }
        Pointer dt = this.programDTM.getPointer(typ);
        BooleanDataType returnDT = BooleanDataType.dataType;
        List<ParameterDefinitionImpl> params = List.of(new ParameterDefinitionImpl("o1", (DataType)dt, null), new ParameterDefinitionImpl("o2", (DataType)dt, null));
        Set<FuncDefFlags> flags = typ != null ? Set.of(FuncDefFlags.FROM_ANALYSIS) : Set.of(FuncDefFlags.FROM_ANALYSIS, FuncDefFlags.PARAM_SUBSTITUTION);
        FunctionDefinitionDataType funcDef = this.goTypes.createFuncDef(params, (DataType)returnDT, symbolName, false);
        return new FuncDefResult((FunctionDefinition)funcDef, null, flags, "func(*o1, *o2) bool", symbolName);
    }

    private FuncDefResult createFuncDefForDotHash(GoSymbolName symbolName) throws IOException {
        GoSymbolName typeName = GoSymbolName.parseTypeName(symbolName.getBaseName(), null);
        DataType typ = this.goTypes.findDataType(typeName);
        Pointer dt = this.programDTM.getPointer(typ);
        DataType returnDT = this.goTypes.getDataType("uintptr");
        List<ParameterDefinitionImpl> params = List.of(new ParameterDefinitionImpl(null, (DataType)dt, null), new ParameterDefinitionImpl("seed", this.goTypes.getDataType("uintptr"), null));
        Set<FuncDefFlags> flags = typ != null ? Set.of(FuncDefFlags.FROM_ANALYSIS) : Set.of(FuncDefFlags.FROM_ANALYSIS, FuncDefFlags.PARAM_SUBSTITUTION);
        FunctionDefinitionDataType funcDef = this.goTypes.createFuncDef(params, returnDT, symbolName, false);
        return new FuncDefResult((FunctionDefinition)funcDef, null, flags, "func(val*, seed) uintptr", symbolName);
    }

    private FuncDefResult createFuncDefForMethodWrapper(GoSymbolName symbolName) throws IOException {
        Structure closureDT;
        FunctionDefinition closureFuncdef;
        String s = symbolName.asString();
        String baseMethodName = s.substring(0, s.length() - "-fm".length());
        GoFuncData methodFunc = this.getFunctionByName(baseMethodName);
        if (methodFunc != null) {
            GoSymbolName recvTypeName = symbolName.getReceiverTypeName();
            DataType closureDT2 = this.goTypes.getMethodClosureType(recvTypeName.asString());
            FuncDefResult funcDefResult = this.getFuncDefFor(methodFunc);
            if (closureDT2 != null && funcDefResult != null) {
                FunctionDefinition funcDef = funcDefResult.funcDef();
                ParameterDefinition[] args = funcDef.getArguments();
                ParameterDefinition recvArg = args[0];
                recvArg.setName(".context");
                recvArg.setDataType((DataType)this.programDTM.getPointer(closureDT2));
                funcDef.setArguments(args);
                EnumSet<FuncDefFlags> newFlags = EnumSet.copyOf(funcDefResult.flags());
                newFlags.add(FuncDefFlags.METHOD_WRAPPER);
                return new FuncDefResult(funcDef, funcDefResult.recvType, newFlags, funcDefResult.funcDefStr, funcDefResult.symbolName);
            }
        }
        if ((closureFuncdef = this.getFuncDefFromContextStruct(closureDT = this.goTypes.getDefaultMethodWrapperClosureType())) != null) {
            return new FuncDefResult(closureFuncdef, null, EnumSet.of(FuncDefFlags.METHOD_WRAPPER, FuncDefFlags.PARAMS_MISSING, FuncDefFlags.RETURN_INFO_MISSING), "func-fm(.context, ???) ???", symbolName);
        }
        return null;
    }

    private FunctionDefinition getFuncDefFromContextStruct(Structure struct) {
        FunctionDefinition funcdef;
        Pointer ptr;
        DataType dataType;
        DataType ptrF = struct.getNumDefinedComponents() > 0 ? struct.getComponent(0).getDataType() : null;
        return ptrF instanceof Pointer && (dataType = (ptr = (Pointer)ptrF).getDataType()) instanceof FunctionDefinition ? (funcdef = (FunctionDefinition)dataType) : null;
    }

    private FuncDefResult createFuncDefForClosure(GoSymbolName symbolName) throws IOException {
        List<ParameterDefinitionImpl> closureParams = List.of(new ParameterDefinitionImpl(".context", (DataType)this.programDTM.getPointer(this.goTypes.getDefaultClosureType()), null));
        EnumSet<FuncDefFlags> flags = EnumSet.of(FuncDefFlags.PARAMS_MISSING, FuncDefFlags.RETURN_INFO_MISSING, FuncDefFlags.CLOSURE);
        FunctionDefinitionDataType funcDef = this.goTypes.createFuncDef(closureParams, (DataType)null, symbolName, false);
        return new FuncDefResult((FunctionDefinition)funcDef, null, flags, "func(.context, ???) ???", symbolName);
    }

    private FuncDefResult createFuncDefFromMethod(GoSymbolName symbolName, GoMethod.GoMethodInfo methodInfo) throws IOException {
        EnumSet<FuncDefFlags> flags = EnumSet.of(FuncDefFlags.FROM_RTTI_METHOD);
        GoType recvType = methodInfo.getType();
        GoFuncType methodFuncDefType = methodInfo.getMethodFuncType();
        FunctionDefinition funcdef = methodFuncDefType.getFunctionSignature(this.goTypes);
        FunctionDefinitionDataType funcDT = this.goTypes.createFuncDef(List.of(funcdef.getArguments()), funcdef.getReturnType(), symbolName, false);
        this.insertArg((FunctionDefinition)funcDT, 0, "self", this.goTypes.getDataType(recvType));
        if (symbolName.hasGenerics()) {
            this.insertArg((FunctionDefinition)funcDT, 1, "generics_dict", this.goTypes.getGenericDictDT());
        }
        return new FuncDefResult((FunctionDefinition)funcDT, recvType, flags, methodInfo.toString(), symbolName);
    }

    private FuncDefResult createFuncDefWithMissingInfo(GoSymbolName symbolName, GoType recvType) throws IOException {
        String funcdefStr = "";
        EnumSet<FuncDefFlags> flags = EnumSet.of(FuncDefFlags.PARAMS_MISSING, FuncDefFlags.RETURN_INFO_MISSING);
        ArrayList<ParameterDefinition> params = new ArrayList<ParameterDefinition>();
        if (symbolName.hasReceiver()) {
            DataType recvDT = this.goTypes.getDataType(recvType);
            if (recvDT == null) {
                recvDT = this.goTypes.findRecieverType(symbolName);
            }
            if (recvType == null) {
                recvType = this.goTypes.getSubstitutionType(symbolName.getReceiverString());
                flags.add(FuncDefFlags.RECV_ARTIFICIAL);
            }
            if (recvType == null) {
                return null;
            }
            funcdefStr = recvType.getMethodPrototypeString(symbolName.getBaseName(), null);
            params.add((ParameterDefinition)new ParameterDefinitionImpl("self", this.goTypes.getDataType(recvType), null));
        }
        if (symbolName.hasGenerics()) {
            params.add((ParameterDefinition)new ParameterDefinitionImpl("generics_dict", this.goTypes.getGenericDictDT(), null));
        }
        if (!params.isEmpty()) {
            FunctionDefinitionDataType funcDef = this.goTypes.createFuncDef(params, (DataType)null, symbolName, false);
            return new FuncDefResult((FunctionDefinition)funcDef, recvType, flags, funcdefStr, symbolName);
        }
        return null;
    }

    private FuncDefResult createFuncDefFromApiSnapshot(GoSymbolName symbolName, GoType recvType, GoApiSnapshot.GoFuncDef snapshotFuncdef) throws IOException {
        DataType pDT;
        EnumSet<FuncDefFlags> flags = EnumSet.of(FuncDefFlags.FROM_SNAPSHOT);
        ArrayList<ParameterDefinition> params = new ArrayList<ParameterDefinition>();
        ArrayList<ParameterDefinition> returnParams = new ArrayList<ParameterDefinition>();
        for (int i = 0; i < snapshotFuncdef.Params.size(); ++i) {
            GoApiSnapshot.GoNameTypePair p = snapshotFuncdef.Params.get(i);
            pDT = this.goTypes.findDataType(p.DataType);
            if (pDT == null) break;
            if (!this.goTypes.hasGoType(p.DataType)) {
                flags.add(i == 0 && symbolName.hasReceiver() ? FuncDefFlags.RECV_ARTIFICIAL : FuncDefFlags.PARAM_SUBSTITUTION);
            }
            String paramName = (p.Name == null || p.Name.isEmpty()) && i == 0 ? "self" : p.Name;
            params.add((ParameterDefinition)new ParameterDefinitionImpl(paramName, pDT, null));
        }
        for (GoApiSnapshot.GoNameTypePair p : snapshotFuncdef.Results) {
            pDT = this.goTypes.findDataType(p.DataType);
            if (pDT == null) break;
            if (!this.goTypes.hasGoType(p.DataType)) {
                flags.add(FuncDefFlags.RESULT_SUBSTITUTION);
            }
            returnParams.add((ParameterDefinition)new ParameterDefinitionImpl(p.Name, pDT, null));
        }
        if (params.size() < snapshotFuncdef.Params.size()) {
            flags.add(params.isEmpty() ? FuncDefFlags.PARAMS_MISSING : FuncDefFlags.PARAMS_PARTIAL);
        }
        if (returnParams.size() < snapshotFuncdef.Results.size()) {
            if (returnParams.isEmpty()) {
                returnParams = null;
            }
            flags.add(returnParams == null ? FuncDefFlags.RETURN_INFO_MISSING : FuncDefFlags.RETURN_INFO_PARTIAL);
        }
        if (symbolName.hasGenerics()) {
            int generics_index;
            int n = generics_index = symbolName.hasReceiver() && params.size() > 0 ? 1 : 0;
            if (params.size() >= generics_index) {
                params.add(generics_index, (ParameterDefinition)new ParameterDefinitionImpl("generics_dict", this.goTypes.getGenericDictDT(), null));
            }
        }
        FunctionDefinitionDataType funcDef = this.goTypes.createFuncDef(params, returnParams, symbolName, snapshotFuncdef.getFuncFlags().contains((Object)GoApiSnapshot.FuncFlags.NoReturn));
        return new FuncDefResult((FunctionDefinition)funcDef, recvType, flags, snapshotFuncdef.getDefinitionString(symbolName), symbolName);
    }

    private void insertArg(FunctionDefinition funcDef, int index, String argName, DataType argDT) {
        ArrayList<ParameterDefinition> args = new ArrayList<ParameterDefinition>(Arrays.asList(funcDef.getArguments()));
        args.add(index, (ParameterDefinition)new ParameterDefinitionImpl(argName, argDT, null));
        funcDef.setArguments((ParameterDefinition[])args.toArray(ParameterDefinition[]::new));
    }

    public GoMethod.GoMethodInfo getMethodInfoForFunction(Address funcAddr) {
        List results = this.methodsByAddr.getOrDefault(funcAddr, List.of());
        for (MethodInfo mi : results) {
            GoMethod.GoMethodInfo gmi;
            if (!(mi instanceof GoMethod.GoMethodInfo) || !(gmi = (GoMethod.GoMethodInfo)mi).isTfn(funcAddr)) continue;
            return gmi;
        }
        return null;
    }

    public <T> GoName getSafeName(GoNameSupplier supplier, T structInstance, String defaultValue) {
        try {
            GoName result = supplier.get();
            if (result != null) {
                return result;
            }
        }
        catch (IOException e) {
            defaultValue = null;
        }
        StructureContext<T> structContext = this.getStructureContextOfInstance(structInstance);
        String fallbackName = defaultValue;
        fallbackName = fallbackName == null && structContext != null ? "%s_%x".formatted(structContext.getMappingInfo().getStructureName(), structContext.getStructureStart()) : "invalid_object";
        return GoName.createFakeInstance(fallbackName);
    }

    public Address resolveTextOff(long ptrInModule, long off) {
        if (off == -1L || off == 0xFFFFFFFFL) {
            return null;
        }
        GoModuledata module = this.findContainingModule(ptrInModule);
        return module != null ? module.getText().add(off) : null;
    }

    public GoName resolveNameOff(long ptrInModule, long off) throws IOException {
        if (off == 0L) {
            return null;
        }
        GoModuledata module = this.findContainingModule(ptrInModule);
        if (module == null) {
            throw new IOException("Unable to find containing module for structure at 0x%x".formatted(ptrInModule));
        }
        long nameStart = module.getTypesOffset() + off;
        return this.getGoName(nameStart);
    }

    public GoName getGoName(long offset) throws IOException {
        return offset != 0L ? this.readStructure(GoName.class, offset) : null;
    }

    public GoFuncData getFunctionData(Address funcAddr) {
        return this.funcdataByAddr.get(funcAddr);
    }

    public GoFuncData getFunctionByName(String funcName) {
        return this.funcdataByName.get(funcName);
    }

    public List<GoFuncData> getFunctionsByNamePattern(Pattern pattern) {
        ArrayList<GoFuncData> results = new ArrayList<GoFuncData>();
        for (Map.Entry<String, GoFuncData> entry : this.funcdataByName.entrySet()) {
            String name = entry.getKey();
            GoFuncData func = entry.getValue();
            if (!pattern.matcher(name).matches()) continue;
            results.add(func);
        }
        return results;
    }

    public List<GoFuncData> getAllFunctions() {
        return new ArrayList<GoFuncData>(this.funcdataByAddr.values());
    }

    private GoModuledata findFirstModuledata(TaskMonitor monitor) throws IOException {
        Address pcHeaderAddress;
        GoModuledata result = GoModuledata.getFirstModuledata(this);
        Address address = pcHeaderAddress = result != null ? result.getPcHeaderAddress() : GoPcHeader.getPcHeaderAddress(this.program);
        if (pcHeaderAddress == null) {
            monitor.initialize(0L, "Searching for Go pclntab");
            pcHeaderAddress = GoPcHeader.findPcHeaderAddress(this, this.getPclntabSearchRange(), monitor);
        }
        if (result == null && pcHeaderAddress != null) {
            monitor.initialize(0L, "Searching for Go firstmoduledata");
            GoPcHeader pcHeader = this.readStructure(GoPcHeader.class, pcHeaderAddress);
            result = GoModuledata.findFirstModule(this, pcHeaderAddress, pcHeader, this.getModuledataSearchRange(), monitor);
        }
        if (result != null && !result.isValid()) {
            throw new IOException("Invalid Go moduledata at %s".formatted(result.getStructureContext().getStructureAddress()));
        }
        return result;
    }

    private AddressRange getPclntabSearchRange() {
        MemoryBlock memBlock = GoRttiMapper.getFirstGoSection(this.program, "noptrdata", "rdata");
        return memBlock != null ? new AddressRangeImpl(memBlock.getStart(), memBlock.getEnd()) : null;
    }

    private AddressRange getModuledataSearchRange() {
        MemoryBlock memBlock = GoRttiMapper.getFirstGoSection(this.program, "noptrdata", "data");
        return memBlock != null ? new AddressRangeImpl(memBlock.getStart(), memBlock.getEnd()) : null;
    }

    public AddressSetView getStringStructRange() {
        AddressSet result = new AddressSet();
        for (GoModuledata moduledata : this.modules) {
            result.add(moduledata.getDataRange());
            result.add(moduledata.getRoDataRange());
        }
        return result;
    }

    public AddressSetView getStringDataRange() {
        AddressSet result = new AddressSet();
        for (GoModuledata moduledata : this.modules) {
            result.add(moduledata.getRoDataRange());
        }
        return result;
    }

    public AddressSetView getTextAddresses() {
        AddressSet result = new AddressSet();
        for (GoModuledata moduledata : this.modules) {
            result.add(moduledata.getTextRange());
        }
        return result;
    }

    public AddressSetView getUninitializedNoPtrDataRange() {
        AddressSet result = new AddressSet();
        for (GoModuledata moduledata : this.modules) {
            result.add(moduledata.getUninitializedNoPtrDataRange());
        }
        return result;
    }

    public Symbol getGoSymbol(String symbolName) {
        return GoRttiMapper.getGoSymbol(this.program, symbolName);
    }

    public MemoryBlock getGoSection(String sectionName) {
        return GoRttiMapper.getGoSection(this.program, sectionName);
    }

    public record FuncDefResult(FunctionDefinition funcDef, GoType recvType, Set<FuncDefFlags> flags, String funcDefStr, GoSymbolName symbolName) {
    }

    public static enum FuncDefFlags {
        RECV_MISSING,
        RECV_ARTIFICIAL,
        PARAMS_PARTIAL,
        PARAM_SUBSTITUTION,
        PARAMS_MISSING,
        RETURN_INFO_PARTIAL,
        RESULT_SUBSTITUTION,
        RETURN_INFO_MISSING,
        FROM_RTTI_METHOD,
        FROM_SNAPSHOT,
        FROM_ANALYSIS,
        CLOSURE,
        METHOD_WRAPPER;

    }

    public static interface GoNameSupplier {
        public GoName get() throws IOException;
    }
}

