/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.widgets.DropDownSelectionTextField;
import docking.widgets.DropDownTextFieldDataModel;
import ghidra.app.util.NamespaceDropDownModel;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.exception.CancelledException;
import ghidra.util.layout.PairLayout;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class NamespaceChooserDialog
extends DialogComponentProvider {
    private DropDownSelectionTextField<Namespace> dropDownField;
    private NamespaceDropDownModel namespaceModel = new NamespaceDropDownModel();
    private Namespace chosenNamespace;

    public NamespaceChooserDialog() {
        super("Namespace Chooser");
        this.addWorkPanel(this.buildWorkPanel());
        this.addOKButton();
        this.addCancelButton();
    }

    public Namespace getNameSpace(Program program) {
        List<Namespace> namespaces = this.gatherNamespaces(program);
        if (namespaces == null) {
            return null;
        }
        this.namespaceModel.setNamespaces(namespaces);
        DockingWindowManager.showDialog((DialogComponentProvider)this);
        return this.chosenNamespace;
    }

    protected void okCallback() {
        this.chosenNamespace = (Namespace)this.dropDownField.getSelectedValue();
        this.close();
    }

    protected void cancelCallback() {
        this.chosenNamespace = null;
        this.close();
    }

    private List<Namespace> gatherNamespaces(Program program) {
        GatherNamespacesTask task = new GatherNamespacesTask(program);
        TaskLauncher.launch((Task)task);
        return task.getNamespaces();
    }

    private JComponent buildWorkPanel() {
        JPanel panel = new JPanel((LayoutManager)new PairLayout());
        panel.add(new JLabel("Namespace:  "));
        this.dropDownField = new DropDownSelectionTextField((DropDownTextFieldDataModel)this.namespaceModel);
        panel.add((Component)this.dropDownField);
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        return panel;
    }

    private static class GatherNamespacesTask
    extends Task {
        private List<Namespace> namespaces;
        private Program program;

        GatherNamespacesTask(Program program) {
            super("Gather Namespaces");
            this.program = program;
        }

        public void run(TaskMonitor monitor) throws CancelledException {
            ArrayList<Namespace> list = new ArrayList<Namespace>();
            list.add(this.program.getGlobalNamespace());
            for (Symbol symbol : this.program.getSymbolTable().getDefinedSymbols()) {
                Function f;
                Object object;
                monitor.checkCancelled();
                if (!symbol.getSymbolType().isNamespace() || (object = symbol.getObject()) instanceof Function && (f = (Function)object).isThunk()) continue;
                list.add((Namespace)object);
            }
            this.namespaces = list;
        }

        List<Namespace> getNamespaces() {
            return this.namespaces;
        }
    }
}

