/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.strings;

import docking.DialogComponentProvider;
import docking.widgets.checkbox.GCheckBox;
import docking.widgets.combobox.GhidraComboBox;
import docking.widgets.label.GDHtmlLabel;
import docking.widgets.label.GHtmlLabel;
import docking.widgets.label.GLabel;
import docking.widgets.list.GComboBoxCellRenderer;
import docking.widgets.list.GListCellRenderer;
import docking.widgets.spinner.IntegerSpinner;
import docking.widgets.table.threaded.ThreadedTableModelListener;
import generic.jar.ResourceFile;
import generic.theme.GThemeDefaults;
import generic.theme.Gui;
import ghidra.app.plugin.core.strings.CharacterScriptUtils;
import ghidra.app.plugin.core.strings.EncodedStringsFilterStats;
import ghidra.app.plugin.core.strings.EncodedStringsOptions;
import ghidra.app.plugin.core.strings.EncodedStringsPlugin;
import ghidra.app.plugin.core.strings.EncodedStringsRow;
import ghidra.app.plugin.core.strings.EncodedStringsTableModel;
import ghidra.app.plugin.core.strings.EncodedStringsThreadedTablePanel;
import ghidra.app.plugin.core.strings.TrigramStringValidator;
import ghidra.app.services.StringTranslationService;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsImpl;
import ghidra.framework.Application;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.AbstractStringDataType;
import ghidra.program.model.data.CharsetInfo;
import ghidra.program.model.data.CharsetSettingsDefinition;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.StringDataType;
import ghidra.program.model.data.StringUTF8DataType;
import ghidra.program.model.data.Unicode32DataType;
import ghidra.program.model.data.UnicodeDataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.program.util.ProgramLocation;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.exception.CancelledException;
import ghidra.util.layout.PairLayout;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraTableFilterPanel;
import ghidra.util.task.MonitoredRunnable;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;

public class EncodedStringsDialog
extends DialogComponentProvider {
    private static final Map<String, AbstractStringDataType> CHARSET_TO_DT_MAP = Map.ofEntries(Map.entry("US-ASCII", StringDataType.dataType), Map.entry("UTF-8", StringUTF8DataType.dataType), Map.entry("UTF-16", UnicodeDataType.dataType), Map.entry("UTF-32", Unicode32DataType.dataType));
    private static final String BUTTON_FONT_ID = "font.plugin.strings.buttons";
    private final PluginTool tool;
    private final EncodedStringsPlugin plugin;
    private final Program program;
    private AddressSetView selectedAddresses;
    private EncodedStringsTableModel tableModel;
    private EncodedStringsThreadedTablePanel<EncodedStringsRow> threadedTablePanel;
    private GhidraTableFilterPanel<EncodedStringsRow> filterPanel;
    private GhidraTable table;
    private JPanel optionsPanel;
    private GhidraComboBox<String> charsetComboBox;
    private JToggleButton showAdvancedOptionsButton;
    private JToggleButton showScriptOptionsButton;
    private JToggleButton showTranslateOptionsButton;
    private GhidraComboBox<Character.UnicodeScript> requiredUnicodeScript;
    private Map<Character.UnicodeScript, String> scriptExampleStrings = new HashMap<Character.UnicodeScript, String>();
    private JToggleButton allowLatinScriptButton;
    private JToggleButton allowCommonScriptButton;
    private JToggleButton allowAnyScriptButton;
    private GCheckBox excludeStringsWithCodecErrorCB;
    private GCheckBox excludeStringsWithNonStdCtrlCharsCB;
    private IntegerSpinner minStringLengthSpinner;
    private GCheckBox alignStartOfStringCB;
    private GCheckBox breakOnRefCB;
    private GDHtmlLabel codecErrorsCountLabel;
    private GDHtmlLabel nonStdCtrlCharsErrorsCountLabel;
    private GDHtmlLabel stringModelFailedCountLabel;
    private GDHtmlLabel minLenFailedCountLabel;
    private GDHtmlLabel scriptFailedCountLabel;
    private GDHtmlLabel otherScriptsFailedCountLabel;
    private GDHtmlLabel latinScriptFailedCountLabel;
    private GDHtmlLabel commonScriptFailedCountLabel;
    private GDHtmlLabel advancedFailedCountLabel;
    private JButton createButton;
    private GhidraComboBox<StringTranslationService> translateComboBox;
    private EncodedStringsOptions currentOptions;
    private AtomicReference<List<Address>> previouslySelectedRowAddrs = new AtomicReference();
    private AtomicBoolean updateInProgressFlag = new AtomicBoolean();
    private AtomicReference<Integer> rowToSelect = new AtomicReference();
    private GCheckBox requireValidStringCB;
    private GhidraComboBox<String> stringModelFilenameComboBox;
    private TrigramStringValidator stringValidator;
    private String trigramModelFilename;
    private int optionsPanelRowCount;
    private int advOptsRow1;
    private int advOptsRow2;
    private int stringModelRow;
    private int scriptRow;
    private int translateRow;
    private EncodedStringsFilterStats prevStats = new EncodedStringsFilterStats();
    private ItemListener itemListener = this::comboboxItemListener;

    public EncodedStringsDialog(EncodedStringsPlugin plugin, Program program, AddressSetView selectedAddresses) {
        super(EncodedStringsDialog.makeTitleString(selectedAddresses), false, true, true, true);
        this.setRememberSize(false);
        this.plugin = plugin;
        this.tool = plugin.getTool();
        this.program = program;
        this.selectedAddresses = selectedAddresses;
        this.setHelpLocation(EncodedStringsPlugin.HELP_LOCATION);
        this.build();
    }

    public void setSelectedCharset(String charsetName) {
        this.charsetComboBox.setSelectedItem((Object)charsetName);
    }

    public void setRequireValidStringOption(boolean b) {
        this.requireValidStringCB.setSelected(b);
        this.updateOptionsAndRefresh();
    }

    public void setAllowLatinScriptOption(boolean b) {
        if (this.allowLatinScriptButton.isSelected() != b) {
            this.allowLatinScriptButton.doClick();
        }
    }

    public void setAllowCommonScriptOption(boolean b) {
        if (this.allowCommonScriptButton.isSelected() != b) {
            this.allowCommonScriptButton.doClick();
        }
    }

    public void setAllowAnyScriptOption(boolean b) {
        if (this.allowAnyScriptButton.isSelected() != b) {
            this.allowAnyScriptButton.doClick();
        }
    }

    public void setRequiredScript(Character.UnicodeScript requiredScript) {
        this.requiredUnicodeScript.setSelectedItem((Object)requiredScript);
        this.updateOptionsAndRefresh();
    }

    public void setShowAdvancedOptions(boolean b) {
        if (this.showAdvancedOptionsButton.isSelected() != b) {
            this.showAdvancedOptionsButton.doClick();
        }
    }

    public void setShowScriptOptions(boolean b) {
        if (this.showScriptOptionsButton.isSelected() != b) {
            this.showScriptOptionsButton.doClick();
        }
    }

    public void setExcludeCodecErrors(boolean b) {
        if (this.excludeStringsWithCodecErrorCB.isSelected() != b) {
            this.excludeStringsWithCodecErrorCB.doClick();
        }
    }

    public void setExcludeNonStdCtrlChars(boolean b) {
        if (this.excludeStringsWithNonStdCtrlCharsCB.isSelected() != b) {
            this.excludeStringsWithNonStdCtrlCharsCB.doClick();
        }
    }

    public EncodedStringsTableModel getStringModel() {
        return this.tableModel;
    }

    public JButton getCreateButton() {
        return this.createButton;
    }

    public void programClosed(Program p) {
        if (this.program == p) {
            this.close();
        }
    }

    private void buildScriptExamplesMap(Font f) {
        if (this.scriptExampleStrings.isEmpty()) {
            this.scriptExampleStrings.putAll(CharacterScriptUtils.getDisplayableScriptExamples(f, 7));
        }
    }

    private void build() {
        this.addWorkPanel(this.buildWorkPanel());
        this.createButton = new JButton("Create");
        this.createButton.setName("Create");
        this.createButton.getAccessibleContext().setAccessibleName("Create");
        this.createButton.addActionListener(e -> {
            if (this.isSingleStringMode()) {
                this.createStringsAndClose();
            } else {
                this.createStrings();
            }
        });
        this.addButton(this.createButton);
        this.addCancelButton();
        this.cancelButton.setText("Dismiss");
        this.setDefaultButton(this.createButton);
    }

    private JComponent buildWorkPanel() {
        this.optionsPanel = new JPanel((LayoutManager)new PairLayout(5, 5));
        this.optionsPanel.setBorder(BorderFactory.createTitledBorder("Options"));
        this.optionsPanel.getAccessibleContext().setAccessibleName("Options");
        this.buildCharsetPickerComponents();
        this.buildOptionsButtonComponents();
        this.buildAdvancedOptionsComponents();
        this.buildScriptFilterComponents();
        this.buildTranslateComponents();
        boolean ssm = this.selectedAddresses.getNumAddresses() == 1L;
        this.addRow((Component)new GLabel("Charset:", 4), new Component[]{this.charsetComboBox, this.showScriptOptionsButton, this.showTranslateOptionsButton, this.showAdvancedOptionsButton, this.advancedFailedCountLabel});
        GLabel scriptLabel = new GLabel("Script:", 4);
        scriptLabel.getAccessibleContext().setAccessibleName("Script");
        GLabel allowAddLabel = new GLabel("Allow Additional:");
        allowAddLabel.getAccessibleContext().setAccessibleName("Allow Additional");
        this.scriptRow = this.addRow((Component)scriptLabel, new Component[]{this.requiredUnicodeScript, this.scriptFailedCountLabel, allowAddLabel, this.allowAnyScriptButton, this.otherScriptsFailedCountLabel, this.allowLatinScriptButton, this.latinScriptFailedCountLabel, this.allowCommonScriptButton, this.commonScriptFailedCountLabel});
        this.advOptsRow1 = this.addRow(null, new Component[]{this.excludeStringsWithCodecErrorCB, this.codecErrorsCountLabel, this.excludeStringsWithNonStdCtrlCharsCB, this.nonStdCtrlCharsErrorsCountLabel});
        this.stringModelRow = this.addRow(null, new Component[]{this.requireValidStringCB, this.stringModelFailedCountLabel, this.stringModelFilenameComboBox});
        if (ssm) {
            this.advOptsRow2 = this.addRow(null, new Component[]{this.alignStartOfStringCB, this.breakOnRefCB});
        } else {
            GLabel minLenLabel = new GLabel("Min Length:", 4);
            minLenLabel.setToolTipText(this.minStringLengthSpinner.getSpinner().getToolTipText());
            minLenLabel.getAccessibleContext().setAccessibleName("Minimum Length");
            this.advOptsRow2 = this.addRow(null, new Component[]{minLenLabel, this.minStringLengthSpinner.getSpinner(), this.minLenFailedCountLabel, this.alignStartOfStringCB, this.breakOnRefCB});
        }
        this.translateRow = this.addRow((Component)new GLabel("Translate:", 4), new Component[]{this.translateComboBox});
        this.setRowVisibility(this.advOptsRow1, this.showAdvancedOptionsButton.isSelected());
        this.setRowVisibility(this.advOptsRow2, this.showAdvancedOptionsButton.isSelected());
        this.setRowVisibility(this.stringModelRow, this.showAdvancedOptionsButton.isSelected());
        this.setRowVisibility(this.scriptRow, this.showScriptOptionsButton.isSelected());
        this.setRowVisibility(this.translateRow, this.showTranslateOptionsButton.isSelected());
        this.buildPreviewTableComponents();
        JPanel previewTablePanel = new JPanel(new BorderLayout());
        previewTablePanel.add((Component)((Object)this.threadedTablePanel), "Center");
        previewTablePanel.add((Component)((Object)this.filterPanel), "South");
        previewTablePanel.getAccessibleContext().setAccessibleName("Preview Table");
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.optionsPanel, "North");
        panel.add((Component)previewTablePanel, "Center");
        panel.getAccessibleContext().setAccessibleName("Encoded Strings");
        return panel;
    }

    private void buildPreviewTableComponents() {
        this.tableModel = new EncodedStringsTableModel(this.program, this.selectedAddresses);
        this.tableModel.addTableModelListener(e -> {
            Integer rowNum = this.rowToSelect.getAndSet(null);
            if (rowNum != null && rowNum < this.tableModel.getRowCount()) {
                this.table.selectRow(rowNum);
                this.table.requestFocusInWindow();
            }
        });
        this.tableModel.addThreadedTableModelListener(new ThreadedTableModelListener(){

            public void loadingStarted() {
                EncodedStringsDialog.this.setStatusText("Filtering strings...");
                EncodedStringsDialog.this.setCreateButtonInfo(0, 0);
                EncodedStringsDialog.this.threadedTablePanel.showEmptyTableOverlay(false);
            }

            public void loadingFinished(boolean wasCancelled) {
                EncodedStringsFilterStats stats = EncodedStringsDialog.this.tableModel.getStats();
                EncodedStringsDialog.this.prevStats = stats.clone();
                int rowCount = EncodedStringsDialog.this.tableModel.getRowCount();
                EncodedStringsDialog.this.setStatusText("%s strings found, %d strings match, %d excluded%s.".formatted(stats.total, rowCount, stats.getTotalOmitted(), wasCancelled ? " (partial results)" : ""));
                List previousAddrs = EncodedStringsDialog.this.previouslySelectedRowAddrs.getAndSet(null);
                if (previousAddrs != null) {
                    EncodedStringsDialog.this.setSelectedAddresses(previousAddrs);
                }
                EncodedStringsDialog.this.selectedRowChange();
                EncodedStringsDialog.this.codecErrorsCountLabel.setText(EncodedStringsDialog.this.getErrorCountString(stats.codecErrors));
                EncodedStringsDialog.this.nonStdCtrlCharsErrorsCountLabel.setText(EncodedStringsDialog.this.getErrorCountString(stats.nonStdCtrlChars));
                EncodedStringsDialog.this.stringModelFailedCountLabel.setText(EncodedStringsDialog.this.getErrorCountString(stats.failedStringModel));
                EncodedStringsDialog.this.minLenFailedCountLabel.setText(EncodedStringsDialog.this.getErrorCountString(stats.stringLength));
                EncodedStringsDialog.this.scriptFailedCountLabel.setText(EncodedStringsDialog.this.getErrorCountString(stats.requiredScripts));
                EncodedStringsDialog.this.latinScriptFailedCountLabel.setText(EncodedStringsDialog.this.getErrorCountString(stats.latinScript));
                EncodedStringsDialog.this.commonScriptFailedCountLabel.setText(EncodedStringsDialog.this.getErrorCountString(stats.commonScript));
                EncodedStringsDialog.this.otherScriptsFailedCountLabel.setText(EncodedStringsDialog.this.getErrorCountString(stats.otherScripts));
                EncodedStringsDialog.this.advancedFailedCountLabel.setText(EncodedStringsDialog.this.getErrorCountString(stats.getTotalForAdvancedOptions()));
                EncodedStringsDialog.this.updateRequiredScriptsList(stats);
                EncodedStringsDialog.this.threadedTablePanel.showEmptyTableOverlay(rowCount == 0);
            }

            public void loadPending() {
            }
        });
        JPanel emptyTableOverlay = new JPanel(new GridBagLayout());
        emptyTableOverlay.add((Component)new GHtmlLabel("<html>No strings matched filter criteria..."), new GridBagConstraints());
        emptyTableOverlay.getAccessibleContext().setAccessibleName("Empty Table Overlay");
        this.threadedTablePanel = new EncodedStringsThreadedTablePanel<EncodedStringsRow>(this.tableModel, 1000, emptyTableOverlay);
        this.threadedTablePanel.setBorder(BorderFactory.createTitledBorder("Preview"));
        this.threadedTablePanel.getAccessibleContext().setAccessibleName("Threaded Table");
        this.table = this.threadedTablePanel.getTable();
        this.table.setName("DataTable");
        this.table.getAccessibleContext().setAccessibleName("Data Table");
        this.table.setPreferredScrollableViewportSize(new Dimension(350, 150));
        this.table.getSelectionModel().addListSelectionListener(e -> this.selectedRowChange());
        this.table.installNavigation((ServiceProvider)this.tool);
        this.filterPanel = new GhidraTableFilterPanel((JTable)((Object)this.table), this.tableModel);
        this.filterPanel.getAccessibleContext().setAccessibleName("Filter");
    }

    private void buildCharsetPickerComponents() {
        this.charsetComboBox = new GhidraComboBox();
        this.charsetComboBox.getAccessibleContext().setAccessibleName("Charset Checkboxes");
        for (String charsetName : CharsetInfo.getInstance().getCharsetNames()) {
            this.charsetComboBox.addToModel((Object)charsetName);
        }
        this.charsetComboBox.setSelectedItem((Object)this.getDefault("Default Charset", "US-ASCII"));
        this.charsetComboBox.addItemListener(this.itemListener);
        this.charsetComboBox.setToolTipText("Which character set to use to decode the raw bytes.");
    }

    private void buildOptionsButtonComponents() {
        this.showAdvancedOptionsButton = new JToggleButton("Advanced...");
        this.showAdvancedOptionsButton.setName("SHOW_ADVANCED_OPTIONS");
        this.showAdvancedOptionsButton.getAccessibleContext().setAccessibleName("Show Advanced Options");
        this.showAdvancedOptionsButton.setToolTipText("Show advanced options.");
        this.showAdvancedOptionsButton.addActionListener(e -> {
            this.setRowVisibility(this.advOptsRow1, this.showAdvancedOptionsButton.isSelected());
            this.setRowVisibility(this.advOptsRow2, this.showAdvancedOptionsButton.isSelected());
            this.setRowVisibility(this.stringModelRow, this.showAdvancedOptionsButton.isSelected());
            this.advancedFailedCountLabel.setVisible(!this.showAdvancedOptionsButton.isSelected());
        });
        this.advancedFailedCountLabel = new GDHtmlLabel("<html><div width=50></div>");
        this.advancedFailedCountLabel.setForeground((Color)GThemeDefaults.Colors.Messages.ERROR);
        this.advancedFailedCountLabel.setToolTipText("Number of strings excluded due to filtering options in advanced options.");
        this.advancedFailedCountLabel.setVisible(!this.showAdvancedOptionsButton.isSelected());
        this.advancedFailedCountLabel.getAccessibleContext().setAccessibleName("Advanced Failed Count");
        this.showScriptOptionsButton = new JToggleButton("A-Z,\u6211\u7684,\u062d\u064e\u0648\u0651");
        this.showScriptOptionsButton.setName("SHOW_SCRIPT_OPTIONS");
        this.showScriptOptionsButton.getAccessibleContext().setAccessibleName("Show Script Options");
        this.showScriptOptionsButton.setToolTipText("Filter by character scripts (alphabets).");
        this.showScriptOptionsButton.addActionListener(e -> {
            this.setRowVisibility(this.scriptRow, this.showScriptOptionsButton.isSelected());
            this.updateOptionsAndRefresh();
        });
        this.showTranslateOptionsButton = new JToggleButton("Translate");
        this.showTranslateOptionsButton.setName("SHOW_TRANSLATE_OPTIONS");
        this.showTranslateOptionsButton.getAccessibleContext().setAccessibleName("Show Translate Options");
        this.showTranslateOptionsButton.setToolTipText("Translate strings after creation.");
        this.showTranslateOptionsButton.addActionListener(e -> this.setRowVisibility(this.translateRow, this.showTranslateOptionsButton.isSelected()));
    }

    private void buildAdvancedOptionsComponents() {
        boolean singleStringMode = this.isSingleStringMode();
        this.excludeStringsWithCodecErrorCB = new GCheckBox("Exclude codec errors");
        this.excludeStringsWithCodecErrorCB.setSelected(!singleStringMode);
        this.excludeStringsWithCodecErrorCB.addItemListener(this::checkboxItemListener);
        this.excludeStringsWithCodecErrorCB.setToolTipText("<html>Exclude strings that have charset codec errors.<br>\n(bytes/sequences that are invalid for the chosen charset)");
        this.excludeStringsWithCodecErrorCB.getAccessibleContext().setAccessibleName("Exclude Strings With Codec Error");
        this.codecErrorsCountLabel = new GDHtmlLabel();
        this.codecErrorsCountLabel.setForeground((Color)GThemeDefaults.Colors.Messages.ERROR);
        this.codecErrorsCountLabel.setToolTipText("Number of strings excluded due to codec errors.");
        this.codecErrorsCountLabel.getAccessibleContext().setAccessibleName("Codec Errors Count");
        this.excludeStringsWithNonStdCtrlCharsCB = new GCheckBox("Exclude non-std ctrl chars");
        this.excludeStringsWithNonStdCtrlCharsCB.setSelected(!singleStringMode);
        this.excludeStringsWithNonStdCtrlCharsCB.setToolTipText("<html>Exclude strings that contain non-standard control characters.<br>\n(ASCII 1..31, not including tab, CR, LF)");
        this.excludeStringsWithNonStdCtrlCharsCB.addItemListener(this::checkboxItemListener);
        this.excludeStringsWithNonStdCtrlCharsCB.getAccessibleContext().setAccessibleName("Exclude Strings with Non-Standard Control Characters");
        this.nonStdCtrlCharsErrorsCountLabel = new GDHtmlLabel();
        this.nonStdCtrlCharsErrorsCountLabel.setForeground((Color)GThemeDefaults.Colors.Messages.ERROR);
        this.nonStdCtrlCharsErrorsCountLabel.setToolTipText("Number of strings excluded due to non-standard control characters.");
        this.nonStdCtrlCharsErrorsCountLabel.getAccessibleContext().setAccessibleName("Non-Standard Control Character Error Count");
        this.alignStartOfStringCB = new GCheckBox("Align start of string");
        this.alignStartOfStringCB.setToolTipText("<html>If the chosen charset specifies a char size greater than 1, only look for<br>\nstrings that begin on an aligned boundary.");
        this.alignStartOfStringCB.setSelected(!singleStringMode);
        this.alignStartOfStringCB.addItemListener(this::checkboxItemListener);
        this.alignStartOfStringCB.getAccessibleContext().setAccessibleName("Align Start of String");
        this.breakOnRefCB = new GCheckBox("Truncate at ref");
        this.breakOnRefCB.setSelected(true);
        this.breakOnRefCB.addItemListener(this::checkboxItemListener);
        this.breakOnRefCB.setToolTipText("Truncate strings at references.");
        this.breakOnRefCB.getAccessibleContext().setAccessibleName("Break on References");
        this.minStringLengthSpinner = new IntegerSpinner(new SpinnerNumberModel((Number)Math.min(5L, this.selectedAddresses.getNumAddresses()), Long.valueOf(0L), Long.valueOf(Math.min(99L, this.selectedAddresses.getNumAddresses())), (Number)1L), 3);
        this.minStringLengthSpinner.getSpinner().setToolTipText("Exclude strings that are shorter (in characters, not bytes) than this minimum");
        this.minStringLengthSpinner.getTextField().setShowNumberMode(false);
        this.minStringLengthSpinner.getSpinner().addChangeListener(e -> this.updateOptionsAndRefresh());
        this.minStringLengthSpinner.getSpinner().getAccessibleContext().setAccessibleName("Minimum String Length");
        this.minLenFailedCountLabel = new GDHtmlLabel();
        this.minLenFailedCountLabel.setForeground((Color)GThemeDefaults.Colors.Messages.ERROR);
        this.minLenFailedCountLabel.setToolTipText("Number of strings excluded due to length.");
        this.minLenFailedCountLabel.getAccessibleContext().setAccessibleName("Minimum Failed Length Count");
        this.stringModelFilenameComboBox = new GhidraComboBox();
        this.stringModelFilenameComboBox.setEditable(true);
        for (String builtinStringModelFilename : this.getBuiltinStringModelFilenames()) {
            this.stringModelFilenameComboBox.addToModel((Object)builtinStringModelFilename);
        }
        this.stringModelFilenameComboBox.setText(this.getDefault("Default String Model Filename", "stringngrams/StringModel.sng"));
        this.stringModelFilenameComboBox.addItemListener(this.itemListener);
        this.stringModelFilenameComboBox.setToolTipText("<html>Select the name of a built-in string model,<br>\nor<br>\nEnter the full path to a user-supplied .sng model file,<br>\nor<br>\nClear the field for no string model.");
        this.stringModelFilenameComboBox.getAccessibleContext().setAccessibleName("String Model Filename");
        this.requireValidStringCB = new GCheckBox("Exclude invalid strings");
        this.requireValidStringCB.setSelected(false);
        this.requireValidStringCB.setToolTipText("Verify strings against the string model.");
        this.requireValidStringCB.addItemListener(this::checkboxItemListener);
        this.requireValidStringCB.getAccessibleContext().setAccessibleName("Reguire Valid Sring");
        this.stringModelFailedCountLabel = new GDHtmlLabel();
        this.stringModelFailedCountLabel.setForeground((Color)GThemeDefaults.Colors.Messages.ERROR);
        this.stringModelFailedCountLabel.setToolTipText("Number of strings excluded due to failing string model check.");
        this.stringModelFailedCountLabel.getAccessibleContext().setAccessibleName("String Model Failed Count");
    }

    private void buildScriptFilterComponents() {
        this.requiredUnicodeScript = new CharScriptComboBox();
        this.requiredUnicodeScript.setSelectedItem((Object)CharacterScriptUtils.ANY_SCRIPT_ALIAS);
        this.requiredUnicodeScript.addItemListener(this.itemListener);
        this.requiredUnicodeScript.setToolTipText("<html>Require at least one character of this script (alphabet) to be present in the string.<p>\n<p>\nUse the <b>Allow Additional</b> toggle buttons (if currently not enabled) to<br>\nallow more strings to match.<p>\n<p>\nNote: character scripts that are drawable using the current font will have<br>\nsome example characters displayed to the right of the name.");
        this.requiredUnicodeScript.getAccessibleContext().setAccessibleName("Required Unicode Script");
        this.scriptFailedCountLabel = new GDHtmlLabel();
        this.scriptFailedCountLabel.setForeground((Color)GThemeDefaults.Colors.Messages.ERROR);
        this.scriptFailedCountLabel.setToolTipText("Number of strings excluded due to failing script requirements.");
        this.scriptFailedCountLabel.getAccessibleContext().setAccessibleName("Script Failed Count");
        this.allowLatinScriptButton = new JToggleButton("A-Z");
        this.allowLatinScriptButton.setName("ALLOW_LATIN_SCRIPT");
        Gui.registerFont((Component)this.allowLatinScriptButton, (String)BUTTON_FONT_ID);
        this.allowLatinScriptButton.setToolTipText("Allow Latin characters (e.g. A-Z, etc) to also be present in the string.");
        this.allowLatinScriptButton.setSelected(true);
        this.allowLatinScriptButton.addItemListener(this::checkboxItemListener);
        this.allowLatinScriptButton.getAccessibleContext().setAccessibleName("Allow Latin Script");
        this.latinScriptFailedCountLabel = new GDHtmlLabel();
        this.latinScriptFailedCountLabel.setForeground((Color)GThemeDefaults.Colors.Messages.ERROR);
        this.latinScriptFailedCountLabel.setToolTipText("Number of strings excluded because they contained Latin characters.");
        this.latinScriptFailedCountLabel.getAccessibleContext().setAccessibleName("Latin Script Failed Count");
        this.allowCommonScriptButton = new JToggleButton("0-9,!?");
        this.allowCommonScriptButton.setName("ALLOW_COMMON_SCRIPT");
        Gui.registerFont((Component)this.allowCommonScriptButton, (String)BUTTON_FONT_ID);
        this.allowCommonScriptButton.setToolTipText("Allow common characters (e.g. 0-9, space, punctuation, etc) to also be present in the string.");
        this.allowCommonScriptButton.setSelected(true);
        this.allowCommonScriptButton.addItemListener(this::checkboxItemListener);
        this.allowCommonScriptButton.getAccessibleContext().setAccessibleName("Allow Common Script");
        this.commonScriptFailedCountLabel = new GDHtmlLabel();
        this.commonScriptFailedCountLabel.setForeground((Color)GThemeDefaults.Colors.Messages.ERROR);
        this.commonScriptFailedCountLabel.setToolTipText("Number of strings excluded because they contained Common (0-9, space, punctuation, etc) characters.");
        this.commonScriptFailedCountLabel.getAccessibleContext().setAccessibleName("Common Script Failed Count");
        this.allowAnyScriptButton = new JToggleButton("Any");
        this.allowAnyScriptButton.setName("ALLOW_ANY_SCRIPT");
        Gui.registerFont((Component)this.allowAnyScriptButton, (String)BUTTON_FONT_ID);
        this.allowAnyScriptButton.setToolTipText("Allow all other character scripts to also be present in the string.");
        this.allowAnyScriptButton.setSelected(true);
        this.allowAnyScriptButton.addItemListener(this::checkboxItemListener);
        this.allowAnyScriptButton.getAccessibleContext().setAccessibleName("Allow Any Script");
        this.otherScriptsFailedCountLabel = new GDHtmlLabel();
        this.otherScriptsFailedCountLabel.setForeground((Color)GThemeDefaults.Colors.Messages.ERROR);
        this.otherScriptsFailedCountLabel.setToolTipText("Number of strings excluded because they contained characters from other scripts (alphabets).");
        this.otherScriptsFailedCountLabel.getAccessibleContext().setAccessibleName("Other Scripts Failed Count");
    }

    private List<String> getBuiltinStringModelFilenames() {
        return List.of("stringngrams/StringModel.sng");
    }

    private void fixupComboBoxSizes() {
        this.requiredUnicodeScript.setPreferredSize(this.charsetComboBox.getPreferredSize());
    }

    private void buildTranslateComponents() {
        List<StringTranslationService> translationServices = StringTranslationService.getCurrentStringTranslationServices(this.tool);
        this.translateComboBox = new GhidraComboBox(translationServices);
        this.translateComboBox.getAccessibleContext().setAccessibleName("Translate Checkboxes");
        StringTranslationService defaultSTS = this.getDefaultTranslationService(translationServices);
        if (defaultSTS != null) {
            this.translateComboBox.setSelectedItem((Object)defaultSTS);
        }
        this.translateComboBox.setRenderer((ListCellRenderer)GComboBoxCellRenderer.createDefaultTextRenderer(sts -> sts != null ? sts.getTranslationServiceName() : ""));
    }

    private void setRowVisibility(int rowNum, boolean b) {
        Component leftComp = this.optionsPanel.getComponent(rowNum * 2);
        leftComp.setVisible(b);
        Component rightComp = this.optionsPanel.getComponent(rowNum * 2 + 1);
        rightComp.setVisible(b);
        if (b) {
            Swing.runLater(this::fixTooSmallTablePanel);
        }
    }

    private void fixTooSmallTablePanel() {
        int rowHeight = this.table.getRowHeight();
        Dimension tableSize = this.threadedTablePanel.getSize();
        int desiredMinTableHt = rowHeight * 4;
        if (tableSize.height < desiredMinTableHt) {
            Dimension dlgSize = this.getDialogSize();
            dlgSize.height += desiredMinTableHt - tableSize.height;
            this.setDialogSize(dlgSize);
        }
    }

    private int addRow(Component leftComponent, Component ... rightComponents) {
        Component rightComponent;
        if (leftComponent == null) {
            leftComponent = new GLabel();
        }
        if (rightComponents.length > 1) {
            JPanel panel = new JPanel(new FlowLayout(0));
            for (Component c : rightComponents) {
                if (c == null) continue;
                panel.add(c);
            }
            rightComponent = panel;
        } else {
            rightComponent = rightComponents[0];
        }
        this.optionsPanel.add(leftComponent);
        this.optionsPanel.add(rightComponent);
        return this.optionsPanelRowCount++;
    }

    protected void dialogShown() {
        this.fixupComboBoxSizes();
        this.updateOptionsAndRefresh();
    }

    protected void cancelCallback() {
        this.saveDefaults();
        this.close();
    }

    public void close() {
        super.close();
        this.dispose();
    }

    public void dispose() {
        this.plugin.dialogClosed(this);
        this.table.dispose();
        super.dispose();
    }

    private void createStrings() {
        this.setActionItemEnablement(false);
        this.executeMonitoredRunnable("Creating Strings", true, true, 100, this::createStrings);
    }

    private void createStringsAndClose() {
        this.saveDefaults();
        this.setActionItemEnablement(false);
        this.executeMonitoredRunnable("Creating Strings", true, true, 100, this::createStringsAndClose);
    }

    private void setActionItemEnablement(boolean enabled) {
        this.createButton.setEnabled(enabled);
        this.cancelButton.setEnabled(enabled);
        this.table.removeNavigation();
        if (enabled) {
            this.table.installNavigation((ServiceProvider)this.tool);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createStringsHelper(Runnable followupAction, TaskMonitor monitor) {
        int count = 0;
        ArrayList<ProgramLocation> newStrings = new ArrayList<ProgramLocation>();
        this.setStatusText("Creating strings...");
        int txId = this.program.startTransaction("Create Strings");
        boolean success = false;
        try {
            ArrayList<EncodedStringsRow> stringsToCreate = new ArrayList<EncodedStringsRow>();
            int[] selectedRowNums = this.table.getSelectedRows();
            if (selectedRowNums.length == 0) {
                stringsToCreate.addAll(this.tableModel.getUnfilteredData());
            } else {
                stringsToCreate.addAll(this.tableModel.getRowObjects(selectedRowNums));
            }
            monitor.initialize((long)stringsToCreate.size());
            monitor.setMessage("Creating strings...");
            Settings settings = this.currentOptions.settings();
            for (EncodedStringsRow row : stringsToCreate) {
                if (monitor.isCancelled()) break;
                monitor.incrementProgress(1L);
                try {
                    Data data = DataUtilities.createData((Program)this.program, (Address)row.sdi().getAddress(), (DataType)this.currentOptions.stringDT(), (int)row.sdi().getDataLength(), (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CLEAR_ALL_DEFAULT_CONFLICT_DATA);
                    for (String settingName : settings.getNames()) {
                        Object settingValue = settings.getValue(settingName);
                        data.setValue(settingName, settingValue);
                    }
                    ++count;
                    newStrings.add(new ProgramLocation(this.program, row.sdi().getAddress()));
                }
                catch (CodeUnitInsertionException e) {
                    Msg.warn((Object)((Object)this), (Object)("Failed to create string at " + String.valueOf(row.sdi().getAddress())));
                }
            }
            this.tool.setStatusInfo("Created %d strings.".formatted(count));
            this.tableModel.removeRows(stringsToCreate);
            if (selectedRowNums.length > 0 && selectedRowNums[0] < this.tableModel.getRowCount()) {
                this.rowToSelect.set(selectedRowNums[0]);
            }
            success = true;
        }
        finally {
            this.program.endTransaction(txId, success);
        }
        StringTranslationService sts = this.getSelectedStringTranslationService(true);
        if (followupAction != null) {
            followupAction.run();
        }
        if (success && sts != null && !newStrings.isEmpty()) {
            sts.translate(this.program, newStrings, new StringTranslationService.TranslateOptions(true));
        }
    }

    private void createStrings(TaskMonitor monitor) {
        this.createStringsHelper(() -> this.setActionItemEnablement(true), monitor);
    }

    private void createStringsAndClose(TaskMonitor monitor) {
        this.createStringsHelper(this::close, monitor);
    }

    private void setCreateButtonInfo(int rowCount, int selectedRowCount) {
        if (rowCount == 0) {
            this.createButton.setText("Create");
            this.createButton.setEnabled(false);
            return;
        }
        String createMessage = this.isSingleStringMode() ? "Create" : "Create %s".formatted(rowCount == selectedRowCount || selectedRowCount == 0 ? "All" : "Selected (%d)".formatted(selectedRowCount));
        this.createButton.setEnabled(true);
        this.createButton.setText(createMessage);
    }

    private void selectedRowChange() {
        int rowCount = this.table.getRowCount();
        int selectedRowCount = this.table.getSelectedRowCount();
        this.setCreateButtonInfo(rowCount, selectedRowCount);
        if (selectedRowCount == 1 && this.tableModel.getProgram() != null) {
            int[] selectedRows = this.table.getSelectedRows();
            this.table.navigate(selectedRows[0], 0);
        }
    }

    private List<Address> getSelectedAddresses() {
        ArrayList<Address> result = new ArrayList<Address>();
        for (EncodedStringsRow row : this.tableModel.getRowObjects(this.table.getSelectedRows())) {
            result.add(row.sdi().getAddress());
        }
        return result;
    }

    private void setSelectedAddresses(List<Address> addrs) {
        HashSet<Address> addrSet = new HashSet<Address>(addrs);
        for (EncodedStringsRow row : this.tableModel.getModelData()) {
            int viewIndex;
            if (!addrSet.contains(row.sdi().getAddress()) || (viewIndex = this.tableModel.getViewIndex(row)) < 0) continue;
            this.table.getSelectionManager().addSelectionInterval(viewIndex, viewIndex);
        }
    }

    private void suppressRecursiveCallbacks(AtomicBoolean flag, Runnable r) {
        if (flag.compareAndSet(false, true)) {
            r.run();
            flag.set(false);
        }
    }

    private void updateOptionsAndRefresh() {
        this.suppressRecursiveCallbacks(this.updateInProgressFlag, () -> {
            List<Address> selectedAddrs = this.getSelectedAddresses();
            if (!selectedAddrs.isEmpty()) {
                this.previouslySelectedRowAddrs.set(selectedAddrs);
            }
            this.updateOptions();
            this.tableModel.setOptions(this.currentOptions);
            this.selectedRowChange();
        });
    }

    private String getErrorCountString(int count) {
        return count > 0 ? "<html><sup>[%d]".formatted(count) : null;
    }

    private void updateOptions() {
        String charsetName = this.charsetComboBox.getSelectedItem().toString();
        if (!EncodedStringsDialog.charsetExists(charsetName)) {
            charsetName = "US-ASCII";
        }
        boolean scriptOptions = this.showScriptOptionsButton.isSelected();
        boolean excludeStringsWithErrors = this.excludeStringsWithCodecErrorCB.isSelected();
        boolean excludeStringsWithNonStdCtrlChars = this.excludeStringsWithNonStdCtrlCharsCB.isSelected();
        boolean alignStartofString = this.alignStartOfStringCB.isSelected();
        int minStrLen = !this.isSingleStringMode() ? (int)Math.min((long)this.minStringLengthSpinner.getTextField().getIntValue(), this.selectedAddresses.getNumAddresses()) : -1;
        AbstractStringDataType stringDT = CHARSET_TO_DT_MAP.get(charsetName);
        Settings settings = SettingsImpl.NO_SETTINGS;
        if (stringDT == null) {
            stringDT = StringDataType.dataType;
            settings = new SettingsImpl();
            CharsetSettingsDefinition.CHARSET.setCharset(settings, charsetName);
        }
        int charSize = CharsetInfo.getInstance().getCharsetCharSize(charsetName);
        this.updateTrigramStringValidator(this.stringModelFilenameComboBox.getText());
        boolean requireValidStrings = this.requireValidStringCB.isSelected();
        boolean breakOnRef = this.breakOnRefCB.isSelected();
        this.currentOptions = new EncodedStringsOptions(stringDT, settings, charsetName, scriptOptions ? this.getRequiredScripts() : null, scriptOptions ? this.getAllowedScripts() : null, excludeStringsWithErrors, excludeStringsWithNonStdCtrlChars, alignStartofString, charSize, minStrLen, breakOnRef, this.stringValidator, requireValidStrings);
    }

    private void updateTrigramStringValidator(String newTrigramModelFilename) {
        if (!newTrigramModelFilename.equals(this.trigramModelFilename)) {
            this.trigramModelFilename = newTrigramModelFilename;
            ResourceFile file = this.getTrigramStringModelFile(this.trigramModelFilename);
            try {
                this.stringValidator = file != null ? TrigramStringValidator.read(file) : null;
            }
            catch (IOException e) {
                Msg.error((Object)((Object)this), (Object)"Error reading string model file", (Throwable)e);
                this.stringValidator = null;
            }
        }
    }

    private ResourceFile getTrigramStringModelFile(String filename) {
        ResourceFile rf;
        if (filename == null || filename.isBlank()) {
            return null;
        }
        File f = new File(filename);
        ResourceFile resourceFile = rf = f.isAbsolute() && f.isFile() ? new ResourceFile(f) : Application.findDataFileInAnyModule((String)filename);
        if (rf == null) {
            Msg.error((Object)((Object)this), (Object)"Unable to find string model file: %s".formatted(filename));
        }
        return rf;
    }

    private Set<Character.UnicodeScript> getRequiredScripts() {
        EnumSet<Character.UnicodeScript> scripts = EnumSet.noneOf(Character.UnicodeScript.class);
        Character.UnicodeScript selectedUnicodeScript = (Character.UnicodeScript)((Object)this.requiredUnicodeScript.getSelectedItem());
        if (selectedUnicodeScript != null && selectedUnicodeScript != CharacterScriptUtils.ANY_SCRIPT_ALIAS) {
            scripts.add(selectedUnicodeScript);
        }
        return scripts;
    }

    private Set<Character.UnicodeScript> getAllowedScripts() {
        EnumSet<Character.UnicodeScript> results = EnumSet.noneOf(Character.UnicodeScript.class);
        if (this.allowAnyScriptButton.isSelected()) {
            results.addAll(EnumSet.allOf(Character.UnicodeScript.class));
            results.remove((Object)Character.UnicodeScript.LATIN);
            results.remove((Object)Character.UnicodeScript.COMMON);
        }
        if (this.allowLatinScriptButton.isSelected()) {
            results.add(Character.UnicodeScript.LATIN);
        }
        if (this.allowCommonScriptButton.isSelected()) {
            results.add(Character.UnicodeScript.COMMON);
        }
        return results;
    }

    private String getDefault(String optionName, String defaultValue) {
        ToolOptions stringOptions = this.tool.getOptions("Strings");
        return stringOptions.getString(optionName, defaultValue);
    }

    private StringTranslationService getDefaultTranslationService(List<StringTranslationService> translationServices) {
        String translationServiceName = this.getDefault("Default Translation Service Name", null);
        if (translationServiceName != null) {
            for (StringTranslationService sts : translationServices) {
                if (!translationServiceName.equals(sts.getTranslationServiceName())) continue;
                return sts;
            }
        }
        return null;
    }

    private StringTranslationService getSelectedStringTranslationService(boolean ifEnabled) {
        boolean enabled = this.showTranslateOptionsButton.isSelected();
        return ifEnabled && !enabled ? null : (StringTranslationService)this.translateComboBox.getSelectedItem();
    }

    private void saveDefaults() {
        if (this.currentOptions == null) {
            return;
        }
        ToolOptions stringOptions = this.tool.getOptions("Strings");
        stringOptions.setString("Default Charset", this.currentOptions.charsetName());
        StringTranslationService sts = this.getSelectedStringTranslationService(false);
        stringOptions.setString("Default Translation Service Name", sts != null ? sts.getTranslationServiceName() : null);
        stringOptions.setString("Default String Model Filename", this.trigramModelFilename);
    }

    private void comboboxItemListener(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.updateOptionsAndRefresh();
        }
    }

    private void checkboxItemListener(ItemEvent e) {
        this.updateOptionsAndRefresh();
    }

    private void updateRequiredScriptsList(EncodedStringsFilterStats stats) {
        this.requiredUnicodeScript.removeItemListener(this.itemListener);
        Character.UnicodeScript currentSelectedScript = (Character.UnicodeScript)((Object)this.requiredUnicodeScript.getSelectedItem());
        this.requiredUnicodeScript.setModel(this.getScriptListModel(stats));
        if (stats.foundScriptCounts.containsKey((Object)currentSelectedScript)) {
            this.requiredUnicodeScript.setSelectedItem((Object)currentSelectedScript);
        } else {
            this.requiredUnicodeScript.setSelectedItem((Object)CharacterScriptUtils.ANY_SCRIPT_ALIAS);
        }
        this.requiredUnicodeScript.addItemListener(this.itemListener);
    }

    private ComboBoxModel<Character.UnicodeScript> getScriptListModel(EncodedStringsFilterStats stats) {
        ArrayList<Character.UnicodeScript> scripts = new ArrayList<Character.UnicodeScript>(stats.foundScriptCounts.keySet());
        Collections.sort(scripts, (us1, us2) -> {
            int us1Count = stats.foundScriptCounts.get(us1);
            int us2Count = stats.foundScriptCounts.get(us2);
            return Integer.compare(us2Count, us1Count);
        });
        scripts.add(0, CharacterScriptUtils.ANY_SCRIPT_ALIAS);
        return new DefaultComboBoxModel<Character.UnicodeScript>(new Vector<Character.UnicodeScript>(scripts));
    }

    private boolean isSingleStringMode() {
        return this.selectedAddresses.getNumAddresses() == 1L;
    }

    private void executeMonitoredRunnable(String taskTitle, boolean canCancel, boolean hasProgress, int delay, final MonitoredRunnable runnable) {
        Task task = new Task(this, taskTitle, canCancel, hasProgress, false){

            public void run(TaskMonitor monitor) throws CancelledException {
                runnable.monitoredRun(monitor);
            }
        };
        this.executeProgressTask(task, delay);
    }

    private static String makeTitleString(AddressSetView addrs) {
        String addrRangeStr = !addrs.isEmpty() ? "(%s - %s)".formatted(addrs.getMinAddress(), addrs.getMaxAddress()) : "";
        return "Search For Encoded Strings - %s %s".formatted(EncodedStringsDialog.formatLength(addrs.getNumAddresses(), "addresses"), addrRangeStr);
    }

    private static boolean charsetExists(String charsetName) {
        try {
            Charset charset = Charset.forName(charsetName);
            return charset != null;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    private static String formatLength(long length, String unitSuffix) {
        int divisor = 1;
        String unitPrefix = "";
        if (length >= 1000L) {
            if (length < 1000000L) {
                divisor = 1000;
                unitPrefix = "K";
            } else {
                divisor = 1000000;
                unitPrefix = "M";
            }
        }
        return "%d%s %s".formatted(length / (long)divisor, unitPrefix, unitSuffix);
    }

    private class CharScriptComboBox
    extends GhidraComboBox<Character.UnicodeScript> {
        CharScriptComboBox() {
            super(List.of(CharacterScriptUtils.ANY_SCRIPT_ALIAS));
            Function<Character.UnicodeScript, String> cellToTextMappingFunction = unicodeScript -> {
                EncodedStringsDialog.this.buildScriptExamplesMap(this.getFont());
                if (unicodeScript == null) {
                    return "";
                }
                if (unicodeScript == CharacterScriptUtils.ANY_SCRIPT_ALIAS) {
                    return "<ANY>";
                }
                String name = unicodeScript.name();
                Object example = EncodedStringsDialog.this.scriptExampleStrings.getOrDefault(unicodeScript, "");
                if (!((String)example).isEmpty()) {
                    example = " \u2014 " + (String)example;
                }
                int count = EncodedStringsDialog.this.prevStats.foundScriptCounts.getOrDefault(unicodeScript, 0);
                return "%s%s (%d)".formatted(name, example, count);
            };
            this.setRenderer((ListCellRenderer)GListCellRenderer.createDefaultTextRenderer(cellToTextMappingFunction));
        }
    }
}

