/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.strings;

import docking.ComponentProvider;
import docking.widgets.table.GTableTextCellEditor;
import docking.widgets.table.threaded.ThreadedTableModelListener;
import generic.theme.GIcon;
import ghidra.app.plugin.core.strings.DefinedStringsContext;
import ghidra.app.plugin.core.strings.DefinedStringsPlugin;
import ghidra.app.plugin.core.strings.DefinedStringsTableModel;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.StringDataInstance;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraTableFilterPanel;
import ghidra.util.table.GhidraThreadedTablePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;

public class DefinedStringsProvider
extends ComponentProviderAdapter {
    public static final Icon ICON = new GIcon("icon.plugin.viewstrings.provider");
    private GhidraThreadedTablePanel<ProgramLocation> threadedTablePanel;
    private GhidraTableFilterPanel<ProgramLocation> filterPanel;
    private GhidraTable table;
    private DefinedStringsTableModel stringModel;
    private JComponent mainPanel;
    private Program currentProgram;
    private HelpLocation helpLocation;
    private AtomicReference<ProgramLocation> delayedShowProgramLocation = new AtomicReference();

    DefinedStringsProvider(DefinedStringsPlugin plugin) {
        super(plugin.getTool(), "Defined Strings", plugin.getName());
        this.mainPanel = this.createWorkPanel();
        this.setIcon(ICON);
        this.helpLocation = new HelpLocation(plugin.getName(), plugin.getName());
        this.addToTool();
    }

    public void componentHidden() {
        this.stringModel.reload(null);
    }

    public void componentShown() {
        this.stringModel.reload(this.currentProgram);
    }

    public DefinedStringsContext getActionContext(MouseEvent event) {
        return new DefinedStringsContext(this, this.table, this.stringModel);
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    public HelpLocation getHelpLocation() {
        return this.helpLocation;
    }

    void setProgram(Program program) {
        if (program == this.currentProgram) {
            return;
        }
        this.currentProgram = program;
        this.delayedShowProgramLocation.set(null);
        if (this.isVisible()) {
            this.stringModel.reload(program);
        }
    }

    void dispose() {
        this.currentProgram = null;
        this.removeFromTool();
        this.threadedTablePanel.dispose();
        this.filterPanel.dispose();
    }

    private JComponent createWorkPanel() {
        this.stringModel = new DefinedStringsTableModel(this.tool);
        this.threadedTablePanel = new GhidraThreadedTablePanel<ProgramLocation>(this.stringModel, 1000);
        this.table = this.threadedTablePanel.getTable();
        this.table.setPreferredScrollableViewportSize(new Dimension(350, 150));
        this.table.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                this.notifyContextChanged();
            }
        });
        this.stringModel.addTableModelListener(e -> {
            int rowCount = this.stringModel.getRowCount();
            int unfilteredCount = this.stringModel.getUnfilteredRowCount();
            this.setSubTitle("%d items%s".formatted(rowCount, rowCount != unfilteredCount ? " (of " + unfilteredCount + ")" : ""));
        });
        this.stringModel.addThreadedTableModelListener(new ThreadedTableModelListener(){

            public void loadingStarted() {
            }

            public void loadingFinished(boolean wasCancelled) {
                ProgramLocation delayedProgLoc;
                if (DefinedStringsProvider.this.stringModel.getRowCount() != 0 && (delayedProgLoc = (ProgramLocation)DefinedStringsProvider.this.delayedShowProgramLocation.getAndSet(null)) != null) {
                    DefinedStringsProvider.this.doShowProgramLocation(delayedProgLoc);
                }
            }

            public void loadPending() {
            }
        });
        TableColumn stringRepCol = this.table.getColumnModel().getColumn(DefinedStringsTableModel.COLUMNS.STRING_REP_COL.ordinal());
        stringRepCol.setCellEditor((TableCellEditor)((Object)new StringRepCellEditor()));
        this.table.installNavigation((ServiceProvider)this.tool);
        this.filterPanel = new GhidraTableFilterPanel((JTable)((Object)this.table), this.stringModel);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)((Object)this.threadedTablePanel), "Center");
        panel.add((Component)((Object)this.filterPanel), "South");
        String namePrefix = "Defined Strings";
        this.table.setAccessibleNamePrefix(namePrefix);
        this.filterPanel.setAccessibleNamePrefix(namePrefix);
        return panel;
    }

    private void notifyContextChanged() {
        this.tool.contextChanged((ComponentProvider)this);
    }

    void add(Data data) {
        if (this.isVisible()) {
            this.stringModel.addDataInstance(this.currentProgram, data);
        }
    }

    void remove(Address addr) {
        if (this.isVisible()) {
            this.stringModel.removeDataInstanceAt(addr);
        }
    }

    void remove(Address start, Address end) {
        if (this.isVisible()) {
            long count = end.subtract(start);
            for (long offset = 0L; offset < count; ++offset) {
                this.stringModel.removeDataInstanceAt(start.add(offset));
            }
        }
    }

    void reload() {
        if (this.isVisible()) {
            this.stringModel.reload();
        }
    }

    public GhidraTable getTable() {
        return this.table;
    }

    public DefinedStringsTableModel getModel() {
        return this.stringModel;
    }

    private void doShowProgramLocation(ProgramLocation pl) {
        ProgramLocation modelLocation = this.stringModel.findEquivProgramLocation(pl);
        if (modelLocation == null) {
            return;
        }
        int newRow = this.stringModel.getViewIndex(modelLocation);
        if (newRow < 0) {
            return;
        }
        this.table.selectRow(newRow);
        this.table.scrollToSelectedRow();
    }

    public void showProgramLocation(ProgramLocation loc) {
        if (loc == null) {
            return;
        }
        if (!this.stringModel.isBusy()) {
            this.doShowProgramLocation(loc);
        } else {
            this.delayedShowProgramLocation.set(loc);
        }
    }

    public Program getProgram() {
        return this.currentProgram;
    }

    private class StringRepCellEditor
    extends GTableTextCellEditor {
        private JTextField textField;

        StringRepCellEditor() {
            super(new JTextField());
            this.textField = (JTextField)super.getComponent();
        }

        public Object getCellEditorValue() {
            return this.textField.getText();
        }

        public Component getTableCellEditorComponent(JTable jTable, Object value, boolean isSelected, int rowIndex, int columnIndex) {
            Data data = DataUtilities.getDataAtLocation((ProgramLocation)((ProgramLocation)DefinedStringsProvider.this.stringModel.getRowObject(rowIndex)));
            if (data != null) {
                this.textField.setEditable(true);
                StringDataInstance sdi = StringDataInstance.getStringDataInstance((Data)data);
                if (sdi.isShowTranslation() && sdi.getTranslatedValue() != null) {
                    this.textField.setText(sdi.getTranslatedValue());
                } else {
                    this.textField.setText(sdi.getStringValue());
                }
            } else {
                this.textField.setEditable(false);
                this.textField.setText("unsupported");
            }
            return this.textField;
        }
    }
}

