/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.strings;

import docking.ComponentProvider;
import docking.DefaultActionContext;
import ghidra.app.context.DataLocationListContext;
import ghidra.app.plugin.core.strings.DefinedStringsProvider;
import ghidra.app.plugin.core.strings.DefinedStringsTableModel;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.table.GhidraTable;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public class DefinedStringsContext
extends DefaultActionContext
implements DataLocationListContext {
    private final DefinedStringsProvider viewStringsProvider;
    private final GhidraTable table;
    private final DefinedStringsTableModel tableModel;

    DefinedStringsContext(DefinedStringsProvider provider, GhidraTable table, DefinedStringsTableModel tableModel) {
        super((ComponentProvider)provider, (Component)((Object)table));
        this.viewStringsProvider = provider;
        this.table = table;
        this.tableModel = tableModel;
    }

    @Override
    public int getCount() {
        return this.table.getSelectedRowCount();
    }

    @Override
    public Program getProgram() {
        return this.viewStringsProvider.getProgram();
    }

    @Override
    public List<ProgramLocation> getDataLocationList() {
        return this.getDataLocationList(null);
    }

    @Override
    public List<ProgramLocation> getDataLocationList(Predicate<Data> filter) {
        int[] selectedRows;
        ArrayList<ProgramLocation> result = new ArrayList<ProgramLocation>();
        for (int row : selectedRows = this.table.getSelectedRows()) {
            ProgramLocation location = (ProgramLocation)this.tableModel.getRowObject(row);
            Data data = DataUtilities.getDataAtLocation((ProgramLocation)location);
            if (!this.passesFilter(data, filter)) continue;
            result.add(location);
        }
        return result;
    }

    private boolean passesFilter(Data data, Predicate<Data> filter) {
        if (data == null) {
            return false;
        }
        if (filter == null) {
            return true;
        }
        return filter.test(data);
    }

    ProgramSelection getProgramSelection() {
        return this.table.getProgramSelection();
    }

    public int getSelectedRowCount() {
        return this.table.getSelectedRowCount();
    }

    public Data getSelectedData() {
        int selectedRow = this.table.getSelectedRow();
        if (selectedRow < 0) {
            return null;
        }
        ProgramLocation location = (ProgramLocation)this.tableModel.getRowObject(selectedRow);
        return DataUtilities.getDataAtLocation((ProgramLocation)location);
    }
}

