/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.register;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.DockingUtils;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.cmd.register.SetRegisterCmd;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ListingContextAction;
import ghidra.app.context.ProgramLocationActionContext;
import ghidra.app.nav.Navigatable;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.register.RegisterManagerProvider;
import ghidra.app.plugin.core.register.SetRegisterValueDialog;
import ghidra.app.services.FieldMouseHandlerService;
import ghidra.app.services.ProgramManager;
import ghidra.app.util.viewer.field.FieldMouseHandler;
import ghidra.framework.cmd.Command;
import ghidra.framework.cmd.CompoundCmd;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.util.CodeUnitLocation;
import ghidra.program.util.OperandFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.RegisterFieldLocation;
import ghidra.program.util.RegisterTransitionFieldLocation;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Code Viewer", shortDescription="Manage register values", description="This plugin provides actions and a component for editing register values across address ranges in a program")
public class RegisterPlugin
extends ProgramPlugin {
    private DockingAction setRegisterAction;
    private RegisterManagerProvider registerMgrProvider;
    private Register[] registers = new Register[0];
    private DockingAction deleteRegisterRangeAction;
    private DockingAction deleteRegisterAtFunctionAction;
    private DockingAction clearRegisterAction;
    private FieldMouseHandlerService fieldMouseHandlerService;
    private RegisterTransitionFieldMouseHandler fieldMouseHandler;

    public RegisterPlugin(PluginTool tool) {
        super(tool);
    }

    protected void init() {
        this.registerMgrProvider = new RegisterManagerProvider(this.tool, this.getName());
        this.tool.addComponentProvider((ComponentProvider)this.registerMgrProvider, false);
        this.createActions();
        this.fieldMouseHandlerService = (FieldMouseHandlerService)this.tool.getService(FieldMouseHandlerService.class);
        this.fieldMouseHandler = new RegisterTransitionFieldMouseHandler();
        if (this.fieldMouseHandlerService != null) {
            this.fieldMouseHandlerService.addFieldMouseHandler(this.fieldMouseHandler);
        }
    }

    protected void dispose() {
        this.registerMgrProvider.dispose();
        super.dispose();
    }

    private void createActions() {
        this.setRegisterAction = new DockingAction("Set Register Values", this.getName()){

            public void actionPerformed(ActionContext actionContext) {
                ProgramLocationActionContext programActionContext = RegisterPlugin.this.getProgramActionContext(actionContext);
                RegisterPlugin.this.setRegisterValues(programActionContext);
            }

            public boolean isEnabledForContext(ActionContext context) {
                Object contextObject = context.getContextObject();
                return contextObject instanceof ListingActionContext || contextObject instanceof RegisterManagerProvider;
            }
        };
        this.setRegisterAction.setPopupMenuData(new MenuData(new String[]{"Set Register Values..."}, null, "Registers"));
        this.setRegisterAction.setKeyBindingData(new KeyBindingData(82, DockingUtils.CONTROL_KEY_MODIFIER_MASK));
        this.setRegisterAction.setDescription("Set register values in a program.");
        this.setRegisterAction.setHelpLocation(new HelpLocation("RegisterPlugin", "SetRegisterValues"));
        this.setRegisterAction.setEnabled(true);
        this.tool.addAction((DockingActionIf)this.setRegisterAction);
        this.clearRegisterAction = new DockingAction("Clear Register Values", this.getName()){

            public void actionPerformed(ActionContext actionContext) {
                ProgramLocationActionContext programActionContext = RegisterPlugin.this.getProgramActionContext(actionContext);
                RegisterPlugin.this.clearRegisterValues(programActionContext);
            }

            public boolean isEnabledForContext(ActionContext context) {
                Object contextObject = context.getContextObject();
                return contextObject instanceof ListingActionContext || contextObject instanceof RegisterManagerProvider;
            }
        };
        this.clearRegisterAction.setPopupMenuData(new MenuData(new String[]{"Clear Register Values..."}, null, "Registers"));
        this.clearRegisterAction.setDescription("Clear register values in a program.");
        this.clearRegisterAction.setHelpLocation(new HelpLocation("RegisterPlugin", "ClearRegisterValues"));
        this.clearRegisterAction.setEnabled(true);
        this.tool.addAction((DockingActionIf)this.clearRegisterAction);
        this.deleteRegisterRangeAction = new ListingContextAction("Delete Register Value Range", this.getName()){

            @Override
            public void actionPerformed(ListingActionContext context) {
                RegisterPlugin.this.deleteRegisterValueRange(context);
            }

            @Override
            public boolean isEnabledForContext(ListingActionContext context) {
                RegisterTransitionFieldLocation loc;
                if (context.getLocation() instanceof RegisterTransitionFieldLocation && (loc = (RegisterTransitionFieldLocation)context.getLocation()).getRegister() != null) {
                    Address addr = loc.getAddress();
                    Register reg = loc.getRegister();
                    RegisterValue regVal = context.getProgram().getProgramContext().getNonDefaultValue(reg, addr);
                    return regVal != null && regVal.hasValue();
                }
                return false;
            }
        };
        this.deleteRegisterRangeAction.setKeyBindingData(new KeyBindingData(127, 0));
        this.deleteRegisterRangeAction.setDescription("Delete register value at Function.");
        this.deleteRegisterRangeAction.setHelpLocation(new HelpLocation("RegisterPlugin", "DeleteRegisterValueRange"));
        this.deleteRegisterRangeAction.setEnabled(true);
        this.tool.addAction((DockingActionIf)this.deleteRegisterRangeAction);
        this.deleteRegisterAtFunctionAction = new ListingContextAction("Delete Register Value Range", this.getName()){

            @Override
            public void actionPerformed(ListingActionContext context) {
                RegisterPlugin.this.deleteRegisterValueAtFunction(context);
            }

            @Override
            public boolean isEnabledForContext(ListingActionContext context) {
                RegisterFieldLocation loc;
                if (context.getLocation() instanceof RegisterFieldLocation && (loc = (RegisterFieldLocation)context.getLocation()).getRegister() != null) {
                    Address addr = loc.getAddress();
                    Register reg = loc.getRegister();
                    RegisterValue regVal = context.getProgram().getProgramContext().getNonDefaultValue(reg, addr);
                    return regVal != null && regVal.hasValue();
                }
                return false;
            }
        };
        this.deleteRegisterAtFunctionAction.setPopupMenuData(new MenuData(new String[]{"Delete Register Value Range..."}, null, "Registers"));
        this.deleteRegisterAtFunctionAction.setKeyBindingData(new KeyBindingData(127, 0));
        this.deleteRegisterAtFunctionAction.setDescription("Delete register value range.");
        this.deleteRegisterAtFunctionAction.setHelpLocation(new HelpLocation("RegisterPlugin", "DeleteRegisterValueRange"));
        this.deleteRegisterAtFunctionAction.setEnabled(true);
        this.tool.addAction((DockingActionIf)this.deleteRegisterAtFunctionAction);
        this.registerMgrProvider.createActions();
    }

    private ProgramLocationActionContext getProgramActionContext(ActionContext actionContext) {
        if (actionContext.getContextObject() instanceof ListingActionContext) {
            return (ListingActionContext)actionContext.getContextObject();
        }
        return new ProgramLocationActionContext(null, this.currentProgram, this.currentLocation, this.currentSelection, null);
    }

    protected void deleteRegisterValueRange(ListingActionContext context) {
        RegisterTransitionFieldLocation location = (RegisterTransitionFieldLocation)context.getLocation();
        Register register = location.getRegister();
        Address addr = location.getAddress();
        ProgramContext programContext = context.getProgram().getProgramContext();
        AddressRangeIterator it = programContext.getRegisterValueAddressRanges(register);
        while (it.hasNext()) {
            AddressRange range = (AddressRange)it.next();
            if (!range.contains(addr)) continue;
            SetRegisterCmd cmd = new SetRegisterCmd(register, range.getMinAddress(), range.getMaxAddress(), null);
            if (!this.tool.execute((Command)cmd, (DomainObject)context.getProgram())) {
                Msg.showError((Object)((Object)this), (Component)this.tool.getToolFrame(), (String)"Register Context Error", (Object)cmd.getStatusMsg());
            }
            return;
        }
    }

    protected void deleteRegisterValueAtFunction(ListingActionContext context) {
        Address addr;
        RegisterFieldLocation location = (RegisterFieldLocation)context.getLocation();
        Register register = location.getRegister();
        SetRegisterCmd cmd = new SetRegisterCmd(register, addr = location.getAddress(), addr, null);
        if (!this.tool.execute((Command)cmd, (DomainObject)context.getProgram())) {
            Msg.showError((Object)((Object)this), (Component)this.tool.getToolFrame(), (String)"Register Context Error", (Object)cmd.getStatusMsg());
        }
    }

    protected Register getRegister(ProgramLocationActionContext context) {
        Program program = context.getProgram();
        ProgramLocation location = context.getLocation();
        if (location instanceof OperandFieldLocation) {
            OperandFieldLocation opLoc = (OperandFieldLocation)location;
            CodeUnit cu = program.getListing().getCodeUnitAt(opLoc.getAddress());
            if (cu instanceof Instruction) {
                Object[] opObjs;
                Instruction inst = (Instruction)cu;
                for (Object object : opObjs = inst.getOpObjects(opLoc.getOperandIndex())) {
                    if (!(object instanceof Register)) continue;
                    return (Register)object;
                }
            }
        }
        return null;
    }

    protected void setRegisterValues(ProgramLocationActionContext context) {
        Register register = this.getRegister(context);
        AddressSetView addrSet = this.getAddressSet(context);
        if (register == null) {
            register = this.registerMgrProvider.getSelectedRegister();
        }
        this.setRegisterValues(context, register, addrSet, true);
    }

    void clearRegisterValues(ProgramLocationActionContext context) {
        Register register = this.getRegister(context);
        AddressSetView addrSet = this.getAddressSet(context);
        if (register == null) {
            register = this.registerMgrProvider.getSelectedRegister();
        }
        SetRegisterValueDialog dialog = new SetRegisterValueDialog(context.getProgram(), this.registers, register, addrSet, false);
        this.tool.showDialog((DialogComponentProvider)dialog);
        Register selectedRegister = dialog.getSelectRegister();
        if (selectedRegister != null) {
            this.applyRegisterValues(context.getProgram(), selectedRegister, null, addrSet);
        }
    }

    void setRegisterValues(ProgramLocationActionContext context, Register register, AddressSetView addrSet, boolean selectRegister) {
        SetRegisterValueDialog dialog = new SetRegisterValueDialog(context.getProgram(), this.registers, register, addrSet, true);
        this.tool.showDialog((DialogComponentProvider)dialog);
        BigInteger value = dialog.getRegisterValue();
        Register selectedRegister = dialog.getSelectRegister();
        if (value != null && selectedRegister != null) {
            this.applyRegisterValues(context.getProgram(), selectedRegister, value, addrSet);
            if (selectRegister) {
                this.registerMgrProvider.selectRegister(selectedRegister);
            }
        }
    }

    private AddressSetView getAddressSet(ProgramLocationActionContext context) {
        if (context.hasSelection()) {
            return context.getSelection();
        }
        if (context.getAddress() != null) {
            Address address = context.getAddress();
            return new AddressSet(address, address);
        }
        return new AddressSet();
    }

    @Override
    protected void programActivated(Program program) {
        this.registerMgrProvider.setProgram(program);
        ArrayList<Register> list = new ArrayList<Register>();
        for (Register reg : program.getProgramContext().getRegisters()) {
            if (reg.isHidden()) continue;
            list.add(reg);
        }
        Collections.sort(list);
        this.registers = new Register[list.size()];
        this.registers = list.toArray(this.registers);
    }

    @Override
    protected void programDeactivated(Program program) {
        this.registerMgrProvider.setProgram(null);
        this.registers = new Register[0];
    }

    @Override
    protected void locationChanged(ProgramLocation loc) {
        RegisterFieldLocation regLoc;
        Register reg;
        if (loc instanceof RegisterTransitionFieldLocation) {
            RegisterTransitionFieldLocation regLoc2 = (RegisterTransitionFieldLocation)loc;
            Register reg2 = regLoc2.getRegister();
            if (reg2 != null) {
                this.registerMgrProvider.setLocation(reg2, regLoc2.getAddress());
            }
        } else if (loc instanceof RegisterFieldLocation && (reg = (regLoc = (RegisterFieldLocation)loc).getRegister()) != null) {
            this.registerMgrProvider.setLocation(reg, regLoc.getAddress());
        }
        if (loc instanceof CodeUnitLocation) {
            this.registerMgrProvider.setLocation(null, loc.getAddress());
        }
    }

    private void applyRegisterValues(Program program, Register register, BigInteger value, AddressSetView addressSet) {
        if (program == null || addressSet.isEmpty()) {
            return;
        }
        CompoundCmd cmd = new CompoundCmd("Set Register Values");
        for (AddressRange range : addressSet) {
            SetRegisterCmd regCmd = new SetRegisterCmd(register, range.getMinAddress(), range.getMaxAddress(), value);
            cmd.add((Command)regCmd);
        }
        if (!this.tool.execute((Command)cmd, (DomainObject)program)) {
            Msg.showError((Object)((Object)this), (Component)this.tool.getToolFrame(), (String)"Register Context Error", (Object)cmd.getStatusMsg());
        }
    }

    public void serviceAdded(Class<?> interfaceClass, Object service) {
        super.serviceAdded(interfaceClass, service);
        if (interfaceClass == FieldMouseHandlerService.class && this.fieldMouseHandlerService == null) {
            this.fieldMouseHandlerService = (FieldMouseHandlerService)service;
            this.fieldMouseHandlerService.addFieldMouseHandler(this.fieldMouseHandler);
        }
    }

    public void serviceRemoved(Class<?> interfaceClass, Object service) {
        if (interfaceClass == FieldMouseHandlerService.class && this.fieldMouseHandlerService != null && this.fieldMouseHandlerService == service && this.fieldMouseHandler != null) {
            this.fieldMouseHandlerService = null;
        }
        super.serviceRemoved(interfaceClass, service);
    }

    class RegisterTransitionFieldMouseHandler
    implements FieldMouseHandler {
        RegisterTransitionFieldMouseHandler() {
        }

        @Override
        public boolean fieldElementClicked(Object clickedObject, Navigatable sourceNavigatable, ProgramLocation location, MouseEvent mouseEvent, ServiceProvider serviceProvider) {
            if (mouseEvent.getClickCount() != 2) {
                return false;
            }
            Register reg = null;
            if (location instanceof RegisterTransitionFieldLocation) {
                loc = (RegisterTransitionFieldLocation)location;
                reg = loc.getRegister();
            } else if (location instanceof RegisterFieldLocation) {
                loc = (RegisterFieldLocation)location;
                reg = loc.getRegister();
            }
            ProgramManager programManager = (ProgramManager)serviceProvider.getService(ProgramManager.class);
            if (programManager == null) {
                return false;
            }
            Program activeProgram = programManager.getCurrentProgram();
            if (reg != null && activeProgram == sourceNavigatable.getProgram()) {
                RegisterPlugin.this.tool.showComponentProvider((ComponentProvider)RegisterPlugin.this.registerMgrProvider, true);
                RegisterPlugin.this.registerMgrProvider.setLocation(reg, location.getAddress());
            }
            return true;
        }

        @Override
        public Class<?>[] getSupportedProgramLocations() {
            return new Class[]{RegisterTransitionFieldLocation.class, RegisterFieldLocation.class};
        }
    }
}

