/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.navigation;

import docking.DockingUtils;
import generic.theme.GIcon;
import ghidra.app.plugin.core.navigation.AbstractNextPreviousAction;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitIterator;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public class NextPreviousLabelAction
extends AbstractNextPreviousAction {
    private static final Icon ICON = new GIcon("icon.plugin.navigation.label");

    public NextPreviousLabelAction(PluginTool tool, String owner, String subGroup) {
        super(tool, "Next Label", owner, subGroup);
    }

    @Override
    protected Icon getIcon() {
        return ICON;
    }

    @Override
    protected KeyStroke getKeyStroke() {
        return KeyStroke.getKeyStroke(76, DockingUtils.CONTROL_KEY_MODIFIER_MASK | 0x200);
    }

    @Override
    protected String getNavigationTypeName() {
        return "Label";
    }

    @Override
    protected Address getNextAddress(TaskMonitor monitor, Program program, Address address) throws CancelledException {
        if (this.isInverted) {
            return this.getNextNonLabel(monitor, program, address);
        }
        address = this.getAddressOfNextCodeUnit(program, address);
        return this.getAddressOfNextPreviousLabel(program, address, true);
    }

    @Override
    protected Address getPreviousAddress(TaskMonitor monitor, Program program, Address address) throws CancelledException {
        if (this.isInverted) {
            return this.getPreviousNonLabel(monitor, program, address);
        }
        address = this.getAddressOfPreviousCodeUnit(program, address);
        return this.getAddressOfNextPreviousLabel(program, address, false);
    }

    private Address getNextNonLabel(TaskMonitor monitor, Program program, Address address) throws CancelledException {
        if (!this.hasLabelAt(program, address)) {
            address = this.getAddressOfNextPreviousLabel(program, address, true);
        }
        return this.getAddressOfNextPreviousNonLabel(monitor, program, address, true);
    }

    private Address getPreviousNonLabel(TaskMonitor monitor, Program program, Address address) throws CancelledException {
        if (!this.hasLabelAt(program, address)) {
            address = this.getAddressOfNextPreviousLabel(program, address, false);
        }
        return this.getAddressOfNextPreviousNonLabel(monitor, program, address, false);
    }

    private Address getAddressOfNextPreviousNonLabel(TaskMonitor monitor, Program program, Address address, boolean forward) throws CancelledException {
        if (address == null) {
            return null;
        }
        SymbolTable symbolTable = program.getSymbolTable();
        CodeUnitIterator codeUnits = program.getListing().getCodeUnits(address, forward);
        while (codeUnits.hasNext()) {
            monitor.checkCancelled();
            CodeUnit codeUnit = codeUnits.next();
            Address minAddress = codeUnit.getMinAddress();
            if (symbolTable.getPrimarySymbol(minAddress) != null) continue;
            return minAddress;
        }
        return null;
    }

    private boolean hasLabelAt(Program program, Address address) {
        SymbolTable symbolTable = program.getSymbolTable();
        return symbolTable.getPrimarySymbol(address) != null;
    }

    private Address getAddressOfNextCodeUnit(Program program, Address address) {
        CodeUnit cu = program.getListing().getCodeUnitAfter(address);
        if (cu == null) {
            return null;
        }
        return cu.getAddress();
    }

    private Address getAddressOfPreviousCodeUnit(Program program, Address address) {
        CodeUnit cu = program.getListing().getCodeUnitBefore(address);
        if (cu == null) {
            return null;
        }
        return cu.getAddress();
    }

    private Address getAddressOfNextPreviousLabel(Program program, Address address, boolean forward) {
        if (address == null) {
            return null;
        }
        Address nextDefinedLableAddress = this.getNextDefinedLableAddress(program, address, forward);
        Address nextReferenceToAddress = this.getNextReferenceToAddress(program, address, forward);
        if (nextDefinedLableAddress == null) {
            return nextReferenceToAddress;
        }
        if (nextReferenceToAddress == null) {
            return nextDefinedLableAddress;
        }
        int compare = nextDefinedLableAddress.compareTo((Object)nextReferenceToAddress);
        if (forward) {
            return compare <= 0 ? nextDefinedLableAddress : nextReferenceToAddress;
        }
        return compare >= 0 ? nextDefinedLableAddress : nextReferenceToAddress;
    }

    private Address getNextReferenceToAddress(Program program, Address address, boolean forward) {
        ReferenceManager referenceManager = program.getReferenceManager();
        AddressIterator it = referenceManager.getReferenceDestinationIterator(address, forward);
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }

    private Address getNextDefinedLableAddress(Program program, Address address, boolean forward) {
        SymbolTable symbolTable = program.getSymbolTable();
        SymbolIterator it = symbolTable.getSymbolIterator(address, forward);
        if (it.hasNext()) {
            return it.next().getAddress();
        }
        return null;
    }
}

