/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.marker;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.action.ToggleDockingAction;
import ghidra.app.nav.Navigatable;
import ghidra.app.plugin.core.marker.MarkerManager;
import ghidra.app.plugin.core.marker.MarkerSetImpl;
import ghidra.app.plugin.core.marker.NavigationPanel;
import ghidra.app.util.viewer.listingpanel.ListingOverviewProvider;
import ghidra.app.util.viewer.util.AddressIndexMap;
import ghidra.framework.options.Options;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.Swing;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class MarkerOverviewProvider
implements ListingOverviewProvider {
    private final PluginTool tool;
    private final String owner;
    private final MarkerManager markerManager;
    private final NavigationPanel navigationPanel;
    private final MarkerActionList actionList;
    private Program program;

    MarkerOverviewProvider(String owner, PluginTool tool, final MarkerManager markerManager) {
        this.tool = tool;
        this.owner = owner;
        this.markerManager = markerManager;
        this.navigationPanel = new NavigationPanel(markerManager);
        this.navigationPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                markerManager.updateMarkerSets(MarkerOverviewProvider.this.program, false, true, true);
            }
        });
        this.actionList = new MarkerActionList();
    }

    @Override
    public void dispose() {
        this.actionList.dispose();
    }

    public void repaintPanel() {
        this.navigationPanel.repaint();
    }

    @Override
    public JComponent getComponent() {
        return this.navigationPanel;
    }

    @Override
    public void screenDataChanged(Program p, AddressIndexMap addressMap) {
        this.program = p;
        this.navigationPanel.setProgram(p, addressMap);
        this.markerManager.updateMarkerSets(p, true, true, false);
        this.actionList.refresh();
    }

    @Override
    public void setNavigatable(Navigatable navigatable) {
        this.navigationPanel.setNavigatable(navigatable);
    }

    void refreshActionList(Program p) {
        if (this.program != p) {
            return;
        }
        this.actionList.refresh();
    }

    private class MarkerActionList
    implements OptionsChangeListener {
        private final List<DockingAction> actions = new ArrayList<DockingAction>();
        private ToolOptions listOptions;

        MarkerActionList() {
            this.initOptions();
            this.refresh();
        }

        private void initOptions() {
            this.listOptions = MarkerOverviewProvider.this.tool.getOptions("Navigation Markers");
            this.listOptions.removeOptionsChangeListener((OptionsChangeListener)this);
            this.listOptions.addOptionsChangeListener((OptionsChangeListener)this);
        }

        public void optionsChanged(ToolOptions options, String name, Object oldValue, Object newValue) {
            for (DockingAction action : this.actions) {
                if (action instanceof ActivateMarkerAction) {
                    ((ActivateMarkerAction)action).optionsChanged();
                }
                if (!(action instanceof ActivateMarkerGroupAction)) continue;
                ((ActivateMarkerGroupAction)action).optionsChanged();
            }
        }

        void refresh() {
            Swing.runLater(this::doRefresh);
        }

        private void doRefresh() {
            ToggleDockingAction action;
            for (DockingAction action2 : this.actions) {
                MarkerOverviewProvider.this.tool.removeAction((DockingActionIf)action2);
            }
            this.actions.clear();
            if (MarkerOverviewProvider.this.program == null || MarkerOverviewProvider.this.program.isClosed()) {
                return;
            }
            List<MarkerSetImpl> list = MarkerOverviewProvider.this.markerManager.copyMarkerSets(MarkerOverviewProvider.this.program);
            List<List<MarkerSetImpl>> groupsList = this.extractManagerGroups(list);
            Collections.sort(groupsList, (ms1, ms2) -> ((MarkerSetImpl)ms1.get(0)).getName().compareTo(((MarkerSetImpl)ms2.get(0)).getName()));
            for (List<MarkerSetImpl> group : groupsList) {
                action = new ActivateMarkerGroupAction(MarkerOverviewProvider.this.owner, group, MarkerOverviewProvider.this.navigationPanel, (Options)this.listOptions);
                this.actions.add((DockingAction)action);
                MarkerOverviewProvider.this.tool.addAction((DockingActionIf)action);
            }
            Collections.sort(list, (ms1, ms2) -> ms1.getName().compareTo(ms2.getName()));
            for (MarkerSetImpl mgr : list) {
                action = new ActivateMarkerAction(MarkerOverviewProvider.this.owner, mgr, MarkerOverviewProvider.this.navigationPanel, (Options)this.listOptions);
                this.actions.add((DockingAction)action);
                MarkerOverviewProvider.this.tool.addAction((DockingActionIf)action);
            }
            MarkerOverviewProvider.this.navigationPanel.repaint();
        }

        private List<List<MarkerSetImpl>> extractManagerGroups(List<MarkerSetImpl> fromList) {
            HashMap<String, ArrayList<MarkerSetImpl>> nameToManagerMap = new HashMap<String, ArrayList<MarkerSetImpl>>();
            Iterator<MarkerSetImpl> iterator = fromList.iterator();
            while (iterator.hasNext()) {
                MarkerSetImpl markerSetImpl = iterator.next();
                String name = markerSetImpl.getName();
                ArrayList<MarkerSetImpl> subList = (ArrayList<MarkerSetImpl>)nameToManagerMap.get(name);
                if (subList == null) {
                    subList = new ArrayList<MarkerSetImpl>();
                    nameToManagerMap.put(name, subList);
                }
                subList.add(markerSetImpl);
                iterator.remove();
            }
            ArrayList<List<MarkerSetImpl>> groupList = new ArrayList<List<MarkerSetImpl>>(fromList.size());
            Set entrySet = nameToManagerMap.entrySet();
            for (Map.Entry entry : entrySet) {
                List listValue = (List)entry.getValue();
                if (listValue.size() == 1) {
                    fromList.add((MarkerSetImpl)listValue.get(0));
                    continue;
                }
                groupList.add(listValue);
            }
            return groupList;
        }

        void dispose() {
            this.listOptions.removeOptionsChangeListener((OptionsChangeListener)this);
            this.actions.forEach(a -> MarkerOverviewProvider.this.tool.removeAction((DockingActionIf)a));
        }
    }

    private static class ActivateMarkerGroupAction
    extends ToggleDockingAction {
        private List<MarkerSetImpl> markerSets;
        private NavigationPanel panel;
        private Options options;

        ActivateMarkerGroupAction(String owner, List<MarkerSetImpl> managerList, NavigationPanel panel, Options options) {
            super(managerList.get(0).getName(), owner);
            this.markerSets = managerList;
            this.panel = panel;
            this.options = options;
            HelpLocation helpLocation = new HelpLocation("CodeBrowserPlugin", "Markers");
            options.registerOption(this.getName(), (Object)true, helpLocation, "This options enables/disables the display of " + this.getName() + " marker types.");
            this.setEnabled(true);
            this.setSelected(this.isActive());
            ImageIcon icon = managerList.get(0).getNavIcon();
            this.setPopupMenuData(new MenuData(new String[]{this.getName()}, (Icon)icon));
            boolean isEnabled = this.isOptionEnabled();
            this.setSelected(isEnabled);
            this.setActive(isEnabled);
            this.setHelpLocation(helpLocation);
        }

        private void setActive(boolean active) {
            for (MarkerSetImpl manager : this.markerSets) {
                manager.setActive(active);
            }
        }

        private boolean isActive() {
            return this.markerSets.stream().anyMatch(markers -> markers.isActive());
        }

        public boolean isEnabledForContext(ActionContext context) {
            Object contextObject = context.getContextObject();
            return contextObject == this.panel;
        }

        void optionsChanged() {
            boolean selected = this.isOptionEnabled();
            if (selected != this.isSelected()) {
                this.setSelected(selected);
                this.setActive(selected);
            }
        }

        private boolean isOptionEnabled() {
            return this.options.getBoolean(this.getName(), true);
        }

        public void actionPerformed(ActionContext context) {
            this.options.setBoolean(this.getName(), this.isSelected());
            this.setActive(this.isSelected());
        }
    }

    private static class ActivateMarkerAction
    extends ToggleDockingAction {
        private MarkerSetImpl markers;
        private NavigationPanel panel;
        private Options options;

        ActivateMarkerAction(String owner, MarkerSetImpl markers, NavigationPanel panel, Options options) {
            super(markers.getName(), owner);
            this.markers = markers;
            this.panel = panel;
            this.options = options;
            HelpLocation helpLocation = new HelpLocation("CodeBrowserPlugin", "Markers");
            options.registerOption(markers.getName(), (Object)true, helpLocation, "This options enables/disables the display of " + markers.getName() + " marker types.");
            this.setEnabled(true);
            this.setSelected(markers.active);
            this.setPopupMenuData(new MenuData(new String[]{markers.getName()}, (Icon)markers.getNavIcon(), null));
            boolean isEnabled = this.isOptionEnabled();
            this.setSelected(isEnabled);
            markers.setActive(isEnabled);
            HelpLocation location = new HelpLocation("CodeBrowserPlugin", "Markers");
            this.setHelpLocation(location);
        }

        public boolean isEnabledForContext(ActionContext context) {
            Object contextObject = context.getContextObject();
            return contextObject == this.panel;
        }

        void optionsChanged() {
            boolean selected = this.isOptionEnabled();
            if (selected != this.isSelected()) {
                this.setSelected(selected);
                this.markers.setActive(selected);
            }
        }

        private boolean isOptionEnabled() {
            return this.options.getBoolean(this.markers.getName(), true);
        }

        public void actionPerformed(ActionContext context) {
            this.options.setBoolean(this.markers.getName(), this.isSelected());
            this.markers.setActive(this.isSelected());
        }
    }
}

