/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.widgets.dialogs.NumberRangeInputDialog;
import docking.widgets.tree.GTreeFilterProvider;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.support.GTreeFilter;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypesProvider;
import ghidra.app.plugin.core.datamgr.actions.SecondaryTreeFilterProvider;
import ghidra.app.plugin.core.datamgr.tree.DataTypeArchiveGTree;
import ghidra.app.plugin.core.datamgr.tree.DataTypeNode;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Enum;
import ghidra.util.HelpLocation;
import ghidra.util.datastruct.Range;
import ghidra.util.datastruct.SortedRangeList;
import java.util.Iterator;
import util.CollectionUtils;

public class FindEnumsByValueAction
extends DockingAction {
    public static final String NAME = "Find Enums by Value";
    private DataTypeManagerPlugin plugin;

    public FindEnumsByValueAction(DataTypeManagerPlugin plugin, String menuSubGroup) {
        super(NAME, plugin.getName());
        this.plugin = plugin;
        this.setMenuBarData(new MenuData(new String[]{"Find Enums by Value..."}, null, "VeryLast", -1, menuSubGroup));
        this.setHelpLocation(new HelpLocation("DataTypeManagerPlugin", "Find_Enums_By_Value"));
    }

    public void actionPerformed(ActionContext context) {
        NumberRangeInputDialog inputDialog = new NumberRangeInputDialog(NAME, "Values(s)");
        inputDialog.setHelpLocation(this.getHelpLocation());
        if (!inputDialog.show()) {
            return;
        }
        SortedRangeList values = inputDialog.getValue();
        DataTypesProvider newProvider = this.plugin.createProvider();
        newProvider.setTitle(NAME);
        DataTypeArchiveGTree tree = newProvider.getGTree();
        tree.setFilterProvider((GTreeFilterProvider)new SecondaryTreeFilterProvider(tree, new OffsetGTreeFilter(this, values)));
        newProvider.setVisible(true);
    }

    private class OffsetGTreeFilter
    implements GTreeFilter {
        private final SortedRangeList offsets;

        OffsetGTreeFilter(FindEnumsByValueAction findEnumsByValueAction, SortedRangeList offsets) {
            this.offsets = offsets;
        }

        public boolean showFilterMatches() {
            return true;
        }

        public boolean acceptsNode(GTreeNode node) {
            if (!(node instanceof DataTypeNode)) {
                return false;
            }
            DataTypeNode dataTypeNode = (DataTypeNode)node;
            DataType dataType = dataTypeNode.getDataType();
            if (!(dataType instanceof Enum)) {
                return false;
            }
            Enum enuum = (Enum)dataType;
            OffsetIterator it = new OffsetIterator(this, enuum);
            block0: for (Long value : CollectionUtils.asIterable((Iterator)it)) {
                for (Range range : this.offsets) {
                    int offset;
                    if (range.contains(offset = value.intValue())) {
                        return true;
                    }
                    if (offset >= range.min) continue;
                    continue block0;
                }
            }
            return false;
        }

        private class OffsetIterator
        implements Iterator<Long> {
            private int index = 0;
            private int length;
            private long[] values;

            OffsetIterator(OffsetGTreeFilter offsetGTreeFilter, Enum enuum) {
                this.values = enuum.getValues();
                this.length = this.values.length;
            }

            @Override
            public boolean hasNext() {
                return this.index < this.length;
            }

            @Override
            public Long next() {
                return this.values[this.index++];
            }
        }
    }
}

