/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypesActionContext;
import javax.swing.tree.TreePath;
import resources.Icons;

public class ExpandAllAction
extends DockingAction {
    public ExpandAllAction(DataTypeManagerPlugin plugin) {
        super("Expand All", plugin.getName());
        this.setPopupMenuData(new MenuData(new String[]{"Expand"}, Icons.EXPAND_ALL_ICON, "Tree"));
        this.setKeyBindingData(new KeyBindingData(40, 512));
        this.setEnabled(true);
        this.setDescription("Recursively expand all selected nodes.");
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (!(context instanceof DataTypesActionContext)) {
            return false;
        }
        Object contextObject = context.getContextObject();
        GTree gtree = (GTree)contextObject;
        TreePath[] selectionPaths = gtree.getSelectionPaths();
        if (selectionPaths.length == 0) {
            return false;
        }
        for (TreePath path : selectionPaths) {
            GTreeNode node = (GTreeNode)path.getLastPathComponent();
            if (!node.isLeaf()) continue;
            return false;
        }
        return true;
    }

    public void actionPerformed(ActionContext context) {
        TreePath[] selectionPaths;
        GTree gTree = (GTree)context.getContextObject();
        for (TreePath path : selectionPaths = gTree.getSelectionPaths()) {
            GTreeNode node = (GTreeNode)path.getLastPathComponent();
            gTree.expandTree(node);
        }
    }
}

