/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.clipboard;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.DockingUtils;
import docking.DockingWindowManager;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.action.ToolBarData;
import docking.dnd.GClipboard;
import docking.dnd.StringTransferable;
import generic.theme.GIcon;
import ghidra.app.context.ListingActionContext;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.clipboard.CopyPasteSpecialDialog;
import ghidra.app.services.ClipboardContentProviderService;
import ghidra.app.services.ClipboardService;
import ghidra.app.util.ClipboardType;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.bean.opteditor.OptionsVetoException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.event.ChangeListener;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Common", shortDescription="Clipboard Manager", description="This plugin manages cut/copy/paste of labels, comments, formatted code, and byte strings to and from the system clipboard.", servicesProvided={ClipboardService.class})
public class ClipboardPlugin
extends ProgramPlugin
implements ClipboardOwner,
ClipboardService,
OptionsChangeListener {
    public static final String GROUP_NAME = "Clipboard";
    public static final String TOOLBAR_GROUP_NAME = "ZClipboard";
    static final String REMOVE_QUOTES_OPTION = "Copy Strings Without Quotes";
    private ClipboardContentProviderService clipboardOwnerProvider;
    private Map<ClipboardContentProviderService, List<DockingAction>> serviceActionMap = new HashMap<ClipboardContentProviderService, List<DockingAction>>();
    private Map<ClipboardContentProviderService, ClipboardType> lastUsedCopySpecialType = new HashMap<ClipboardContentProviderService, ClipboardType>();
    private ChangeListener changeListener = e -> {
        this.updateCopyState();
        this.updatePasteState();
    };
    private boolean isClipboardOwner;
    private boolean removeQuotes;

    public ClipboardPlugin(PluginTool tool) {
        super(tool);
        this.initOptions();
    }

    private void initOptions() {
        ToolOptions options = this.tool.getOptions("Tool");
        options.registerOption(REMOVE_QUOTES_OPTION, (Object)false, null, "If true, copying strings to the clipboard will remove outer quotes");
        this.removeQuotes = options.getBoolean(REMOVE_QUOTES_OPTION, false);
        options.addOptionsChangeListener((OptionsChangeListener)this);
    }

    public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) throws OptionsVetoException {
        if (optionName.equals(REMOVE_QUOTES_OPTION)) {
            this.removeQuotes = options.getBoolean(REMOVE_QUOTES_OPTION, false);
        }
    }

    protected void dispose() {
        this.removeAllActions();
        this.clearClipboardContents();
        super.dispose();
    }

    @Override
    protected void programDeactivated(Program program) {
        if (this.clipboardOwnerProvider != null) {
            this.clipboardOwnerProvider.lostOwnership(null);
        }
        this.clipboardOwnerProvider = null;
    }

    @Override
    public void registerClipboardContentProvider(ClipboardContentProviderService service) {
        this.initializeLocalActions(service);
        service.addChangeListener(this.changeListener);
    }

    @Override
    public void deRegisterClipboardContentProvider(ClipboardContentProviderService service) {
        List<DockingAction> actionList = this.serviceActionMap.get(service);
        if (actionList != null) {
            this.removeLocalActions(service, actionList);
        }
        this.serviceActionMap.remove(service);
        service.removeChangeListener(this.changeListener);
    }

    private void initializeLocalActions(ClipboardContentProviderService clipboardService) {
        List<DockingAction> list = this.serviceActionMap.get(clipboardService);
        if (list != null) {
            return;
        }
        List<DockingAction> actionList = this.createActions(clipboardService);
        this.serviceActionMap.put(clipboardService, actionList);
        this.addLocalActions(clipboardService, actionList);
    }

    private void addLocalActions(ClipboardContentProviderService clipboardService, List<DockingAction> actionList) {
        ComponentProvider componentProvider = clipboardService.getComponentProvider();
        for (DockingAction pluginAction : actionList) {
            this.tool.addLocalAction(componentProvider, (DockingActionIf)pluginAction);
        }
    }

    private void removeLocalActions(ClipboardContentProviderService clipboardService, List<DockingAction> actionList) {
        if (this.tool == null) {
            return;
        }
        ComponentProvider componentProvider = clipboardService.getComponentProvider();
        for (DockingAction pluginAction : actionList) {
            this.tool.removeLocalAction(componentProvider, (DockingActionIf)pluginAction);
        }
    }

    private void removeAllActions() {
        Set<Map.Entry<ClipboardContentProviderService, List<DockingAction>>> entrySet = this.serviceActionMap.entrySet();
        for (Map.Entry<ClipboardContentProviderService, List<DockingAction>> entry : entrySet) {
            ClipboardContentProviderService clipboardService = entry.getKey();
            List<DockingAction> actionList = entry.getValue();
            this.removeLocalActions(clipboardService, actionList);
        }
    }

    private List<DockingAction> createActions(ClipboardContentProviderService clipboardService) {
        ArrayList<DockingAction> actionList = new ArrayList<DockingAction>(5);
        if (clipboardService.enableCopy()) {
            actionList.add(new CopyAction(clipboardService));
        }
        if (clipboardService.enableCopySpecial()) {
            actionList.add(new CopySpecialAction(clipboardService));
            actionList.add(new CopySpecialAgainAction(clipboardService));
        }
        if (clipboardService.enablePaste()) {
            actionList.add(new PasteAction(clipboardService));
        }
        return actionList;
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
        if (this.clipboardOwnerProvider != null) {
            this.clipboardOwnerProvider.lostOwnership(contents);
        }
        this.clipboardOwnerProvider = null;
        this.updatePasteState();
    }

    private void setClipboardContents(Clipboard systemClipboard, Transferable transferable) {
        systemClipboard.setContents(transferable, this);
        this.isClipboardOwner = true;
    }

    private void clearClipboardContents() {
        if (this.isClipboardOwner) {
            this.isClipboardOwner = false;
            Clipboard systemClipboard = this.getSystemClipboard();
            systemClipboard.setContents(new DummyTransferable(), (clipboard, contents) -> {});
        }
    }

    private void updateCopyState() {
        Set<Map.Entry<ClipboardContentProviderService, List<DockingAction>>> entrySet = this.serviceActionMap.entrySet();
        for (Map.Entry<ClipboardContentProviderService, List<DockingAction>> entry : entrySet) {
            ClipboardContentProviderService clipboardService = entry.getKey();
            List<DockingAction> actionList = entry.getValue();
            for (DockingAction pluginAction : actionList) {
                if (!(pluginAction instanceof ICopy)) continue;
                pluginAction.setEnabled(clipboardService.canCopy());
            }
        }
    }

    private void updatePasteState() {
        if (this.tool == null) {
            return;
        }
        JFrame toolFrame = this.tool.getToolFrame();
        if (toolFrame == null) {
            return;
        }
        Clipboard systemClipboard = this.getSystemClipboard();
        DataFlavor[] availableDataFlavors = ClipboardPlugin.getAvailableDataFlavors(systemClipboard);
        Set<Map.Entry<ClipboardContentProviderService, List<DockingAction>>> entrySet = this.serviceActionMap.entrySet();
        for (Map.Entry<ClipboardContentProviderService, List<DockingAction>> entry : entrySet) {
            ClipboardContentProviderService clipboardService = entry.getKey();
            List<DockingAction> actionList = entry.getValue();
            for (DockingAction pluginAction : actionList) {
                if (!(pluginAction instanceof IPaste)) continue;
                pluginAction.setEnabled(clipboardService.canPaste(availableDataFlavors));
            }
        }
    }

    private void copy(final ClipboardContentProviderService clipboardService) {
        Task copyTask = new Task("Copying", true, false, true){

            public void run(TaskMonitor monitor) {
                monitor.setMessage("Setting Clipboard Contents");
                Clipboard systemClipboard = ClipboardPlugin.this.getSystemClipboard();
                Transferable transferable = clipboardService.copy(monitor);
                if (ClipboardPlugin.this.removeQuotes && transferable instanceof StringTransferable) {
                    StringTransferable stringTransferable = (StringTransferable)transferable;
                    stringTransferable.removeOuterQuotesAndStandardStringPrefix();
                }
                if (transferable == null) {
                    return;
                }
                if (ClipboardPlugin.this.clipboardOwnerProvider != null) {
                    ClipboardPlugin.this.clipboardOwnerProvider.lostOwnership(null);
                }
                ClipboardPlugin.this.setClipboardContents(systemClipboard, transferable);
                ClipboardPlugin.this.clipboardOwnerProvider = clipboardService;
                ClipboardPlugin.this.updatePasteState();
            }
        };
        new TaskLauncher(copyTask, (Component)clipboardService.getComponentProvider().getComponent(), 250);
    }

    private void paste(ClipboardContentProviderService clipboardService) {
        DockingWindowManager windowManager = DockingWindowManager.getActiveInstance();
        Window activeWindow = windowManager.getActiveWindow();
        Clipboard systemClipboard = this.getSystemClipboard();
        new TaskLauncher((Task)new PasteTask(systemClipboard, clipboardService), (Component)activeWindow);
        this.clipboardOwnerProvider = null;
    }

    private void copySpecial(final ClipboardContentProviderService clipboardService, ClipboardType type, boolean prompt) {
        ClipboardType newType = type;
        List<ClipboardType> availableTypes = clipboardService.getCurrentCopyTypes();
        if (availableTypes == null || availableTypes.isEmpty()) {
            if (prompt) {
                Msg.showError((Object)this, (Component)this.tool.getToolFrame(), (String)"Error", (Object)"There are no copy formats available");
            } else {
                this.tool.setStatusInfo("There are no copy formats available");
            }
            return;
        }
        if (prompt) {
            CopyPasteSpecialDialog dialog = new CopyPasteSpecialDialog(this, availableTypes, "Copy Special");
            this.tool.showDialog((DialogComponentProvider)dialog, clipboardService.getComponentProvider());
            newType = dialog.getSelectedType();
        }
        if (newType == null) {
            return;
        }
        this.lastUsedCopySpecialType.put(clipboardService, newType);
        final ClipboardType selectedType = newType;
        Task copyTask = new Task("Copying", true, false, true){

            public void run(TaskMonitor monitor) {
                monitor.setMessage("Setting Clipboard Contents");
                Clipboard systemClipboard = ClipboardPlugin.this.getSystemClipboard();
                Transferable transferable = clipboardService.copySpecial(selectedType, monitor);
                if (transferable != null) {
                    ClipboardPlugin.this.setClipboardContents(systemClipboard, transferable);
                    ClipboardPlugin.this.clipboardOwnerProvider = clipboardService;
                    ClipboardPlugin.this.updatePasteState();
                }
            }
        };
        new TaskLauncher(copyTask, (Component)clipboardService.getComponentProvider().getComponent(), 250);
    }

    private Clipboard getSystemClipboard() {
        return GClipboard.getSystemClipboard();
    }

    void copySpecial(ClipboardContentProviderService clipboardService, ClipboardType type) {
        Clipboard systemClipboard = this.getSystemClipboard();
        Transferable transferable = clipboardService.copySpecial(type, TaskMonitor.DUMMY);
        if (transferable != null) {
            this.setClipboardContents(systemClipboard, transferable);
            this.updatePasteState();
        }
    }

    private static DataFlavor[] getAvailableDataFlavors(Clipboard clipboard) {
        try {
            return clipboard.getAvailableDataFlavors();
        }
        catch (Exception exception) {
            return new DataFlavor[0];
        }
    }

    private String getActionOwner(ClipboardContentProviderService clipboardService) {
        String owner = clipboardService.getClipboardActionOwner();
        if (owner != null) {
            return owner;
        }
        return this.getName();
    }

    private class CopyAction
    extends DockingAction
    implements ICopy {
        private final ClipboardContentProviderService clipboardService;

        private CopyAction(ClipboardContentProviderService clipboardService) {
            super("Copy", ClipboardPlugin.this.getActionOwner(clipboardService));
            this.clipboardService = clipboardService;
            this.setPopupMenuData(new MenuData(new String[]{"Copy"}, ClipboardPlugin.GROUP_NAME));
            this.setToolBarData(new ToolBarData((Icon)new GIcon("icon.plugin.clipboard.copy"), ClipboardPlugin.GROUP_NAME));
            this.setKeyBindingData(new KeyBindingData(67, DockingUtils.CONTROL_KEY_MODIFIER_MASK));
            this.setHelpLocation(new HelpLocation("ClipboardPlugin", "Copy"));
            clipboardService.customizeClipboardAction(this);
        }

        public void actionPerformed(ActionContext context) {
            ClipboardPlugin.this.copy(this.clipboardService);
        }

        public boolean isEnabledForContext(ActionContext context) {
            if (!this.clipboardService.isValidContext(context)) {
                return false;
            }
            return this.clipboardService.canCopy();
        }

        public boolean isAddToPopup(ActionContext context) {
            return context instanceof ListingActionContext || this.isEnabledForContext(context);
        }
    }

    private class CopySpecialAction
    extends DockingAction
    implements ICopy {
        private final ClipboardContentProviderService clipboardService;

        private CopySpecialAction(ClipboardContentProviderService clipboardService) {
            super("Copy Special", ClipboardPlugin.this.getActionOwner(clipboardService));
            this.clipboardService = clipboardService;
            this.setPopupMenuData(new MenuData(new String[]{"Copy Special..."}, ClipboardPlugin.GROUP_NAME));
            this.setEnabled(false);
            this.setHelpLocation(new HelpLocation("ClipboardPlugin", "Copy_Special"));
            clipboardService.customizeClipboardAction(this);
        }

        public void actionPerformed(ActionContext context) {
            ClipboardPlugin.this.copySpecial(this.clipboardService, null, true);
        }

        public boolean isEnabledForContext(ActionContext context) {
            if (!this.clipboardService.isValidContext(context)) {
                return false;
            }
            return this.clipboardService.canCopySpecial();
        }

        public boolean isAddToPopup(ActionContext context) {
            return context instanceof ListingActionContext || this.isEnabledForContext(context);
        }
    }

    private class CopySpecialAgainAction
    extends DockingAction
    implements ICopy {
        private final ClipboardContentProviderService clipboardService;

        private CopySpecialAgainAction(ClipboardContentProviderService clipboardService) {
            super("Copy Special Again", ClipboardPlugin.this.getActionOwner(clipboardService));
            this.clipboardService = clipboardService;
            this.setPopupMenuData(new MenuData(new String[]{"Copy Special Again"}, ClipboardPlugin.GROUP_NAME));
            this.setEnabled(false);
            this.setHelpLocation(new HelpLocation("ClipboardPlugin", "Copy_Special"));
            clipboardService.customizeClipboardAction(this);
        }

        public void actionPerformed(ActionContext context) {
            ClipboardPlugin.this.copySpecial(this.clipboardService, ClipboardPlugin.this.lastUsedCopySpecialType.get(this.clipboardService), false);
        }

        public boolean isEnabledForContext(ActionContext context) {
            if (!this.clipboardService.isValidContext(context)) {
                return false;
            }
            if (ClipboardPlugin.this.lastUsedCopySpecialType.get(this.clipboardService) == null) {
                return false;
            }
            String copiedItemName = ClipboardPlugin.this.lastUsedCopySpecialType.get(this.clipboardService).getTypeName();
            this.setPopupMenuData(new MenuData(new String[]{"Copy \"" + copiedItemName + "\""}, ClipboardPlugin.GROUP_NAME));
            return this.clipboardService.canCopySpecial();
        }
    }

    private class PasteAction
    extends DockingAction
    implements IPaste {
        private final ClipboardContentProviderService clipboardService;

        private PasteAction(ClipboardContentProviderService clipboardService) {
            super("Paste", ClipboardPlugin.this.getActionOwner(clipboardService));
            this.clipboardService = clipboardService;
            this.setPopupMenuData(new MenuData(new String[]{"Paste"}, ClipboardPlugin.GROUP_NAME));
            this.setToolBarData(new ToolBarData((Icon)new GIcon("icon.plugin.clipboard.paste"), ClipboardPlugin.GROUP_NAME));
            this.setKeyBindingData(new KeyBindingData(86, DockingUtils.CONTROL_KEY_MODIFIER_MASK));
            this.setHelpLocation(new HelpLocation("ClipboardPlugin", "Paste"));
            clipboardService.customizeClipboardAction(this);
        }

        public void actionPerformed(ActionContext context) {
            ClipboardPlugin.this.paste(this.clipboardService);
        }

        public boolean isEnabledForContext(ActionContext context) {
            if (!this.clipboardService.isValidContext(context)) {
                return false;
            }
            Clipboard systemClipboard = ClipboardPlugin.this.getSystemClipboard();
            DataFlavor[] flavors = ClipboardPlugin.getAvailableDataFlavors(systemClipboard);
            return this.clipboardService.canPaste(flavors);
        }

        public boolean isAddToPopup(ActionContext context) {
            return context instanceof ListingActionContext || this.isEnabledForContext(context);
        }
    }

    private static class DummyTransferable
    implements Transferable {
        private DummyTransferable() {
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            return null;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[0];
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return true;
        }
    }

    private static interface ICopy {
    }

    private static interface IPaste {
    }

    private static class PasteTask
    extends Task {
        private final Clipboard clipboard;
        private final ClipboardContentProviderService clipboardService;

        public PasteTask(Clipboard clipboard, ClipboardContentProviderService clipboardService) {
            super("Paste Task", false, false, true);
            this.clipboard = clipboard;
            this.clipboardService = clipboardService;
        }

        public void run(TaskMonitor monitor) {
            Transferable transferable = this.clipboard.getContents((Object)this);
            this.clipboardService.paste(transferable);
        }
    }
}

