/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.plugin.core.analysis.AnalysisTask;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.services.Analyzer;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.options.Options;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Language;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public class AnalysisScheduler {
    private AutoAnalysisManager analysisMgr;
    private Analyzer analyzer;
    private AddressSet removeSet;
    private AddressSet addSet;
    private boolean defaultEnablement;
    private boolean enabled;
    private boolean scheduled;

    AnalysisScheduler(AutoAnalysisManager analysisMgr, Analyzer analyzer) {
        this.analysisMgr = analysisMgr;
        this.analyzer = analyzer;
        if (analyzer.getName().indexOf(46) >= 0) {
            throw new IllegalArgumentException("Analyzer name may not contain a period: " + analyzer.getName());
        }
        this.enabled = this.defaultEnablement = this.getDefaultEnablement();
        this.removeSet = new AddressSet();
        this.addSet = new AddressSet();
    }

    private boolean getDefaultEnablement() {
        boolean override;
        Program program = this.analysisMgr.getProgram();
        boolean defaultEnable = this.analyzer.getDefaultEnablement(program);
        if (defaultEnable != (override = this.getEnableOverride(defaultEnable))) {
            Msg.warn(AnalysisScheduler.class, (Object)("Analyzer '" + this.analyzer.getName() + "' for " + program.getName() + " " + (override ? "enabled" : "disabled") + " by PSPEC file override"));
            defaultEnable = override;
        }
        return defaultEnable;
    }

    synchronized void schedule() {
        if (!(this.scheduled || this.addSet.isEmpty() && this.removeSet.isEmpty())) {
            this.analysisMgr.schedule(new AnalysisTask(this, this.analysisMgr.getMessageLog()), this.getPriority());
            this.scheduled = true;
        }
    }

    synchronized void added(AddressSetView set) {
        if (!this.enabled) {
            return;
        }
        this.addSet.add(set);
        this.schedule();
    }

    synchronized void added(Address addr) {
        if (!this.enabled) {
            return;
        }
        this.addSet.add(addr);
        this.schedule();
    }

    synchronized void removed(AddressSetView set) {
        if (!this.enabled) {
            return;
        }
        this.removeSet.add(set);
        this.schedule();
    }

    synchronized void removed(Address addr) {
        if (!this.enabled) {
            return;
        }
        this.removeSet.add(addr);
        this.schedule();
    }

    Analyzer getAnalyzer() {
        return this.analyzer;
    }

    private AddressSet getAddedAddressSet() {
        AddressSet oldSet = this.addSet;
        this.addSet = new AddressSet();
        return oldSet;
    }

    private AddressSet getRemovedAddressSet() {
        AddressSet oldSet = this.removeSet;
        this.removeSet = new AddressSet();
        return oldSet;
    }

    public void optionsChanged(Options options) {
        this.enabled = options.getBoolean(this.analyzer.getName(), this.defaultEnablement);
        this.analyzer.optionsChanged(options.getOptions(this.analyzer.getName()), this.analysisMgr.getProgram());
    }

    public void registerOptions(Options options) {
        Options analyzerOptions = options.getOptions(this.analyzer.getName());
        options.registerOption(this.analyzer.getName(), (Object)this.defaultEnablement, null, this.analyzer.getDescription());
        this.analyzer.registerOptions(analyzerOptions, this.analysisMgr.getProgram());
    }

    private boolean getEnableOverride(boolean defaultEnable) {
        Language language = this.analysisMgr.getProgram().getLanguage();
        boolean allOverriden = false;
        if (language.hasProperty("DisableAllAnalyzers")) {
            allOverriden = true;
        }
        boolean overrideEnable = defaultEnable;
        String propertyName = "Analyzers." + this.analyzer.getName();
        if (language.hasProperty(propertyName)) {
            overrideEnable = language.getPropertyAsBoolean(propertyName, defaultEnable);
        } else if (allOverriden) {
            overrideEnable = false;
        }
        return overrideEnable;
    }

    public int getPriority() {
        return this.analyzer.getPriority().priority();
    }

    public String getName() {
        return this.analyzer.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runAnalyzer(Program program, TaskMonitor monitor, MessageLog log) throws CancelledException {
        AddressSet saveRemoveSet;
        AddressSet saveAddSet;
        AnalysisScheduler analysisScheduler = this;
        synchronized (analysisScheduler) {
            saveAddSet = this.getAddedAddressSet();
            saveRemoveSet = this.getRemovedAddressSet();
            this.scheduled = false;
        }
        monitor.setMessage(this.analyzer.getName());
        monitor.setProgress(0L);
        boolean result = false;
        if (!saveAddSet.isEmpty()) {
            result |= this.analyzer.added(program, (AddressSetView)saveAddSet, monitor, log);
        }
        if (!saveRemoveSet.isEmpty()) {
            result |= this.analyzer.removed(program, (AddressSetView)saveRemoveSet, monitor, log);
        }
        return result;
    }

    public void runCanceled() {
        this.getAddedAddressSet();
        this.getRemovedAddressSet();
        this.scheduled = false;
    }

    public String toString() {
        return this.analyzer.getName();
    }
}

