/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.protocol;

import ghidra.features.bsim.query.LSHException;
import ghidra.features.bsim.query.description.DescriptionManager;
import ghidra.features.bsim.query.description.ExecutableRecord;
import ghidra.features.bsim.query.description.FunctionDescription;
import ghidra.features.bsim.query.protocol.SimilarityNote;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SimilarityResult
implements Iterable<SimilarityNote> {
    private FunctionDescription basefunc;
    private List<SimilarityNote> notes;
    private int totalcount;

    public SimilarityResult() {
    }

    public SimilarityResult(FunctionDescription f) {
        this.basefunc = f;
        this.notes = new ArrayList<SimilarityNote>();
        this.totalcount = 0;
    }

    public void addNote(FunctionDescription f, double similarity, double significance) {
        this.notes.add(new SimilarityNote(f, similarity, significance));
    }

    public FunctionDescription getBase() {
        return this.basefunc;
    }

    public int size() {
        return this.notes.size();
    }

    public void setTotalCount(int count) {
        this.totalcount = count;
    }

    public int getTotalCount() {
        return this.totalcount;
    }

    @Override
    public Iterator<SimilarityNote> iterator() {
        return this.notes.iterator();
    }

    public void transfer(DescriptionManager manage, boolean transsig) throws LSHException {
        for (SimilarityNote note : this.notes) {
            note.transfer(manage, transsig);
        }
    }

    public void setTransfer(SimilarityResult op2, DescriptionManager qmanage, DescriptionManager rmanage, boolean transsig) throws LSHException {
        ExecutableRecord erec = qmanage.findExecutable(op2.basefunc.getExecutableRecord().getMd5());
        this.basefunc = qmanage.findFunction(op2.basefunc.getFunctionName(), op2.basefunc.getAddress(), erec);
        this.totalcount = op2.totalcount;
        this.notes = new ArrayList<SimilarityNote>();
        for (SimilarityNote item : op2.notes) {
            SimilarityNote newitem = new SimilarityNote();
            newitem.setTransfer(item, rmanage, transsig);
            this.notes.add(newitem);
        }
    }

    public void saveXml(Writer write) throws IOException {
        StringBuilder buf = new StringBuilder();
        buf.append("<simres");
        SpecXmlUtils.encodeUnsignedIntegerAttribute((StringBuilder)buf, (String)"id", (long)this.basefunc.getExecutableRecord().getXrefIndex());
        SpecXmlUtils.xmlEscapeAttribute((StringBuilder)buf, (String)"name", (String)this.basefunc.getFunctionName());
        SpecXmlUtils.encodeUnsignedIntegerAttribute((StringBuilder)buf, (String)"addr", (long)this.basefunc.getAddress());
        SpecXmlUtils.encodeUnsignedIntegerAttribute((StringBuilder)buf, (String)"total", (long)this.totalcount);
        buf.append(">\n");
        write.append(buf.toString());
        Iterator<SimilarityNote> iter = this.notes.iterator();
        while (iter.hasNext()) {
            iter.next().saveXml(write);
        }
        write.append("</simres>\n");
    }

    public void restoreXml(XmlPullParser parser, DescriptionManager qmanage, DescriptionManager rmanage, Map<Integer, ExecutableRecord> qMap, Map<Integer, ExecutableRecord> rMap) throws LSHException {
        this.notes = new ArrayList<SimilarityNote>();
        XmlElement el = parser.start(new String[]{"simres"});
        int id = SpecXmlUtils.decodeInt((String)el.getAttribute("id"));
        ExecutableRecord exe = qMap.get(id);
        long address = SpecXmlUtils.decodeLong((String)el.getAttribute("addr"));
        this.basefunc = qmanage.findFunction(el.getAttribute("name"), address, exe);
        this.totalcount = SpecXmlUtils.decodeInt((String)el.getAttribute("total"));
        while (parser.peek().isStart()) {
            SimilarityNote newnote = new SimilarityNote();
            newnote.restoreXml(parser, rmanage, rMap);
            this.notes.add(newnote);
        }
        parser.end();
    }

    public void sortNotes() {
        Collections.sort(this.notes);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " - base function: " + String.valueOf(this.basefunc);
    }
}

