/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.protocol;

import generic.lsh.vector.LSHVectorFactory;
import ghidra.features.bsim.query.LSHException;
import ghidra.features.bsim.query.description.ExecutableRecord;
import ghidra.features.bsim.query.protocol.QueryNearestVector;
import ghidra.features.bsim.query.protocol.QueryResponseRecord;
import ghidra.features.bsim.query.protocol.SimilarityVectorResult;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ResponseNearestVector
extends QueryResponseRecord {
    public int totalvec;
    public int totalmatch;
    public int uniquematch;
    public List<SimilarityVectorResult> result = new ArrayList<SimilarityVectorResult>();
    public QueryNearestVector qnear;

    public ResponseNearestVector(QueryNearestVector q) {
        super("responsenearestvec");
        this.qnear = q;
    }

    @Override
    public void sort() {
        for (SimilarityVectorResult res : this.result) {
            res.sortNotes();
        }
    }

    @Override
    public void mergeResults(QueryResponseRecord subresponse) {
        ResponseNearestVector subnearest = (ResponseNearestVector)subresponse;
        this.totalvec += subnearest.totalvec;
        this.totalmatch += subnearest.totalmatch;
        this.uniquematch += subnearest.uniquematch;
        this.result.addAll(subnearest.result);
    }

    @Override
    public void saveXml(Writer fwrite) throws IOException {
        this.qnear.manage.populateExecutableXref();
        fwrite.append('<').append(this.name).append(">\n");
        fwrite.append(" <tvec>").append(SpecXmlUtils.encodeSignedInteger((long)this.totalvec)).append("</tvec>\n");
        fwrite.append(" <tmatch>").append(SpecXmlUtils.encodeSignedInteger((long)this.totalmatch)).append("</tmatch>\n");
        fwrite.append(" <umatch>").append(SpecXmlUtils.encodeSignedInteger((long)this.uniquematch)).append("</umatch>\n");
        Iterator<SimilarityVectorResult> iter = this.result.iterator();
        while (iter.hasNext()) {
            iter.next().saveXml(fwrite);
        }
        fwrite.append("</").append(this.name).append(">\n");
    }

    @Override
    public void restoreXml(XmlPullParser parser, LSHVectorFactory vectorFactory) throws LSHException {
        parser.start(new String[]{this.name});
        parser.start(new String[]{"tvec"});
        this.totalvec = SpecXmlUtils.decodeInt((String)parser.end().getText());
        parser.start(new String[]{"tmatch"});
        this.totalmatch = SpecXmlUtils.decodeInt((String)parser.end().getText());
        parser.start(new String[]{"umatch"});
        this.uniquematch = SpecXmlUtils.decodeInt((String)parser.end().getText());
        Map<Integer, ExecutableRecord> exeMap = this.qnear.manage.generateExecutableXrefMap();
        while (parser.peek().isStart()) {
            SimilarityVectorResult res = new SimilarityVectorResult();
            res.restoreXml(parser, vectorFactory, this.qnear.manage, exeMap);
            this.result.add(res);
        }
        parser.end();
    }
}

