/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.tree;

import docking.ActionContext;
import docking.DockingWindowManager;
import docking.Tool;
import docking.action.ComponentBasedDockingAction;
import docking.action.DockingAction;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.actions.KeyBindingUtils;
import docking.actions.ToolActions;
import docking.widgets.JTreeMouseListenerDelegate;
import docking.widgets.filter.FilterTextField;
import docking.widgets.table.AutoscrollAdapter;
import docking.widgets.tree.DefaultGTreeFilterProvider;
import docking.widgets.tree.GTreeFilterProvider;
import docking.widgets.tree.GTreeFilterTask;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.GTreeRestoreTreeStateTask;
import docking.widgets.tree.GTreeRootParentNode;
import docking.widgets.tree.GTreeState;
import docking.widgets.tree.GTreeTask;
import docking.widgets.tree.internal.DefaultGTreeDataTransformer;
import docking.widgets.tree.internal.GTreeDragNDropAdapter;
import docking.widgets.tree.internal.GTreeModel;
import docking.widgets.tree.internal.GTreeSelectionModel;
import docking.widgets.tree.support.GTreeCellEditor;
import docking.widgets.tree.support.GTreeDragNDropHandler;
import docking.widgets.tree.support.GTreeFilter;
import docking.widgets.tree.support.GTreeRenderer;
import docking.widgets.tree.support.GTreeSelectionEvent;
import docking.widgets.tree.support.GTreeSelectionListener;
import docking.widgets.tree.support.IgnoredNodesGtreeFilter;
import docking.widgets.tree.tasks.GTreeBulkTask;
import docking.widgets.tree.tasks.GTreeClearSelectionTask;
import docking.widgets.tree.tasks.GTreeExpandAllTask;
import docking.widgets.tree.tasks.GTreeExpandNodeToDepthTask;
import docking.widgets.tree.tasks.GTreeExpandPathsTask;
import docking.widgets.tree.tasks.GTreeSelectNodeByNameTask;
import docking.widgets.tree.tasks.GTreeSelectPathsTask;
import docking.widgets.tree.tasks.GTreeStartEditingTask;
import generic.theme.GColor;
import generic.theme.Gui;
import generic.theme.ThemeListener;
import generic.timer.ExpiringSwingTimer;
import ghidra.util.FilterTransformer;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.BusyListener;
import ghidra.util.task.MonitoredRunnable;
import ghidra.util.task.SwingUpdateManager;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.TaskMonitorComponent;
import ghidra.util.worker.PriorityJob;
import ghidra.util.worker.PriorityWorker;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.Autoscroll;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.Action;
import javax.swing.CellEditor;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.apache.commons.lang3.StringUtils;
import resources.Icons;

public class GTree
extends JPanel
implements BusyListener {
    private static final Color BACKGROUND = new GColor("color.bg.tree");
    private AutoScrollTree tree;
    private GTreeModel model;
    private volatile GTreeNode realModelRootNode;
    private volatile GTreeNode realViewRootNode;
    private GTreeRootParentNode rootParent = new GTreeRootParentNode(this);
    private JScrollPane scrollPane;
    private GTreeRenderer renderer;
    private FilterTransformer<GTreeNode> transformer = new DefaultGTreeDataTransformer();
    private JTreeMouseListenerDelegate mouseListenerDelegate;
    private GTreeDragNDropHandler dragNDropHandler;
    private boolean isFilteringEnabled = true;
    private ThemeListener themeListener = e -> {
        if (e.isLookAndFeelChanged()) {
            this.model.fireNodeStructureChanged(this.getModelRoot());
        }
    };
    private ThreadLocal<TaskMonitor> threadLocalMonitor = new ThreadLocal();
    private PriorityWorker worker;
    private Timer showTimer;
    private TaskMonitorComponent monitor;
    private JComponent progressPanel;
    private JPanel mainPanel;
    private GTreeState filterRestoreTreeState;
    private GTreeFilterTask lastFilterTask;
    private String uniquePreferenceKey;
    private GTreeFilter filter;
    private GTreeFilterProvider filterProvider;
    private SwingUpdateManager filterUpdateManager;
    private Set<GTreeNode> ignoredNodes = new HashSet<GTreeNode>();

    public GTree(GTreeNode root) {
        this.uniquePreferenceKey = GTree.generateFilterPreferenceKey();
        this.realModelRootNode = root;
        this.realViewRootNode = root;
        this.monitor = new TaskMonitorComponent();
        this.monitor.setShowProgressValue(false);
        this.worker = new PriorityWorker("GTree Worker", (TaskMonitor)this.monitor);
        root.setParent(this.rootParent);
        this.model = new GTreeModel(root);
        this.worker.setBusyListener((BusyListener)this);
        this.init();
        DockingWindowManager.registerComponentLoadedListener(this, (windowManager, provider) -> this.filterProvider.loadFilterPreference(windowManager));
        this.filterUpdateManager = new SwingUpdateManager(1000, 30000, () -> this.updateModelFilter());
        Gui.addThemeListener((ThemeListener)this.themeListener);
    }

    void setThreadLocalMonitor(TaskMonitor monitor) {
        this.threadLocalMonitor.set(monitor);
    }

    TaskMonitor getThreadLocalMonitor() {
        TaskMonitor localMonitor = this.threadLocalMonitor.get();
        if (localMonitor != null) {
            return localMonitor;
        }
        return TaskMonitor.DUMMY;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.tree.setEnabled(enabled);
        this.scrollPane.setEnabled(enabled);
        this.filterProvider.setEnabled(enabled);
    }

    public void setEventsEnabled(boolean b) {
        this.model.setEventsEnabled(b);
    }

    public void setDragNDropHandler(GTreeDragNDropHandler dragNDropHandler) {
        this.dragNDropHandler = dragNDropHandler;
        new GTreeDragNDropAdapter(this, this.tree, dragNDropHandler);
    }

    @Override
    public void setTransferHandler(TransferHandler handler) {
        this.tree.setTransferHandler(handler);
    }

    public GTreeDragNDropHandler getDragNDropHandler() {
        return this.dragNDropHandler;
    }

    private void init() {
        this.setBackground(BACKGROUND);
        this.tree = new AutoScrollTree(this.model);
        this.setLayout(new BorderLayout());
        this.scrollPane = new JScrollPane(this.tree);
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.add((Component)this.scrollPane, "Center");
        this.add((Component)this.mainPanel, "Center");
        this.renderer = new GTreeRenderer();
        this.tree.setCellRenderer(this.renderer);
        this.tree.setCellEditor(new GTreeCellEditor(this.tree, this.renderer));
        this.tree.setEditable(true);
        this.addGTreeSelectionListener(e -> {
            if (e.getEventOrigin() == GTreeSelectionEvent.EventOrigin.USER_GENERATED || e.getEventOrigin() == GTreeSelectionEvent.EventOrigin.API_GENERATED) {
                this.filterRestoreTreeState = this.getTreeState();
            }
        });
        this.mouseListenerDelegate = this.createMouseListenerDelegate();
        this.filterProvider = new DefaultGTreeFilterProvider(this);
        this.add((Component)this.filterProvider.getFilterComponent(), "South");
    }

    public void setAccessibleNamePrefix(String namePrefix) {
        this.setName(namePrefix + "GTree");
        this.tree.setName(namePrefix + " Tree");
        this.tree.getAccessibleContext().setAccessibleName(namePrefix);
        this.tree.getAccessibleContext().setAccessibleDescription("");
        this.filterProvider.setAccessibleNamePrefix(namePrefix);
    }

    public void setCellRenderer(GTreeRenderer renderer) {
        this.renderer = renderer;
        this.tree.setCellRenderer(renderer);
    }

    public GTreeRenderer getCellRenderer() {
        return this.renderer;
    }

    public void dispose() {
        this.ignoredNodes.clear();
        this.filterUpdateManager.dispose();
        this.worker.dispose();
        if (this.realModelRootNode != null) {
            this.realModelRootNode.dispose();
        }
        if (this.realViewRootNode != null && this.realViewRootNode != this.realModelRootNode) {
            this.realViewRootNode.disposeClone();
        }
        this.filterProvider.dispose();
        this.model.dispose();
        Gui.removeThemeListener((ThemeListener)this.themeListener);
    }

    public boolean isDisposed() {
        return this.worker.isDisposed();
    }

    public void cancelWork() {
        this.worker.clearAllJobs();
    }

    public void filterChanged() {
        this.ignoredNodes.clear();
        this.updateModelFilter();
    }

    private void ignoreFilter(GTreeNode node) {
        if (!this.isFiltered()) {
            return;
        }
        this.ignoredNodes.add(node);
        this.updateModelFilter();
    }

    protected void updateModelFilter() {
        this.filter = this.filterProvider.getFilter();
        if (this.filter != null && !this.ignoredNodes.isEmpty()) {
            this.filter = new IgnoredNodesGtreeFilter(this.filter, this.ignoredNodes);
        }
        this.filterUpdateManager.stop();
        if (this.lastFilterTask != null) {
            this.lastFilterTask.cancel();
        }
        this.lastFilterTask = new GTreeFilterTask(this, this.filter);
        if (this.isFilteringEnabled()) {
            this.worker.schedule((PriorityJob)this.lastFilterTask);
        }
    }

    protected JTreeMouseListenerDelegate createMouseListenerDelegate() {
        return new GTreeMouseListenerDelegate(this, this.tree, this);
    }

    public GTreeState getTreeState() {
        GTreeNode root = this.getViewRoot();
        if (root == null) {
            return null;
        }
        return new GTreeState(this);
    }

    public GTreeState getTreeState(GTreeNode node) {
        return new GTreeState(this, node);
    }

    public void restoreTreeState(GTreeState state) {
        this.runTask(new GTreeRestoreTreeStateTask(this, state));
    }

    protected void setFilterRestoreState(GTreeState state) {
        this.filterRestoreTreeState = state;
    }

    void saveFilterRestoreState() {
        if (this.filterRestoreTreeState == null) {
            this.filterRestoreTreeState = new GTreeState(this);
        }
    }

    GTreeState getFilterRestoreState() {
        return this.filterRestoreTreeState;
    }

    void clearFilterRestoreState() {
        this.filterRestoreTreeState = null;
    }

    public String getPreferenceKey() {
        return this.uniquePreferenceKey;
    }

    public void expandedStateRestored(TaskMonitor taskMonitor) {
    }

    public List<TreePath> getExpandedPaths() {
        return this.getExpandedPaths(this.getViewRoot());
    }

    public List<TreePath> getExpandedPaths(GTreeNode node) {
        Enumeration<TreePath> expandedPaths = this.tree.getExpandedDescendants(node.getTreePath());
        if (expandedPaths == null) {
            return Collections.emptyList();
        }
        return Collections.list(expandedPaths);
    }

    public void expandTree(GTreeNode node) {
        this.runTask(new GTreeExpandAllTask(this, node));
    }

    public void expandAll() {
        this.runTask(new GTreeExpandAllTask(this, this.getViewRoot()));
    }

    public void collapseAll(GTreeNode node) {
        SystemUtilities.runSwingNow(() -> {
            if (!this.isFiltered() && this.lastFilterTask != null) {
                this.lastFilterTask.cancel();
            }
            node.fireNodeStructureChanged();
            this.tree.collapsePath(node.getTreePath());
            boolean nodeIsRoot = node.equals(this.model.getRoot());
            if (nodeIsRoot && !this.tree.isRootAllowedToCollapse()) {
                this.runTask(new GTreeExpandNodeToDepthTask(this, node, 1));
            }
        });
    }

    public void expandPath(GTreeNode node) {
        this.expandPaths(List.of(node.getTreePath()));
    }

    public void expandPath(TreePath path) {
        this.expandPaths(List.of(path));
    }

    public void expandPaths(TreePath[] paths) {
        this.expandPaths(Arrays.asList(paths));
    }

    public void expandPaths(List<TreePath> paths) {
        this.runTask(new GTreeExpandPathsTask(this, paths));
    }

    public void clearSelectionPaths() {
        this.runTask(new GTreeClearSelectionTask(this, this.tree));
    }

    public void expandAndSelectPaths(List<TreePath> paths) {
        this.setSelectionPaths(paths, true, GTreeSelectionEvent.EventOrigin.API_GENERATED);
    }

    public void addSelectionPath(TreePath path) {
        this.tree.addSelectionPath(path);
    }

    public void setSelectedNode(GTreeNode node) {
        this.setSelectionPaths(new TreePath[]{node.getTreePath()});
    }

    public void setSelectedNodes(GTreeNode ... nodes) {
        ArrayList<TreePath> paths = new ArrayList<TreePath>();
        for (GTreeNode node : nodes) {
            paths.add(node.getTreePath());
        }
        this.setSelectionPaths(paths);
    }

    public void setSelectedNodes(Collection<GTreeNode> nodes) {
        ArrayList<TreePath> paths = new ArrayList<TreePath>();
        for (GTreeNode node : nodes) {
            paths.add(node.getTreePath());
        }
        this.setSelectionPaths(paths);
    }

    public void setSelectionPaths(TreePath[] paths) {
        this.setSelectionPaths(paths, GTreeSelectionEvent.EventOrigin.API_GENERATED);
    }

    public void setSelectionPaths(List<TreePath> pathsList) {
        TreePath[] treePaths = pathsList.toArray(new TreePath[pathsList.size()]);
        this.setSelectionPaths(treePaths, GTreeSelectionEvent.EventOrigin.API_GENERATED);
    }

    public void setSelectionPath(TreePath path) {
        this.setSelectionPaths(new TreePath[]{path});
    }

    public void setSelectedNodeByNamePath(String[] namePath) {
        this.runTask(new GTreeSelectNodeByNameTask(this, this.tree, namePath, GTreeSelectionEvent.EventOrigin.API_GENERATED));
    }

    public void setSeletedNodeByName(GTreeNode parentNode, String childName) {
        TreePath treePath = parentNode.getTreePath();
        TreePath pathWithChild = treePath.pathByAddingChild(childName);
        this.setSelectedNodeByPathName(pathWithChild);
    }

    public void setSelectedNodeByPathName(TreePath treePath) {
        Object[] path = treePath.getPath();
        String[] namePath = new String[treePath.getPathCount()];
        for (int i = 0; i < path.length; ++i) {
            namePath[i] = path[i].toString();
        }
        this.runTask(new GTreeSelectNodeByNameTask(this, this.tree, namePath, GTreeSelectionEvent.EventOrigin.API_GENERATED));
    }

    public void setSelectionPaths(TreePath[] paths, GTreeSelectionEvent.EventOrigin origin) {
        this.setSelectionPaths(Arrays.asList(paths), false, origin);
    }

    public void setSelectionPaths(List<TreePath> paths, boolean expandPaths, GTreeSelectionEvent.EventOrigin origin) {
        if (expandPaths) {
            this.expandPaths(paths);
        }
        this.runTask(new GTreeSelectPathsTask(this, this.tree, paths, origin));
    }

    public boolean isCollapsed(TreePath path) {
        return this.tree.isCollapsed(path);
    }

    public void setHorizontalScrollPolicy(int policy) {
        this.scrollPane.setHorizontalScrollBarPolicy(policy);
    }

    protected JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public void setScrollableUnitIncrement(int increment) {
        this.tree.setScrollableUnitIncrement(increment);
    }

    public GTreeModel getModel() {
        return this.model;
    }

    protected final JTree getJTree() {
        return this.tree;
    }

    public Point getViewPosition() {
        JViewport viewport = this.scrollPane.getViewport();
        Point p = viewport.getViewPosition();
        return p;
    }

    public void setViewPosition(Point p) {
        JViewport viewport = this.scrollPane.getViewport();
        viewport.setViewPosition(p);
    }

    public Rectangle getViewRect() {
        JViewport viewport = this.scrollPane.getViewport();
        Rectangle viewRect = viewport.getViewRect();
        return viewRect;
    }

    public GTreeNode getNodeForLocation(int x, int y) {
        TreePath pathForLocation = this.tree.getPathForLocation(x, y);
        if (pathForLocation != null) {
            return (GTreeNode)pathForLocation.getLastPathComponent();
        }
        return null;
    }

    public GTreeNode getModelNode(GTreeNode node) {
        return this.getNodeForPath(this.getModelRoot(), node.getTreePath());
    }

    public GTreeNode getModelNodeForPath(TreePath path) {
        return this.getNodeForPath(this.getModelRoot(), path);
    }

    public GTreeNode getViewNode(GTreeNode node) {
        return this.getNodeForPath(this.getViewRoot(), node.getTreePath());
    }

    public GTreeNode getViewNodeForPath(TreePath path) {
        return this.getNodeForPath(this.getViewRoot(), path);
    }

    private GTreeNode getNodeForPath(GTreeNode root, TreePath path) {
        if (path == null || root == null) {
            return null;
        }
        GTreeNode node = (GTreeNode)path.getLastPathComponent();
        if (path.getPathCount() == 1) {
            if (root.equals(node)) {
                return root;
            }
            return null;
        }
        if (node.getRoot() == root) {
            return node;
        }
        TreePath parentPath = path.getParentPath();
        GTreeNode parentNode = this.getNodeForPath(root, parentPath);
        if (parentNode == null) {
            return null;
        }
        GTreeNode lastPathComponent = (GTreeNode)path.getLastPathComponent();
        List<GTreeNode> children = parentNode.getChildren();
        for (GTreeNode child : children) {
            if (!child.equals(lastPathComponent)) continue;
            return child;
        }
        return null;
    }

    public void setActiveDropTargetNode(GTreeNode node) {
        this.renderer.setRendererDropTarget(node);
    }

    public void setFilterText(String text) {
        this.filterProvider.setFilterText(text);
    }

    public GTreeFilterProvider getFilterProvider() {
        return this.filterProvider;
    }

    public void setFilterProvider(GTreeFilterProvider filterProvider) {
        this.filterProvider = Objects.requireNonNull(filterProvider);
        this.removeAll();
        this.add((Component)this.mainPanel, "Center");
        JComponent filterComponent = filterProvider.getFilterComponent();
        if (filterComponent != null) {
            this.add((Component)filterComponent, "South");
        }
        filterProvider.setDataTransformer(this.transformer);
        this.updateModelFilter();
    }

    public void setFilterFieldEnabled(boolean enabled) {
        this.filterProvider.setEnabled(enabled);
    }

    public void setFilteringEnabled(boolean enabled) {
        this.isFilteringEnabled = enabled;
        this.setFilterFieldEnabled(enabled);
        this.validate();
        this.refilterNow();
    }

    public void setFilterVisible(boolean visible) {
        JComponent filterComponent = this.filterProvider.getFilterComponent();
        filterComponent.setVisible(visible);
        this.validate();
    }

    public boolean isFilteringEnabled() {
        return this.isFilteringEnabled;
    }

    public void setDataTransformer(FilterTransformer<GTreeNode> transformer) {
        this.filterProvider.setDataTransformer(transformer);
    }

    public Component getFilterField() {
        JComponent filterComponent = this.filterProvider.getFilterComponent();
        if (filterComponent != null) {
            Component[] components;
            for (Component component : components = filterComponent.getComponents()) {
                if (!(component instanceof FilterTextField)) continue;
                return component;
            }
            return filterComponent;
        }
        return this.tree;
    }

    public boolean isMyJTree(JTree jTree) {
        return this.tree == jTree;
    }

    public void setRootNode(GTreeNode rootNode) {
        Swing.runIfSwingOrRunLater(() -> {
            this.worker.clearAllJobs();
            rootNode.setParent(this.rootParent);
            GTreeNode oldModelRoot = this.realModelRootNode;
            GTreeNode oldViewRoot = this.realViewRootNode;
            this.realModelRootNode = rootNode;
            this.realViewRootNode = rootNode;
            this.swingSetModelRootNode(rootNode);
            this.disposeOldRoots(oldModelRoot, oldViewRoot);
            if (this.filter != null) {
                this.filterUpdateManager.update();
            }
        });
    }

    private void disposeOldRoots(GTreeNode oldModelRoot, GTreeNode oldViewRoot) {
        if (oldModelRoot != null && oldModelRoot != this.realModelRootNode) {
            oldModelRoot.dispose();
        }
        if (oldViewRoot != null && oldViewRoot != this.realViewRootNode) {
            oldViewRoot.disposeClone();
        }
    }

    void swingSetFilteredRootNode(GTreeNode filteredRootNode) {
        filteredRootNode.setParent(this.rootParent);
        this.realViewRootNode = filteredRootNode;
        GTreeNode currentRoot = this.swingSetModelRootNode(filteredRootNode);
        if (currentRoot != this.realModelRootNode) {
            currentRoot.disposeClone();
        }
    }

    void swingRestoreNonFilteredRootNode() {
        this.realViewRootNode = this.realModelRootNode;
        GTreeNode currentRoot = this.swingSetModelRootNode(this.realModelRootNode);
        if (currentRoot != this.realModelRootNode && currentRoot != null) {
            currentRoot.disposeClone();
        }
    }

    private GTreeNode swingSetModelRootNode(GTreeNode rootNode) {
        GTreeNode oldNode = this.model.getModelRoot();
        this.model.privateSwingSetRootNode(rootNode);
        return oldNode;
    }

    public GTreeNode getModelRoot() {
        return this.realModelRootNode;
    }

    public GTreeNode getViewRoot() {
        return this.realViewRootNode;
    }

    public static void printEvent(PrintWriter out, String name, TreeModelEvent e) {
        Object[] children;
        StringBuffer buf = new StringBuffer();
        buf.append(name);
        buf.append("\n\tPath: ");
        Object[] path = e.getPath();
        if (path != null) {
            for (Object object : path) {
                GTreeNode node = (GTreeNode)object;
                buf.append(node.getName() + "(" + node.hashCode() + ")");
                buf.append(",");
            }
        }
        buf.append("\n\t");
        int[] childIndices = e.getChildIndices();
        if (childIndices != null) {
            buf.append("indices [ ");
            for (int index : childIndices) {
                buf.append(Integer.toString(index) + ", ");
            }
            buf.append("]\n\t");
        }
        if ((children = e.getChildren()) != null) {
            buf.append("children [ ");
            for (Object child : children) {
                GTreeNode node = (GTreeNode)child;
                buf.append(node.getName() + "(" + node.hashCode() + "), ");
            }
            buf.append("]");
        }
        out.println(buf.toString());
    }

    public TreeSelectionModel getSelectionModel() {
        return this.tree.getSelectionModel();
    }

    public GTreeSelectionModel getGTSelectionModel() {
        return (GTreeSelectionModel)this.tree.getSelectionModel();
    }

    public void setSelectionModel(GTreeSelectionModel selectionModel) {
        this.tree.setSelectionModel(selectionModel);
    }

    public int getRowCount() {
        return this.tree.getRowCount();
    }

    public int getRowForPath(TreePath treePath) {
        return this.tree.getRowForPath(treePath);
    }

    public TreePath getPathForRow(int row) {
        return this.tree.getPathForRow(row);
    }

    public TreePath getSelectionPath() {
        return this.tree.getSelectionPath();
    }

    public TreePath[] getSelectionPaths() {
        TreePath[] paths = this.tree.getSelectionPaths();
        if (paths == null) {
            paths = new TreePath[]{};
        }
        return paths;
    }

    public List<GTreeNode> getSelectedNodes() {
        TreePath[] paths = this.getSelectionPaths();
        return Arrays.stream(paths).map(tp -> (GTreeNode)tp.getLastPathComponent()).collect(Collectors.toList());
    }

    public boolean isExpanded(TreePath treePath) {
        return this.tree.isExpanded(treePath);
    }

    public boolean isPathSelected(TreePath treePath) {
        return this.tree.isPathSelected(treePath);
    }

    public boolean isRootVisible() {
        return this.tree.isRootVisible();
    }

    public void setRootVisible(boolean b) {
        this.tree.setRootVisible(b);
    }

    public void setShowsRootHandles(boolean b) {
        this.tree.setShowsRootHandles(b);
    }

    public void scrollPathToVisible(TreePath treePath) {
        this.tree.scrollPathToVisible(treePath);
    }

    public CellEditor getCellEditor() {
        return this.tree.getCellEditor();
    }

    public TreePath getPathForLocation(int x, int y) {
        return this.tree.getPathForLocation(x, y);
    }

    public Rectangle getPathBounds(TreePath path) {
        return this.tree.getPathBounds(path);
    }

    public void setRowHeight(int rowHeight) {
        this.tree.setRowHeight(rowHeight);
    }

    public void addTreeExpansionListener(TreeExpansionListener listener) {
        this.tree.addTreeExpansionListener(listener);
    }

    public void removeTreeExpansionListener(TreeExpansionListener listener) {
        this.tree.removeTreeExpansionListener(listener);
    }

    public void addGTreeSelectionListener(GTreeSelectionListener listener) {
        GTreeSelectionModel selectionModel = (GTreeSelectionModel)this.tree.getSelectionModel();
        selectionModel.addGTreeSelectionListener(listener);
    }

    public void removeGTreeSelectionListener(GTreeSelectionListener listener) {
        GTreeSelectionModel selectionModel = (GTreeSelectionModel)this.tree.getSelectionModel();
        selectionModel.removeGTreeSelectionListener(listener);
    }

    public void addGTModelListener(TreeModelListener listener) {
        this.model.addTreeModelListener(listener);
    }

    public void removeGTModelListener(TreeModelListener listener) {
        this.model.removeTreeModelListener(listener);
    }

    public void setEditable(boolean editable) {
        this.tree.setEditable(editable);
    }

    private void getModelNode(GTreeNode parent, Predicate<GTreeNode> matches, Consumer<GTreeNode> consumer) {
        Objects.requireNonNull(parent);
        Objects.requireNonNull(matches);
        Objects.requireNonNull(consumer);
        int expireMs = 3000;
        Supplier<GTreeNode> supplier = () -> {
            GTreeNode modelParent = this.getModelNode(parent);
            if (modelParent == null) {
                return null;
            }
            List<GTreeNode> children = modelParent.getChildren();
            for (GTreeNode node : children) {
                if (!matches.test(node)) continue;
                return node;
            }
            return null;
        };
        ExpiringSwingTimer.get(supplier, (int)expireMs, consumer);
    }

    private void getViewNode(GTreeNode parent, Predicate<GTreeNode> matches, Consumer<GTreeNode> consumer) {
        Objects.requireNonNull(parent);
        Objects.requireNonNull(matches);
        Objects.requireNonNull(consumer);
        int expireMs = 3000;
        Supplier<GTreeNode> supplier = () -> {
            GTreeNode viewParent = this.getViewNode(parent);
            if (viewParent == null) {
                return null;
            }
            List<GTreeNode> children = viewParent.getChildren();
            for (GTreeNode node : children) {
                if (!matches.test(node)) continue;
                return node;
            }
            return null;
        };
        ExpiringSwingTimer.get(supplier, (int)expireMs, consumer);
    }

    public void whenNodeIsReady(GTreeNode parent, Predicate<GTreeNode> matches, Consumer<GTreeNode> consumer) {
        GTreeNode modelParent = this.getModelNode(parent);
        if (modelParent == null) {
            Msg.error((Object)this, (Object)("Attempted to show a node with an invalid parent.\n\tParent: " + String.valueOf(parent)));
            return;
        }
        this.getModelNode(modelParent, matches, newModelChildren -> {
            this.ignoreFilter((GTreeNode)newModelChildren);
            this.getViewNode(modelParent, matches, consumer);
        });
    }

    public void whenNodeIsReady(GTreeNode parent, String childName, Consumer<GTreeNode> consumer) {
        Predicate<GTreeNode> nameMatches = n -> n.getName().equals(childName);
        this.whenNodeIsReady(parent, nameMatches, consumer);
    }

    public void startEditing(GTreeNode parent, String childName) {
        this.expandPath(parent);
        Predicate<GTreeNode> nameMatches = n -> n.getName().equals(childName);
        GTreeNode modelParent = this.getModelNode(parent);
        this.whenNodeIsReady(modelParent, nameMatches, (GTreeNode editNode) -> this.runTask(new GTreeStartEditingTask(this, this.tree, (GTreeNode)editNode)));
    }

    public void startEditing(GTreeNode node) {
        this.expandPath(node.getParent());
        GTreeNode viewNode = this.getViewNode(node);
        if (viewNode == null) {
            this.startEditing(node.getParent(), node.getName());
            return;
        }
        this.runTask(new GTreeStartEditingTask(this, this.tree, viewNode));
    }

    @Override
    public synchronized void addMouseListener(MouseListener listener) {
        this.mouseListenerDelegate.addMouseListener(listener);
    }

    @Override
    public synchronized void removeMouseListener(MouseListener listener) {
        this.mouseListenerDelegate.removeMouseListener(listener);
    }

    @Override
    public synchronized MouseListener[] getMouseListeners() {
        return this.mouseListenerDelegate.getMouseListeners();
    }

    public void setCellEditor(TreeCellEditor editor) {
        this.tree.setCellEditor(editor);
    }

    public boolean isPathEditable(TreePath path) {
        GTreeNode node = (GTreeNode)path.getLastPathComponent();
        return node.isEditable();
    }

    public void setPaintHandlesForLeafNodes(boolean enable) {
        this.tree.setPaintHandlesForLeafNodes(enable);
    }

    public boolean isRootAllowedToCollapse() {
        return this.tree.isRootAllowedToCollapse();
    }

    public void setRootNodeAllowedToCollapse(boolean allowed) {
        this.tree.setRootNodeAllowedToCollapse(allowed);
    }

    private void showProgressPanel(boolean show) {
        if (show) {
            this.progressPanel = this.monitor;
            this.mainPanel.add((Component)this.progressPanel, "South");
            this.progressPanel.invalidate();
        } else if (this.progressPanel != null) {
            this.mainPanel.remove(this.progressPanel);
            this.progressPanel = null;
        }
        this.validate();
        this.repaint();
    }

    private void showProgress(int delay) {
        Runnable r = () -> {
            if (delay <= 0) {
                this.showProgressPanel(true);
            } else {
                this.showTimer = new Timer(delay, ev -> {
                    if (this.isBusy()) {
                        this.showProgressPanel(true);
                        this.showTimer = null;
                    }
                });
                this.showTimer.setInitialDelay(delay);
                this.showTimer.setRepeats(false);
                this.showTimer.start();
            }
        };
        SwingUtilities.invokeLater(r);
    }

    public boolean isBusy() {
        return this.worker.isBusy();
    }

    public void setBusy(boolean busy) {
        SystemUtilities.runSwingLater(() -> {
            if (busy) {
                this.showProgress(1000);
            } else {
                this.showProgressPanel(false);
            }
        });
    }

    public void refilterNow() {
        if (this.isFilteringEnabled && this.filter != null) {
            this.filterUpdateManager.updateNow();
        }
    }

    public void refilterLater() {
        if (this.isFilteringEnabled && this.filter != null) {
            this.filterUpdateManager.updateLater();
        }
    }

    public void refilterLater(GTreeNode newNode) {
        if (!this.isFilteringEnabled || this.filter == null) {
            return;
        }
        if (!newNode.isLeaf() || this.filter.acceptsNode(newNode)) {
            this.filterUpdateManager.updateLater();
        }
    }

    public GTreeFilter getFilter() {
        return this.filter;
    }

    public boolean isFiltered() {
        return this.filter != null;
    }

    public boolean hasFilterText() {
        return !StringUtils.isBlank((CharSequence)this.filterProvider.getFilterText());
    }

    public String getFilterText() {
        return this.filterProvider.getFilterText();
    }

    public void clearFilter() {
        this.filterProvider.setFilterText("");
    }

    public void runTask(GTreeTask task) {
        this.worker.schedule((PriorityJob)task);
    }

    public void runTask(final MonitoredRunnable runnableTask) {
        this.worker.schedule((PriorityJob)new GTreeTask(this, this){

            public void run(TaskMonitor localMonitor) throws CancelledException {
                runnableTask.monitoredRun(localMonitor);
            }
        });
    }

    public void runBulkTask(GTreeBulkTask task) {
        this.worker.schedule((PriorityJob)task);
    }

    public boolean isEditing() {
        return this.tree.isEditing();
    }

    public void stopEditing() {
        this.tree.stopEditing();
    }

    public void cancelEditing() {
        this.tree.cancelEditing();
    }

    public void setNodeEditable(GTreeNode child) {
    }

    @Override
    public String toString() {
        GTreeNode rootNode = this.getModelRoot();
        if (rootNode == null) {
            return "GTree - no root node";
        }
        return rootNode.toString();
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        String text = super.getToolTipText(event);
        if (text != null) {
            return text;
        }
        return this.tree.getDefaultToolTipText(event);
    }

    public void clearSizeCache() {
        this.recurseClearSizeCache(this.getViewRoot());
    }

    private void recurseClearSizeCache(GTreeNode node) {
        if (this.isExpanded(node.getTreePath())) {
            for (GTreeNode child : node.getChildren()) {
                this.recurseClearSizeCache(child);
            }
        }
        node.fireNodeChanged();
    }

    protected boolean isAddToPopup(DockingAction action) {
        return true;
    }

    public void setDoubleClickExpansionEnabled(boolean b) {
        this.tree.setToggleClickCount(b ? 2 : 0);
    }

    public static void createSharedActions(Tool tool, ToolActions toolActions, String owner) {
        String actionMenuGroup = "zzzTreeGroup";
        tool.setMenuGroup(new String[]{"Collapse"}, actionMenuGroup, "1");
        tool.setMenuGroup(new String[]{"Expand"}, actionMenuGroup, "2");
        int subGroupIndex = 1;
        GTreeAction collapseAction = new GTreeAction("Tree Collapse Node", owner){

            @Override
            public void actionPerformed(ActionContext context) {
                GTree gTree = this.getTree(context);
                List<GTreeNode> nodes = gTree.getSelectedNodes();
                for (GTreeNode node : nodes) {
                    gTree.collapseAll(node);
                }
            }

            @Override
            public boolean isEnabledForContext(ActionContext context) {
                if (!super.isEnabledForContext(context)) {
                    return false;
                }
                GTree gTree = this.getTree(context);
                List<GTreeNode> nodes = gTree.getSelectedNodes();
                return !nodes.isEmpty();
            }
        };
        collapseAction.setPopupMenuData(new MenuData(new String[]{"Collapse"}, Icons.COLLAPSE_ALL_ICON, actionMenuGroup, -1, Integer.toString(subGroupIndex++)));
        collapseAction.setKeyBindingData(new KeyBindingData(38, 512));
        GTreeAction expandAction = new GTreeAction("Tree Expand Node", owner){

            @Override
            public void actionPerformed(ActionContext context) {
                GTree gTree = this.getTree(context);
                List<GTreeNode> nodes = gTree.getSelectedNodes();
                for (GTreeNode node : nodes) {
                    gTree.expandTree(node);
                }
            }

            @Override
            public boolean isEnabledForContext(ActionContext context) {
                if (!super.isEnabledForContext(context)) {
                    return false;
                }
                GTree gTree = this.getTree(context);
                List<GTreeNode> nodes = gTree.getSelectedNodes();
                return !nodes.isEmpty();
            }
        };
        expandAction.setPopupMenuData(new MenuData(new String[]{"Expand"}, Icons.EXPAND_ALL_ICON, actionMenuGroup, -1, Integer.toString(subGroupIndex++)));
        expandAction.setKeyBindingData(new KeyBindingData(40, 512));
        GTreeAction collapseTreeAction = new GTreeAction("Tree Collapse All", owner){

            @Override
            public void actionPerformed(ActionContext context) {
                GTree gTree = this.getTree(context);
                GTreeNode root = gTree.getViewRoot();
                gTree.collapseAll(root);
            }
        };
        collapseTreeAction.setPopupMenuData(new MenuData(new String[]{"Collapse Tree"}, null, actionMenuGroup, -1, Integer.toString(subGroupIndex++)));
        GTreeAction expandTreeAction = new GTreeAction("Tree Expand All", owner){

            @Override
            public void actionPerformed(ActionContext context) {
                GTree gTree = this.getTree(context);
                gTree.expandAll();
            }
        };
        expandTreeAction.setPopupMenuData(new MenuData(new String[]{"Expand Tree"}, null, actionMenuGroup, -1, Integer.toString(subGroupIndex++)));
        GTreeAction copyFormattedAction = new GTreeAction("Tree Copy Formatted", owner){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionContext context) {
                GTree gTree = this.getTree(context);
                gTree.tree.isCopyFormatted = true;
                try {
                    Action builtinCopyAction = TransferHandler.getCopyAction();
                    builtinCopyAction.actionPerformed(new ActionEvent(gTree.tree, 0, "copy"));
                }
                finally {
                    gTree.tree.isCopyFormatted = false;
                }
            }
        };
        copyFormattedAction.setPopupMenuData(new MenuData(new String[]{"Copy Formatted"}, null, actionMenuGroup, -1, Integer.toString(subGroupIndex++)));
        copyFormattedAction.setHelpLocation(new HelpLocation("Trees", "Copy_Formatted"));
        GTreeAction activateFilterAction = new GTreeAction("Table/Tree Activate Filter", owner){

            @Override
            public void actionPerformed(ActionContext context) {
                GTree gTree = this.getTree(context);
                gTree.filterProvider.activate();
            }
        };
        activateFilterAction.setPopupMenuData(new MenuData(new String[]{"Activate Filter"}, null, actionMenuGroup, -1, Integer.toString(subGroupIndex++)));
        activateFilterAction.setKeyBindingData(new KeyBindingData("Control F"));
        activateFilterAction.setHelpLocation(new HelpLocation("Trees", "Toggle_Filter"));
        GTreeAction toggleFilterAction = new GTreeAction("Table/Tree Toggle Filter", owner){

            @Override
            public void actionPerformed(ActionContext context) {
                GTree gTree = this.getTree(context);
                gTree.filterProvider.toggleVisibility();
            }
        };
        toggleFilterAction.setPopupMenuData(new MenuData(new String[]{"Toggle Filter"}, null, actionMenuGroup, -1, Integer.toString(subGroupIndex++)));
        toggleFilterAction.setHelpLocation(new HelpLocation("Trees", "Toggle_Filter"));
        collapseAction.markHelpUnnecessary();
        expandAction.markHelpUnnecessary();
        collapseTreeAction.markHelpUnnecessary();
        expandTreeAction.markHelpUnnecessary();
        toolActions.addGlobalAction(collapseAction);
        toolActions.addGlobalAction(expandAction);
        toolActions.addGlobalAction(collapseTreeAction);
        toolActions.addGlobalAction(expandTreeAction);
        toolActions.addGlobalAction(copyFormattedAction);
        toolActions.addGlobalAction(activateFilterAction);
        toolActions.addGlobalAction(toggleFilterAction);
    }

    private static String generateFilterPreferenceKey() {
        Throwable throwable = new Throwable();
        StackTraceElement[] stackTrace = throwable.getStackTrace();
        return GTree.getInceptionInformationFromTheFirstClassThatIsNotUs(stackTrace);
    }

    private static String getInceptionInformationFromTheFirstClassThatIsNotUs(StackTraceElement[] stackTrace) {
        String myClassName = GTree.class.getName();
        int myClassNameStartIndex = -1;
        for (int i = 1; i < stackTrace.length; ++i) {
            StackTraceElement stackTraceElement = stackTrace[i];
            String elementClassName = stackTraceElement.getClassName();
            if (!myClassName.equals(elementClassName)) continue;
            myClassNameStartIndex = i;
            break;
        }
        int creatorIndex = myClassNameStartIndex;
        for (int i = myClassNameStartIndex; i < stackTrace.length; ++i) {
            StackTraceElement stackTraceElement = stackTrace[i];
            String elementClassName = stackTraceElement.getClassName();
            if (myClassName.equals(elementClassName) || elementClassName.toLowerCase().endsWith("tree")) continue;
            creatorIndex = i;
            break;
        }
        return stackTrace[creatorIndex].getClassName();
    }

    class AutoScrollTree
    extends JTree
    implements Autoscroll {
        private AutoscrollAdapter scroller;
        private boolean paintLeafHandles;
        private int scrollableUnitIncrementOverride;
        private boolean allowRootCollapse;
        private boolean isCopyFormatted;

        public AutoScrollTree(TreeModel model) {
            super(model);
            this.paintLeafHandles = true;
            this.scrollableUnitIncrementOverride = -1;
            this.allowRootCollapse = true;
            this.setBackground(BACKGROUND);
            this.scroller = new AutoscrollAdapter(this, 5);
            this.setRowHeight(-1);
            this.setSelectionModel(new GTreeSelectionModel());
            this.setInvokesStopCellEditing(true);
            this.updateDefaultKeyBindings();
            ToolTipManager.sharedInstance().registerComponent(this);
        }

        @Override
        public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            String spacing = "";
            if (this.isCopyFormatted) {
                GTreeNode node = (GTreeNode)value;
                TreePath path = node.getTreePath();
                int n = path.getPathCount();
                int tabs = (n - 1) * 4;
                spacing = StringUtils.repeat((char)' ', (int)tabs);
            }
            String text = super.convertValueToText(value, selected, expanded, leaf, row, hasFocus);
            return spacing + text;
        }

        private void updateDefaultKeyBindings() {
            KeyBindingUtils.clearKeyBinding((JComponent)this, "startEditing");
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            if (this.scrollableUnitIncrementOverride != -1) {
                return this.scrollableUnitIncrementOverride;
            }
            return super.getScrollableUnitIncrement(visibleRect, orientation, direction);
        }

        public void setScrollableUnitIncrement(int increment) {
            this.scrollableUnitIncrementOverride = increment;
        }

        GTree getGTree() {
            return GTree.this;
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            return this.getGTree().getToolTipText(event);
        }

        public String getDefaultToolTipText(MouseEvent event) {
            return super.getToolTipText(event);
        }

        @Override
        public void autoscroll(Point cursorLocn) {
            this.scroller.autoscroll(cursorLocn);
        }

        @Override
        public Insets getAutoscrollInsets() {
            return this.scroller.getAutoscrollInsets();
        }

        @Override
        public boolean isPathEditable(TreePath path) {
            return this.getGTree().isPathEditable(path);
        }

        @Override
        public boolean hasBeenExpanded(TreePath path) {
            if (this.paintLeafHandles) {
                return super.hasBeenExpanded(path);
            }
            return true;
        }

        public void setPaintHandlesForLeafNodes(boolean enable) {
            this.paintLeafHandles = enable;
        }

        public void setRootNodeAllowedToCollapse(boolean allowed) {
            if (this.allowRootCollapse == allowed) {
                return;
            }
            this.allowRootCollapse = allowed;
            if (!allowed && GTree.this.model != null && GTree.this.model.getRoot() != null) {
                GTree.this.runTask(new GTreeExpandNodeToDepthTask(GTree.this, GTree.this.model.getModelRoot(), 1));
            }
        }

        public boolean isRootAllowedToCollapse() {
            return this.allowRootCollapse;
        }

        @Override
        public synchronized void addMouseListener(MouseListener l) {
            if (GTree.this.mouseListenerDelegate == null) {
                super.addMouseListener(l);
            } else {
                GTree.this.mouseListenerDelegate.addMouseListener(l);
            }
        }

        @Override
        public synchronized void removeMouseListener(MouseListener l) {
            if (GTree.this.mouseListenerDelegate == null) {
                super.removeMouseListener(l);
            } else {
                GTree.this.mouseListenerDelegate.removeMouseListener(l);
            }
        }

        @Override
        public synchronized MouseListener[] getMouseListeners() {
            if (GTree.this.mouseListenerDelegate == null) {
                return super.getMouseListeners();
            }
            return GTree.this.mouseListenerDelegate.getMouseListeners();
        }

        @Override
        public void removeSelectionPath(TreePath path) {
            GTreeSelectionModel gTreeSelectionModel = (GTreeSelectionModel)this.getSelectionModel();
            gTreeSelectionModel.userRemovedSelectionPath(path);
        }
    }

    private class GTreeMouseListenerDelegate
    extends JTreeMouseListenerDelegate {
        private final GTree gTree;

        GTreeMouseListenerDelegate(GTree gTree, JTree jTree, GTree gTree2) {
            super(jTree);
            this.gTree = gTree2;
        }

        @Override
        protected void setSelectedPathNow(TreePath path) {
            GTreeSelectionModel selectionModel = (GTreeSelectionModel)this.gTree.getSelectionModel();
            selectionModel.setSelectionPaths(new TreePath[]{path}, GTreeSelectionEvent.EventOrigin.USER_GENERATED);
        }
    }

    private static abstract class GTreeAction
    extends DockingAction
    implements ComponentBasedDockingAction {
        GTreeAction(String name, String owner) {
            super(name, owner);
        }

        @Override
        public boolean isAddToPopup(ActionContext context) {
            if (!this.isEnabledForContext(context)) {
                return false;
            }
            GTree gTree = this.getTree(context);
            return gTree.isAddToPopup(this);
        }

        @Override
        public boolean isEnabledForContext(ActionContext context) {
            return this.getTree(context) != null;
        }

        @Override
        public boolean isValidComponentContext(ActionContext context) {
            return this.getTree(context) != null;
        }

        protected GTree getTree(ActionContext context) {
            Component c = context.getSourceComponent();
            if (c instanceof GTree) {
                return (GTree)c;
            }
            if (c instanceof AutoScrollTree) {
                return ((AutoScrollTree)c).getGTree();
            }
            return null;
        }
    }
}

