/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.search;

import docking.widgets.CursorPosition;
import docking.widgets.SearchLocation;
import docking.widgets.search.FindDialogSearcher;
import docking.widgets.search.SearchLocationContext;
import docking.widgets.search.SearchLocationContextBuilder;
import docking.widgets.search.SearchResults;
import docking.widgets.search.TextComponentSearchLocation;
import docking.widgets.search.TextComponentSearchResults;
import ghidra.util.Msg;
import ghidra.util.UserSearchUtils;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import ghidra.util.worker.Worker;
import java.awt.Component;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class TextComponentSearcher
implements FindDialogSearcher {
    static final int MAX_CONTEXT_CHARS = 100;
    private int maxContextChars = 100;
    protected JEditorPane editorPane;
    private Worker worker = Worker.createGuiWorker();
    private TextComponentSearchResults searchResults;

    public TextComponentSearcher(JEditorPane editorPane) {
        this.editorPane = editorPane;
    }

    public void setEditorPane(JEditorPane editorPane) {
        if (this.editorPane != editorPane && this.searchResults != null) {
            this.searchResults.dispose();
            this.searchResults = null;
        }
        this.editorPane = editorPane;
    }

    public JEditorPane getEditorPane() {
        return this.editorPane;
    }

    void setMaxContextChars(int max) {
        this.maxContextChars = max;
    }

    public boolean isBusy() {
        return this.worker.isBusy();
    }

    @Override
    public void dispose() {
        if (this.searchResults != null) {
            this.searchResults.dispose();
            this.searchResults = null;
        }
    }

    public boolean hasSearchResults() {
        return this.searchResults != null && !this.searchResults.isEmpty();
    }

    public boolean isStale() {
        return this.searchResults != null && this.searchResults.isStale();
    }

    @Override
    public CursorPosition getCursorPosition() {
        int pos = this.editorPane.getCaretPosition();
        return new CursorPosition(pos);
    }

    @Override
    public CursorPosition getStart() {
        return new CursorPosition(0);
    }

    @Override
    public CursorPosition getEnd() {
        int length = this.editorPane.getDocument().getLength();
        return new CursorPosition(length - 1);
    }

    @Override
    public TextComponentSearchResults searchAll(String text, boolean useRegex) {
        return this.doSearch(text, useRegex);
    }

    @Override
    public SearchResults search(String text, CursorPosition cursorPosition, boolean searchForward, boolean useRegex) {
        this.updateSearchResults(text, useRegex);
        int pos = cursorPosition.getPosition();
        int searchStart = this.getSearchStart(pos, searchForward);
        if (searchStart == -1) {
            return null;
        }
        TextComponentSearchLocation location = this.searchResults.getNextLocation(searchStart, searchForward);
        if (location == null) {
            return null;
        }
        this.searchResults.setActiveLocation(location);
        return this.searchResults;
    }

    private void updateSearchResults(String text, boolean useRegex) {
        if (this.searchResults != null) {
            if (!this.searchResults.isInvalid(text)) {
                this.searchResults.activate();
                return;
            }
            this.searchResults.dispose();
            this.searchResults = null;
        }
        this.searchResults = this.doSearch(text, useRegex);
    }

    private TextComponentSearchResults doSearch(String text, boolean useRegex) {
        SearchTask searchTask = new SearchTask(text, useRegex);
        TaskLauncher.launch(searchTask);
        TextComponentSearchResults newSearchResults = searchTask.doCreateSearchResults();
        newSearchResults.activate();
        return newSearchResults;
    }

    private int getSearchStart(int startPosition, boolean isForward) {
        SearchLocation location = this.searchResults.getActiveLocation();
        if (location == null) {
            return startPosition;
        }
        int lastMatchStart = location.getStartIndexInclusive();
        if (startPosition != lastMatchStart) {
            return startPosition;
        }
        if (isForward) {
            int next = startPosition + 1;
            int end = this.editorPane.getText().length();
            if (next == end) {
                return -1;
            }
            return next;
        }
        if (startPosition == 0) {
            return -1;
        }
        return startPosition - 1;
    }

    protected TextComponentSearchResults createSearchResults(Worker theWorker, JEditorPane editor, String searchText, TreeMap<Integer, TextComponentSearchLocation> matchesByPosition) {
        return new TextComponentSearchResults(theWorker, editor, searchText, matchesByPosition);
    }

    private class SearchTask
    extends Task {
        private String searchText;
        private TreeMap<Integer, TextComponentSearchLocation> matchesByPosition;
        private boolean useRegex;

        SearchTask(String searchText, boolean useRegex) {
            super("Text Find Task", true, false, true, true);
            this.matchesByPosition = new TreeMap();
            this.searchText = searchText;
            this.useRegex = useRegex;
        }

        TextComponentSearchResults doCreateSearchResults() {
            return TextComponentSearcher.this.createSearchResults(TextComponentSearcher.this.worker, TextComponentSearcher.this.editorPane, this.searchText, this.matchesByPosition);
        }

        public void run(TaskMonitor monitor) throws CancelledException {
            String fullText;
            try {
                Document document = TextComponentSearcher.this.editorPane.getDocument();
                fullText = document.getText(0, document.getLength());
            }
            catch (BadLocationException e) {
                Msg.error((Object)((Object)this), (Object)"Unable to get text for user find operation", (Throwable)e);
                return;
            }
            TreeMap<Integer, Line> lineRangeMap = this.mapLines(fullText);
            Pattern pattern = this.createSearchPattern(this.searchText, this.useRegex);
            Matcher matcher = pattern.matcher(fullText);
            while (matcher.find()) {
                monitor.checkCancelled();
                int start = matcher.start();
                int end = matcher.end();
                Line line = lineRangeMap.floorEntry(start).getValue();
                String matchText = fullText.substring(start, end);
                SearchLocationContext context = this.createContext(line, start, end);
                TextComponentSearchLocation location = new TextComponentSearchLocation(matchText, start, end - 1, line.lineNumber(), context);
                this.matchesByPosition.put(start, location);
            }
        }

        private TreeMap<Integer, Line> mapLines(String fullText) {
            String[] lines;
            TreeMap<Integer, Line> linesRangeMap = new TreeMap<Integer, Line>();
            int lineNumber = 0;
            int pos = 0;
            for (String line : lines = fullText.split("\\n")) {
                linesRangeMap.put(pos, new Line(line, ++lineNumber, pos));
                pos += line.length() + 1;
            }
            return linesRangeMap;
        }

        private SearchLocationContext createContext(Line line, int start, int end) {
            int max;
            SearchLocationContextBuilder builder = new SearchLocationContextBuilder();
            String text = line.text();
            int offset = line.offset();
            int rstart = start - offset;
            int rend = end - offset;
            int lineStart = 0;
            int lineEnd = text.length();
            int length = text.length();
            if (length > (max = TextComponentSearcher.this.maxContextChars)) {
                int matchLength = end - start;
                int remaining = max - matchLength;
                int half = remaining / 2;
                int firstHalf = rstart;
                int available = Math.min(half, firstHalf);
                int newStart = rstart - available;
                available = max - (available + matchLength);
                int newEnd = Math.min(length, rend + available);
                lineStart = newStart;
                lineEnd = newEnd;
            }
            if (lineStart != 0) {
                builder.append("...");
            }
            builder.append(text.substring(lineStart, rstart));
            builder.appendMatch(text.substring(rstart, rend));
            if (rend < text.length()) {
                builder.append(text.substring(rend, lineEnd));
            }
            if (lineEnd < text.length()) {
                builder.append("...");
            }
            return builder.build();
        }

        private Pattern createSearchPattern(String searchString, boolean isRegex) {
            int options = 34;
            if (isRegex) {
                try {
                    return Pattern.compile(searchString, options);
                }
                catch (PatternSyntaxException e) {
                    Msg.showError((Object)((Object)this), (Component)TextComponentSearcher.this.editorPane, (String)"Regular Expression Syntax Error", (Object)e.getMessage());
                    return null;
                }
            }
            return UserSearchUtils.createPattern((String)searchString, (boolean)false, (int)options);
        }

        record Line(String text, int lineNumber, int offset) {
        }
    }
}

