/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.search;

import generic.json.Json;
import ghidra.util.HTMLUtilities;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class SearchLocationContext {
    private static final String EMBOLDEN_START = "<span style=\"background-color: #a3e4d7; color: black;\"><b><font size=4>";
    private static final String EMBOLDEN_END = "</font></b></span>";
    public static final SearchLocationContext EMPTY_CONTEXT = new SearchLocationContext();
    private final List<Part> parts;

    public static SearchLocationContext get(String text) {
        return text == null ? EMPTY_CONTEXT : new SearchLocationContext(text);
    }

    public static SearchLocationContext get(SearchLocationContext context) {
        return context == null ? EMPTY_CONTEXT : context;
    }

    private SearchLocationContext() {
        this.parts = List.of(new BasicPart(""));
    }

    private SearchLocationContext(String context) {
        Objects.requireNonNull(context);
        this.parts = List.of(new BasicPart(context));
    }

    SearchLocationContext(List<Part> parts) {
        this.parts = parts;
    }

    public String getPlainText() {
        StringBuilder buffy = new StringBuilder();
        for (Part part : this.parts) {
            buffy.append(part.getText());
        }
        return buffy.toString();
    }

    public String getDebugText() {
        StringBuilder buffy = new StringBuilder();
        for (Part part : this.parts) {
            buffy.append(part.getDebugText());
        }
        return buffy.toString();
    }

    public String getBoldMatchingText() {
        StringBuilder buffy = new StringBuilder();
        for (Part part : this.parts) {
            buffy.append(part.getHtmlText());
        }
        return "<html>" + buffy.toString();
    }

    public List<String> getMatches() {
        ArrayList<String> matches = new ArrayList<String>();
        for (Part part : this.parts) {
            if (!(part instanceof MatchPart)) continue;
            matches.add(part.getText());
        }
        return matches;
    }

    public String toString() {
        return this.getPlainText();
    }

    static class BasicPart
    extends Part {
        BasicPart(String text) {
            super(text);
        }

        @Override
        String getDebugText() {
            return this.text;
        }

        @Override
        String getHtmlText() {
            String escaped = HTMLUtilities.escapeHTML((String)this.text);
            String updated = BasicPart.fixBreakingSpaces(escaped);
            return updated;
        }
    }

    static abstract class Part {
        protected String text;

        Part(String text) {
            this.text = text;
        }

        String getText() {
            return this.text;
        }

        abstract String getHtmlText();

        abstract String getDebugText();

        static String fixBreakingSpaces(String s) {
            String updated = s.replaceAll("\\s", "&nbsp;");
            return updated;
        }

        public String toString() {
            return Json.toString((Object)this);
        }
    }

    static class MatchPart
    extends Part {
        MatchPart(String text) {
            super(text);
        }

        @Override
        String getDebugText() {
            return " [[ " + this.text + " ]] ";
        }

        @Override
        String getHtmlText() {
            String escaped = HTMLUtilities.escapeHTML((String)this.text);
            String updated = MatchPart.fixBreakingSpaces(escaped);
            return SearchLocationContext.EMBOLDEN_START + updated + SearchLocationContext.EMBOLDEN_END;
        }
    }
}

