/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.data.exceptionhandling;

import ghidra.app.cmd.data.AbstractCreateDataBackgroundCmd;
import ghidra.app.cmd.data.exceptionhandling.CreateEHCatchHandlerMapBackgroundCmd;
import ghidra.app.cmd.data.exceptionhandling.EHCatchHandlerModel;
import ghidra.app.cmd.data.exceptionhandling.EHTryBlockModel;
import ghidra.app.util.datatype.microsoft.DataApplyOptions;
import ghidra.app.util.datatype.microsoft.DataValidationOptions;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;

public class CreateEHTryBlockMapBackgroundCmd
extends AbstractCreateDataBackgroundCmd<EHTryBlockModel> {
    public CreateEHTryBlockMapBackgroundCmd(Address address, int count) {
        super(EHTryBlockModel.DATA_TYPE_NAME, address, count);
    }

    public CreateEHTryBlockMapBackgroundCmd(Address address, int count, DataValidationOptions validationOptions, DataApplyOptions applyOptions) {
        super(EHTryBlockModel.DATA_TYPE_NAME, address, count, validationOptions, applyOptions);
    }

    CreateEHTryBlockMapBackgroundCmd(EHTryBlockModel tryBlockModel, DataApplyOptions applyOptions) {
        super(tryBlockModel, applyOptions);
    }

    @Override
    protected EHTryBlockModel createModel(Program program) {
        if (this.model == null) {
            this.model = new EHTryBlockModel(program, this.count, this.getDataAddress(), this.validationOptions);
        }
        return (EHTryBlockModel)this.model;
    }

    @Override
    protected boolean createAssociatedData() throws CancelledException {
        return this.createCatchHandlerMapEntries();
    }

    private boolean createCatchHandlerMapEntries() throws CancelledException {
        this.monitor.setMessage("Creating HandlerTypes from TryBlockMap");
        boolean result = true;
        Program program = ((EHTryBlockModel)this.model).getProgram();
        for (int tryBlockEntryOrdinal = 0; tryBlockEntryOrdinal < this.count; ++tryBlockEntryOrdinal) {
            EHCatchHandlerModel catchHandlerModel;
            int catchHandlerCount;
            Address catchHandlerMapAddress;
            Address compAddress;
            this.monitor.checkCancelled();
            try {
                compAddress = ((EHTryBlockModel)this.model).getComponentAddressOfCatchHandlerMapAddress(tryBlockEntryOrdinal);
                catchHandlerMapAddress = ((EHTryBlockModel)this.model).getCatchHandlerMapAddress(tryBlockEntryOrdinal);
                catchHandlerCount = ((EHTryBlockModel)this.model).getCatchHandlerCount(tryBlockEntryOrdinal);
            }
            catch (InvalidDataTypeException e) {
                throw new AssertException((Throwable)e);
            }
            if (catchHandlerMapAddress == null || catchHandlerCount == 0) continue;
            try {
                catchHandlerModel = ((EHTryBlockModel)this.model).getCatchHandlerModel(tryBlockEntryOrdinal);
            }
            catch (InvalidDataTypeException e) {
                throw new AssertException((Throwable)e);
            }
            try {
                catchHandlerModel.validate();
            }
            catch (InvalidDataTypeException e1) {
                this.handleErrorMessage(program, catchHandlerModel.getName(), catchHandlerMapAddress, compAddress, (Exception)((Object)e1));
                result = false;
                continue;
            }
            this.monitor.checkCancelled();
            CreateEHCatchHandlerMapBackgroundCmd cmd = new CreateEHCatchHandlerMapBackgroundCmd(catchHandlerModel, this.applyOptions);
            result &= cmd.applyTo(program, this.monitor);
        }
        return result;
    }

    @Override
    protected boolean createMarkup() throws CancelledException {
        return true;
    }
}

