/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.spatial.rtree;

import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.jungrapht.visualization.spatial.rtree.LeafNode;
import org.jungrapht.visualization.spatial.rtree.Node;
import org.jungrapht.visualization.spatial.rtree.Pair;
import org.jungrapht.visualization.spatial.rtree.RTreeNode;
import org.jungrapht.visualization.spatial.rtree.SplitterContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InnerNode<T>
extends RTreeNode<T>
implements Node<T> {
    private static final Logger log = LoggerFactory.getLogger(InnerNode.class);
    private Optional<Rectangle2D> bounds = Optional.empty();
    private List<Node<T>> children;
    private final boolean leafChildren;

    public static <T> InnerNode<T> create(Node<T> node) {
        return new InnerNode<T>(node);
    }

    public static <T> InnerNode<T> create(InnerNode<T> node) {
        return new InnerNode<T>(node);
    }

    public static <T> InnerNode<T> create(Collection<Node<T>> nodes) {
        return new InnerNode<T>(nodes);
    }

    InnerNode(Node<T> node) {
        node.setParent(this);
        this.updateBounds(node.getBounds());
        this.leafChildren = node instanceof LeafNode;
        this.children = new ArrayList<Node<T>>();
        this.children.add(node);
    }

    InnerNode(Collection<Node<T>> nodes) {
        this.children = new ArrayList<Node<T>>();
        Node<T> sample = null;
        Iterator<Node<T>> iterator = nodes.iterator();
        while (iterator.hasNext()) {
            Node<T> node;
            sample = node = iterator.next();
            node.setParent(this);
            this.updateBounds(node.getBounds());
            this.children.add(node);
        }
        this.leafChildren = sample instanceof LeafNode;
    }

    @Override
    public boolean isLeafChildren() {
        return this.leafChildren;
    }

    public Node<T> get(int i) {
        return this.children.get(i);
    }

    public List<Node<T>> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public Rectangle2D getBounds() {
        return this.bounds.orElse(new Rectangle2D.Double());
    }

    @Override
    public Point2D centerOfGravity() {
        int count = this.children.size();
        double xSum = 0.0;
        double ySum = 0.0;
        for (Node<T> child : this.children) {
            Rectangle2D r = child.getBounds();
            xSum += r.getCenterX();
            ySum += r.getCenterY();
        }
        return new Point2D.Double(xSum / (double)count, ySum / (double)count);
    }

    @Override
    public Node<T> recalculateBounds() {
        this.bounds = Optional.empty();
        for (Node<T> child : this.children) {
            this.updateBounds(child.getBounds());
        }
        if (this.parent.isPresent()) {
            return ((Node)this.parent.get()).recalculateBounds();
        }
        return this;
    }

    @Override
    public T getPickedObject(Point2D p) {
        T picked = null;
        if (this.getBounds().contains(p)) {
            Node<T> child;
            log.trace("{} does contain {}", (Object)this, (Object)p);
            Iterator<Node<T>> iterator = this.children.iterator();
            while (iterator.hasNext() && (picked = (T)(child = iterator.next()).getPickedObject(p)) == null) {
            }
        } else {
            log.trace("{} does not contain {}", (Object)this, (Object)p);
        }
        return picked;
    }

    @Override
    public int size() {
        return this.children.size();
    }

    private Node<T> findElement(T o) {
        Node<T> found = null;
        for (Node<T> kid : this.children) {
            if (kid instanceof LeafNode) {
                return kid;
            }
            found = ((InnerNode)kid).findElement(o);
        }
        return found;
    }

    @Override
    public LeafNode<T> getContainingLeaf(T element) {
        Node<T> child;
        LeafNode<T> containingLeaf = null;
        Iterator<Node<T>> iterator = this.children.iterator();
        while (iterator.hasNext() && (containingLeaf = (child = iterator.next()).getContainingLeaf(element)) == null) {
        }
        return containingLeaf;
    }

    LeafNode<T> getContainingLeaf(T element, Rectangle2D bounds) {
        LeafNode<T> containingLeaf = null;
        for (Node<T> node : this.children) {
            if (node.getBounds().intersects(bounds) && (containingLeaf = node.getContainingLeaf(element)) != null) break;
        }
        return containingLeaf;
    }

    @Override
    public Set<LeafNode<T>> getContainingLeafs(Set<LeafNode<T>> containingLeafs, Point2D p) {
        return this.getContainingLeafs(containingLeafs, p.getX(), p.getY());
    }

    @Override
    public Set<LeafNode<T>> getContainingLeafs(Set<LeafNode<T>> containingLeafs, double x, double y) {
        if (this.getBounds().contains(x, y)) {
            for (Node<T> node : this.children) {
                node.getContainingLeafs(containingLeafs, x, y);
            }
        }
        return containingLeafs;
    }

    @Override
    public Collection<Shape> collectGrids(Collection<Shape> list) {
        list.add(this.getBounds());
        for (Node<T> child : this.children) {
            child.collectGrids(list);
        }
        log.trace("in nonleaf {}, added {} so list size now {}", new Object[]{this.hashCode(), this.children.size(), list.size()});
        return list;
    }

    private void add(Collection<? extends Node<T>> collection) {
        this.children.addAll(collection);
    }

    private void updateBounds(Rectangle2D r) {
        this.bounds = this.bounds.map(rectangle2D -> rectangle2D.createUnion(r)).or(() -> Optional.of(r));
        Rectangle2D b = this.bounds.get();
    }

    @Override
    public Node<T> add(SplitterContext<T> splitterContext, T element, Rectangle2D bounds) {
        this.updateBounds(bounds);
        Optional pathToFollow = splitterContext.splitter.chooseSubtree(this, element, bounds);
        if (pathToFollow.isPresent()) {
            Node node = pathToFollow.get().add(splitterContext, element, bounds);
            return node.getParent().orElse(node);
        }
        log.error("no path to follow");
        return null;
    }

    @Override
    public Node<T> remove(T element) {
        log.trace("want to remove {} from {}", element, (Object)this);
        LeafNode<T> containingLeaf = this.getContainingLeaf(element);
        if (containingLeaf == null) {
            log.warn("{} is not in this subtree! ", element);
            return this;
        }
        log.trace("remove {} from {}", element, containingLeaf);
        Node<T> goner = containingLeaf.remove(element);
        if (this.getChildren().isEmpty()) {
            log.trace("removed the last node, should remove this from parent now");
            Optional parentOptional = this.getParent();
            if (parentOptional.isPresent()) {
                ((InnerNode)parentOptional.get()).removeVertex(this);
            } else {
                log.trace("no parent for this " + this);
            }
        }
        return goner;
    }

    void addVertex(Node<T> node) {
        if (node == this) {
            throw new RuntimeException("Attempt to add self as child");
        }
        if (this.children.contains(node)) {
            throw new RuntimeException("Attempt to add duplicate child");
        }
        node.setParent(this);
        this.updateBounds(node.getBounds());
        this.children.add(node);
    }

    void removeVertex(Node<T> node) {
        this.children.remove(node);
        if (this.children.isEmpty() && this.parent.isPresent()) {
            ((InnerNode)this.parent.get()).removeVertex(this);
        }
    }

    InnerNode<T> replaceVertex(Node<T> goner, SplitterContext<T> splitterContext, Node<T> ... nodes) {
        this.children.remove(goner);
        return this.add(splitterContext, nodes);
    }

    InnerNode<T> add(SplitterContext<T> splitterContext, Node<T> ... nodes) {
        InnerNode<T> top = this;
        for (Node<T> node : nodes) {
            top = this.add(splitterContext, node);
        }
        if (top.getParent().isPresent()) {
            return (InnerNode)top.getParent().get();
        }
        return top;
    }

    private InnerNode<T> add(SplitterContext<T> splitterContext, Node<T> node) {
        if (node == this) {
            throw new RuntimeException("Attempt to add self as child");
        }
        this.updateBounds(node.getBounds());
        if (this.size() > 10) {
            log.trace("splitting InnerVertex {}", (Object)this);
            Pair pair = splitterContext.splitter.split(this.children, node);
            if (this.parent.isPresent()) {
                InnerNode innerVertexParent = (InnerNode)this.parent.get();
                if (this == pair.left || this == pair.right) {
                    throw new RuntimeException("Pair left " + pair.left + " or right " + pair.right + " the same as this" + this);
                }
                return innerVertexParent.replaceVertex(this, splitterContext, (Node)pair.left, (Node)pair.right);
            }
            InnerNode<T> innerVertexParent = InnerNode.create((InnerNode)pair.left);
            return innerVertexParent.add(splitterContext, (Node<T>)((Node)pair.right));
        }
        this.addVertex(node);
        return this.parent.orElse(this);
    }

    @Override
    public Set<T> getVisibleElements(Set<T> visibleElements, Shape shape) {
        if (shape.intersects(this.getBounds())) {
            for (Node<T> child : this.children) {
                child.getVisibleElements(visibleElements, shape);
            }
        }
        log.trace("visibleElements of InnerVertex inside {} are {}", (Object)shape, visibleElements);
        return visibleElements;
    }

    @Override
    public int count() {
        int count = 0;
        for (Node<T> child : this.children) {
            count += child.count();
        }
        return count;
    }

    private String asString() {
        return this.asString("");
    }

    public String toString() {
        return this.asString();
    }

    @Override
    public String asString(String margin) {
        StringBuilder s = new StringBuilder();
        s.append(margin);
        s.append("InnerVertex:parent:").append(this.parent.isPresent() ? "yes" : "none");
        s.append(" bounds=");
        s.append(Node.asString(this.getBounds()));
        s.append('\n');
        for (Node<T> child : this.children) {
            s.append(child.asString(margin + "   "));
        }
        return s.toString();
    }
}

