/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.renderers;

import java.awt.Dimension;
import org.jungrapht.visualization.RenderContext;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.renderers.EdgeArrowRenderingSupport;
import org.jungrapht.visualization.renderers.HeavyweightRenderer;
import org.jungrapht.visualization.spatial.Spatial;

public interface Renderer<V, E> {
    public static <V, E> Builder<V, E, ?, ?> builder() {
        return new Builder();
    }

    public void render(RenderContext<V, E> var1, LayoutModel<V> var2, Spatial<V, V> var3, Spatial<E, V> var4);

    public void render(RenderContext<V, E> var1, LayoutModel<V> var2);

    public void renderVertex(RenderContext<V, E> var1, LayoutModel<V> var2, V var3);

    public void renderVertexLabel(RenderContext<V, E> var1, LayoutModel<V> var2, V var3);

    public void renderEdge(RenderContext<V, E> var1, LayoutModel<V> var2, E var3);

    public void renderEdgeLabel(RenderContext<V, E> var1, LayoutModel<V> var2, E var3);

    public void setVertexRenderer(Vertex<V, E> var1);

    public void setEdgeRenderer(Edge<V, E> var1);

    public void setVertexLabelRenderer(VertexLabel<V, E> var1);

    public void setEdgeLabelRenderer(EdgeLabel<V, E> var1);

    public VertexLabel<V, E> getVertexLabelRenderer();

    public Vertex<V, E> getVertexRenderer();

    public Edge<V, E> getEdgeRenderer();

    public EdgeLabel<V, E> getEdgeLabelRenderer();

    public static class Builder<V, E, T extends Renderer<V, E>, B extends Builder<V, E, T, B>> {
        public T build() {
            return (T)new HeavyweightRenderer();
        }
    }

    public static interface EdgeLabel<V, E> {
        public void labelEdge(RenderContext<V, E> var1, LayoutModel<V> var2, E var3, String var4);

        public static class NOOP<V, E>
        implements EdgeLabel<V, E> {
            @Override
            public void labelEdge(RenderContext<V, E> renderContext, LayoutModel<V> layoutModel, E e, String label) {
            }
        }
    }

    public static interface VertexLabel<V, E> {
        public void labelVertex(RenderContext<V, E> var1, LayoutModel<V> var2, V var3, String var4);

        public void setPositioner(Positioner var1);

        public Positioner getPositioner();

        public static interface Positioner {
            public Position getPosition(float var1, float var2, Dimension var3);
        }

        public static enum Position {
            N,
            NE,
            E,
            SE,
            S,
            SW,
            W,
            NW,
            CNTR,
            AUTO;

        }

        public static class NOOP<V, E>
        implements VertexLabel<V, E> {
            @Override
            public void labelVertex(RenderContext<V, E> renderContext, LayoutModel<V> layoutModel, V v, String label) {
            }

            public Position getPosition() {
                return Position.CNTR;
            }

            public void setPosition(Position position) {
            }

            @Override
            public Positioner getPositioner() {
                return (x, y, d) -> Position.CNTR;
            }

            @Override
            public void setPositioner(Positioner positioner) {
            }
        }
    }

    public static interface Edge<V, E> {
        public void paintEdge(RenderContext<V, E> var1, LayoutModel<V> var2, E var3);

        public EdgeArrowRenderingSupport<V, E> getEdgeArrowRenderingSupport();

        public void setEdgeArrowRenderingSupport(EdgeArrowRenderingSupport<V, E> var1);

        public static class NOOP<V, E>
        implements Edge<V, E> {
            @Override
            public void paintEdge(RenderContext<V, E> renderContext, LayoutModel<V> layoutModel, E e) {
            }

            @Override
            public EdgeArrowRenderingSupport getEdgeArrowRenderingSupport() {
                return null;
            }

            @Override
            public void setEdgeArrowRenderingSupport(EdgeArrowRenderingSupport edgeArrowRenderingSupport) {
            }
        }
    }

    public static interface Vertex<V, E> {
        public void paintVertex(RenderContext<V, E> var1, LayoutModel<V> var2, V var3);

        public static class NOOP<V, E>
        implements Vertex<V, E> {
            @Override
            public void paintVertex(RenderContext<V, E> renderContext, LayoutModel<V> layoutModel, V v) {
            }
        }
    }
}

