/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.type;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractParsableItem;
import ghidra.app.util.bin.format.pdb2.pdbreader.DelimiterState;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import java.util.HashMap;
import java.util.Map;

public class MsProperty
extends AbstractParsableItem {
    public static final MsProperty NONE = new MsProperty(false);
    private static final String PACKED_STRING = "packed";
    private static final String CTOR_STRING = "ctor";
    private static final String OVERLOADED_OPS_STRING = "ovlops";
    private static final String NESTED_STRING = "isnested";
    private static final String CONTAINS_NESTED_STRING = "cnested";
    private static final String OVERLOADED_ASSIGN_STRING = "opassign";
    private static final String CASTING_METHODS_STRING = "opcast";
    private static final String FORWARD_REFS_STRING = "fwdref";
    private static final String SCOPED_STRING = "scoped";
    private static final String HAS_UNIQUE_NAME_STRING = "hasuniquename";
    private static final String SEALED_STRING = "sealed";
    private static final String INTRINSIC_STRING = "intrinsic";
    private boolean packedStructure;
    private boolean constructorOrDestructorPresent;
    private boolean overloadedOperatorsPresent;
    private boolean isNestedClass;
    private boolean containsNestedTypes;
    private boolean hasOverloadedAssignment;
    private boolean hasCastingMethods;
    private boolean isForwardReference;
    private boolean scopedDefinition;
    private boolean hasUniqueName;
    private boolean sealed;
    private boolean isIntrinsic;
    private Hfa hfa;
    private Mocom mocom;

    public MsProperty(PdbByteReader reader) throws PdbException {
        int properties = reader.parseUnsignedShortVal();
        this.processProperties(properties);
    }

    private MsProperty(boolean isFwdRef) {
        this.isForwardReference = isFwdRef;
        this.hfa = Hfa.NONE;
        this.mocom = Mocom.NONE;
    }

    public boolean isPacked() {
        return this.packedStructure;
    }

    public boolean hasConstructorOrDestructor() {
        return this.constructorOrDestructorPresent;
    }

    public boolean hasOverloadedOperators() {
        return this.overloadedOperatorsPresent;
    }

    public boolean isNestedClass() {
        return this.isNestedClass;
    }

    public boolean containsNestedTypes() {
        return this.containsNestedTypes;
    }

    public boolean hasOverloadedAssignment() {
        return this.hasOverloadedAssignment;
    }

    public boolean hasCastingMethods() {
        return this.hasCastingMethods;
    }

    public boolean isForwardReference() {
        return this.isForwardReference;
    }

    public boolean hasScopedDefinition() {
        return this.scopedDefinition;
    }

    public boolean hasUniqueName() {
        return this.hasUniqueName;
    }

    public boolean isSealed() {
        return this.sealed;
    }

    public boolean isIntrinsic() {
        return this.isIntrinsic;
    }

    public Hfa getHfa() {
        return this.hfa;
    }

    public Mocom getMocom() {
        return this.mocom;
    }

    @Override
    public void emit(StringBuilder builder) {
        DelimiterState ds = new DelimiterState("", " ");
        builder.append(ds.out(this.packedStructure, PACKED_STRING));
        builder.append(ds.out(this.constructorOrDestructorPresent, CTOR_STRING));
        builder.append(ds.out(this.overloadedOperatorsPresent, OVERLOADED_OPS_STRING));
        builder.append(ds.out(this.isNestedClass, NESTED_STRING));
        builder.append(ds.out(this.containsNestedTypes, CONTAINS_NESTED_STRING));
        builder.append(ds.out(this.hasOverloadedAssignment, OVERLOADED_ASSIGN_STRING));
        builder.append(ds.out(this.hasCastingMethods, CASTING_METHODS_STRING));
        builder.append(ds.out(this.isForwardReference, FORWARD_REFS_STRING));
        builder.append(ds.out(this.scopedDefinition, SCOPED_STRING));
        builder.append(ds.out(this.hasUniqueName, HAS_UNIQUE_NAME_STRING));
        builder.append(ds.out(this.sealed, SEALED_STRING));
        builder.append(ds.out(this.hfa != Hfa.NONE, (Object)this.hfa));
        builder.append(ds.out(this.isIntrinsic, INTRINSIC_STRING));
        builder.append(ds.out(this.mocom != Mocom.NONE, (Object)this.mocom));
    }

    private void processProperties(int properties) {
        this.packedStructure = (properties & 1) == 1;
        this.constructorOrDestructorPresent = ((properties >>= 1) & 1) == 1;
        this.overloadedOperatorsPresent = ((properties >>= 1) & 1) == 1;
        this.isNestedClass = ((properties >>= 1) & 1) == 1;
        this.containsNestedTypes = ((properties >>= 1) & 1) == 1;
        this.hasOverloadedAssignment = ((properties >>= 1) & 1) == 1;
        this.hasCastingMethods = ((properties >>= 1) & 1) == 1;
        this.isForwardReference = ((properties >>= 1) & 1) == 1;
        this.scopedDefinition = ((properties >>= 1) & 1) == 1;
        this.hasUniqueName = ((properties >>= 1) & 1) == 1;
        this.sealed = ((properties >>= 1) & 1) == 1;
        this.hfa = Hfa.fromValue((properties >>= 1) & 3);
        this.isIntrinsic = ((properties >>= 2) & 1) == 1;
        this.mocom = Mocom.fromValue((properties >>= 1) & 3);
    }

    public static enum Hfa {
        NONE("", 0),
        FLOAT("hfaFloat", 1),
        DOUBLE("hfaDouble", 2),
        RESV("hfa(3)", 3);

        private static final Map<Integer, Hfa> BY_VALUE;
        public final String label;
        public final int value;

        public String toString() {
            return this.label;
        }

        public static Hfa fromValue(int val) {
            return BY_VALUE.getOrDefault(val, NONE);
        }

        private Hfa(String label, int value) {
            this.label = label;
            this.value = value;
        }

        static {
            BY_VALUE = new HashMap<Integer, Hfa>();
            for (Hfa val : Hfa.values()) {
                BY_VALUE.put(val.value, val);
            }
        }
    }

    public static enum Mocom {
        NONE("", 0),
        REF("ref", 1),
        VALUE("value", 2),
        INTERFACE("interface", 3);

        private static final Map<Integer, Mocom> BY_VALUE;
        public final String label;
        public final int value;

        public String toString() {
            return this.label;
        }

        public static Mocom fromValue(int val) {
            return BY_VALUE.getOrDefault(val, NONE);
        }

        private Mocom(String label, int value) {
            this.label = label;
            this.value = value;
        }

        static {
            BY_VALUE = new HashMap<Integer, Mocom>();
            for (Mocom val : Mocom.values()) {
                BY_VALUE.put(val.value, val);
            }
        }
    }
}

