/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.DockingUtils;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.decompiler.ClangFieldToken;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.actions.AbstractDecompilerAction;
import ghidra.app.plugin.core.decompile.actions.RetypeFieldTask;
import ghidra.app.plugin.core.decompile.actions.RetypeStructFieldTask;
import ghidra.app.plugin.core.decompile.actions.RetypeUnionFieldTask;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.Structure;
import ghidra.program.model.listing.Function;
import ghidra.util.HelpLocation;
import ghidra.util.UndefinedFunction;

public class RetypeFieldAction
extends AbstractDecompilerAction {
    public RetypeFieldAction() {
        super("Retype Field");
        this.setHelpLocation(new HelpLocation("DecompilePlugin", "ActionRetypeField"));
        this.setPopupMenuData(new MenuData(new String[]{"Retype Field"}, "Decompile"));
        this.setKeyBindingData(new KeyBindingData(76, DockingUtils.CONTROL_KEY_MODIFIER_MASK));
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        Function function = context.getFunction();
        if (function == null || function instanceof UndefinedFunction) {
            return false;
        }
        ClangToken tokenAtCursor = context.getTokenAtCursor();
        if (tokenAtCursor == null) {
            return false;
        }
        if (tokenAtCursor instanceof ClangFieldToken) {
            Composite dt = RetypeFieldAction.getCompositeDataType(tokenAtCursor);
            return dt != null;
        }
        return false;
    }

    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        ClangToken tokenAtCursor = context.getTokenAtCursor();
        Composite composite = RetypeFieldAction.getCompositeDataType(tokenAtCursor);
        RetypeFieldTask retypeTask = composite instanceof Structure ? new RetypeStructFieldTask(context.getTool(), context.getProgram(), context.getComponentProvider(), tokenAtCursor, composite) : new RetypeUnionFieldTask(context.getTool(), context.getProgram(), context.getComponentProvider(), tokenAtCursor, composite);
        retypeTask.runTask();
    }
}

