/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.framework.options.SaveState;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CommentType;
import ghidra.program.model.listing.Program;
import ghidra.program.util.CommentFieldLocation;
import ghidra.program.util.ProgramUtilities;

public class RefRepeatCommentFieldLocation
extends CommentFieldLocation {
    private int currentCommentRow;
    private Address refRepeatAddress;

    public RefRepeatCommentFieldLocation(Program program, Address addr, int[] componentPath, String[] comment, int row, int charOffset, int currentCommentRow, Address refRepeatAddress) {
        super(program, addr, componentPath, comment, CommentType.EOL, row, charOffset);
        this.currentCommentRow = currentCommentRow;
        this.refRepeatAddress = refRepeatAddress;
    }

    public RefRepeatCommentFieldLocation() {
    }

    public Address getReferencedRepeatableAddress() {
        return this.refRepeatAddress;
    }

    public int getCurrentCommentRow() {
        return this.currentCommentRow;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.currentCommentRow;
        result = 31 * result + (this.refRepeatAddress == null ? 0 : this.refRepeatAddress.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RefRepeatCommentFieldLocation other = (RefRepeatCommentFieldLocation)obj;
        if (this.currentCommentRow != other.currentCommentRow) {
            return false;
        }
        return !(this.refRepeatAddress == null ? other.refRepeatAddress != null : !this.refRepeatAddress.equals(other.refRepeatAddress));
    }

    @Override
    public void restoreState(Program p, SaveState obj) {
        super.restoreState(p, obj);
        this.currentCommentRow = obj.getInt("_COMMENT_ROW", 0);
        String refRepeatAddrStr = obj.getString("_REF_REPEAT_ADDRESS", null);
        if (refRepeatAddrStr != null) {
            this.refRepeatAddress = ProgramUtilities.parseAddress(p, refRepeatAddrStr);
        }
    }

    @Override
    public void saveState(SaveState obj) {
        super.saveState(obj);
        obj.putInt("_COMMENT_ROW", this.currentCommentRow);
        if (this.refRepeatAddress != null) {
            obj.putString("_REF_REPEAT_ADDRESS", this.refRepeatAddress.toString());
        }
    }

    @Override
    public String toString() {
        return super.toString() + ", RefRepeatAddr = " + String.valueOf(this.refRepeatAddress) + ", Comment Row = " + this.currentCommentRow;
    }
}

